/*
 * Decompiled with CFR 0.152.
 */
package er.rest;

import com.webobjects.appserver.WORequest;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXFetchSpecificationBatchIterator;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXKeyFilter;
import er.extensions.eof.ERXQ;
import er.extensions.eof.ERXS;
import er.rest.ERXFilteredQualifierTraversal;
import er.rest.ERXRequestFormValues;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRestFetchSpecification<T extends EOEnterpriseObject> {
    private static final Pattern _rangePattern = Pattern.compile("items=(.*)-(.*)");
    private String _entityName;
    private EOQualifier _defaultQualifier;
    private EOQualifier _baseQualifier;
    private ERXKeyFilter _qualifierFilter;
    private NSArray<EOSortOrdering> _defaultSortOrderings;
    private int _maxBatchSize;
    private int _defaultBatchSize;
    private boolean _requestQualifiersEnabled;

    public ERXRestFetchSpecification(String entityName, EOQualifier defaultQualifier, NSArray<EOSortOrdering> defaultSortOrderings) {
        this(entityName, defaultQualifier, defaultSortOrderings, -1);
    }

    public ERXRestFetchSpecification(String entityName, EOQualifier defaultQualifier, NSArray<EOSortOrdering> defaultSortOrderings, int defaultBatchSize) {
        this._entityName = entityName;
        this._defaultQualifier = defaultQualifier;
        this._defaultSortOrderings = defaultSortOrderings;
        this._maxBatchSize = 100;
        this._defaultBatchSize = defaultBatchSize;
    }

    public ERXRestFetchSpecification(String entityName, EOQualifier defaultQualifier, EOQualifier baseQualifier, ERXKeyFilter qualifierFilter, NSArray<EOSortOrdering> defaultSortOrderings, int defaultBatchSize) {
        this._entityName = entityName;
        this._defaultQualifier = defaultQualifier;
        this._defaultSortOrderings = defaultSortOrderings;
        this._maxBatchSize = 100;
        this._defaultBatchSize = defaultBatchSize;
        this.enableRequestQualifiers(baseQualifier, qualifierFilter);
    }

    public String entityName() {
        return this._entityName;
    }

    public int maxBatchSize() {
        return this._maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this._maxBatchSize = maxBatchSize;
    }

    public int defaultBatchSize() {
        return this._defaultBatchSize;
    }

    public void setDefaultBatchSize(int defaultBatchSize) {
        this._defaultBatchSize = defaultBatchSize;
    }

    public void enableRequestQualifiers(EOQualifier baseQualifier, ERXKeyFilter qualifierFilter) {
        this._baseQualifier = baseQualifier;
        this._qualifierFilter = qualifierFilter;
        this._requestQualifiersEnabled = true;
    }

    public NSArray<EOSortOrdering> sortOrderings(EOEditingContext editingContext, NSKeyValueCoding options) {
        String sortKeysStr = (String)options.valueForKey("sort");
        if (sortKeysStr == null || sortKeysStr.length() == 0) {
            return this._defaultSortOrderings;
        }
        EOEntity entity = EOUtilities.entityNamed((EOEditingContext)editingContext, (String)this._entityName);
        NSMutableArray sortOrderings = new NSMutableArray();
        for (String sortKeyStr : sortKeysStr.split(",")) {
            String[] sortAttributes = sortKeyStr.split("\\|");
            String sortKey = sortAttributes[0];
            NSSelector sortDirection = sortAttributes.length == 2 ? (sortAttributes[1].equalsIgnoreCase("asc") ? EOSortOrdering.CompareCaseInsensitiveAscending : (sortAttributes[1].equalsIgnoreCase("desc") ? EOSortOrdering.CompareCaseInsensitiveDescending : EOSortOrdering.CompareCaseInsensitiveAscending)) : EOSortOrdering.CompareCaseInsensitiveAscending;
            if (this._qualifierFilter != null && !this._qualifierFilter.matches(new ERXKey(sortKey), ERXFilteredQualifierTraversal.typeForKeyInEntity(sortKey, entity))) {
                throw new SecurityException("You do not have access to the key path '" + sortKey + "'.");
            }
            sortOrderings.addObject((Object)EOSortOrdering.sortOrderingWithKey((String)sortKey, (NSSelector)sortDirection));
        }
        return sortOrderings;
    }

    public EOQualifier qualifier(EOEditingContext editingContext, NSKeyValueCoding options) {
        Object qualifier;
        if (!this._requestQualifiersEnabled) {
            qualifier = this._defaultQualifier;
        } else {
            String qualifierStr = (String)options.valueForKey("qualifier");
            if (qualifierStr == null || qualifierStr.length() == 0) {
                qualifier = this._baseQualifier == null ? this._defaultQualifier : ERXQ.and((EOQualifier[])new EOQualifier[]{this._baseQualifier, this._defaultQualifier});
            } else {
                qualifier = EOQualifier.qualifierWithQualifierFormat((String)qualifierStr, null);
                if (qualifier == null) {
                    qualifier = this._baseQualifier;
                } else {
                    EOEntity entity = EOUtilities.entityNamed((EOEditingContext)editingContext, (String)this._entityName);
                    ERXFilteredQualifierTraversal.checkQualifierForEntityWithFilter(qualifier, entity, this._qualifierFilter);
                    if (this._baseQualifier != null) {
                        qualifier = ERXQ.and((EOQualifier[])new EOQualifier[]{this._baseQualifier, qualifier});
                    }
                }
            }
        }
        return qualifier;
    }

    public int batchNumber(NSKeyValueCoding options) {
        String batchNumberStr = (String)options.valueForKey("batch");
        int batchNumber = batchNumberStr == null ? 0 : Integer.parseInt(batchNumberStr);
        return batchNumber;
    }

    public NSRange range(NSKeyValueCoding options) {
        NSRange range = null;
        String rangeStr = (String)options.valueForKey("Range");
        if (rangeStr != null) {
            Matcher rangeMatcher = _rangePattern.matcher(rangeStr);
            if (rangeMatcher.matches()) {
                int start = Integer.parseInt(rangeMatcher.group(1));
                int length = Integer.parseInt(rangeMatcher.group(2)) - start + 1;
                range = new NSRange(start, length);
            }
        } else {
            int batchNumber = this.batchNumber(options);
            int batchSize = this.batchSize(options);
            if (batchSize > 0) {
                range = new NSRange(batchNumber * batchSize, batchSize);
            }
        }
        return range;
    }

    public int batchSize(NSKeyValueCoding options) {
        String batchSizeStr = (String)options.valueForKey("batchSize");
        int batchSize = batchSizeStr == null ? this._defaultBatchSize : Math.min(Integer.parseInt(batchSizeStr), this._maxBatchSize);
        return batchSize;
    }

    public Results<T> results(EOEditingContext editingContext, NSKeyValueCoding options) {
        Results results;
        NSArray<EOSortOrdering> sortOrderings = this.sortOrderings(editingContext, options);
        EOQualifier qualifier = this.qualifier(editingContext, options);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(this._entityName, qualifier, sortOrderings);
        fetchSpec.setIsDeep(true);
        NSRange range = this.range(options);
        if (range == null) {
            NSArray objects = editingContext.objectsWithFetchSpecification(fetchSpec);
            results = new Results(objects, 0, -1, objects.count());
        } else {
            ERXFetchSpecificationBatchIterator batchIterator = new ERXFetchSpecificationBatchIterator(fetchSpec, editingContext, range.length());
            NSArray objects = batchIterator.batchWithRange(range);
            results = new Results(objects, range.location(), range.length(), batchIterator.count());
        }
        return results;
    }

    public NSArray<T> objects(EOEditingContext editingContext, NSKeyValueCoding options) {
        Results<T> results = this.results(editingContext, options);
        return results == null ? null : results.objects();
    }

    public NSArray<T> objects(NSArray<T> objects, EOEditingContext editingContext, NSKeyValueCoding options) {
        NSArray<EOSortOrdering> sortOrderings = this.sortOrderings(editingContext, options);
        EOQualifier qualifier = this.qualifier(editingContext, options);
        int batchSize = this.batchSize(options);
        NSArray results = ERXS.sorted((NSArray)ERXQ.filtered(objects, (EOQualifier)qualifier), sortOrderings);
        if (batchSize > 0) {
            int batchNumber = this.batchNumber(options);
            int offset = batchNumber * batchSize;
            int length = batchSize;
            if (offset >= results.count()) {
                results = NSArray.emptyArray();
            } else {
                NSRange range = offset + length > results.count() ? new NSRange(offset, results.count() - offset) : new NSRange(offset, length);
                results = objects.subarrayWithRange(range);
            }
        }
        return results;
    }

    public NSArray<T> objects(EOEditingContext editingContext, WORequest request) {
        return this.objects(editingContext, new ERXRequestFormValues(request));
    }

    public NSArray<T> objects(NSArray<T> objects, EOEditingContext editingContext, WORequest request) {
        return this.objects(objects, editingContext, new ERXRequestFormValues(request));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Results<T> {
        private NSArray<T> _objects;
        private int _startIndex;
        private int _batchSize;
        private int _total;

        public Results(NSArray<T> objects, int startIndex, int batchSize, int totalCount) {
            this._objects = objects;
            this._startIndex = startIndex;
            this._batchSize = batchSize;
            this._total = totalCount;
        }

        public NSArray<T> objects() {
            return this._objects;
        }

        public int startIndex() {
            return this._startIndex;
        }

        public int batchSize() {
            return this._batchSize;
        }

        public int totalCount() {
            return this._total;
        }
    }
}

