/*
 * Decompiled with CFR 0.152.
 */
package er.rest.entityDelegates;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueCoding;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.eof.ERXEOGlobalIDUtilities;
import er.extensions.eof.ERXFetchSpecification;
import er.extensions.eof.ERXGuardedObjectInterface;
import er.extensions.eof.ERXQ;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.rest.ERXRestException;
import er.rest.ERXRestRequestNode;
import er.rest.ERXRestUtils;
import er.rest.entityDelegates.ERXRestContext;
import er.rest.entityDelegates.ERXRestEntityDelegateUtils;
import er.rest.entityDelegates.ERXRestKey;
import er.rest.entityDelegates.ERXRestNotFoundException;
import er.rest.entityDelegates.ERXRestSecurityException;
import er.rest.entityDelegates.ERXUnsafeRestEntityDelegate;
import er.rest.entityDelegates.IERXRestEntityDelegate;
import java.text.ParseException;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXAbstractRestEntityDelegate
implements IERXRestEntityDelegate {
    @Override
    public void initializeEntityNamed(String entityName) {
    }

    @Override
    public String entityAliasForEntityNamed(String entityName) {
        return entityName;
    }

    @Override
    public String propertyNameForPropertyAlias(EOEntity entity, String propertyAlias) {
        return propertyAlias;
    }

    @Override
    public String propertyAliasForPropertyNamed(EOEntity entity, String propertyName) {
        return propertyName;
    }

    @Override
    public Object valueForKey(EOEntity entity, Object obj, String propertyName, ERXRestContext context) {
        return NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)obj, (String)propertyName);
    }

    @Override
    public void takeValueForKey(EOEntity entity, Object obj, String propertyName, String value, ERXRestContext context) throws ParseException, ERXRestException {
        Object parsedAttributeValue = this.parseAttributeValue(entity, obj, propertyName, value);
        EOKeyValueCoding.Utility.takeStoredValueForKey((Object)obj, (Object)parsedAttributeValue, (String)propertyName);
    }

    @Override
    public void preprocess(EOEntity entity, NSArray objects, ERXRestContext context) throws ERXRestException {
    }

    protected NSArray<String> allPossiblePropertyNamesOnEarth(EOEntity entity) {
        NSArray propertyNames = entity._propertyNames();
        NSArray subEntities = entity.subEntities();
        if (subEntities.count() > 0) {
            NSMutableSet mutablePropertyNames = new NSMutableSet(propertyNames);
            for (EOEntity subEntity : subEntities) {
                mutablePropertyNames.addObjectsFromArray(subEntity._propertyNames());
            }
            propertyNames = mutablePropertyNames.allObjects();
        }
        return propertyNames;
    }

    @Override
    public boolean isEOID(ERXRestKey restKey) {
        boolean isID = false;
        String key = restKey.key();
        if (key != null) {
            EOEntity entity = restKey.entity();
            if (this._isEOID(entity, key)) {
                isID = true;
            } else if (restKey.previousKey() == null) {
                if (!restKey.isKeyAll()) {
                    isID = !this.allPossiblePropertyNamesOnEarth(entity).containsObject((Object)key);
                }
            } else if (restKey.previousKey().isKeyAll()) {
                isID = true;
            } else if (this.allPossiblePropertyNamesOnEarth(entity).containsObject((Object)key)) {
                isID = false;
            } else {
                try {
                    Object previousValue = restKey.previousKey()._value(false);
                    if (previousValue instanceof NSArray) {
                        isID = true;
                    }
                }
                catch (ERXRestException e) {
                    throw new RuntimeException("Failed to check key '" + key + "'.", e);
                }
                catch (ERXRestSecurityException e) {
                    throw new RuntimeException("Failed to check key '" + key + "'.", e);
                }
                catch (ERXRestNotFoundException e) {
                    throw new RuntimeException("Failed to check key '" + key + "'.", e);
                }
            }
        }
        return isID;
    }

    protected String idAttributeName(EOEntity entity) {
        return null;
    }

    protected boolean _isEOID(EOEntity entity, String key) {
        boolean isID = !this.allPossiblePropertyNamesOnEarth(entity).containsObject((Object)key);
        return isID;
    }

    @Override
    public String stringIDForEO(EOEntity entity, EOEnterpriseObject eo) {
        Object id = this.idForEO(entity, eo);
        if (id instanceof Object[]) {
            throw new IllegalArgumentException(eo.entityName() + " has a compound primary key, which is currently not supported.");
        }
        String idStr = String.valueOf(id);
        return idStr;
    }

    @Override
    public Object idForEO(EOEntity entity, EOEnterpriseObject eo) {
        Object id;
        String idAttributeName = this.idAttributeName(entity);
        if (idAttributeName != null) {
            id = eo.valueForKey(idAttributeName);
        } else {
            EOGlobalID gid = eo.editingContext().globalIDForObject(eo);
            if (!(gid instanceof EOKeyGlobalID)) {
                throw new IllegalArgumentException("Unsupported primary key type '" + gid + "'.");
            }
            EOKeyGlobalID keyGID = (EOKeyGlobalID)gid;
            Object[] keyValues = keyGID.keyValues();
            if (keyValues.length > 1) {
                throw new IllegalArgumentException("Compound primary keys (" + eo.entityName() + ") are not currently supported.");
            }
            id = keyValues.length == 1 ? keyValues[0] : keyValues;
        }
        return id;
    }

    protected String idForNode(ERXRestRequestNode attributeNode) {
        Object idObj = attributeNode.id();
        String id = String.valueOf(idObj);
        if (idObj != null && id.length() == 0) {
            id = null;
        }
        return id;
    }

    @Override
    public EOEnterpriseObject objectForNode(EOEntity entity, ERXRestRequestNode node, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        String idForNode = this.idForNode(node);
        EOEnterpriseObject eo = node.isNull() ? null : (idForNode == null ? (node.children().count() == 0 ? null : null) : this.objectWithKey(entity, idForNode, context));
        return eo;
    }

    @Override
    public EOEnterpriseObject objectWithKey(EOEntity entity, String key, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        EOEnterpriseObject obj = this._objectWithKey(entity, key, context);
        if (obj == null) {
            throw new ERXRestNotFoundException("There is no " + this.entityAliasForEntityNamed(entity.name()) + " with the id '" + key + "'.");
        }
        if (!this.canViewObject(entity, obj, context)) {
            throw new ERXRestSecurityException("You are not allowed to view the " + this.entityAliasForEntityNamed(entity.name()) + " with the id '" + key + "'.");
        }
        return obj;
    }

    protected EOEnterpriseObject _objectWithKey(EOEntity entity, String key, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        EOEnterpriseObject obj;
        String idAttributeName = this.idAttributeName(entity);
        if (idAttributeName == null) {
            EOKeyGlobalID gid;
            if (ERXStringUtilities.isDigitsOnly((String)key)) {
                gid = EOKeyGlobalID.globalIDWithEntityName((String)entity.name(), (Object[])new Object[]{Integer.valueOf(key)});
            } else {
                NSArray primaryKeyAttributes = entity.primaryKeyAttributes();
                if (primaryKeyAttributes.count() > 1) {
                    throw new IllegalArgumentException("Compound primary keys (" + entity + ") are not currently supported.");
                }
                EOAttribute primaryKeyAttribute = (EOAttribute)primaryKeyAttributes.objectAtIndex(0);
                if (NSData.class.getName().equals(primaryKeyAttribute.className())) {
                    if (!key.startsWith("<")) {
                        key = "<" + key + ">";
                    }
                    gid = EOKeyGlobalID.globalIDWithEntityName((String)entity.name(), (Object[])new Object[]{new NSData((NSData)NSPropertyListSerialization.propertyListFromString((String)key))});
                } else {
                    gid = EOKeyGlobalID.globalIDWithEntityName((String)entity.name(), (Object[])new Object[]{key});
                }
            }
            obj = ERXEOGlobalIDUtilities.fetchObjectWithGlobalID((EOEditingContext)context.editingContext(), (EOGlobalID)gid);
        } else {
            ERXFetchSpecification fetchSpec = new ERXFetchSpecification(entity.name(), (EOQualifier)ERXQ.equals((String)idAttributeName, (Object)key), null);
            fetchSpec.setIncludeEditingContextChanges(true);
            fetchSpec.setIsDeep(true);
            NSArray matchingObjects = context.editingContext().objectsWithFetchSpecification((EOFetchSpecification)fetchSpec);
            if (matchingObjects.count() == 0) {
                obj = null;
            } else if (matchingObjects.count() == 1) {
                obj = (EOEnterpriseObject)matchingObjects.objectAtIndex(0);
            } else {
                throw new ERXRestException("There was more than one " + this.entityAliasForEntityNamed(entity.name()) + " with the " + idAttributeName + " '" + key + "'.");
            }
        }
        return obj;
    }

    @Override
    public EOEnterpriseObject objectWithKey(EOEntity entity, String key, NSArray objs, ERXRestContext context) throws ERXRestException, ERXRestSecurityException, ERXRestNotFoundException {
        NSMutableArray filteredObjs = new NSMutableArray();
        Enumeration objsEnum = objs.objectEnumerator();
        while (objsEnum.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)objsEnum.nextElement();
            if (!this.stringIDForEO(entity, eo).equals(key)) continue;
            filteredObjs.addObject((Object)eo);
        }
        if (filteredObjs.count() == 0) {
            throw new ERXRestNotFoundException("There is no " + this.entityAliasForEntityNamed(entity.name()) + " in this relationship with the id '" + key + "'.");
        }
        EOEnterpriseObject obj = (EOEnterpriseObject)filteredObjs.objectAtIndex(0);
        if (!this.canViewObject(entity, obj, context)) {
            throw new ERXRestSecurityException("You are not allowed to view the " + this.entityAliasForEntityNamed(entity.name()) + " with the id '" + key + "'.");
        }
        return obj;
    }

    @Override
    public void delete(EOEntity entity, EOEnterpriseObject eo, ERXRestContext context) throws ERXRestException, ERXRestSecurityException {
        if (!this.canDeleteObject(entity, eo, context)) {
            throw new ERXRestSecurityException("You are not allowed to delete the given " + this.entityAliasForEntityNamed(entity.name()) + " object.");
        }
        if (eo instanceof ERXGuardedObjectInterface) {
            ((ERXGuardedObjectInterface)eo).delete();
        } else {
            eo.editingContext().deleteObject(eo);
        }
    }

    @Override
    public String formatAttributeValue(EOEntity entity, Object object, String attributeName, Object attributeValue) throws ParseException, ERXRestException {
        String formattedValue;
        if (attributeValue == null) {
            formattedValue = null;
        } else if (attributeValue instanceof NSTimestamp) {
            NSTimestamp timestamp = (NSTimestamp)attributeValue;
            formattedValue = new NSTimestampFormatter("%Y-%m-%dT%H:%M:%SZ").format((Object)timestamp);
        } else {
            formattedValue = attributeValue.toString();
        }
        return formattedValue;
    }

    public Object parseAttributeValue(EOEntity entity, Object object, String attributeName, String attributeValue) throws ParseException, ERXRestException {
        return ERXRestUtils.coerceValueToAttributeType(attributeValue, entity.classDescriptionForInstances(), object, attributeName);
    }

    @Override
    public EOEnterpriseObject insertObjectFromDocument(EOEntity entity, ERXRestRequestNode insertNode, EOEntity parentEntity, EOEnterpriseObject parentObject, String parentKey, ERXRestContext context) throws ERXRestSecurityException, ERXRestException, ERXRestNotFoundException {
        boolean canInsert = parentObject == null ? this.canInsertObject(entity, context) : this.canInsertObject(parentEntity, parentObject, parentKey, entity, context);
        if (!canInsert) {
            throw new ERXRestSecurityException("You are not allowed to insert this " + this.entityAliasForEntityNamed(entity.name()) + " object.");
        }
        EOEnterpriseObject eo = EOUtilities.createAndInsertInstance((EOEditingContext)context.editingContext(), (String)entity.name());
        this._updatePropertiesFromDocument(true, entity, eo, insertNode, context);
        if (parentObject != null) {
            parentObject.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)eo, parentKey);
        }
        this.inserted(entity, eo, context);
        return eo;
    }

    @Override
    public EOEnterpriseObject processObjectFromDocument(EOEntity entity, ERXRestRequestNode eoNode, ERXRestContext context) throws ERXRestSecurityException, ERXRestException, ERXRestNotFoundException {
        EOEnterpriseObject eo;
        IERXRestEntityDelegate delegate = context.delegate().entityDelegate(entity);
        try {
            eo = delegate.objectForNode(entity, eoNode, context);
            if (eo == null) {
                eo = this.insertObjectFromDocument(entity, eoNode, null, null, null, context);
            } else {
                this.updateObjectFromDocument(entity, eo, eoNode, context);
            }
        }
        catch (ERXRestNotFoundException e) {
            eo = this.insertObjectFromDocument(entity, eoNode, null, null, null, context);
        }
        return eo;
    }

    @Override
    public void updateObjectFromDocument(EOEntity entity, EOEnterpriseObject eo, ERXRestRequestNode eoNode, ERXRestContext context) throws ERXRestSecurityException, ERXRestException, ERXRestNotFoundException {
        if (!this.canUpdateObject(entity, eo, context)) {
            throw new ERXRestSecurityException("You are not allowed to update this " + this.entityAliasForEntityNamed(entity.name()) + " object.");
        }
        this._updatePropertiesFromDocument(false, entity, eo, eoNode, context);
    }

    public void _updateRelationshipFromDocument(EOEntity entity, EOEnterpriseObject eo, EORelationship relationship, ERXRestRequestNode relationshipNode, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        EOEntity destinationEntity;
        String relationshipName = relationship.name();
        String typeName = relationshipNode.type();
        if (typeName == null) {
            destinationEntity = relationship.destinationEntity();
            typeName = destinationEntity.name();
        }
        destinationEntity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, typeName);
        IERXRestEntityDelegate destinationEntityDelegate = context.delegate().entityDelegate(destinationEntity);
        if (!relationship.isToMany()) {
            EOEnterpriseObject originalObject = (EOEnterpriseObject)this.valueForKey(entity, eo, relationship.name(), context);
            EOEnterpriseObject newObject = destinationEntityDelegate.objectForNode(destinationEntity, relationshipNode, context);
            if (newObject == null && !relationshipNode.isNull() && relationshipNode.children().count() > 0) {
                newObject = destinationEntityDelegate.insertObjectFromDocument(destinationEntity, relationshipNode, entity, eo, relationshipName, context);
            }
            if (relationshipNode.isNull() || newObject == null) {
                if (!relationship.isMandatory()) {
                    eo.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)originalObject, relationshipName);
                }
            } else if (originalObject == null && newObject != null) {
                eo.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)newObject, relationshipName);
            } else if (originalObject != null && !originalObject.equals(newObject)) {
                eo.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)originalObject, relationshipName);
                if (newObject != null) {
                    eo.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)newObject, relationshipName);
                }
            }
        } else {
            NSArray originalObjects = (NSArray)this.valueForKey(entity, eo, relationshipName, context);
            NSArray<ERXRestRequestNode> newNodes = relationshipNode.children();
            if (!relationshipNode.isNull()) {
                this._updateArrayFromDocument(entity, eo, relationshipName, destinationEntity, originalObjects, newNodes, context);
            }
        }
    }

    public void _updatePropertiesFromDocument(boolean inserting, EOEntity entity, EOEnterpriseObject eo, ERXRestRequestNode eoNode, ERXRestContext context) throws ERXRestSecurityException, ERXRestException, ERXRestNotFoundException {
        String type;
        entity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, eo.entityName());
        String entityAlias = this.entityAliasForEntityNamed(eo.entityName());
        if (!entityAlias.equals(type = eoNode.type()) && !entityAlias.equals(eoNode.name())) {
            throw new ERXRestException("You attempted to put a " + eoNode.name() + " into a " + entityAlias + "." + eo + "  " + eoNode);
        }
        IERXRestEntityDelegate entityDelegate = context.delegate().entityDelegate(entity);
        Enumeration attributeNodesEnum = eoNode.children().objectEnumerator();
        while (attributeNodesEnum.hasMoreElements()) {
            ERXRestRequestNode attributeNode = (ERXRestRequestNode)attributeNodesEnum.nextElement();
            boolean updateAttribute = true;
            String attributeName = entityDelegate.propertyNameForPropertyAlias(entity, attributeNode.name());
            if ("id".equals(attributeName)) {
                updateAttribute = false;
            }
            if (!updateAttribute) continue;
            if (inserting && !this.canInsertProperty(entity, eo, attributeName, context)) {
                throw new ERXRestSecurityException("You are not allowed to insert the property '" + attributeName + "' on " + entityAlias + ".");
            }
            if (!inserting && !this.canUpdateProperty(entity, eo, attributeName, context)) {
                throw new ERXRestSecurityException("You are not allowed to update the property '" + attributeName + "' on " + entityAlias + ".");
            }
            EORelationship relationship = entity.relationshipNamed(attributeName);
            if (relationship != null) {
                this._updateRelationshipFromDocument(entity, eo, relationship, attributeNode, context);
                continue;
            }
            String attributeValue = (String)attributeNode.value();
            try {
                this.takeValueForKey(entity, eo, attributeName, attributeValue, context);
            }
            catch (ParseException e) {
                throw new ERXRestException("Failed to parse attribute value '" + attributeValue + "'.", e);
            }
        }
        this.updated(entity, eo, context);
    }

    @Override
    public void updateArrayFromDocument(EOEntity parentEntity, EOEnterpriseObject parentObject, String attributeName, EOEntity entity, NSArray currentObjects, NSArray toManyNodes, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        IERXRestEntityDelegate parentEntityDelegate = context.delegate().entityDelegate(entity);
        if (parentObject != null && !parentEntityDelegate.canUpdateObject(parentEntity, parentObject, context)) {
            throw new ERXRestSecurityException("You are not allowed to update this " + entity.name() + " object.");
        }
        if (parentObject != null && attributeName != null && !parentEntityDelegate.canUpdateProperty(parentEntity, parentObject, attributeName, context)) {
            throw new ERXRestSecurityException("You are not allowed to update this " + entity.name() + " object.");
        }
        this._updateArrayFromDocument(parentEntity, parentObject, attributeName, entity, currentObjects, toManyNodes, context);
    }

    protected void _updateArrayFromDocument(EOEntity parentEntity, EOEnterpriseObject parentObject, String attributeName, EOEntity entity, NSArray currentObjects, NSArray toManyNodes, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        NSMutableArray keepObjects = new NSMutableArray();
        NSMutableArray addObjects = new NSMutableArray();
        NSMutableArray removeObjects = new NSMutableArray();
        IERXRestEntityDelegate destinationEntityDelegate = context.delegate().entityDelegate(entity);
        Enumeration toManyNodesEnum = toManyNodes.objectEnumerator();
        while (toManyNodesEnum.hasMoreElements()) {
            ERXRestRequestNode toManyNode = (ERXRestRequestNode)toManyNodesEnum.nextElement();
            String toManyNodeName = toManyNode.name();
            entity = ERXRestEntityDelegateUtils.requiredEntityNamed(context, toManyNodeName);
            if (!this.entityAliasForEntityNamed(entity.name()).equals(toManyNodeName)) {
                throw new ERXRestException("You attempted to put a " + toManyNodeName + " into a " + this.entityAliasForEntityNamed(entity.name()) + ".");
            }
            try {
                EOEnterpriseObject relatedObject = destinationEntityDelegate.objectForNode(entity, toManyNode, context);
                if (relatedObject == null) {
                    relatedObject = destinationEntityDelegate.insertObjectFromDocument(entity, toManyNode, parentEntity, parentObject, attributeName, context);
                    addObjects.addObject((Object)relatedObject);
                    continue;
                }
                destinationEntityDelegate.updateObjectFromDocument(entity, relatedObject, toManyNode, context);
                if (currentObjects.containsObject((Object)relatedObject)) {
                    keepObjects.addObject((Object)relatedObject);
                    continue;
                }
                addObjects.addObject((Object)relatedObject);
            }
            catch (ERXRestNotFoundException e) {
                EOEnterpriseObject relatedObject = destinationEntityDelegate.insertObjectFromDocument(entity, toManyNode, parentEntity, parentObject, attributeName, context);
                addObjects.addObject((Object)relatedObject);
            }
        }
        Enumeration currentObjectsEnum = currentObjects.immutableClone().objectEnumerator();
        while (currentObjectsEnum.hasMoreElements()) {
            EOEnterpriseObject currentObject = (EOEnterpriseObject)currentObjectsEnum.nextElement();
            if (keepObjects.containsObject((Object)currentObject)) continue;
            parentObject.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)currentObject, attributeName);
        }
        Enumeration addObjectsEnum = addObjects.objectEnumerator();
        while (addObjectsEnum.hasMoreElements()) {
            EOEnterpriseObject addObject = (EOEnterpriseObject)addObjectsEnum.nextElement();
            parentObject.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)addObject, attributeName);
        }
        this.updated(entity, parentObject, context);
    }

    public static String cascadingValue(ERXRestKey result, String propertyPrefix, String propertySuffix, String defaultValue) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        ERXRestKey cascadingKey = result.firstKey();
        String propertyValue = ERXAbstractRestEntityDelegate._cascadingValue(cascadingKey, propertyPrefix, propertySuffix);
        if (propertyValue == null) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }

    public static String _cascadingValue(ERXRestKey cascadingKey, String propertyPrefix, String propertySuffix) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        String propertyValue = null;
        EOEntity entity = cascadingKey.entity();
        while (entity != null && propertyValue == null) {
            ERXRestKey entityCascadingKey = cascadingKey.cloneKeyWithNewEntity(entity, true, true);
            String keypathWithoutGIDs = entityCascadingKey.path(true);
            String propertyName = propertyPrefix + keypathWithoutGIDs.replace('/', '.') + propertySuffix;
            propertyValue = ERXProperties.stringForKey((String)propertyName);
            if (propertyValue != null) continue;
            entity = entity.parentEntity();
        }
        if (propertyValue == null && cascadingKey.nextKey() != null) {
            propertyValue = ERXAbstractRestEntityDelegate._cascadingValue(cascadingKey.nextKey(), propertyPrefix, propertySuffix);
        }
        return propertyValue;
    }

    public static boolean _displayDetailsFromProperties(ERXRestKey result) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        String displayDetailsStr = ERXAbstractRestEntityDelegate.cascadingValue(result, "ERXRest.", ".details", null);
        boolean displayDetails = displayDetailsStr == null ? result.previousKey() == null && (result.key() == null || result.isKeyGID()) : Boolean.valueOf(displayDetailsStr);
        return displayDetails;
    }

    public static String[] _displayPropertiesFromProperties(ERXRestKey result, boolean displayAllProperties, boolean displayAllToMany) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        String[] displayPropertyNames;
        String displayPropertyNamesStr = ERXAbstractRestEntityDelegate.cascadingValue(result, "ERXRest.", ".detailsProperties", null);
        if (displayPropertyNamesStr == null) {
            if (displayAllProperties) {
                NSArray<String> allPropertyNames = ERXUnsafeRestEntityDelegate.allPropertyNames(result.nextEntity(), displayAllToMany);
                displayPropertyNames = new String[allPropertyNames.count()];
                for (int propertyNum = 0; propertyNum < displayPropertyNames.length; ++propertyNum) {
                    displayPropertyNames[propertyNum] = (String)allPropertyNames.objectAtIndex(propertyNum);
                }
            } else {
                displayPropertyNames = null;
            }
        } else {
            displayPropertyNames = displayPropertyNamesStr.split(",");
        }
        return displayPropertyNames;
    }

    @Override
    public String[] displayProperties(ERXRestKey key, boolean allProperties, boolean allToMany, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        String[] displayProperties = ERXAbstractRestEntityDelegate._displayPropertiesFromProperties(key, allProperties, allToMany);
        return displayProperties;
    }

    @Override
    public boolean displayDetails(ERXRestKey key, ERXRestContext context) throws ERXRestException, ERXRestNotFoundException, ERXRestSecurityException {
        return ERXAbstractRestEntityDelegate._displayDetailsFromProperties(key);
    }

    public abstract void updated(EOEntity var1, EOEnterpriseObject var2, ERXRestContext var3) throws ERXRestException, ERXRestSecurityException;

    public abstract void inserted(EOEntity var1, EOEnterpriseObject var2, ERXRestContext var3) throws ERXRestException, ERXRestSecurityException;
}

