/*
 * Decompiled with CFR 0.152.
 */
package er.rest.format;

import com.webobjects.foundation.NSTimestamp;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.rest.ERXRestRequestNode;
import er.rest.ERXRestUtils;
import er.rest.format.ERXRestFormat;
import er.rest.format.IERXRestResponse;
import er.rest.format.IERXRestWriter;
import java.math.BigDecimal;
import java.util.Map;

public class ERXXmlRestWriter
implements IERXRestWriter {
    public void appendHeadersToResponse(ERXRestRequestNode node, IERXRestResponse response) {
        response.setHeader("text/xml", "Content-Type");
    }

    public void appendToResponse(ERXRestRequestNode node, IERXRestResponse response, ERXRestFormat.Delegate delegate) {
        this.appendHeadersToResponse(node, response);
        response.appendContentString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.appendNodeToResponse(node, response, 0, delegate);
    }

    protected String coerceValueToString(Object value) {
        return ERXRestUtils.coerceValueToString(value);
    }

    protected void appendNodeToResponse(ERXRestRequestNode node, IERXRestResponse response, int indent, ERXRestFormat.Delegate delegate) {
        delegate.nodeWillWrite(node);
        if (node.value() != null || node.isNull()) {
            this.appendValueToResponse(node, response, indent);
        } else if (node.isArray()) {
            this.appendArrayToResponse(node, response, indent, delegate);
        } else {
            this.appendDictionaryToResponse(node, response, indent, delegate);
        }
    }

    protected void appendValueToResponse(ERXRestRequestNode node, IERXRestResponse response, int indent) {
        String name = node.name();
        Object value = node.value();
        String formattedValue = this.coerceValueToString(value);
        if (formattedValue == null) {
            this.indent(response, indent);
            response.appendContentString("<");
            response.appendContentString(name);
            this.appendAttributesToResponse(node, response);
            response.appendContentString("/>");
            response.appendContentString("\n");
        } else if (formattedValue != null) {
            this.indent(response, indent);
            response.appendContentString("<");
            response.appendContentString(name);
            this.appendAttributesToResponse(node, response);
            response.appendContentString(">");
            response.appendContentString(ERXStringUtilities.escapeNonXMLChars((String)formattedValue));
            response.appendContentString("</");
            response.appendContentString(name);
            response.appendContentString(">");
            response.appendContentString("\n");
        } else if (indent == 0) {
            response.appendContentString("<null/>");
        }
    }

    protected void appendAttributesToResponse(ERXRestRequestNode node, IERXRestResponse response) {
        for (Map.Entry attribute : node.attributes().entrySet()) {
            String key = (String)attribute.getKey();
            String formattedValue = this.coerceValueToString(attribute.getValue());
            if (formattedValue == null) continue;
            response.appendContentString(" ");
            response.appendContentString(key);
            response.appendContentString("=\"");
            response.appendContentString(ERXStringUtilities.escapeNonXMLChars((String)formattedValue));
            response.appendContentString("\"");
        }
    }

    protected void appendDictionaryToResponse(ERXRestRequestNode node, IERXRestResponse response, int indent, ERXRestFormat.Delegate delegate) {
        String objectName = node.name();
        if (objectName == null) {
            objectName = node.type();
        }
        this.indent(response, indent);
        response.appendContentString("<");
        response.appendContentString(objectName);
        this.appendAttributesToResponse(node, response);
        if (node.children().size() == 0) {
            response.appendContentString("/>");
            response.appendContentString("\n");
        } else {
            response.appendContentString(">");
            response.appendContentString("\n");
            for (ERXRestRequestNode child : node.children()) {
                this.appendNodeToResponse(child, response, indent + 1, delegate);
            }
            this.indent(response, indent);
            response.appendContentString("</");
            response.appendContentString(objectName);
            response.appendContentString(">");
            response.appendContentString("\n");
        }
    }

    protected void appendTypeToResponse(Object value, IERXRestResponse response) {
        if (!(value instanceof String) && !ERXProperties.booleanForKeyWithDefault((String)"ERXRest.suppressTypeAttributesForSimpleTypes", (boolean)false)) {
            if (value instanceof NSTimestamp) {
                response.appendContentString(" type = \"datetime\"");
            } else if (value instanceof Integer) {
                response.appendContentString(" type = \"integer\"");
            } else if (value instanceof Long) {
                response.appendContentString(" type = \"long\"");
            } else if (value instanceof Short) {
                response.appendContentString(" type = \"short\"");
            } else if (value instanceof Double) {
                response.appendContentString(" type = \"double\"");
            } else if (value instanceof Float) {
                response.appendContentString(" type = \"float\"");
            } else if (value instanceof Boolean) {
                response.appendContentString(" type = \"boolean\"");
            } else if (value instanceof BigDecimal) {
                response.appendContentString(" type = \"bigint\"");
            } else if (value instanceof Enum) {
                response.appendContentString(" type = \"enum\"");
            }
        }
    }

    protected void appendArrayToResponse(ERXRestRequestNode node, IERXRestResponse response, int indent, ERXRestFormat.Delegate delegate) {
        this.indent(response, indent);
        String arrayName = node.name();
        response.appendContentString("<");
        response.appendContentString(arrayName);
        this.appendAttributesToResponse(node, response);
        response.appendContentString(">");
        response.appendContentString("\n");
        for (ERXRestRequestNode child : node.children()) {
            this.appendNodeToResponse(child, response, indent + 1, delegate);
        }
        this.indent(response, indent);
        response.appendContentString("</");
        response.appendContentString(arrayName);
        response.appendContentString(">");
        response.appendContentString("\n");
    }

    protected void indent(IERXRestResponse response, int indent) {
        for (int i = 0; i < indent; ++i) {
            response.appendContentString("  ");
        }
    }
}

