/*
 * Decompiled with CFR 0.152.
 */
package er.rest.routes;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import er.rest.ERXRestUtils;
import er.rest.IERXRestDelegate;
import er.rest.routes.ERXRouteController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRoute {
    public static final Key ControllerKey = new Key("controller");
    public static final Key ActionKey = new Key("action");
    private String _entityName;
    private Pattern _routePattern;
    private Method _method;
    private NSMutableArray<Key> _keys;
    private Class<? extends ERXRouteController> _controller;
    private String _action;

    public ERXRoute(String entityName, String urlPattern, Method method) {
        this(entityName, urlPattern, method, (Class<? extends ERXRouteController>)null, null);
    }

    public ERXRoute(String entityName, String urlPattern) {
        this(entityName, urlPattern, Method.All, (Class<? extends ERXRouteController>)null, null);
    }

    public ERXRoute(String entityName, String urlPattern, String controller) {
        this(entityName, urlPattern, Method.All, _NSUtilities.classWithName((String)controller).asSubclass(ERXRouteController.class), null);
    }

    public ERXRoute(String entityName, String urlPattern, Method method, String controller) {
        this(entityName, urlPattern, method, _NSUtilities.classWithName((String)controller).asSubclass(ERXRouteController.class), null);
    }

    public ERXRoute(String entityName, String urlPattern, Class<? extends ERXRouteController> controller) {
        this(entityName, urlPattern, Method.All, controller, null);
    }

    public ERXRoute(String entityName, String urlPattern, Method method, Class<? extends ERXRouteController> controller) {
        this(entityName, urlPattern, method, controller, null);
    }

    public ERXRoute(String entityName, String urlPattern, String controller, String action) {
        this(entityName, urlPattern, Method.All, _NSUtilities.classWithName((String)controller).asSubclass(ERXRouteController.class), action);
    }

    public ERXRoute(String entityName, String urlPattern, Method method, String controller, String action) {
        this(entityName, urlPattern, method, _NSUtilities.classWithName((String)controller).asSubclass(ERXRouteController.class), action);
    }

    public ERXRoute(String entityName, String urlPattern, Class<? extends ERXRouteController> controller, String action) {
        this(entityName, urlPattern, Method.All, controller, action);
    }

    public ERXRoute(String entityName, String urlPattern, Method method, Class<? extends ERXRouteController> controller, String action) {
        this._entityName = entityName;
        this._method = method;
        this._controller = controller;
        this._action = action;
        Matcher keyMatcher = Pattern.compile("\\{([^}]+)\\}").matcher(urlPattern);
        this._keys = new NSMutableArray();
        StringBuffer routeRegex = new StringBuffer();
        if (!urlPattern.startsWith("^")) {
            routeRegex.append("^");
        }
        while (keyMatcher.find()) {
            String keyStr = keyMatcher.group(1);
            String replacement = "([^/]+)";
            Key key = new Key();
            int colonIndex = keyStr.indexOf(58);
            if (colonIndex == -1) {
                key._key = keyStr;
                key._valueType = Character.isUpperCase(keyStr.charAt(0)) ? keyStr : String.class.getName();
            } else {
                String[] segments = keyStr.split(":");
                key._key = segments[0];
                key._valueType = segments[1];
                if (segments.length == 3) {
                    replacement = "(" + segments[2].replaceAll("[\\\\$]", "\\\\$0") + ")";
                }
            }
            if ("identifier".equals(key._valueType)) {
                key._valueType = String.class.getName();
                replacement = "(\\\\D[^/-]*)";
            }
            this._keys.addObject((Object)key);
            keyMatcher.appendReplacement(routeRegex, replacement);
        }
        keyMatcher.appendTail(routeRegex);
        if (!urlPattern.endsWith("$")) {
            if (routeRegex.lastIndexOf(".") == -1) {
                routeRegex.append("/?(\\..*)?");
            }
            routeRegex.append("$");
        }
        this._routePattern = Pattern.compile(routeRegex.toString());
    }

    public String entityName() {
        return this._entityName;
    }

    public Class<? extends ERXRouteController> controller() {
        return this._controller;
    }

    public Pattern routePattern() {
        return this._routePattern;
    }

    public Method method() {
        return this._method;
    }

    public void setMethod(Method method) {
        this._method = method;
    }

    public void _clearCaches() {
        for (Key key : this._keys) {
            key._clearRouteParameterMethodCache();
        }
        ControllerKey._clearRouteParameterMethodCache();
        ActionKey._clearRouteParameterMethodCache();
    }

    public NSDictionary<Key, String> keys(String url, Method method) {
        Matcher routeMatcher;
        NSMutableDictionary keys = null;
        if ((this._method == Method.All || this._method == null || method == null || method.equals((Object)this._method)) && (routeMatcher = this._routePattern.matcher(url)).matches()) {
            keys = new NSMutableDictionary();
            int keyCount = this._keys.count();
            for (int keyNum = 0; keyNum < keyCount; ++keyNum) {
                Key key = (Key)this._keys.objectAtIndex(keyNum);
                String value = routeMatcher.group(keyNum + 1);
                keys.setObjectForKey((Object)value, (Object)key);
            }
            if (!keys.containsKey((Object)ControllerKey) && this._controller != null) {
                keys.setObjectForKey((Object)this._controller.getName(), (Object)ControllerKey);
            }
            if (!keys.containsKey((Object)ActionKey) && this._action != null) {
                keys.setObjectForKey((Object)this._action, (Object)ActionKey);
            }
        }
        return keys;
    }

    public NSDictionary<Key, Object> keysWithObjects(String url, Method method, IERXRestDelegate delegate) {
        return ERXRoute.keysWithObjects(this.keys(url, method), delegate);
    }

    public NSDictionary<String, Object> objects(String url, Method method, IERXRestDelegate delegate) {
        return this.objects(this.keys(url, method), delegate);
    }

    public static NSDictionary<Key, Object> keysWithObjects(NSDictionary<Key, String> keys, IERXRestDelegate delegate) {
        NSMutableDictionary objects = null;
        if (keys != null) {
            objects = new NSMutableDictionary();
            for (Map.Entry entry : keys.entrySet()) {
                Key key = (Key)entry.getKey();
                String valueStr = (String)entry.getValue();
                Object value = ERXRestUtils.coerceValueToTypeNamed(valueStr, key.valueType(), delegate);
                objects.setObjectForKey(value, (Object)key);
            }
        } else {
            objects = new NSMutableDictionary();
        }
        return objects;
    }

    public NSDictionary<String, Object> objects(NSDictionary<Key, String> keys, IERXRestDelegate delegate) {
        NSMutableDictionary objects = null;
        if (keys != null) {
            objects = new NSMutableDictionary();
            for (Map.Entry entry : keys.entrySet()) {
                Key key = (Key)entry.getKey();
                String valueStr = (String)entry.getValue();
                Object value = ERXRestUtils.coerceValueToTypeNamed(valueStr, key.valueType(), delegate);
                objects.setObjectForKey(value, (Object)key._key);
            }
        }
        return objects;
    }

    public String toString() {
        return "[ERXRoute: pattern=" + this._routePattern + "; method=" + (Object)((Object)this._method) + "; keys=" + this._keys.valueForKey("key") + "]";
    }

    public static class RouteParameterMethod {
        private java.lang.reflect.Method _method;
        private boolean _stringParameter;

        public RouteParameterMethod(java.lang.reflect.Method method) {
            this._method = method;
            if (this._method != null) {
                Class<?>[] parameterTypes = this._method.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalArgumentException("The route parameter method '" + method + "' must take a single parameter.");
                }
                this._stringParameter = String.class.isAssignableFrom(parameterTypes[0]);
            }
        }

        public boolean isStringParameter() {
            return this._stringParameter;
        }

        public boolean hasMethod() {
            return this._method != null;
        }

        public java.lang.reflect.Method method() {
            return this._method;
        }

        public String toString() {
            return "[ERXRoute.RouteParameterMethod: method=" + (this._method == null ? "(none)" : this._method.toString()) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key {
        protected String _valueType;
        protected String _key;
        private Map<Class<?>, RouteParameterMethod> _routeParameterMethodCache = new ConcurrentHashMap();

        public Key(String key) {
            this(key, String.class.getName());
        }

        public Key(String key, String valueType) {
            this();
            this._key = key;
            this._valueType = valueType;
        }

        protected Key() {
        }

        public String key() {
            return this._key;
        }

        public String valueType() {
            return this._valueType;
        }

        public void _clearRouteParameterMethodCache() {
            this._routeParameterMethodCache.clear();
        }

        public RouteParameterMethod _routeParameterMethodForClass(Class<?> resultsClass) {
            return this._routeParameterMethodCache.get(resultsClass);
        }

        public void _setRouteParameterMethodForClass(RouteParameterMethod routeParameter, Class<?> resultsClass) {
            this._routeParameterMethodCache.put(resultsClass, routeParameter);
        }

        public int hashCode() {
            return this._key.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && ((Key)obj)._key.equals(this._key);
        }

        public String toString() {
            return "[ERXRoute.Key: " + this._key + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        All,
        Get,
        Put,
        Post,
        Delete,
        Head,
        Options,
        Trace,
        Connect;

    }
}

