/*
 * Decompiled with CFR 0.152.
 */
package er.profiling.delegates;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import er.extensions.foundation.ERXProperties;
import er.profiling.PFProfiler;
import er.profiling.PFStatsNode;
import java.util.List;

public class PFHeatMap
implements PFProfiler.Delegate {
    private static Boolean _heatOverride;
    private boolean _heatEnabled;

    public static void setHeatEnabled(boolean heatEnabled) {
        _heatOverride = heatEnabled;
    }

    public static boolean isHeatEnabled() {
        return _heatOverride != null ? _heatOverride : ERXProperties.booleanForKey((String)"PFProfiler.heatMapEnabled");
    }

    public void requestStarted(WORequest request) {
        this._heatEnabled = PFHeatMap.isHeatEnabled();
    }

    public void requestEnded(WORequest request) {
    }

    public void willAppendToResponse(WOElement element, WOResponse response, WOContext context) {
    }

    public void didAppendToResponse(WOElement element, WOResponse response, WOContext context) {
    }

    public void responseEnded(WOResponse response, WOContext context) {
        PFStatsNode rootStats;
        if (this._heatEnabled && (rootStats = PFProfiler.currentStats()) != null) {
            response.appendContentString("<style>");
            this.appendHeatStyles(rootStats, response, context);
            response.appendContentString("</style>");
        }
    }

    protected void appendHeatStyles(PFStatsNode stats, WOResponse response, WOContext context) {
        List<PFStatsNode> children = stats.children();
        if (children != null) {
            for (PFStatsNode child : children) {
                this.appendHeatStyles(child, response, context);
            }
        }
        if ("appendToResponse".equals(stats.name())) {
            double fValue = stats.percentage();
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 1;
            if (!(fValue <= 0.01)) {
                int value = (int)(255.0 * (1.0 - fValue * fValue));
                r = 255;
                g = value;
                b = 0;
                response.appendContentString("." + stats.cssID() + " { !important; border: 3px solid rgba(" + r + "," + g + "," + b + "," + a + ") !important; }\n");
            }
        }
    }
}

