/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSCollectionEnumerator;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaSetIterator;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NSSet
implements Cloneable,
Serializable,
NSCoding,
_NSFoundationCollection,
Set {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSSet");
    public static final NSSet EmptySet = new NSSet();
    static final long serialVersionUID = -8833684352747517048L;
    private static final String SerializationKeysFieldKey = "objects";
    protected transient int _capacity;
    protected transient int _hashtableBuckets;
    protected transient int _count;
    protected Object[] _objects;
    protected transient Object[] _objectsCache;
    protected transient byte[] _flags;
    protected transient int _hashCache;
    protected transient int _deletionLimit;
    protected static int _NSSetClassHashCode = _CLASS.hashCode();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};

    protected void _initializeSet() {
        this._count = 0;
        this._capacity = 0;
        this._objectsCache = null;
        this._objects = null;
        this._flags = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
    }

    protected void _ensureCapacity(int capacity) {
        int newCapacity;
        int currentCapacity = this._capacity;
        if (capacity > currentCapacity && (newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity(capacity)) != currentCapacity) {
            int oldSize = this._hashtableBuckets;
            this._capacity = newCapacity;
            this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(newCapacity);
            int newSize = this._hashtableBuckets;
            if (newSize == 0) {
                this._objects = null;
                this._flags = null;
            } else {
                Object[] oldObjects = this._objects;
                byte[] oldFlags = this._flags;
                this._objects = new Object[newSize];
                this._flags = new byte[newSize];
                for (int i = 0; i < oldSize; ++i) {
                    if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                    _NSCollectionPrimitives.addValueToSet(oldObjects[i], this._objects, this._flags);
                }
            }
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(newSize);
        }
    }

    protected void _clearDeletionsAndCollisions() {
        int size = this._hashtableBuckets;
        if (this._count == 0) {
            this._flags = new byte[size];
        } else {
            Object[] oldObjects = this._objects;
            byte[] oldFlags = this._flags;
            this._objects = new Object[size];
            this._flags = new byte[size];
            for (int i = 0; i < size; ++i) {
                if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                _NSCollectionPrimitives.addValueToSet(oldObjects[i], this._objects, this._flags);
            }
        }
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(size);
    }

    public NSSet() {
        this._initializeSet();
    }

    public NSSet(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        this._initializeSet();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueToSet(object, this._objects, this._flags)) {
            ++this._count;
        }
    }

    private void initFromObjects(Object[] objects, boolean checkForNull) {
        int i;
        if (checkForNull) {
            for (i = 0; i < objects.length; ++i) {
                if (objects[i] != null) continue;
                throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
            }
        }
        this._initializeSet();
        this._ensureCapacity(objects.length);
        for (i = 0; i < objects.length; ++i) {
            if (!_NSCollectionPrimitives.addValueToSet(objects[i], this._objects, this._flags)) continue;
            ++this._count;
        }
    }

    private NSSet(Object[] objects, boolean checkForNull) {
        this.initFromObjects(objects, checkForNull);
    }

    public NSSet(Object[] objects) {
        this(objects, true);
    }

    public NSSet(NSArray objects) {
        this(objects != null ? objects.objectsNoCopy() : null, false);
    }

    public NSSet(NSSet otherSet) {
        this(otherSet != null ? otherSet.objectsNoCopy() : null, false);
    }

    public NSSet(Set set, boolean ignoreNull) {
        if (set == null) {
            throw new IllegalArgumentException("Set cannot be null");
        }
        Object[] aSet = set.toArray();
        this.initFromObjects(aSet, ignoreNull);
    }

    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            this._objectsCache = this._count == 0 ? _NSCollectionPrimitives.EmptyArray : _NSCollectionPrimitives.valuesInHashTable(this._objects, this._objects, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._objectsCache;
    }

    public int count() {
        return this._count;
    }

    public Object member(Object object) {
        return this._count == 0 || object == null ? null : _NSCollectionPrimitives.findValueInHashTable(object, this._objects, this._objects, this._flags);
    }

    public NSSet setByIntersectingSet(NSSet otherSet) {
        NSMutableSet set = new NSMutableSet(this);
        set.intersectSet(otherSet);
        return set;
    }

    public NSSet setBySubtractingSet(NSSet otherSet) {
        NSMutableSet set = new NSMutableSet(this);
        set.subtractSet(otherSet);
        return set;
    }

    public NSSet setByUnioningSet(NSSet otherSet) {
        NSMutableSet set = new NSMutableSet(this);
        set.unionSet(otherSet);
        return set;
    }

    public boolean containsObject(Object object) {
        return object != null ? this.member(object) != null : false;
    }

    public boolean intersectsSet(NSSet otherSet) {
        if (this.count() != 0 && otherSet != null && otherSet.count() != 0) {
            Object[] objects = this.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                if (otherSet.member(objects[i]) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubsetOfSet(NSSet otherSet) {
        int count = this.count();
        if (otherSet == null || otherSet.count() < count) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            if (otherSet.member(objects[i]) != null) continue;
            return false;
        }
        return true;
    }

    private boolean _equalsSet(NSSet otherSet) {
        int count = this.count();
        if (count != otherSet.count()) {
            return false;
        }
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < count; ++i) {
            if (otherSet.member(objects[i]) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualToSet(NSSet otherSet) {
        if (otherSet == null) {
            return false;
        }
        if (otherSet == this) {
            return true;
        }
        return this._equalsSet(otherSet);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSSet) {
            return this._equalsSet((NSSet)object);
        }
        return false;
    }

    public Object anyObject() {
        return this.count() > 0 ? this.objectsNoCopy()[0] : null;
    }

    public Object[] _allObjects() {
        int count = this.count();
        Object[] objects = new Object[count];
        if (count > 0) {
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        }
        return objects;
    }

    public NSArray allObjects() {
        return new NSArray(this.objectsNoCopy());
    }

    public Enumeration objectEnumerator() {
        return new _NSCollectionEnumerator(this._objects, this._flags, this._count);
    }

    public Class classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        return new NSSet(coder.decodeObjects());
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObjects(this.objectsNoCopy());
    }

    public int _shallowHashCode() {
        return _NSSetClassHashCode;
    }

    public int hashCode() {
        return _NSSetClassHashCode ^ this.count();
    }

    public HashSet hashSet() {
        Object[] objects = this.objectsNoCopy();
        HashSet<Object> set = new HashSet<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            set.add(objects[i]);
        }
        return set;
    }

    public Object clone() {
        return this;
    }

    public NSSet immutableClone() {
        return this;
    }

    public NSMutableSet mutableClone() {
        return new NSMutableSet(this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("(");
        Object[] objects = this.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (i > 0) {
                buffer.append(", ");
            }
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append((String)object);
                buffer.append('\"');
                continue;
            }
            if (object instanceof Boolean) {
                buffer.append((Boolean)object != false ? "true" : "false");
                continue;
            }
            buffer.append(object.toString());
        }
        buffer.append(")");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationKeysFieldKey, this._allObjects());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        this.initFromObjects(keys, true);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptySet;
        }
        return this;
    }

    public int size() {
        return this._count;
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public boolean contains(Object o) {
        return this.containsObject(o);
    }

    public boolean containsAll(Collection c) {
        if (c == null) {
            throw new NullPointerException("Collection passed into containsAll() cannot be null");
        }
        Object[] objects = c.toArray();
        if (objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) {
                    return false;
                }
                if (this.member(objects[i]) != null) continue;
                return false;
            }
        }
        return true;
    }

    public Iterator iterator() {
        return new _NSJavaSetIterator(this.objectsNoCopy());
    }

    public Object[] toArray() {
        return this.objectsNoCopy();
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            throw new NullPointerException("Cannot pass null as parameter");
        }
        Object[] currObjects = this.objectsNoCopy();
        if (a.length < currObjects.length) {
            return currObjects;
        }
        System.arraycopy(currObjects, 0, a, 0, currObjects.length);
        return a;
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("retainAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("removeAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    public void clear() {
        throw new UnsupportedOperationException("clear is not a supported operation in com.webobjects.foundation.NSSet");
    }
}

