/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSForwardException;
import java.lang.reflect.Field;

public class _NSSerialFieldDesc {
    private final String _name;
    private final Class _type;
    private final Field _field;

    public static String sanitizeCharForXML(char val, boolean forArray) {
        if (val >= ' ' && val != '\u007f' && val != '\ufffe' && val != '\uffff') {
            if (!forArray) {
                return String.valueOf(val);
            }
            if (val == ' ') {
                return "\\u0020";
            }
            if (val == '\\') {
                return "\\";
            }
            return String.valueOf(val);
        }
        if (val < '\u0010') {
            return "\\u000" + Integer.toHexString(val);
        }
        if (val <= '\u007f') {
            return "\\u00" + Integer.toHexString(val);
        }
        return "\\u" + Integer.toHexString(val);
    }

    public _NSSerialFieldDesc(Field field) {
        this._field = field;
        this._field.setAccessible(true);
        this._name = this._field.getName();
        this._type = this._field.getType();
    }

    public _NSSerialFieldDesc(String name, Class type) {
        this._name = name;
        this._type = type;
        this._field = null;
    }

    public final boolean isPrimitive() {
        return this._type.isPrimitive();
    }

    public final Object value(Object obj) {
        block11: {
            try {
                if (this._type.isPrimitive()) {
                    if (this._type.equals(Boolean.TYPE)) {
                        return String.valueOf(this._field.getBoolean(obj));
                    }
                    if (this._type.equals(Byte.TYPE)) {
                        return String.valueOf(this._field.getByte(obj));
                    }
                    if (this._type.equals(Short.TYPE)) {
                        return String.valueOf(this._field.getShort(obj));
                    }
                    if (this._type.equals(Character.TYPE)) {
                        return _NSSerialFieldDesc.sanitizeCharForXML(this._field.getChar(obj), false);
                    }
                    if (this._type.equals(Integer.TYPE)) {
                        return String.valueOf(this._field.getInt(obj));
                    }
                    if (this._type.equals(Long.TYPE)) {
                        return String.valueOf(this._field.getLong(obj));
                    }
                    if (this._type.equals(Float.TYPE)) {
                        return String.valueOf(this._field.getFloat(obj));
                    }
                    if (this._type.equals(Double.TYPE)) {
                        return String.valueOf(this._field.getDouble(obj));
                    }
                    break block11;
                }
                return this._field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new NSForwardException(e);
            }
        }
        return null;
    }

    public final String name() {
        return this._name;
    }

    public final Class type() {
        return this._type;
    }

    public final Field field() {
        return this._field;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer(20);
        sb.append(this._name);
        sb.append(": ");
        sb.append(this._type);
        return sb.toString();
    }
}

