/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilities;

public class NSMutableSet
extends NSSet {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSMutableSet");
    static final long serialVersionUID = -6054074706096120227L;

    public NSMutableSet() {
    }

    public NSMutableSet(int capacity) {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableSet(Object object) {
        super(object);
    }

    public NSMutableSet(Object[] objects) {
        super(objects);
    }

    public NSMutableSet(NSArray objects) {
        super(objects);
    }

    public NSMutableSet(NSSet otherSet) {
        super(otherSet);
    }

    public void addObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int capacity = this._capacity;
        int count = this._count;
        if (++count > capacity) {
            this._ensureCapacity(count);
        }
        if (_NSCollectionPrimitives.addValueToSet(object, this._objects, this._flags)) {
            this._count = count;
            this._objectsCache = null;
        }
    }

    public Object removeObject(Object object) {
        Object result = null;
        if (object != null && this._count != 0 && (result = _NSCollectionPrimitives.removeValueInHashTable(object, this._objects, this._objects, this._flags)) != null) {
            --this._count;
            --this._deletionLimit;
            if (this._count == 0 || this._deletionLimit == 0) {
                this._clearDeletionsAndCollisions();
            }
            this._objectsCache = null;
        }
        return result;
    }

    public void removeAllObjects() {
        if (this._count != 0) {
            this._objects = new Object[this._hashtableBuckets];
            this._flags = new byte[this._hashtableBuckets];
            this._count = 0;
            this._objectsCache = null;
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
        }
    }

    public void setSet(NSSet otherSet) {
        if (otherSet != this) {
            this.removeAllObjects();
            if (otherSet != null) {
                Object[] objects = otherSet.objectsNoCopy();
                for (int i = 0; i < objects.length; ++i) {
                    this.addObject(objects[i]);
                }
            }
        }
    }

    public void addObjectsFromArray(NSArray array) {
        if (array != null) {
            Object[] objects = array.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                this.addObject(objects[i]);
            }
        }
    }

    public void intersectSet(NSSet otherSet) {
        if (otherSet != this) {
            if (otherSet == null || otherSet.count() == 0) {
                this.removeAllObjects();
                return;
            }
            Object[] objects = this.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                if (otherSet.member(objects[i]) != null) continue;
                this.removeObject(objects[i]);
            }
        }
    }

    public void subtractSet(NSSet otherSet) {
        if (otherSet == null || otherSet.count() == 0) {
            return;
        }
        if (otherSet == this) {
            this.removeAllObjects();
            return;
        }
        Object[] objects = otherSet.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            if (this.member(objects[i]) == null) continue;
            this.removeObject(objects[i]);
        }
    }

    public void unionSet(NSSet otherSet) {
        if (otherSet == null || otherSet.count() == 0 || otherSet == this) {
            return;
        }
        Object[] objects = otherSet.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            this.addObject(objects[i]);
        }
    }

    public Object clone() {
        return new NSMutableSet(this);
    }

    public NSSet immutableClone() {
        return new NSSet(this);
    }

    public NSMutableSet mutableClone() {
        return (NSMutableSet)this.clone();
    }
}

