/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation._NSSerialFieldDesc;
import java.io.Externalizable;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.WeakHashMap;

public class _NSSerialClassReflector {
    private static final Permission XMLSerializationAccessPermission = new RuntimePermission("XMLSerializationAccess");
    private static final Factory _factory = new Factory();
    private Class _cl;
    private boolean _s_zable;
    private boolean _e_zable;
    private _NSSerialFieldDesc[] _fieldDescs;
    private Method[] _methodsForSerialization;
    static final int WRITE_OBJECT = 0;
    static final int READ_OBJECT = 1;
    static final int WRITE_REPLACE = 2;
    static final int READ_RESOLVE = 3;
    private final int NUM_MTDS = 4;
    static /* synthetic */ Class class$com$webobjects$foundation$_NSSerialClassReflector;

    private static _NSSerialClassReflector createClassReflector(final Class cl) {
        return (_NSSerialClassReflector)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class reflClass = class$com$webobjects$foundation$_NSSerialClassReflector == null ? (class$com$webobjects$foundation$_NSSerialClassReflector = _NSSerialClassReflector.class$("com.webobjects.foundation._NSSerialClassReflector")) : class$com$webobjects$foundation$_NSSerialClassReflector;
                    _NSSerialClassReflector refl = (_NSSerialClassReflector)reflClass.newInstance();
                    refl.init(cl);
                    return refl;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new InternalError();
                }
            }
        });
    }

    _NSSerialClassReflector() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(XMLSerializationAccessPermission);
        }
    }

    private void init(Class cl) {
        this._cl = cl;
        this._s_zable = Serializable.class.isAssignableFrom(cl);
        this._e_zable = Externalizable.class.isAssignableFrom(cl);
    }

    private _NSSerialFieldDesc[] serialPersistentFields() {
        ObjectStreamField[] serialPersistentFields = null;
        try {
            Field spf = this._cl.getDeclaredField("serialPersistentFields");
            int mask = 26;
            if ((spf.getModifiers() & mask) == mask) {
                spf.setAccessible(true);
                serialPersistentFields = (ObjectStreamField[])spf.get(null);
                if (serialPersistentFields == null) {
                    serialPersistentFields = ObjectStreamClass.NO_FIELDS;
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (serialPersistentFields != null) {
            this._fieldDescs = new _NSSerialFieldDesc[serialPersistentFields.length];
            for (int i = 0; i < serialPersistentFields.length; ++i) {
                void osf = serialPersistentFields[i];
                try {
                    Field rfield = this._cl.getDeclaredField(osf.getName());
                    if (rfield.getType() == osf.getType() && (rfield.getModifiers() & 8) == 0) {
                        this._fieldDescs[i] = new _NSSerialFieldDesc(rfield);
                    }
                }
                catch (NoSuchFieldException ex) {
                    // empty catch block
                }
                if (this._fieldDescs[i] != null) continue;
                this._fieldDescs[i] = new _NSSerialFieldDesc(osf.getName(), osf.getType());
            }
        }
        return this._fieldDescs;
    }

    private _NSSerialFieldDesc[] defaultSerialFields() {
        Field[] rfields = this._cl.getDeclaredFields();
        ArrayList<_NSSerialFieldDesc> list = new ArrayList<_NSSerialFieldDesc>();
        int mask = 136;
        for (int i = 0; i < rfields.length; ++i) {
            if ((rfields[i].getModifiers() & mask) != 0) continue;
            list.add(new _NSSerialFieldDesc(rfields[i]));
        }
        return list.toArray(new _NSSerialFieldDesc[list.size()]);
    }

    private Method privateMethod(String name, Class[] argTypes, Class returnType) {
        try {
            Method mtd = this._cl.getDeclaredMethod(name, argTypes);
            int mods = mtd.getModifiers();
            mtd.setAccessible(true);
            return mtd.getReturnType() == returnType && (mods & 8) == 0 && (mods & 2) != 0 ? mtd : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private Method inheritableMethod(String name, Class[] argTypes, Class returnType) {
        Package defPkg;
        Class defCl;
        Method metd = null;
        for (defCl = this._cl; defCl != null; defCl = defCl.getSuperclass()) {
            try {
                metd = defCl.getDeclaredMethod(name, argTypes);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        if (metd == null || metd.getReturnType() != returnType) {
            return null;
        }
        metd.setAccessible(true);
        int mods = metd.getModifiers();
        if ((mods & 0x408) != 0) {
            return null;
        }
        if ((mods & 5) != 0) {
            return metd;
        }
        if ((mods & 2) != 0) {
            return this._cl == defCl ? metd : null;
        }
        Package pkg = this._cl.getPackage();
        return pkg == (defPkg = defCl.getPackage()) || pkg != null && pkg.equals(defPkg) ? metd : null;
    }

    public static Factory factory() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(XMLSerializationAccessPermission);
        }
        return _factory;
    }

    public _NSSerialFieldDesc[] serializableFields() {
        if (this._fieldDescs != null) {
            return this._fieldDescs;
        }
        if (this._s_zable && !this._e_zable) {
            this._fieldDescs = this.serialPersistentFields();
            if (this._fieldDescs == null) {
                this._fieldDescs = this.defaultSerialFields();
            }
            Arrays.sort(this._fieldDescs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    _NSSerialFieldDesc f1 = (_NSSerialFieldDesc)o1;
                    _NSSerialFieldDesc f2 = (_NSSerialFieldDesc)o2;
                    boolean prim1 = f1.isPrimitive();
                    if (prim1 != f2.isPrimitive()) {
                        return prim1 ? -1 : 1;
                    }
                    return f1.name().compareTo(f2.name());
                }
            });
        } else {
            this._fieldDescs = new _NSSerialFieldDesc[0];
        }
        return this._fieldDescs;
    }

    public Method[] methodsForSerialization() {
        if (this._methodsForSerialization != null) {
            return this._methodsForSerialization;
        }
        if (this._s_zable && !this._cl.isInterface()) {
            this._methodsForSerialization = new Method[4];
            this._methodsForSerialization[0] = this.privateMethod("writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
            this._methodsForSerialization[2] = this.inheritableMethod("writeReplace", new Class[]{}, Object.class);
        }
        return this._methodsForSerialization;
    }

    public static final class Factory {
        private static WeakHashMap _cachedReflectors = new WeakHashMap();

        private Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public _NSSerialClassReflector classReflector(Class cl) {
            _NSSerialClassReflector[] _NSSerialClassReflectorArray = _cachedReflectors;
            synchronized (_cachedReflectors) {
                _NSSerialClassReflector[] entry = (_NSSerialClassReflector[])_cachedReflectors.get(cl);
                if (entry == null) {
                    entry = new _NSSerialClassReflector[1];
                    _cachedReflectors.put(cl, entry);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                _NSSerialClassReflectorArray = entry;
                synchronized (entry) {
                    if (entry[0] == null) {
                        entry[0] = _NSSerialClassReflector.createClassReflector(cl);
                    }
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return entry[0];
                }
            }
        }
    }
}

