/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.xml;

import com.webobjects.foundation._NSBase64;
import com.webobjects.foundation._NSObjectStreamClass;
import com.webobjects.foundation._NSSerialFieldDesc;
import com.webobjects.foundation.xml.NSXMLObjectOutput;
import com.webobjects.foundation.xml.NSXMLObjectStreamConstants;
import com.webobjects.foundation.xml.NSXMLOutputFormat;
import com.webobjects.foundation.xml._NSXMLObjectStreamClass;
import com.webobjects.foundation.xml._NSXMLPutField;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class NSXMLOutputStream
extends ObjectOutputStream
implements NSXMLObjectStreamConstants,
NSXMLObjectOutput {
    private static final String XMLNS_WOXML = "xmlns";
    private static final String SCHEMA_LOC = "http://www.apple.com/webobjects/5.2/schemas/woxml.xsd";
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final DocumentBuilderFactory _DOM_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory _TRX_FACTORY;
    private static final String ARRAY_DELIMITER = " ";
    static final String BASE64_TYPE = "base64";
    static final String BASE64_ENCODING = "US-ASCII";
    DOMImplementation _dom;
    Document _doc;
    private int _curHandle;
    private DOMRecursiveInfo _DOMRecursiveInfo;
    private OverriddenMtdsRecursiveInfo _OvMtdsRecursiveInfo;
    private NSXMLOutputFormat _outputFormat;
    private boolean _useBase64ForBinaryData = true;
    private boolean _useReferenceForString = true;
    private int _useReferenceForStringLength;
    private int _depth;
    private _LightweightObjectIntMap _handles;
    private _LightweightReplaceMap _replacements;
    private OutputStream _out;
    private Transformer _transformer;

    static Element createTextElement(Document targetDoc, String NodeName, String textData) {
        Element element = targetDoc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", NodeName);
        Text text = targetDoc.createTextNode(textData);
        element.appendChild(text);
        return element;
    }

    private Element writeTextElement(String NodeName, String textData) {
        Element element = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", NodeName);
        Text text = this._doc.createTextNode(textData);
        element.appendChild(text);
        this._DOMRecursiveInfo._curParent.appendChild(element);
        return element;
    }

    private void writeTextElement(String NodeName, String textData, String key) {
        Element ele = this.writeTextElement(NodeName, textData);
        if (key != null) {
            ele.setAttribute("key", key);
        }
    }

    private void clear() {
        this._replacements.clear();
        this._handles.clear();
        this._depth = 0;
    }

    private Element writeElement(String tagName, String key) {
        Element element = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", tagName);
        if (key != null) {
            element.setAttribute("key", key);
        }
        this._DOMRecursiveInfo._curParent.appendChild(element);
        return element;
    }

    private Element writeHandle(String tagName, String key) {
        Element ele = this.writeElement(tagName, key);
        ele.setAttribute("idRef", String.valueOf(this._curHandle));
        return ele;
    }

    private Element writePrimitiveString(String str) {
        Element ele = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", "string");
        char[] arr = str.toCharArray();
        StringBuffer sanitizedString = new StringBuffer(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            if ((arr[i] >= ' ' || arr[i] == '\n' || arr[i] == '\t') && arr[i] != '\u007f' && arr[i] != '\ufffe' && arr[i] != '\uffff') {
                sanitizedString.append(arr[i]);
                continue;
            }
            if (sanitizedString.length() > 0) {
                ele.appendChild(this._doc.createTextNode(sanitizedString.toString()));
            }
            String ch = arr[i] < '\u0010' ? "\\u000" + Integer.toHexString(arr[i]) : (arr[i] <= '\u007f' ? "\\u00" + Integer.toHexString(arr[i]) : "\\u" + Integer.toHexString(arr[i]));
            ele.appendChild(NSXMLOutputStream.createTextElement(this._doc, "ch", ch));
            sanitizedString = new StringBuffer(arr.length - i);
        }
        if (sanitizedString.length() > 0) {
            ele.appendChild(this._doc.createTextNode(sanitizedString.toString()));
        }
        ele.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        return ele;
    }

    private Element writeString(String str, String key) {
        if ((this._useReferenceForString || this._useReferenceForStringLength != -1 && str.length() > this._useReferenceForStringLength) && (this._curHandle = this._handles.lookup(str)) != -1) {
            return this.writeHandle("string", key);
        }
        this._curHandle = this._handles.assign(str);
        Element ele = this.writePrimitiveString(str);
        ele.setAttribute("id", String.valueOf(this._curHandle));
        if (key != null) {
            ele.setAttribute("key", key);
        }
        this._DOMRecursiveInfo._curParent.appendChild(ele);
        return ele;
    }

    private Element writeClassObject(Class cl, String key) {
        Element ele = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", "object");
        DOMRecursiveInfo old = this._DOMRecursiveInfo;
        this._DOMRecursiveInfo = new DOMRecursiveInfo(ele, true);
        this.writeClassDesc(_NSXMLObjectStreamClass.NSXMLlookup(cl));
        ele.setAttribute("id", String.valueOf(this._handles.assign(cl)));
        ele.setAttribute("type", "java.lang.Class");
        if (key != null) {
            ele.setAttribute("key", key);
        }
        this._DOMRecursiveInfo = old;
        this._DOMRecursiveInfo._curParent.appendChild(ele);
        return ele;
    }

    private Object invoke(Object obj, Method method, Object[] args) throws IOException {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t.getMessage());
        }
    }

    private Object findReplacement(Object obj) throws IOException {
        Class<?> repCl;
        _NSXMLObjectStreamClass desc;
        if (obj instanceof String || obj.getClass().isArray()) {
            return obj;
        }
        Class<?> cl = obj.getClass();
        while ((desc = _NSXMLObjectStreamClass.NSXMLlookup(obj.getClass())) != null && desc.hasWriteReplace() && (obj = this.invoke(obj, desc.writeReplaceMethod(), null)) != null && (repCl = obj.getClass()) != cl) {
            cl = repCl;
        }
        return obj;
    }

    private Element writeObjectStreamClass(ObjectStreamClass osc, String key) {
        Element ele = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", "object");
        DOMRecursiveInfo old = this._DOMRecursiveInfo;
        this._DOMRecursiveInfo = new DOMRecursiveInfo(ele, true);
        this.writeClassDesc(_NSXMLObjectStreamClass.NSXMLlookup(osc.forClass()));
        ele.setAttribute("type", "java.io.ObjectStreamClass");
        if (key != null) {
            ele.setAttribute("key", key);
        }
        this._DOMRecursiveInfo = old;
        this._DOMRecursiveInfo._curParent.appendChild(ele);
        return ele;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element writeInternalObject(Object obj, String key) throws IOException {
        Element ele;
        block13: {
            ++this._depth;
            ele = null;
            try {
                boolean replaced = false;
                while (true) {
                    Object rep;
                    if ((obj = this._replacements.lookup(obj)) == null) {
                        Element element = this.writeElement("object", key);
                        return element;
                    }
                    if (obj instanceof Class) {
                        Element element = this.writeClassObject((Class)obj, key);
                        return element;
                    }
                    if (obj instanceof ObjectStreamClass) {
                        Element element = this.writeObjectStreamClass((ObjectStreamClass)obj, key);
                        return element;
                    }
                    if (replaced || (rep = this.findReplacement(obj)) == obj) break;
                    obj = rep;
                    replaced = true;
                }
                if (obj instanceof String) {
                    ele = this.writeString((String)obj, key);
                    break block13;
                }
                if (obj.getClass().isArray()) {
                    ele = this.writeArray(obj, key);
                    break block13;
                }
                if (obj instanceof Serializable) {
                    ele = this.writeNormalObject((Serializable)obj, key);
                    break block13;
                }
                throw new NotSerializableException(obj.getClass().getName());
            }
            finally {
                --this._depth;
            }
        }
        return ele;
    }

    private void writeNonProxyDesc(_NSXMLObjectStreamClass desc) {
        this._curHandle = this._handles.assign(desc);
        DOMRecursiveInfo old = this._DOMRecursiveInfo;
        Element parent = desc.write(this, this._DOMRecursiveInfo._curParent, this._curHandle, this._DOMRecursiveInfo._leafClass ? "class" : "super");
        this._DOMRecursiveInfo = new DOMRecursiveInfo(parent);
        _NSXMLObjectStreamClass superDesc = (_NSXMLObjectStreamClass)desc.superDesc();
        if (superDesc != null) {
            this.writeClassDesc(superDesc);
        }
        this._DOMRecursiveInfo = old;
    }

    private void writeProxyDesc(_NSXMLObjectStreamClass desc) {
        Element proxyEle = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", "proxy");
        proxyEle.setAttribute("id", String.valueOf(this._handles.assign(desc)));
        Class<?>[] ifaces = desc.forClass().getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            Element ifaceEle = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", "interface");
            ifaceEle.setAttribute("name", ifaces[i].getName());
            proxyEle.appendChild(ifaceEle);
        }
        this._DOMRecursiveInfo._curParent.appendChild(proxyEle);
        desc = (_NSXMLObjectStreamClass)desc.superDesc();
        if (this._handles.lookup(desc) == -1) {
            this._handles.assign(desc);
            this._handles.assign("java.lang.reflect.InvocationHandler");
        }
    }

    private void writeClassDesc(_NSXMLObjectStreamClass desc) {
        this._curHandle = this._handles.lookup(desc);
        if (this._curHandle != -1) {
            if (!desc.isProxy()) {
                Element classEle = this.writeHandle(this._DOMRecursiveInfo._leafClass ? "class" : "super", null);
                classEle.setAttribute("name", desc.getName());
            } else {
                this.writeHandle("proxy", null);
            }
        } else if (!desc.isProxy()) {
            this.writeNonProxyDesc(desc);
        } else {
            this.writeProxyDesc(desc);
        }
    }

    private void writeEndDataBlock() {
        Element lastChild = (Element)this._DOMRecursiveInfo._curParent.getLastChild();
        String edb = lastChild.getAttribute("ignoreEDB");
        if (edb.length() == 0) {
            lastChild.setAttribute("ignoreEDB", "1");
        } else {
            try {
                int numEDB = Integer.parseInt(edb);
                lastChild.setAttribute("ignoreEDB", String.valueOf(++numEDB));
            }
            catch (NumberFormatException e) {
                throw new InternalError();
            }
        }
    }

    private void writeExternalizable(Externalizable obj) throws IOException {
        OverriddenMtdsRecursiveInfo old = this._OvMtdsRecursiveInfo;
        this._OvMtdsRecursiveInfo = new OverriddenMtdsRecursiveInfo(obj, null, null);
        obj.writeExternal(this);
        this.writeEndDataBlock();
        this._OvMtdsRecursiveInfo = old;
    }

    private void _writeSerializable(Serializable obj, _NSXMLObjectStreamClass desc) throws IOException {
        if (desc.hasWriteObject()) {
            OverriddenMtdsRecursiveInfo old = this._OvMtdsRecursiveInfo;
            this._OvMtdsRecursiveInfo = new OverriddenMtdsRecursiveInfo(obj, desc, null);
            this.callWriteObjectOverridden();
            this._OvMtdsRecursiveInfo = old;
        } else {
            this.writeFieldsData(obj, desc);
        }
    }

    private void writeSerializable(Serializable obj, _NSXMLObjectStreamClass desc) throws IOException {
        _NSXMLObjectStreamClass localDesc;
        _NSObjectStreamClass[] hierarchy = desc.classHierarchy();
        this._DOMRecursiveInfo._leafClass = false;
        for (int i = 0; i < hierarchy.length - 1; ++i) {
            localDesc = (_NSXMLObjectStreamClass)hierarchy[i];
            this._writeSerializable(obj, localDesc);
        }
        this._DOMRecursiveInfo._leafClass = true;
        localDesc = (_NSXMLObjectStreamClass)hierarchy[hierarchy.length - 1];
        this._writeSerializable(obj, localDesc);
    }

    private Element createPrimFieldElement(Object obj, _NSSerialFieldDesc fieldDesc) {
        _NSXMLObjectStreamClass.PrimitiveValue pv = (_NSXMLObjectStreamClass.PrimitiveValue)_NSXMLObjectStreamClass.primitiveClassToXMLTag.get(fieldDesc.type());
        Element ele = NSXMLOutputStream.createTextElement(this._doc, pv.tag, (String)fieldDesc.value(obj));
        this._DOMRecursiveInfo._curParent.appendChild(ele);
        return ele;
    }

    private void writeProxyData(Object proxy, _NSXMLObjectStreamClass desc) throws IOException {
        desc = (_NSXMLObjectStreamClass)desc.superDesc();
        _NSSerialFieldDesc[] fieldDescs = desc.serializableFields();
        for (int i = 0; i < fieldDescs.length; ++i) {
            _NSSerialFieldDesc fDesc = fieldDescs[i];
            if (fDesc.isPrimitive()) {
                this.createPrimFieldElement(proxy, fDesc);
                continue;
            }
            this.writeInternalObject(fDesc.value(proxy), null);
        }
    }

    private void writeFieldsData(Object obj, _NSXMLObjectStreamClass desc) throws IOException {
        _NSSerialFieldDesc[] fieldDescs = desc.serializableFields();
        int handle = this._handles.lookup(desc);
        for (int i = 0; i < fieldDescs.length; ++i) {
            _NSSerialFieldDesc fDesc = fieldDescs[i];
            Element ele = null;
            ele = fDesc.isPrimitive() ? this.createPrimFieldElement(obj, fDesc) : this.writeInternalObject(fDesc.value(obj), null);
            if (!this._DOMRecursiveInfo._leafClass) {
                ele.setAttribute("classId", String.valueOf(handle));
            }
            ele.setAttribute("field", fDesc.name());
        }
    }

    private Element writeNormalObject(Serializable obj, String key) throws IOException {
        this._curHandle = this._handles.lookup(obj);
        if (this._curHandle != -1) {
            return this.writeHandle("object", key);
        }
        Element objElement = this.writeElement("object", key);
        Class<?> cl = obj.getClass();
        _NSXMLObjectStreamClass desc = _NSXMLObjectStreamClass.NSXMLlookup(cl);
        DOMRecursiveInfo old = this._DOMRecursiveInfo;
        this._DOMRecursiveInfo = new DOMRecursiveInfo(objElement, true);
        this.writeClassDesc(desc);
        objElement.setAttribute("id", String.valueOf(this._handles.assign(obj)));
        if (!desc.isProxy()) {
            if (!Externalizable.class.isAssignableFrom(cl)) {
                this.writeSerializable(obj, desc);
            } else {
                this.writeExternalizable((Externalizable)obj);
            }
        } else {
            this.writeProxyData(obj, desc);
        }
        this._DOMRecursiveInfo = old;
        return objElement;
    }

    private int writeArrayData(Object array, Element parent, _NSXMLObjectStreamClass desc) throws IOException {
        Class<?> ctype = desc.forClass().getComponentType();
        int len = 0;
        if (ctype.isPrimitive()) {
            StringBuffer buf = new StringBuffer(len * 2);
            if (ctype == Boolean.TYPE) {
                boolean[] za = (boolean[])array;
                len = za.length;
                for (int i = 0; i < len; ++i) {
                    buf.append(za[i]);
                    buf.append(ARRAY_DELIMITER);
                }
            } else if (ctype == Byte.TYPE) {
                byte[] ba = (byte[])array;
                len = ba.length;
                if (this._useBase64ForBinaryData) {
                    parent.appendChild(this._doc.createTextNode(new String(_NSBase64.encode(ba, 0, len), BASE64_ENCODING)));
                    return len;
                }
                for (int i = 0; i < len; ++i) {
                    buf.append(ba[i]);
                    buf.append(ARRAY_DELIMITER);
                }
            } else if (ctype == Short.TYPE) {
                short[] sa = (short[])array;
                len = sa.length;
                for (int i = 0; i < len; ++i) {
                    buf.append(sa[i]);
                    buf.append(ARRAY_DELIMITER);
                }
            } else if (ctype == Character.TYPE) {
                char[] ca = (char[])array;
                len = ca.length;
                for (int i = 0; i < len; ++i) {
                    buf.append(_NSSerialFieldDesc.sanitizeCharForXML(ca[i], true));
                    buf.append(ARRAY_DELIMITER);
                }
            } else if (ctype == Integer.TYPE) {
                int[] ia = (int[])array;
                len = ia.length;
                for (int i = 0; i < len; ++i) {
                    buf.append(ia[i]);
                    buf.append(ARRAY_DELIMITER);
                }
            } else if (ctype == Long.TYPE) {
                long[] ja = (long[])array;
                len = ja.length;
                for (int i = 0; i < len; ++i) {
                    buf.append(ja[i]);
                    buf.append(ARRAY_DELIMITER);
                }
            } else if (ctype == Float.TYPE) {
                float[] fa = (float[])array;
                len = fa.length;
                for (int i = 0; i < len; ++i) {
                    buf.append(fa[i]);
                    buf.append(ARRAY_DELIMITER);
                }
            } else if (ctype == Double.TYPE) {
                double[] da = (double[])array;
                len = da.length;
                for (int i = 0; i < len; ++i) {
                    buf.append(da[i]);
                    buf.append(ARRAY_DELIMITER);
                }
            }
            parent.appendChild(this._doc.createTextNode(buf.toString()));
        } else {
            Object[] objs = (Object[])array;
            len = objs.length;
            for (int i = 0; i < len; ++i) {
                parent.appendChild(this.writeInternalObject(objs[i], null));
            }
        }
        return len;
    }

    private Element writeArray(Object array, String key) throws IOException {
        this._curHandle = this._handles.lookup(array);
        if (this._curHandle != -1) {
            return this.writeHandle("array", key);
        }
        Element ele = this.writeElement("array", key);
        _NSXMLObjectStreamClass desc = _NSXMLObjectStreamClass.NSXMLlookup(array.getClass());
        desc.writeArray(this, ele, this._handles.assign(desc));
        ele.setAttribute("id", String.valueOf(this._handles.assign(array)));
        ele.setAttribute("length", String.valueOf(this.writeArrayData(array, ele, desc)));
        return ele;
    }

    private void writeFinalException(IOException e) throws StreamCorruptedException {
        this.clear();
        Element ele = this._doc.createElementNS("http://www.apple.com/webobjects/XMLSerialization", "finalException");
        _NSXMLObjectStreamClass desc = _NSXMLObjectStreamClass.NSXMLlookup(e.getClass());
        Element root = this._doc.getDocumentElement();
        this._DOMRecursiveInfo = new DOMRecursiveInfo(ele, true);
        this.writeClassDesc(desc);
        ele.setAttribute("id", String.valueOf(this._handles.assign(e)));
        try {
            this.writeSerializable(e, desc);
        }
        catch (IOException ex) {
            throw new StreamCorruptedException(ex.getMessage());
        }
        root.appendChild(ele);
        this.clear();
    }

    private void callWriteObjectOverridden() throws IOException {
        this.invoke(this._OvMtdsRecursiveInfo._curObj, this._OvMtdsRecursiveInfo._curDesc.writeObjectMethod(), new Object[]{this});
        this.writeEndDataBlock();
    }

    private boolean isOverridden() {
        return this._OvMtdsRecursiveInfo != null && this._OvMtdsRecursiveInfo.isActive();
    }

    private void initWithTransformer(Source source) throws IOException {
        try {
            this._transformer = _TRX_FACTORY.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    private boolean setUseReferenceForString(boolean on) {
        boolean old = this._useReferenceForString;
        this._useReferenceForString = on;
        this._useReferenceForStringLength = -1;
        return old;
    }

    void setFieldType(Element element, String typeName) {
        this._handles.assign(typeName);
        element.setAttribute("type", typeName);
    }

    Element curParent() {
        return this._DOMRecursiveInfo._curParent;
    }

    protected void writeStreamHeader() throws IOException {
        Element rootEle = this._doc.getDocumentElement();
        this._DOMRecursiveInfo = new DOMRecursiveInfo(rootEle, true);
        rootEle.setAttributeNS(XMLNS_NAMESPACE, XMLNS_WOXML, "http://www.apple.com/webobjects/XMLSerialization");
        rootEle.setAttributeNS(XMLNS_NAMESPACE, "xmlns:xsi", XSI_NAMESPACE);
        rootEle.setAttributeNS(XSI_NAMESPACE, "xsi:schemaLocation", "http://www.apple.com/webobjects/XMLSerialization\nhttp://www.apple.com/webobjects/5.2/schemas/woxml.xsd");
    }

    protected void writeObjectOverride(Object obj) throws IOException {
        try {
            this.writeInternalObject(obj, null);
        }
        catch (IOException ex) {
            if (this._depth == 0) {
                this.writeFinalException(ex);
            }
            throw ex;
        }
    }

    public NSXMLOutputStream(OutputStream out, File xslt) throws IOException {
        this(out);
        this.initWithTransformer(new StreamSource(xslt));
    }

    public NSXMLOutputStream(OutputStream out, InputSource xslt) throws IOException {
        this(out);
        this.initWithTransformer(new SAXSource(xslt));
    }

    public NSXMLOutputStream(OutputStream out, Transformer transformer) throws IOException {
        this(out);
        this._transformer = transformer;
    }

    public NSXMLOutputStream(OutputStream out) throws IOException {
        this._out = out;
        this._handles = new _LightweightObjectIntMap(20, 3.0f);
        this._replacements = new _LightweightReplaceMap(10, 3.0f);
        this._outputFormat = new NSXMLOutputFormat();
        this._outputFormat.setIndenting(false);
        try {
            this._dom = _DOM_BUILDER_FACTORY.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        this._doc = this._dom.createDocument("http://www.apple.com/webobjects/XMLSerialization", "content", null);
        this.writeStreamHeader();
    }

    public void setXSLTSource(File xslt) throws IOException {
        this.initWithTransformer(new StreamSource(xslt));
    }

    public void setXSLTSource(InputSource xslt) throws IOException {
        this.initWithTransformer(new SAXSource(xslt));
    }

    public void setTransformer(Transformer transformer) {
        this._transformer = transformer;
    }

    public Transformer transformer() {
        return this._transformer;
    }

    public NSXMLOutputFormat outputFormat() {
        return this._outputFormat;
    }

    public void setOutputFormat(NSXMLOutputFormat format) {
        this._outputFormat = format;
    }

    public void defaultWriteObject() throws IOException {
        if (!this.isOverridden()) {
            throw new NotActiveException("This method has to be called from writeObject");
        }
        this.writeFieldsData(this._OvMtdsRecursiveInfo._curObj, this._OvMtdsRecursiveInfo._curDesc);
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (!this.isOverridden()) {
            throw new NotActiveException("This method has to be called from writeObject");
        }
        if (this._OvMtdsRecursiveInfo._curPutField == null) {
            this._OvMtdsRecursiveInfo._curPutField = new _NSXMLPutField(this, this._OvMtdsRecursiveInfo._curDesc, this._DOMRecursiveInfo);
        }
        return this._OvMtdsRecursiveInfo._curPutField;
    }

    public void writeFields() throws IOException {
        if (this._OvMtdsRecursiveInfo == null || this._OvMtdsRecursiveInfo._curPutField == null) {
            throw new NotActiveException("Use putFields() method to get a PutField object first");
        }
        this._OvMtdsRecursiveInfo._curPutField.writeFields();
    }

    public void write(int val) throws IOException {
        this.writeByte(val);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.write(buf, off, len, null);
    }

    public void writeBoolean(boolean val) throws IOException {
        this.writeTextElement("boolean", val ? "true" : "false");
    }

    public void writeByte(int val) throws IOException {
        this.writeTextElement("byte", String.valueOf((byte)val));
    }

    public void writeShort(int val) throws IOException {
        this.writeTextElement("short", String.valueOf((short)val));
    }

    public void writeChar(int val) throws IOException {
        this.writeTextElement("ch", _NSSerialFieldDesc.sanitizeCharForXML((char)val, false));
    }

    public void writeInt(int val) throws IOException {
        this.writeTextElement("int", String.valueOf(val));
    }

    public void writeLong(long val) throws IOException {
        this.writeTextElement("long", String.valueOf(val));
    }

    public void writeFloat(float val) throws IOException {
        this.writeTextElement("float", String.valueOf(val));
    }

    public void writeDouble(double val) throws IOException {
        this.writeTextElement("double", String.valueOf(val));
    }

    public void writeBytes(String str) throws IOException {
        this.write(str.getBytes(this._outputFormat.encoding()));
    }

    public void writeChars(String str) throws IOException {
        this.writeChars(str, null);
    }

    public void writeUTF(String str) throws IOException {
        this._DOMRecursiveInfo._curParent.appendChild(this.writePrimitiveString(str));
    }

    public void reset() throws IOException {
        if (this._depth != 0) {
            throw new IOException("Currently in process of serializing an object");
        }
        this.clear();
        this._doc = this._dom.createDocument("http://www.apple.com/webobjects/XMLSerialization", "content", null);
        this.writeStreamHeader();
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public void close() throws IOException {
        if (this._doc != null) {
            if (this._transformer == null) {
                XMLSerializer s = new XMLSerializer(this._out, this._outputFormat.outputFormat());
                s.serialize(this._doc);
            } else {
                try {
                    this._transformer.transform(new DOMSource(this._doc), new StreamResult(this._out));
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
        }
        this.clear();
        this._out.close();
        this._doc = null;
    }

    public void write(int val, String key) {
        this.writeByte(val, key);
    }

    public void write(byte[] buf, String key) throws IOException {
        this.write(buf, 0, buf.length, key);
    }

    public void write(byte[] buf, int off, int len, String key) throws IOException {
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        Element ele = this.writeElement("array", null);
        if (this._useBase64ForBinaryData) {
            ele.setAttribute("type", BASE64_TYPE);
            ele.appendChild(this._doc.createTextNode(new String(_NSBase64.encode(buf, off, len), BASE64_ENCODING)));
        } else {
            ele.setAttribute("type", "byte[]");
            StringBuffer strBuf = new StringBuffer(len * 2);
            for (int i = off; i < len; ++i) {
                strBuf.append(buf[i]);
                strBuf.append(ARRAY_DELIMITER);
            }
            ele.appendChild(this._doc.createTextNode(strBuf.toString()));
        }
        ele.setAttribute("length", String.valueOf(buf.length));
        if (key != null) {
            ele.setAttribute("key", key);
        }
    }

    public void writeBoolean(boolean val, String key) {
        this.writeTextElement("boolean", val ? "true" : "false", key);
    }

    public void writeByte(int val, String key) {
        this.writeTextElement("byte", String.valueOf(val), key);
    }

    public void writeShort(int val, String key) {
        this.writeTextElement("short", String.valueOf((short)val), key);
    }

    public void writeChar(int val, String key) {
        this.writeTextElement("ch", _NSSerialFieldDesc.sanitizeCharForXML((char)val, false), key);
    }

    public void writeInt(int val, String key) {
        this.writeTextElement("int", String.valueOf(val), key);
    }

    public void writeLong(long val, String key) {
        this.writeTextElement("long", String.valueOf(val), key);
    }

    public void writeFloat(float val, String key) {
        this.writeTextElement("float", String.valueOf(val), key);
    }

    public void writeDouble(double val, String key) {
        this.writeTextElement("double", String.valueOf(val), key);
    }

    public void writeObject(Object obj, String key) throws IOException {
        this.writeInternalObject(obj, key);
    }

    public void writeBytes(String str, String key) throws IOException {
        this.write(str.getBytes(this._outputFormat.encoding()), key);
    }

    public void writeChars(String str, String key) throws IOException {
        char[] chars = str.toCharArray();
        Element ele = this.writeElement("array", null);
        _NSXMLObjectStreamClass desc = _NSXMLObjectStreamClass.NSXMLlookup(chars.getClass());
        desc.writeArray(this, ele, 0);
        ele.setAttribute("length", String.valueOf(this.writeArrayData(chars, ele, desc)));
        if (key != null) {
            ele.setAttribute("key", key);
        }
    }

    public void writeUTF(String str, String key) {
        Element ele = this.writePrimitiveString(str);
        if (key != null) {
            ele.setAttribute("key", key);
        }
        this._DOMRecursiveInfo._curParent.appendChild(ele);
    }

    public void writeComment(String comment) {
        this._DOMRecursiveInfo._curParent.appendChild(this._doc.createComment(comment));
    }

    public void writeRootComment(String comment, boolean before) {
        if (before) {
            this._doc.insertBefore(this._doc.createComment(comment), this._doc.getDocumentElement());
        } else {
            this._doc.appendChild(this._doc.createComment(comment));
        }
    }

    public final boolean setUseBase64ForBinaryData(boolean on) {
        boolean old = this._useBase64ForBinaryData;
        this._useBase64ForBinaryData = on;
        return old;
    }

    public final boolean useBase64ForBinaryData() {
        return this._useBase64ForBinaryData;
    }

    public boolean enableReferenceForString() {
        return this.setUseReferenceForString(true);
    }

    public boolean disableReferenceForString() {
        return this.setUseReferenceForString(false);
    }

    public int disableReferenceForString(int length) {
        int old = this._useReferenceForStringLength;
        this._useReferenceForString = false;
        this._useReferenceForStringLength = length;
        return old;
    }

    public boolean useReferenceForString() {
        return this._useReferenceForString;
    }

    static {
        _DOM_BUILDER_FACTORY.setAttribute("http://xml.org/sax/features/validation", Boolean.FALSE);
        _DOM_BUILDER_FACTORY.setNamespaceAware(true);
        _TRX_FACTORY = TransformerFactory.newInstance();
    }

    private static final class OverriddenMtdsRecursiveInfo {
        Object _curObj;
        _NSXMLObjectStreamClass _curDesc;
        private _NSXMLPutField _curPutField;

        OverriddenMtdsRecursiveInfo(Object curObj, _NSXMLObjectStreamClass curDesc, _NSXMLPutField putField) {
            this._curObj = curObj;
            this._curDesc = curDesc;
            this._curPutField = putField;
        }

        boolean isActive() {
            return this._curObj != null && this._curDesc != null;
        }
    }

    static final class DOMRecursiveInfo {
        Element _curParent;
        boolean _leafClass;

        DOMRecursiveInfo(Element parent) {
            this._curParent = parent;
        }

        DOMRecursiveInfo(Element parent, boolean leaf) {
            this._curParent = parent;
            this._leafClass = leaf;
        }
    }

    private static final class _LightweightReplaceMap {
        private _LightweightObjectIntMap _indices;
        private Object[] _replacements;

        private void grow() {
            Object[] newSubs = new Object[(this._replacements.length << 1) + 1];
            System.arraycopy(this._replacements, 0, newSubs, 0, this._replacements.length);
            this._replacements = newSubs;
        }

        _LightweightReplaceMap(int initialCapacity, float loadFactor) {
            this._indices = new _LightweightObjectIntMap(initialCapacity, loadFactor);
            this._replacements = new Object[initialCapacity];
        }

        void assign(Object obj, Object rep) {
            int index = this._indices.assign(obj);
            while (index >= this._replacements.length) {
                this.grow();
            }
            this._replacements[index] = rep;
        }

        Object lookup(Object obj) {
            int index = this._indices.lookup(obj);
            return index >= 0 ? this._replacements[index] : obj;
        }

        void clear() {
            Arrays.fill(this._replacements, 0, this._indices.size(), null);
            this._indices.clear();
        }

        int size() {
            return this._indices.size();
        }
    }

    private static final class _LightweightObjectIntMap {
        private int _nextInt;
        private int _threshold;
        private float _loadFactor;
        private int[] _spine;
        private int[] _next;
        private Object[] _objs;

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this._spine.length;
            this._objs[handle] = obj;
            this._next[handle] = this._spine[index];
            this._spine[index] = handle;
        }

        private void growSpine() {
            this._spine = new int[(this._spine.length << 1) + 1];
            this._threshold = (int)((float)this._spine.length * this._loadFactor);
            Arrays.fill(this._spine, -1);
            for (int i = 0; i < this._nextInt; ++i) {
                this.insert(this._objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this._next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this._next, 0, newNext, 0, this._nextInt);
            this._next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this._objs, 0, newObjs, 0, this._nextInt);
            this._objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }

        _LightweightObjectIntMap(int initialCapacity, float loadFactor) {
            this._loadFactor = loadFactor;
            this._spine = new int[initialCapacity];
            this._next = new int[initialCapacity];
            this._objs = new Object[initialCapacity];
            this._threshold = (int)((float)initialCapacity * this._loadFactor);
            this.clear();
        }

        int assign(Object obj) {
            if (this._nextInt >= this._next.length) {
                this.growEntries();
            }
            if (this._nextInt >= this._threshold) {
                this.growSpine();
            }
            this.insert(obj, this._nextInt);
            return this._nextInt++;
        }

        int lookup(Object obj) {
            int index = this.hash(obj) % this._spine.length;
            int i = this._spine[index];
            while (i >= 0) {
                if (this._objs[i] == obj) {
                    return i;
                }
                i = this._next[i];
            }
            return -1;
        }

        void clear() {
            Arrays.fill(this._spine, -1);
            Arrays.fill(this._objs, 0, this._nextInt, null);
            this._nextInt = 0;
        }

        int size() {
            return this._nextInt;
        }
    }
}

