/*
 * Decompiled with CFR 0.152.
 */
package er.rest.format;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSTimestamp;
import er.rest.ERXRestRequestNode;
import er.rest.ERXRestUtils;
import er.rest.format.ERXRestFormat;
import er.rest.format.IERXRestResponse;
import er.rest.format.IERXRestWriter;
import java.util.Set;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonValueProcessorMatcher;

public class ERXJSONRestWriter
implements IERXRestWriter {
    public static JsonConfig _config = new JsonConfig();

    protected void removeDictionaryTypes(ERXRestRequestNode node) {
        NSArray<ERXRestRequestNode> children;
        String type = node.type();
        if ("NSDictionary".equals(type) || "NSMutableDictionary".equals(type)) {
            node.setType(null);
        }
        if ((children = node.children()) != null) {
            for (ERXRestRequestNode child : children) {
                this.removeDictionaryTypes(child);
            }
        }
    }

    protected ERXRestRequestNode processNode(ERXRestRequestNode node) {
        return node;
    }

    public void appendHeadersToResponse(ERXRestRequestNode node, IERXRestResponse response) {
        response.setHeader("application/json", "Content-Type");
    }

    public void appendToResponse(ERXRestRequestNode node, IERXRestResponse response, ERXRestFormat.Delegate delegate) {
        node = this.processNode(node);
        this.removeDictionaryTypes(node);
        this.appendHeadersToResponse(node, response);
        Object object = node.toJavaCollection(delegate);
        if (object == null) {
            response.appendContentString("undefined");
        } else if (ERXRestUtils.isPrimitive(object)) {
            response.appendContentString(String.valueOf(object));
        } else {
            response.appendContentString(JSONSerializer.toJSON((Object)object, (JsonConfig)_config).toString());
        }
        response.appendContentString("\n");
    }

    static {
        _config.registerJsonValueProcessor(NSTimestamp.class, (JsonValueProcessor)new NSTimestampProcessor());
        _config.setJsonValueProcessorMatcher((JsonValueProcessorMatcher)new ERXRestValueProcessorMatcher());
    }

    public static class NSTimestampProcessor
    implements JsonValueProcessor {
        public Object processArrayValue(Object obj, JsonConfig jsonconfig) {
            return ERXRestUtils.coerceValueToString(obj);
        }

        public Object processObjectValue(String s, Object obj, JsonConfig jsonconfig) {
            return ERXRestUtils.coerceValueToString(obj);
        }
    }

    public static final class ERXRestValueProcessorMatcher
    extends JsonValueProcessorMatcher {
        public Object getMatch(Class target, Set set) {
            if (target != null && set != null && set.contains(target)) {
                return target;
            }
            return null;
        }
    }
}

