/*
 * Decompiled with CFR 0.152.
 */
package er.rest.routes;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WOPageNotFoundException;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSUtilities;
import er.extensions.appserver.ERXRequest;
import er.extensions.eof.ERXDatabaseContextDelegate;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXKeyFilter;
import er.extensions.foundation.ERXExceptionUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import er.rest.ERXRequestFormValues;
import er.rest.ERXRestClassDescriptionFactory;
import er.rest.ERXRestFetchSpecification;
import er.rest.ERXRestRequestNode;
import er.rest.IERXRestDelegate;
import er.rest.format.ERXRestFormat;
import er.rest.format.ERXWORestRequest;
import er.rest.format.ERXWORestResponse;
import er.rest.format.IERXRestParser;
import er.rest.routes.ERXRoute;
import er.rest.routes.ERXRouteParameter;
import er.rest.routes.ERXRouteRequestHandler;
import er.rest.routes.ERXRouteResults;
import er.rest.routes.IERXRouteComponent;
import er.rest.routes.jsr311.PathParam;
import er.rest.util.ERXRestSchema;
import er.rest.util.ERXRestTransactionRequestAdaptor;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRouteController
extends WODirectAction {
    protected static Logger log = Logger.getLogger(ERXRouteController.class);
    private ERXRouteRequestHandler _requestHandler;
    private ERXRoute _route;
    private String _entityName;
    private ERXRestFormat _format;
    private NSDictionary<ERXRoute.Key, String> _routeKeys;
    private NSDictionary<ERXRoute.Key, Object> _objects;
    private EOEditingContext _editingContext;
    private ERXRestRequestNode _requestNode;
    private NSKeyValueCoding _options;
    private NSSet<String> _prefetchingKeyPaths;
    private boolean _shouldDisposeEditingContext = true;
    private static final String REQUEST_CONTROLLERS_KEY = "ERRest.controllersForRequest";

    public ERXRouteController(WORequest request) {
        super(request);
        ERXRouteController._registerControllerForRequest(this, request);
    }

    protected ERXKeyFilter includeOptional(ERXKey<?> key, ERXKeyFilter filter) {
        if (this.isKeyPathRequested(key)) {
            return filter.include(key);
        }
        return ERXKeyFilter.filterWithNone();
    }

    protected boolean isKeyPathRequested(ERXKey<?> key) {
        return this.isKeyPathRequested(key.key());
    }

    protected boolean isKeyPathRequested(String keyPath) {
        if (this._prefetchingKeyPaths == null) {
            String prefetchingKeyPathsStr;
            NSMutableSet prefetchingKeyPaths = new NSMutableSet();
            NSKeyValueCoding options = this.options();
            if (options != null && (prefetchingKeyPathsStr = (String)options.valueForKey("prefetchingKeyPaths")) != null) {
                for (String prefetchingKeyPath : prefetchingKeyPathsStr.split(",")) {
                    prefetchingKeyPaths.addObject((Object)prefetchingKeyPath);
                }
            }
            this._prefetchingKeyPaths = prefetchingKeyPaths;
        }
        return this._prefetchingKeyPaths.containsObject((Object)keyPath);
    }

    public void setOptions(NSKeyValueCoding options) {
        this._options = options;
    }

    public NSKeyValueCoding options() {
        if (this._options == null) {
            this._options = new ERXRequestFormValues(this.request());
        }
        return this._options;
    }

    public void _setContext(WOContext context) {
        try {
            Field contextField = WOAction.class.getDeclaredField("_context");
            contextField.setAccessible(true);
            contextField.set((Object)this, context);
        }
        catch (Throwable t) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
        }
    }

    public void _setRequestHandler(ERXRouteRequestHandler requestHandler) {
        this._requestHandler = requestHandler;
    }

    public ERXRouteRequestHandler requestHandler() {
        return this._requestHandler;
    }

    protected void checkAccess() throws SecurityException {
    }

    public EOEditingContext editingContext() {
        if (this._editingContext == null) {
            ERXRestTransactionRequestAdaptor transactionAdaptor = ERXRestTransactionRequestAdaptor.defaultAdaptor();
            this._editingContext = transactionAdaptor.transactionsEnabled() && transactionAdaptor.isExecutingTransaction(this.context(), this.request()) ? this.newEditingContext((EOObjectStore)transactionAdaptor.executingTransaction(this.context(), this.request()).editingContext()) : this.newEditingContext();
        }
        return this._editingContext;
    }

    protected EOEditingContext newEditingContext() {
        return ERXEC.newEditingContext();
    }

    protected EOEditingContext newEditingContext(EOObjectStore objectStore) {
        return ERXEC.newEditingContext((EOObjectStore)objectStore);
    }

    public void _setRoute(ERXRoute route) {
        this._route = route;
    }

    public ERXRoute route() {
        return this._route;
    }

    public void _setRouteKeys(NSDictionary<ERXRoute.Key, String> routeKeys) {
        this._routeKeys = routeKeys;
        if (this._routeKeys != routeKeys) {
            this._objects = null;
        }
    }

    public NSDictionary<ERXRoute.Key, String> routeKeys() {
        return this._routeKeys;
    }

    public String routeStringForKey(String key) {
        return (String)this._routeKeys.objectForKey((Object)new ERXRoute.Key(key));
    }

    public boolean containsRouteKey(String key) {
        return this._routeKeys.containsKey((Object)new ERXRoute.Key(key));
    }

    public <T> T routeObjectForKey(String key) {
        return (T)this.routeObjects().objectForKey((Object)new ERXRoute.Key(key));
    }

    public void _setRouteObjects(NSDictionary<ERXRoute.Key, Object> objects) {
        this._objects = objects;
    }

    public NSDictionary<ERXRoute.Key, Object> routeObjects() {
        if (this._objects == null) {
            this._objects = ERXRoute.keysWithObjects(this._routeKeys, this.delegate());
        }
        return this._objects;
    }

    public NSDictionary<ERXRoute.Key, Object> routeObjects(IERXRestDelegate delegate) {
        if (this._route != null) {
            this._objects = ERXRoute.keysWithObjects(this._routeKeys, delegate);
        }
        return this._objects;
    }

    protected ERXRestFormat defaultFormat() {
        String defaultFormatName = ERXProperties.stringForKeyWithDefault((String)"ERXRest.defaultFormat", (String)ERXRestFormat.XML.name());
        return ERXRestFormat.formatNamed(defaultFormatName);
    }

    public void _setFormat(ERXRestFormat format) {
        this._format = format;
    }

    public ERXRestFormat format() {
        ERXRestFormat format = this._format;
        if (format == null) {
            String type = null;
            NSDictionary userInfo = this.request().userInfo();
            if (userInfo != null) {
                type = (String)this.request().userInfo().objectForKey((Object)"ERXRouteRequestHandler.type");
            }
            format = type == null ? this.defaultFormat() : ERXRestFormat.formatNamed(type);
        }
        return format;
    }

    protected IERXRestDelegate delegate() {
        return IERXRestDelegate.Factory.delegateForEntityNamed(this.entityName(), this.editingContext());
    }

    public void _setRequestContent(ERXRestFormat format, String requestContent) {
        this._setFormat(format);
        this._setRequestContent(requestContent);
    }

    public void _setRequestContent(String requestContent) {
        this._requestNode = this.format().parse(requestContent);
    }

    public void _setRequestNode(ERXRestRequestNode requestNode) {
        this._requestNode = requestNode;
    }

    public ERXRestRequestNode requestNode() {
        if (this._requestNode == null) {
            try {
                ERXRestFormat format = this.format();
                IERXRestParser parser = format.parser();
                if (parser == null) {
                    throw new IllegalStateException("There is no parser for the format '" + format.name() + "'.");
                }
                this._requestNode = parser.parseRestRequest(new ERXWORestRequest(this.request()), this.format().delegate());
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to parse a " + this.format() + " request.", t);
            }
        }
        return this._requestNode;
    }

    public <T> T object(ERXKeyFilter filter) {
        return this.object(this.entityName(), filter, this.delegate());
    }

    public <T> T object(String entityName, ERXKeyFilter filter) {
        return this.object(entityName, filter, this.delegate());
    }

    public <T> T object(ERXKeyFilter filter, IERXRestDelegate delegate) {
        return (T)this.requestNode().objectWithFilter(this.entityName(), filter, delegate);
    }

    public <T> T object(String entityName, ERXKeyFilter filter, IERXRestDelegate delegate) {
        return (T)this.requestNode().objectWithFilter(entityName, filter, delegate);
    }

    public <T> T create(ERXKeyFilter filter) {
        return this.create(this.entityName(), filter);
    }

    public <T> T create(String entityName, ERXKeyFilter filter) {
        return this.create(entityName, filter, this.delegate());
    }

    public <T> T create(ERXKeyFilter filter, IERXRestDelegate delegate) {
        return (T)this.requestNode().createObjectWithFilter(this.entityName(), filter, delegate);
    }

    public <T> T create(String entityName, ERXKeyFilter filter, IERXRestDelegate delegate) {
        return (T)this.requestNode().createObjectWithFilter(entityName, filter, delegate);
    }

    public void update(Object obj, ERXKeyFilter filter) {
        this.update(obj, filter, this.delegate());
    }

    public void update(Object obj, ERXKeyFilter filter, IERXRestDelegate delegate) {
        this.requestNode().updateObjectWithFilter(obj, filter, delegate);
    }

    public WOResponse stringResponse(String str) {
        WOResponse response = WOApplication.application().createResponseInContext(this.context());
        response.appendContentString(str);
        return response;
    }

    public WOActionResults json(String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.JSON, this.editingContext(), entityName, values, filter);
    }

    public WOActionResults json(EOEditingContext editingContext, String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.JSON, editingContext, entityName, values, filter);
    }

    public WOActionResults json(EOClassDescription entity, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.JSON, entity, values, filter);
    }

    public WOActionResults plist(String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.PLIST, this.editingContext(), entityName, values, filter);
    }

    public WOActionResults plist(EOEditingContext editingContext, String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.PLIST, editingContext, entityName, values, filter);
    }

    public WOActionResults plist(EOClassDescription entity, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.PLIST, entity, values, filter);
    }

    public WOActionResults xml(String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.XML, this.editingContext(), entityName, values, filter);
    }

    public WOActionResults xml(EOEditingContext editingContext, String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.XML, editingContext, entityName, values, filter);
    }

    public WOActionResults xml(EOClassDescription entity, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.XML, entity, values, filter);
    }

    protected boolean _canSetHeaderForActionResults(WOActionResults results) {
        return results instanceof WOResponse || results instanceof ERXRouteResults;
    }

    protected void _setHeaderForActionResults(String value, String key, WOActionResults results) {
        if (results instanceof WOResponse) {
            ((WOResponse)results).setHeader(value, key);
        } else if (results instanceof ERXRouteResults) {
            ((ERXRouteResults)results).setHeaderForKey(value, key);
        } else {
            log.info((Object)("Unable to set a header on an action results of type '" + results.getClass().getName() + "'."));
        }
    }

    public WOActionResults response(ERXRestFetchSpecification<?> fetchSpec, ERXKeyFilter filter) {
        WOActionResults results;
        if (fetchSpec == null) {
            results = this.response(this.format(), null, filter);
        } else {
            ERXRestFetchSpecification.Results<?> fetchResults = fetchSpec.results(this.editingContext(), this.options());
            results = this.response(this.format(), this.editingContext(), fetchSpec.entityName(), fetchResults.objects(), filter);
            if (fetchResults.batchSize() > 0 && this.options().valueForKey("Range") != null && this._canSetHeaderForActionResults(results)) {
                String contentRangeValue = "items " + fetchResults.startIndex() + "-" + (fetchResults.startIndex() + fetchResults.batchSize() - 1) + "/" + fetchResults.totalCount();
                this._setHeaderForActionResults(contentRangeValue, "Content-Range", results);
            }
        }
        return results;
    }

    public WOActionResults response(String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(this.format(), this.editingContext(), entityName, values, filter);
    }

    public WOActionResults response(EOEditingContext editingContext, String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(this.format(), editingContext, entityName, values, filter);
    }

    public WOActionResults response(EOClassDescription entity, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(this.format(), entity, values, filter);
    }

    public WOActionResults response(ERXRestFormat format, String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(format, this.editingContext(), entityName, values, filter);
    }

    public WOActionResults response(ERXRestFormat format, EOEditingContext editingContext, String entityName, NSArray<?> values, ERXKeyFilter filter) {
        return this.response(format, ERXRestClassDescriptionFactory.classDescriptionForEntityName(entityName), values, filter);
    }

    public WOActionResults response(ERXRestFormat format, EOClassDescription entity, NSArray<?> values, ERXKeyFilter filter) {
        ERXRestRequestNode responseNode;
        try {
            responseNode = ERXRestRequestNode.requestNodeWithObjectAndFilter(entity, values, filter, this.delegate());
        }
        catch (ERXDatabaseContextDelegate.ObjectNotAvailableException e) {
            return this.errorResponse(e, 404);
        }
        catch (SecurityException e) {
            return this.errorResponse(e, 403);
        }
        catch (Throwable t) {
            return this.errorResponse(t, 500);
        }
        return this.response(format, responseNode);
    }

    public WOActionResults response(ERXRestFormat format, ERXRestRequestNode responseNode) {
        ERXRouteResults results = new ERXRouteResults(this.context(), format, responseNode);
        return results;
    }

    public WOActionResults json(Object value, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.JSON, value, filter);
    }

    public WOActionResults plist(Object value, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.PLIST, value, filter);
    }

    public WOActionResults xml(Object value, ERXKeyFilter filter) {
        return this.response(ERXRestFormat.XML, value, filter);
    }

    public WOActionResults response(Object value, ERXKeyFilter filter) {
        return this.response(this.format(), value, filter);
    }

    public WOActionResults response(ERXRestFormat format, Object value, ERXKeyFilter filter) {
        ERXRestRequestNode responseNode;
        try {
            responseNode = ERXRestRequestNode.requestNodeWithObjectAndFilter(value, filter, this.delegate());
        }
        catch (ERXDatabaseContextDelegate.ObjectNotAvailableException e) {
            return this.errorResponse(e, 404);
        }
        catch (SecurityException e) {
            return this.errorResponse(e, 403);
        }
        catch (Throwable t) {
            return this.errorResponse(t, 500);
        }
        return this.response(format, responseNode);
    }

    public WOActionResults errorResponse(Throwable t, int status) {
        String errorMessage = ERXLocalizer.defaultLocalizer().localizedStringForKey("ERXRest." + this.entityName() + ".errorMessage." + status);
        if (errorMessage == null && (errorMessage = ERXLocalizer.defaultLocalizer().localizedStringForKey("ERXRest.errorMessage." + status)) == null) {
            errorMessage = ERXExceptionUtilities.toParagraph((Throwable)t, (boolean)false);
        }
        String str = this.format().toString(errorMessage, null, null);
        WOResponse response = this.stringResponse(str);
        response.setStatus(status);
        log.error((Object)("Request failed: " + this.request().uri()), t);
        return response;
    }

    public WOActionResults errorResponse(String errorMessage, int status) {
        String formattedErrorMessage = this.format().toString(errorMessage, null, null);
        WOResponse response = this.stringResponse(formattedErrorMessage);
        response.setStatus(status);
        log.error((Object)("Request failed: " + this.request().uri() + ", " + errorMessage));
        return response;
    }

    public WOActionResults headAction() {
        WOResponse response = WOApplication.application().createResponseInContext(this.context());
        this.format().writer().appendHeadersToResponse(null, new ERXWORestResponse(response));
        return response;
    }

    protected void _takeRouteParametersFromRequest(WOActionResults results) {
        Class<?> resultsClass = results.getClass();
        for (ERXRoute.Key key : this._routeKeys.allKeys()) {
            ERXRoute.RouteParameterMethod routeParameterMethod = key._routeParameterMethodForClass(resultsClass);
            String keyName = key.key();
            if (routeParameterMethod == null) {
                Method[] possibleMethods;
                String capitalizedKeyName = ERXRestClassDescriptionFactory._guessMismatchedCaseEntityName(keyName);
                if (capitalizedKeyName == null) {
                    capitalizedKeyName = ERXStringUtilities.capitalize((String)keyName);
                }
                String setMethodName = "set" + capitalizedKeyName;
                Method matchingMethod = null;
                for (Method possibleMethod : possibleMethods = resultsClass.getMethods()) {
                    ERXRouteParameter routeParameter = possibleMethod.getAnnotation(ERXRouteParameter.class);
                    if (routeParameter == null || !keyName.equals(routeParameter.value()) && !possibleMethod.getName().equalsIgnoreCase(setMethodName)) continue;
                    matchingMethod = possibleMethod;
                    break;
                }
                routeParameterMethod = new ERXRoute.RouteParameterMethod(matchingMethod);
                key._setRouteParameterMethodForClass(routeParameterMethod, resultsClass);
            }
            if (!routeParameterMethod.hasMethod()) continue;
            try {
                if (routeParameterMethod.isStringParameter()) {
                    routeParameterMethod.method().invoke((Object)results, this.routeStringForKey(keyName));
                    continue;
                }
                Object routeObject = this.routeObjectForKey(keyName);
                if (routeObject instanceof EOEnterpriseObject && ((EOEnterpriseObject)routeObject).editingContext() == this._editingContext) {
                    this._shouldDisposeEditingContext = false;
                }
                routeParameterMethod.method().invoke((Object)results, routeObject);
            }
            catch (Throwable t) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
            }
        }
    }

    protected boolean isAutomaticHtmlRoutingEnabled() {
        return false;
    }

    protected boolean shouldFailOnMissingHtmlPage() {
        return false;
    }

    public void _setEntityName(String entityName) {
        this._entityName = entityName;
    }

    protected String entityName() {
        ERXRoute route;
        String entityName = this._entityName;
        if (entityName == null && (route = this.route()) != null) {
            entityName = route.entityName();
        }
        if (entityName == null) {
            throw new IllegalStateException("Unable to determine the entity name for the controller '" + ((Object)((Object)this)).getClass().getSimpleName() + "'. Please override entityName().");
        }
        return entityName;
    }

    protected String pageNameForAction(String actionName) {
        return this.entityName() + ERXStringUtilities.capitalize((String)actionName) + "Page";
    }

    protected WOActionResults performUnknownAction(String actionName) throws Throwable {
        throw new FileNotFoundException("There is no action named '" + actionName + "Action' on '" + ((Object)((Object)this)).getClass().getSimpleName() + "'.");
    }

    public WOActionResults performActionNamed(String actionName) {
        return this.performActionNamed(actionName, false);
    }

    public ERXRestRequestNode responseNodeForActionNamed(String actionName) {
        String contentString = this.performActionNamed(actionName, true).generateResponse().contentString();
        return this.format().parse(contentString);
    }

    public String responseContentForActionNamed(String actionName) {
        return this.performActionNamed(actionName, true).generateResponse().contentString();
    }

    public WOActionResults performActionNamed(String actionName, boolean throwExceptions) throws RuntimeException {
        String windowNameCrossDomainTransport;
        String allowOrigin;
        WOActionResults results = null;
        try {
            ERXRestTransactionRequestAdaptor transactionAdaptor = ERXRestTransactionRequestAdaptor.defaultAdaptor();
            if (transactionAdaptor.transactionsEnabled() && !transactionAdaptor.isExecutingTransaction(this.context(), this.request()) && !transactionAdaptor.willHandleRequest(this.context(), this.request())) {
                results = transactionAdaptor.didHandleRequest(this.context(), this.request()) ? this.stringResponse("Transaction request enqueued.") : this.stringResponse("Transaction executed.");
            }
            if (results == null) {
                this.checkAccess();
            }
            if (results == null && this.isAutomaticHtmlRoutingEnabled() && this.format() == ERXRestFormat.HTML) {
                String pageName = this.pageNameForAction(actionName);
                if (_NSUtilities.classWithName((String)pageName) != null) {
                    try {
                        results = this.pageWithName(pageName);
                        if (!(results instanceof IERXRouteComponent)) {
                            log.error((Object)(pageName + " does not implement IERXRouteComponent, so it will be ignored."));
                            results = null;
                        }
                    }
                    catch (WOPageNotFoundException e) {
                        log.info((Object)(pageName + " does not exist, falling back to route controller."));
                        results = null;
                    }
                } else {
                    log.info((Object)(pageName + " does not exist, falling back to route controller."));
                }
                if (results == null && this.shouldFailOnMissingHtmlPage()) {
                    results = this.performUnknownAction(actionName);
                }
            }
            if (results == null) {
                Method actionMethod = this._methodForAction(actionName, "Action");
                if (actionMethod == null || actionMethod.getParameterTypes().length > 0) {
                    String actionMethodName = actionName + "Action";
                    int bestParameterCount = 0;
                    Method bestMethod = null;
                    LinkedList<PathParam> bestParams = null;
                    for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
                        if (!method.getName().equals(actionMethodName)) continue;
                        int parameterCount = 0;
                        LinkedList<PathParam> params = new LinkedList<PathParam>();
                        Annotation[][] arr$ = method.getParameterAnnotations();
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            Annotation[] parameterAnnotations;
                            for (Annotation parameterAnnotation : parameterAnnotations = arr$[i$]) {
                                if (parameterAnnotation instanceof PathParam) {
                                    PathParam pathParam = (PathParam)parameterAnnotation;
                                    params.add(pathParam);
                                    ++parameterCount;
                                    continue;
                                }
                                parameterCount = -1;
                                break;
                            }
                            if (parameterCount == -1) break;
                        }
                        if (parameterCount <= bestParameterCount) continue;
                        bestMethod = method;
                        bestParameterCount = parameterCount;
                        bestParams = params;
                    }
                    if (bestMethod == null) {
                        this.performUnknownAction(actionName);
                    } else {
                        Object[] params = new Object[bestParameterCount];
                        for (int paramNum = 0; paramNum < params.length; ++paramNum) {
                            PathParam param = (PathParam)bestParams.get(paramNum);
                            params[paramNum] = this.routeObjectForKey(param.value());
                        }
                        results = (WOActionResults)bestMethod.invoke((Object)this, params);
                    }
                } else {
                    results = (WOActionResults)actionMethod.invoke((Object)this, _NSUtilities._NoObjectArray);
                }
            }
            if (results == null) {
                results = this.response(null, ERXKeyFilter.filterWithAttributes());
            } else if (results instanceof IERXRouteComponent) {
                this._takeRouteParametersFromRequest(results);
            }
        }
        catch (Throwable t) {
            if (throwExceptions) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)t);
            }
            Throwable meaningfulThrowble = ERXExceptionUtilities.getMeaningfulThrowable((Throwable)t);
            results = meaningfulThrowble instanceof ERXDatabaseContextDelegate.ObjectNotAvailableException || meaningfulThrowble instanceof FileNotFoundException ? this.errorResponse(meaningfulThrowble, 404) : (meaningfulThrowble instanceof SecurityException ? this.errorResponse(meaningfulThrowble, 403) : this.errorResponse(meaningfulThrowble, 500));
        }
        WOContext context = this.context();
        WOSession session = context._session();
        if (results instanceof WOResponse) {
            WOResponse response = (WOResponse)results;
            if (session != null && session.storesIDsInCookies()) {
                session._appendCookieToResponse(response);
            }
        }
        if (this._canSetHeaderForActionResults(results) && (allowOrigin = this.accessControlAllowOrigin()) != null) {
            this._setHeaderForActionResults(allowOrigin, "Access-Control-Allow-Origin", results);
        }
        if (this.allowWindowNameCrossDomainTransport() && "true".equals(windowNameCrossDomainTransport = this.request().stringFormValueForKey("windowname"))) {
            WOResponse response = results.generateResponse();
            String content = response.contentString();
            if (content != null) {
                content = content.replaceAll("\n", "");
                content = ERXStringUtilities.escapeJavascriptApostrophes((String)content);
            }
            response.setContent("<html><script type=\"text/javascript\">window.name='" + content + "';</script></html>");
            response.setHeader("text/html", "Content-Type");
            results = response;
        }
        return results;
    }

    protected boolean allowWindowNameCrossDomainTransport() {
        return ERXProperties.booleanForKeyWithDefault((String)"ERXRest.allowWindowNameCrossDomainTransport", (boolean)false);
    }

    protected String accessControlAllowOrigin() {
        return ERXProperties.stringForKeyWithDefault((String)"ERXRest.accessControlAllowOrigin", null);
    }

    protected NSArray<String> accessControlAllowRequestMethods(String requestMethod) {
        String accessControlAllowRequestMethodsStr = ERXProperties.stringForKeyWithDefault((String)"ERXRest.accessControlAllowRequestMethods", (String)"OPTIONS,GET,HEAD,POST,PUT,DELETE,TRACE,CONNECT");
        if (accessControlAllowRequestMethodsStr == null || accessControlAllowRequestMethodsStr.length() == 0) {
            accessControlAllowRequestMethodsStr = requestMethod;
        }
        NSArray accessControlAllowRequestMethods = null;
        if (accessControlAllowRequestMethodsStr != null) {
            accessControlAllowRequestMethods = new NSArray((Object[])accessControlAllowRequestMethodsStr.split(","));
        }
        return accessControlAllowRequestMethods;
    }

    protected NSArray<String> accessControlAllowRequestHeaders(NSArray<String> requestHeaders) {
        String requestHeadersStr = requestHeaders == null ? null : requestHeaders.componentsJoinedByString(",");
        String accessControlAllowRequestHeadersStr = ERXProperties.stringForKeyWithDefault((String)"ERXRest.accessControlAllowRequestHeaders", (String)requestHeadersStr);
        NSArray accessControlAllowRequestHeaders = null;
        if (accessControlAllowRequestHeadersStr != null) {
            accessControlAllowRequestHeaders = new NSArray((Object[])accessControlAllowRequestHeadersStr.split(","));
        }
        return accessControlAllowRequestHeaders;
    }

    protected long accessControlMaxAage() {
        return ERXProperties.longForKeyWithDefault((String)"ERXRest.accessControlMaxAge", (long)1728000L);
    }

    public WOActionResults optionsAction() throws Throwable {
        WOResponse response = new WOResponse();
        String accessControlAllowOrigin = this.accessControlAllowOrigin();
        if (accessControlAllowOrigin != null) {
            long accessControlMaxAge;
            String requestHeadersStr;
            NSArray requestHeaders;
            NSArray<String> accessControlAllowRequestHeaders;
            response.setHeader(accessControlAllowOrigin, "Access-Control-Allow-Origin");
            NSArray<String> accessControlAllowRequestMethods = this.accessControlAllowRequestMethods(this.request().headerForKey((Object)"Access-Control-Request-Method"));
            if (accessControlAllowRequestMethods != null) {
                response.setHeader(accessControlAllowRequestMethods.componentsJoinedByString(","), "Access-Control-Allow-Methods");
            }
            if ((accessControlAllowRequestHeaders = this.accessControlAllowRequestHeaders((NSArray<String>)(requestHeaders = (requestHeadersStr = this.request().headerForKey((Object)"Access-Control-Request-Headers")) == null ? null : NSArray.componentsSeparatedByString((String)requestHeadersStr, (String)",")))) != null) {
                response.setHeader(accessControlAllowRequestHeaders.componentsJoinedByString(","), "Access-Control-Allow-Headers");
            }
            if ((accessControlMaxAge = this.accessControlMaxAage()) >= 0L) {
                response.setHeader(String.valueOf(accessControlMaxAge), "Access-Control-Max-Age");
            }
        }
        return response;
    }

    public <T extends WOComponent> T pageWithName(Class<T> componentClass) {
        return (T)super.pageWithName(componentClass.getName());
    }

    public <T extends ERXRouteController> T controller(String entityName) {
        return (T)((Object)this.controller(this.requestHandler().routeControllerClassForEntityNamed(entityName)));
    }

    public <T extends ERXRouteController> T controller(Class<T> controllerClass) {
        try {
            T controller = this.requestHandler().controller(controllerClass, this.request(), this.context());
            ((ERXRouteController)((Object)controller))._route = this._route;
            ((ERXRouteController)((Object)controller))._editingContext = this._editingContext;
            ((ERXRouteController)((Object)controller))._routeKeys = this._routeKeys;
            ((ERXRouteController)((Object)controller))._objects = this._objects;
            ((ERXRouteController)((Object)controller))._options = this._options;
            return controller;
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public void dispose() {
        if (this._shouldDisposeEditingContext && this._editingContext != null) {
            this._editingContext.dispose();
            this._editingContext = null;
        }
    }

    protected boolean isSchemaRequest() {
        return this.request().stringFormValueForKey("schema") != null;
    }

    protected WOActionResults schemaResponse(ERXKeyFilter filter) {
        return this.schemaResponseForEntityNamed(this.entityName(), filter);
    }

    protected WOActionResults schemaResponseForEntityNamed(String entityName, ERXKeyFilter filter) {
        NSDictionary<String, Object> properties = ERXRestSchema.schemaForEntityNamed(entityName, filter);
        return this.response(properties, ERXKeyFilter.filterWithAllRecursive());
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.request().uri() + "]";
    }

    protected static void _registerControllerForRequest(ERXRouteController controller, WORequest request) {
        NSMutableArray controllers = ERXRouteController._controllersForRequest(request);
        if (controllers == null) {
            controllers = new NSMutableArray();
            if (request != null) {
                NSMutableDictionary userInfo = ((ERXRequest)request).mutableUserInfo();
                userInfo.setObjectForKey((Object)controllers, (Object)REQUEST_CONTROLLERS_KEY);
            }
        }
        controllers.addObject((Object)controller);
    }

    public static NSMutableArray<ERXRouteController> _controllersForRequest(WORequest request) {
        NSDictionary userInfo = request != null ? request.userInfo() : null;
        NSMutableArray controllers = null;
        if (userInfo != null) {
            controllers = (NSMutableArray)userInfo.objectForKey((Object)REQUEST_CONTROLLERS_KEY);
        }
        return controllers;
    }

    public static void _disposeControllersForRequest(WORequest request) {
        NSMutableArray<ERXRouteController> controllers = ERXRouteController._controllersForRequest(request);
        if (controllers != null) {
            for (ERXRouteController controller : controllers) {
                controller.dispose();
            }
        }
    }
}

