/*
 * Decompiled with CFR 0.152.
 */
package er.rest.util;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.eof.ERXEC;
import er.rest.util.ERXRestTransaction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ERXRestTransactionManager {
    private NSMutableDictionary<String, ERXRestTransaction> _transactions = new NSMutableDictionary();
    private IntRangeSet _sequenceIDs = new IntRangeSet();

    protected EOEditingContext newEditingContext() {
        return ERXEC.newEditingContext();
    }

    public void addSequenceID(int sequenceID) {
        this._sequenceIDs.add(sequenceID);
    }

    public ERXRestTransaction transactionForID(String id) {
        ERXRestTransaction transaction = (ERXRestTransaction)this._transactions.objectForKey((Object)id);
        if (transaction == null) {
            transaction = new ERXRestTransaction(id, this.newEditingContext());
            this._transactions.setObjectForKey((Object)transaction, (Object)id);
        }
        return transaction;
    }

    public void removeTransaction(ERXRestTransaction transaction) {
        this._transactions.removeObjectForKey((Object)transaction.identifier());
    }

    public boolean isTransactionReady(ERXRestTransaction transaction) {
        int maximumSequenceID;
        int minimumSequenceID;
        boolean transactionReady = false;
        if (transaction.hasCommit() && this._sequenceIDs.contains(minimumSequenceID = transaction.minimumSequenceID(), maximumSequenceID = transaction.maximumSequenceID())) {
            if (minimumSequenceID == this.minimumPossibleSequenceID()) {
                transactionReady = true;
            } else if (this._sequenceIDs.contains(minimumSequenceID - 1)) {
                transactionReady = true;
            }
        }
        return transactionReady;
    }

    protected int minimumPossibleSequenceID() {
        return 1;
    }

    public static class IntRangeSet {
        private List<IntRange> _ranges = new LinkedList<IntRange>();

        public boolean contains(int start, int end) {
            boolean contains = false;
            for (IntRange range : this._ranges) {
                if (start >= range.start && end <= range.end) {
                    contains = true;
                    break;
                }
                if (range.start <= start) continue;
                break;
            }
            return contains;
        }

        public boolean contains(int value) {
            boolean contains = false;
            for (IntRange range : this._ranges) {
                if (value >= range.start && value <= range.end) {
                    contains = true;
                    break;
                }
                if (range.start <= value) continue;
                break;
            }
            return contains;
        }

        public void add(int value) {
            Iterator<IntRange> rangeIter = this._ranges.iterator();
            int index = 0;
            boolean valueAdded = false;
            while (rangeIter.hasNext()) {
                IntRange range = rangeIter.next();
                if (value <= range.end) {
                    if (value < range.start) {
                        if (value == range.start - 1) {
                            range.start = value;
                        } else {
                            this._ranges.add(index, new IntRange(value, value));
                        }
                    }
                    valueAdded = true;
                    break;
                }
                if (value == range.end + 1) {
                    range.end = value;
                    if (rangeIter.hasNext()) {
                        IntRange nextRange = rangeIter.next();
                        if (nextRange.start == range.end + 1) {
                            range.end = nextRange.end;
                            rangeIter.remove();
                        }
                    }
                    valueAdded = true;
                    break;
                }
                ++index;
            }
            if (!valueAdded) {
                this._ranges.add(new IntRange(value, value));
            }
        }

        protected static class IntRange {
            public int start;
            public int end;

            public IntRange(int start, int end) {
                this.start = start;
                this.end = end;
            }

            public boolean contains(int value) {
                return value >= this.start && value <= this.end;
            }

            public String toString() {
                return "[" + this.start + "-" + this.end + "]";
            }
        }
    }
}

