/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import er.javamail.ERMailAttachment;
import er.javamail.ERMailDeliveryComponentBased;
import java.util.Date;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class ERMailDeliveryHTML
extends ERMailDeliveryComponentBased {
    protected static Factory factory;
    protected String _htmlContent;
    private String _hiddenPlainTextContent;

    public static Factory factory() {
        if (factory == null) {
            factory = new DefaultFactory();
        }
        return factory;
    }

    public static void setFactory(Factory value) {
        factory = value;
    }

    public static ERMailDeliveryHTML newMailDelivery() {
        return ERMailDeliveryHTML.factory().newHTMLMailDelivery();
    }

    public void setHiddenPlainTextContent(String content) {
        this._hiddenPlainTextContent = content;
    }

    public void setHTMLContent(String content) {
        this._htmlContent = content;
    }

    public void newMail() {
        super.newMail();
        this._hiddenPlainTextContent = null;
        this.setHTMLContent(null);
    }

    protected String htmlContent() {
        String htmlContent = null;
        htmlContent = this.component() != null ? this.componentContentString() : this._htmlContent;
        return htmlContent;
    }

    protected DataHandler prepareMail() throws MessagingException {
        MimeMultipart multipart = null;
        MimeBodyPart textPart = null;
        MimeBodyPart htmlPart = null;
        this.mimeMessage().setSentDate(new Date());
        multipart = new MimeMultipart("alternative");
        String textContent = this._hiddenPlainTextContent != null ? this._hiddenPlainTextContent : this.alternativeComponentContentString();
        if (textContent != null) {
            textPart = new MimeBodyPart();
            textPart.setText(textContent + "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n", this.charset());
            multipart.addBodyPart((BodyPart)textPart);
        }
        htmlPart = new MimeBodyPart();
        htmlPart.setContent((Object)this.htmlContent(), "text/html; charset=\"" + this.charset() + "\"");
        if (this.inlineAttachments().count() == 0) {
            multipart.addBodyPart((BodyPart)htmlPart);
        } else {
            MimeMultipart relatedMultiparts = new MimeMultipart("related");
            relatedMultiparts.addBodyPart((BodyPart)htmlPart);
            for (ERMailAttachment attachment : this.inlineAttachments()) {
                BodyPart bp = attachment.getBodyPart();
                relatedMultiparts.addBodyPart(bp);
            }
            MimeBodyPart relatedAttachmentsBodyPart = new MimeBodyPart();
            relatedAttachmentsBodyPart.setDataHandler(new DataHandler((Object)relatedMultiparts, relatedMultiparts.getContentType()));
            multipart.addBodyPart((BodyPart)relatedAttachmentsBodyPart);
        }
        return new DataHandler((Object)multipart, multipart.getContentType());
    }

    public static class DefaultFactory
    implements Factory {
        public ERMailDeliveryHTML newHTMLMailDelivery() {
            return new ERMailDeliveryHTML();
        }
    }

    public static interface Factory {
        public ERMailDeliveryHTML newHTMLMailDelivery();
    }
}

