/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSArray;
import er.javamail.ERJavaMail;
import er.javamail.ERMailDelivery;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class ERWOMailDelivery {
    private static Logger log = Logger.getLogger(ERWOMailDelivery.class);
    private static ERWOMailDelivery _sharedInstance = null;

    public static ERWOMailDelivery sharedInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ERWOMailDelivery();
        }
        return _sharedInstance;
    }

    protected ERWOMailDelivery() {
    }

    public String composePlainTextEmail(String fromEmailAddress, NSArray toEmailAddresses, NSArray bccEmailAddresses, String subject, String message, boolean sendNow) {
        MimeMessage smtpMessage = this.newMimeMessage(fromEmailAddress, toEmailAddresses, bccEmailAddresses, subject, message, "text/plain", sendNow);
        return ERWOMailDelivery.mimeMessageToString(smtpMessage);
    }

    public String composeComponentEmail(String fromEmailAddress, NSArray toEmailAddresses, NSArray bccEmailAddresses, String subject, WOComponent component, boolean sendNow) {
        String response;
        WOSession session = component.context()._session();
        component.context()._generateCompleteURLs();
        if (session == null) {
            response = component.generateResponse().contentString();
        } else {
            boolean oldStoresIDsInURLs = session.storesIDsInURLs();
            session.setStoresIDsInURLs(true);
            response = component.generateResponse().contentString();
            session.setStoresIDsInURLs(oldStoresIDsInURLs);
        }
        component.context()._generateRelativeURLs();
        MimeMessage smtpMessage = this.newMimeMessage(fromEmailAddress, toEmailAddresses, bccEmailAddresses, subject, response, "text/html", sendNow);
        return ERWOMailDelivery.mimeMessageToString(smtpMessage);
    }

    public void sendEmail(String mailString) {
        ByteArrayInputStream bais = new ByteArrayInputStream(mailString.getBytes());
        try {
            MimeMessage smtpMessage = new MimeMessage(ERJavaMail.sharedInstance().defaultSession(), (InputStream)bais);
            new MimeMessageMailDelivery(smtpMessage).sendMail();
        }
        catch (Exception x) {
            log.error((Object)x);
        }
    }

    public String toString() {
        return "<ERWOMailDelivery smtpHost=" + WOApplication.application().SMTPHost() + ">";
    }

    private MimeMessage newMimeMessage(String fromEmailAddress, NSArray toEmailAddresses, NSArray bccEmailAddresses, String subject, String message, String contentType, boolean sendNow) {
        MimeMessage smtpMessage = null;
        try {
            String address;
            smtpMessage = new MimeMessage(ERJavaMail.sharedInstance().defaultSession());
            smtpMessage.setFrom((Address)new InternetAddress(fromEmailAddress));
            Enumeration addressEnumerator = toEmailAddresses.objectEnumerator();
            while (addressEnumerator.hasMoreElements()) {
                address = (String)addressEnumerator.nextElement();
                smtpMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(address));
            }
            if (bccEmailAddresses != null && bccEmailAddresses.count() > 0) {
                addressEnumerator = bccEmailAddresses.objectEnumerator();
                while (addressEnumerator.hasMoreElements()) {
                    address = (String)addressEnumerator.nextElement();
                    smtpMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(address));
                }
            }
            smtpMessage.setSubject(subject);
            smtpMessage.setContent((Object)message, contentType);
            if (sendNow) {
                new MimeMessageMailDelivery(smtpMessage).sendMail();
            }
        }
        catch (Exception x) {
            log.error((Object)x);
        }
        return smtpMessage;
    }

    private static String mimeMessageToString(MimeMessage smtpMessage) {
        String result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            smtpMessage.writeTo((OutputStream)baos);
            result = baos.toString();
        }
        catch (Exception x) {
            log.error((Object)x);
        }
        return result;
    }

    private class MimeMessageMailDelivery
    extends ERMailDelivery {
        public MimeMessageMailDelivery(MimeMessage msg) {
            this.setMimeMessage(msg);
        }

        protected DataHandler prepareMail() {
            MimeMessage msg = this.mimeMessage();
            String contentType = "text/plain";
            try {
                contentType = msg.getContentType();
            }
            catch (MessagingException x) {
                log.error((Object)x);
            }
            return new DataHandler((Object)ERWOMailDelivery.mimeMessageToString(msg), contentType);
        }
    }
}

