/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSBase64;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NSPropertyListSerialization {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSPropertyListSerialization");
    private static final int EOT = -1;

    private NSPropertyListSerialization() {
        throw new IllegalStateException("Can't instantiate an instance of class " + this.getClass().getName());
    }

    public static String stringFromPropertyList(Object plist) {
        return _Utilities.stringFromPropertyList(plist);
    }

    private static boolean startsWithXMLDeclaration(String string) {
        String xmlDeclarationMarker = "<?xml";
        return string != null && string.startsWith("<?xml");
    }

    public static Object propertyListFromString(String string) {
        if (NSPropertyListSerialization.startsWithXMLDeclaration(string)) {
            return _XML.parseStringIntoPlist(string);
        }
        return _Utilities.propertyListFromString(string);
    }

    public static Object propertyListWithPathURL(URL url) {
        String string = _NSStringUtilities.stringFromPathURL(url);
        return NSPropertyListSerialization.propertyListFromString(string);
    }

    public static NSData dataFromPropertyList(Object object) {
        return NSPropertyListSerialization.dataFromPropertyList(object, null);
    }

    public static NSData dataFromPropertyList(Object object, String encoding) {
        if (object == null) {
            return null;
        }
        String string = NSPropertyListSerialization.stringFromPropertyList(object);
        return new NSData(_NSStringUtilities.bytesForString(string, encoding));
    }

    public static Object propertyListFromData(NSData data) {
        return NSPropertyListSerialization.propertyListFromData(data, null);
    }

    public static Object propertyListFromData(NSData data, String encoding) {
        if (data == null) {
            return null;
        }
        String string = _NSStringUtilities.stringForBytes(data.bytes(), encoding);
        return NSPropertyListSerialization.propertyListFromString(string);
    }

    public static boolean booleanForString(String string) {
        String value;
        return string != null && ((value = string.toUpperCase().trim()).equals("YES") || value.equals("TRUE"));
    }

    public static int intForString(String string) {
        if (string != null) {
            try {
                return Integer.parseInt(string.trim());
            }
            catch (NumberFormatException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
        }
        return 0;
    }

    public static NSArray arrayForString(String string) {
        return (NSArray)NSPropertyListSerialization.propertyListFromString(string);
    }

    public static NSDictionary dictionaryForString(String string) {
        return (NSDictionary)NSPropertyListSerialization.propertyListFromString(string);
    }

    public static class _XML {
        public static Object parseStringIntoPlist(String content) {
            SAXParser parser = new SAXParser();
            DictionaryParser dp = new DictionaryParser();
            parser.setDocumentHandler(dp);
            parser.setEntityResolver(dp);
            parser.setErrorHandler(dp);
            try {
                parser.parse(new InputSource(new StringReader(content)));
            }
            catch (SAXException exception) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups(1, 0x200000L)) {
                    NSLog.debug.appendln("XML parse error: " + exception.getMessage());
                    if (NSLog.allowedDebugLevel() > 1) {
                        NSLog.debug.appendln(exception);
                    }
                }
                if (exception instanceof SAXParseException) {
                    SAXParseException e = (SAXParseException)exception;
                    throw new NSForwardException(exception, "Parsing failed in line " + e.getLineNumber() + ", column " + e.getColumnNumber());
                }
                throw new NSForwardException(exception);
            }
            catch (IOException exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
            return dp.plist();
        }

        public static class DictionaryParser
        extends HandlerBase {
            private static String PUBLIC_APPLE_PLIST_1_0 = "-//Apple Computer//DTD PLIST 1.0//EN";
            NSMutableArray _stack;
            Object _plist;
            private StringBuffer _curChars;

            public Object plist() {
                return this._plist;
            }

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                InputSource is = null;
                if (PUBLIC_APPLE_PLIST_1_0.equals(publicId)) {
                    is = new InputSource(new StringReader(""));
                }
                return is;
            }

            public void startDocument() throws SAXException {
                this._stack = new NSMutableArray(64);
                this._plist = null;
                this._curChars = new StringBuffer();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void endDocument() throws SAXException {
                if (this._stack.count() <= 0) return;
                if (this._stack.count() != 1) throw new SAXException("A plist may only contain one top-level node.");
                XMLNode node = (XMLNode)this._stack.lastObject();
                if (node.tag_open) throw new SAXException("Starting <" + node.type + "> node was never ended.");
                this._plist = node.value;
                this._stack.removeLastObject();
            }

            public void startElement(String name, AttributeList attributes) throws SAXException {
                String explicitName = attributes.getValue("name");
                if (explicitName == null) {
                    explicitName = name;
                }
                if ((name = name.toLowerCase()).equals("plist") || name.equals("array") || name.equals("dict") || name.equals("string") || name.equals("key") || name.equals("data") || name.equals("date") || name.equals("real") || name.equals("integer")) {
                    this._stack.addObject(new XMLNode(name));
                } else if (name.equals("true") || name.equals("false")) {
                    this._stack.addObject(new XMLNode("string", name.toUpperCase(), false));
                } else {
                    this._stack.addObject(new XMLNode("unknown"));
                }
                this._curChars = new StringBuffer();
            }

            private void saveCharContent() throws SAXException {
                if (this._curChars.length() == 0) {
                    return;
                }
                XMLNode node = (XMLNode)this._stack.lastObject();
                if ((node.type.equals("string") || node.type.equals("key") || node.type.equals("date") || node.type.equals("real") || node.type.equals("integer")) && node.tag_open) {
                    node.value = _NSStringUtilities.stringFromBuffer(this._curChars);
                    node.tag_open = false;
                } else if (node.type.equals("data")) {
                    try {
                        StringBuffer data = new StringBuffer(this._curChars.length());
                        for (int i = 0; i < this._curChars.length(); ++i) {
                            if (Character.isWhitespace(this._curChars.charAt(i))) continue;
                            data.append(this._curChars.charAt(i));
                        }
                        byte[] b = data.toString().getBytes("US-ASCII");
                        node.value = new NSData(_NSBase64.decode(b));
                        node.tag_open = false;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SAXException(e.getMessage());
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void endElement(String name) throws SAXException {
                if (name.equals("plist")) {
                    if (this._stack.count() != 2) {
                        throw new SAXException("A plist may only contain one top-level node, and all tags must have end tags.");
                    }
                    XMLNode node = (XMLNode)this._stack.lastObject();
                    if (node.tag_open) {
                        throw new SAXException("Starting <" + node.type + "> tag was never ended.");
                    }
                    this._plist = node.value;
                    this._stack.removeLastObject();
                    this._stack.removeLastObject();
                    return;
                }
                this.saveCharContent();
                if (name.equals("string") || name.equals("key") || name.equals("data") || name.equals("date") || name.equals("real") || name.equals("integer")) {
                    XMLNode node = (XMLNode)this._stack.lastObject();
                    if (!node.type.equals(name)) throw new SAXException("Ending <" + name + "> tag does not match starting <" + node.type + "> tag.");
                    if (node.value != null) return;
                    node.value = name.equals("data") ? new NSData() : new String("");
                    node.tag_open = false;
                    return;
                } else {
                    if (name.equals("array")) {
                        NSMutableArray ary = new NSMutableArray();
                        boolean found = false;
                        for (int i = this._stack.count() - 1; i >= 0; --i) {
                            XMLNode node = (XMLNode)this._stack.objectAtIndex(i);
                            if (node.tag_open) {
                                if (!node.type.equals("array")) throw new SAXException("Ending <" + name + "> tag does not match starting <" + node.type + "> tag.");
                                found = true;
                                node.value = ary;
                                node.tag_open = false;
                                break;
                            }
                            ary.insertObjectAtIndex(node.value, 0);
                            this._stack.removeLastObject();
                        }
                        if (found) return;
                        throw new SAXException("No starting <array> tag.");
                    }
                    if (!name.equals("dict")) return;
                    NSMutableDictionary dict = new NSMutableDictionary();
                    boolean found = false;
                    for (int i = this._stack.count() - 1; i >= 0; i -= 2) {
                        XMLNode node = (XMLNode)this._stack.objectAtIndex(i);
                        if (node.tag_open) {
                            if (!node.type.equals("dict")) throw new SAXException("Ending <" + name + "> tag does not match starting <" + node.type + "> tag.");
                            found = true;
                            node.value = dict;
                            node.tag_open = false;
                            break;
                        }
                        if (i < 1) throw new SAXException("All values in a dictionary must have corresponding keys.");
                        Object value = node.value;
                        this._stack.removeLastObject();
                        node = (XMLNode)this._stack.lastObject();
                        if (!node.type.equals("key")) {
                            throw new SAXException("All values in a dictionary must have corresponding keys.");
                        }
                        dict.setObjectForKey(value, node.value);
                        this._stack.removeLastObject();
                    }
                    if (found) return;
                    throw new SAXException("No starting <" + name + "> tag.");
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                this._curChars.append(ch, start, length);
            }

            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            }

            public void processingInstruction(String target, String data) throws SAXException {
            }

            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            public static class XMLNode {
                public String type;
                public Object value;
                public boolean tag_open;

                public XMLNode(String nt) {
                    this.type = nt;
                    this.value = null;
                    this.tag_open = true;
                }

                public XMLNode(String nt, Object obj) {
                    this.type = nt;
                    this.value = obj;
                    this.tag_open = true;
                }

                public XMLNode(String nt, Object obj, boolean open) {
                    this.type = nt;
                    this.value = obj;
                    this.tag_open = open;
                }

                public String toString() {
                    return new String("type = " + this.type + "; object = " + this.value + "; open = " + new Boolean(this.tag_open));
                }
            }
        }
    }

    public static class _Utilities {
        private int _lineNumber;
        private int _startOfLineCharIndex;
        private static int _savedIndex;
        private static int _savedLineNumber;
        private static int _savedStartOfLineCharIndex;
        private static final int _C_NON_COMMENT_OR_SPACE = 1;
        private static final int _C_WHITESPACE = 2;
        private static final int _C_SINGLE_LINE_COMMENT = 3;
        private static final int _C_MULTI_LINE_COMMENT = 4;
        private static final int[] NSToPrecompUnicodeTable;

        private void _saveIndexes(int index, int line, int startOfLine) {
            _savedIndex = index;
            _savedLineNumber = line;
            _savedStartOfLineCharIndex = startOfLine;
        }

        private String _savedIndexesAsString() {
            return "line number: " + _savedLineNumber + ", column: " + (_savedIndex - _savedStartOfLineCharIndex);
        }

        public static boolean propertyListsAreEqual(Object plist1, Object plist2) {
            if (plist1 == null && plist2 == null) {
                return true;
            }
            if ((plist1 instanceof String || plist1 instanceof StringBuffer) && (plist2 instanceof String || plist2 instanceof StringBuffer)) {
                return plist1.toString().equals(plist2.toString());
            }
            if (plist1 instanceof NSData && plist2 instanceof NSData) {
                return ((NSData)plist1).isEqualToData((NSData)plist2);
            }
            if (plist1 instanceof NSArray && plist2 instanceof NSArray) {
                int count2;
                NSArray array1 = (NSArray)plist1;
                NSArray array2 = (NSArray)plist2;
                int count1 = array1.count();
                if (count1 != (count2 = array2.count())) {
                    return false;
                }
                for (int i = 0; i < count1; ++i) {
                    if (_Utilities.propertyListsAreEqual(array1.objectAtIndex(i), array2.objectAtIndex(i))) continue;
                    return false;
                }
                return true;
            }
            if (plist1 instanceof NSDictionary && plist2 instanceof NSDictionary) {
                int count2;
                NSDictionary dictionary1 = (NSDictionary)plist1;
                NSDictionary dictionary2 = (NSDictionary)plist2;
                int count1 = dictionary1.count();
                if (count1 != (count2 = dictionary2.count())) {
                    return false;
                }
                Enumeration keys = dictionary1.keyEnumerator();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object value2 = dictionary2.objectForKey(key);
                    if (value2 == null) {
                        return false;
                    }
                    Object value1 = dictionary1.objectForKey(key);
                    if (_Utilities.propertyListsAreEqual(value1, value2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static Object copyPropertyList(Object plist) {
            if (plist == null) {
                return null;
            }
            if (plist instanceof String) {
                return plist;
            }
            if (plist instanceof StringBuffer) {
                return new String((StringBuffer)plist);
            }
            if (plist instanceof NSData) {
                return ((NSData)plist).clone();
            }
            if (plist instanceof NSArray) {
                NSArray array = (NSArray)plist;
                int count = array.count();
                NSMutableArray newArray = new NSMutableArray(count);
                for (int i = 0; i < count; ++i) {
                    newArray.addObject(_Utilities.copyPropertyList(array.objectAtIndex(i)));
                }
                return newArray;
            }
            if (plist instanceof NSDictionary) {
                NSDictionary dictionary = (NSDictionary)plist;
                NSMutableDictionary newDictionary = new NSMutableDictionary(dictionary.count());
                Enumeration keys = dictionary.keyEnumerator();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object value = dictionary.objectForKey(key);
                    newDictionary.setObjectForKey(_Utilities.copyPropertyList(value), _Utilities.copyPropertyList(key));
                }
                return newDictionary;
            }
            throw new IllegalArgumentException("Property list copying failed while attempting to copy non property list type: " + plist.getClass().getName());
        }

        public static String stringFromPropertyList(Object plist) {
            if (plist == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer(128);
            _Utilities._appendObjectToStringBuffer(plist, buffer, 0);
            return _NSStringUtilities.stringFromBuffer(buffer);
        }

        public static Object propertyListWithContentsOfFile(String path) {
            String string = _NSStringUtilities.stringFromFile(path);
            if (NSPropertyListSerialization.startsWithXMLDeclaration(string)) {
                return _XML.parseStringIntoPlist(string);
            }
            return _Utilities.propertyListFromString(string);
        }

        public static Object propertyListFromString(String string) {
            return new _Utilities()._propertyListFromString(string);
        }

        private _Utilities() {
        }

        private Object _propertyListFromString(String string) {
            this._startOfLineCharIndex = 0;
            this._lineNumber = 0;
            if (string == null) {
                return null;
            }
            char[] characters = string.toCharArray();
            Object[] objects = new Object[1];
            this._lineNumber = 1;
            this._startOfLineCharIndex = 0;
            objects[0] = null;
            int index = 0;
            index = this._readObjectIntoObjectReference(characters, index, objects);
            if ((index = this._skipWhitespaceAndComments(characters, index)) != -1) {
                throw new IllegalArgumentException("propertyListFromString parsed an object, but there's still more text in the string. A plist should contain only one top-level object. Line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            return objects[0];
        }

        private static void _appendObjectToStringBuffer(Object object, StringBuffer buffer, int indentionLevel) {
            if (object instanceof String) {
                _Utilities._appendStringToStringBuffer((String)object, buffer, indentionLevel);
            } else if (object instanceof StringBuffer) {
                _Utilities._appendStringToStringBuffer(((StringBuffer)object).toString(), buffer, indentionLevel);
            } else if (object instanceof NSData) {
                _Utilities._appendDataToStringBuffer((NSData)object, buffer, indentionLevel);
            } else if (object instanceof NSArray) {
                _Utilities._appendArrayToStringBuffer((NSArray)object, buffer, indentionLevel);
            } else if (object instanceof NSDictionary) {
                _Utilities._appendDictionaryToStringBuffer((NSDictionary)object, buffer, indentionLevel);
            } else if (object instanceof Boolean) {
                String value = (Boolean)object != false ? "true" : "false";
                _Utilities._appendStringToStringBuffer(value, buffer, indentionLevel);
            } else {
                _Utilities._appendStringToStringBuffer(object.toString(), buffer, indentionLevel);
            }
        }

        private static void _appendStringToStringBuffer(String string, StringBuffer buffer, int indentionLevel) {
            buffer.append('\"');
            char[] characters = string.toCharArray();
            for (int i = 0; i < characters.length; ++i) {
                if (characters[i] < '\u0080') {
                    if (characters[i] == '\n') {
                        buffer.append("\\n");
                        continue;
                    }
                    if (characters[i] == '\r') {
                        buffer.append("\\r");
                        continue;
                    }
                    if (characters[i] == '\t') {
                        buffer.append("\\t");
                        continue;
                    }
                    if (characters[i] == '\"') {
                        buffer.append("\\\"");
                        continue;
                    }
                    if (characters[i] == '\\') {
                        buffer.append("\\\\");
                        continue;
                    }
                    if (characters[i] == '\f') {
                        buffer.append("\\f");
                        continue;
                    }
                    if (characters[i] == '\b') {
                        buffer.append("\\b");
                        continue;
                    }
                    if (characters[i] == '\u0007') {
                        buffer.append("\\a");
                        continue;
                    }
                    if (characters[i] == '\u000b') {
                        buffer.append("\\v");
                        continue;
                    }
                    buffer.append(characters[i]);
                    continue;
                }
                char character = characters[i];
                byte nibble1 = (byte)(character & 0xF);
                character = (char)(character >> 4);
                byte nibble2 = (byte)(character & 0xF);
                character = (char)(character >> 4);
                byte nibble3 = (byte)(character & 0xF);
                character = (char)(character >> 4);
                byte nibble4 = (byte)(character & 0xF);
                character = (char)(character >> 4);
                buffer.append("\\U");
                buffer.append(_Utilities._hexDigitForNibble(nibble4));
                buffer.append(_Utilities._hexDigitForNibble(nibble3));
                buffer.append(_Utilities._hexDigitForNibble(nibble2));
                buffer.append(_Utilities._hexDigitForNibble(nibble1));
            }
            buffer.append('\"');
        }

        private static void _appendDataToStringBuffer(NSData data, StringBuffer buffer, int indentionLevel) {
            buffer.append('<');
            byte[] bytes = data.bytes();
            for (int i = 0; i < bytes.length; ++i) {
                byte dataByte = bytes[i];
                byte nibble1 = (byte)(dataByte & 0xF);
                dataByte = (byte)(dataByte >> 4);
                byte nibble2 = (byte)(dataByte & 0xF);
                buffer.append(_Utilities._hexDigitForNibble(nibble2));
                buffer.append(_Utilities._hexDigitForNibble(nibble1));
            }
            buffer.append('>');
        }

        private static void _appendArrayToStringBuffer(NSArray array, StringBuffer buffer, int indentionLevel) {
            buffer.append('(');
            int count = array.count();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    buffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel + 1);
                    _Utilities._appendObjectToStringBuffer(array.objectAtIndex(i), buffer, indentionLevel + 1);
                }
                buffer.append('\n');
                _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel);
            }
            buffer.append(')');
        }

        private static void _appendDictionaryToStringBuffer(NSDictionary dictionary, StringBuffer buffer, int indentionLevel) {
            buffer.append('{');
            int count = dictionary.count();
            if (count > 0) {
                Enumeration keyEnumerator = dictionary.keyEnumerator();
                while (keyEnumerator.hasMoreElements()) {
                    Object key = keyEnumerator.nextElement();
                    if (!(key instanceof String)) {
                        throw new IllegalArgumentException("Property list generation failed while attempting to write hashtable. Non-String key found in Hashtable. Property list dictionaries must have String's as keys.");
                    }
                    buffer.append('\n');
                    _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel + 1);
                    _Utilities._appendStringToStringBuffer((String)key, buffer, indentionLevel + 1);
                    buffer.append(" = ");
                    _Utilities._appendObjectToStringBuffer(dictionary.objectForKey(key), buffer, indentionLevel + 1);
                    buffer.append(';');
                }
                buffer.append('\n');
                _Utilities._appendIndentationToStringBuffer(buffer, indentionLevel);
            }
            buffer.append('}');
        }

        private static void _appendIndentationToStringBuffer(StringBuffer buffer, int indentionLevel) {
            for (int i = 0; i < indentionLevel; ++i) {
                buffer.append('\t');
            }
        }

        private static final char _hexDigitForNibble(byte nibble) {
            char digit = '\u0000';
            if (nibble >= 0 && nibble <= 9) {
                digit = (char)(48 + (char)nibble);
            } else if (nibble >= 10 && nibble <= 15) {
                digit = (char)(97 + (char)(nibble - 10));
            }
            return digit;
        }

        private int _readObjectIntoObjectReference(char[] characters, int index, Object[] objects) {
            if ((index = this._skipWhitespaceAndComments(characters, index)) == -1 || index >= characters.length) {
                objects[0] = null;
            } else if (characters[index] == '\"') {
                StringBuffer buffer = new StringBuffer(64);
                index = this._readQuotedStringIntoStringBuffer(characters, index, buffer);
                objects[0] = _NSStringUtilities.stringFromBuffer(buffer);
            } else if (characters[index] == '<') {
                NSMutableData data = new NSMutableData(this._lengthOfData(characters, index));
                index = this._readDataContentsIntoData(characters, index, data);
                objects[0] = data;
            } else if (characters[index] == '(') {
                NSMutableArray array = new NSMutableArray();
                index = this._readArrayContentsIntoArray(characters, index, array);
                objects[0] = array;
            } else if (characters[index] == '{') {
                NSMutableDictionary dictionary = new NSMutableDictionary();
                index = this._readDictionaryContentsIntoDictionary(characters, index, dictionary);
                objects[0] = dictionary;
            } else {
                StringBuffer buffer = new StringBuffer(64);
                index = this._readUnquotedStringIntoStringBuffer(characters, index, buffer);
                objects[0] = _NSStringUtilities.stringFromBuffer(buffer);
            }
            return index >= characters.length ? -1 : index;
        }

        private int _readUnquotedStringIntoStringBuffer(char[] characters, int index, StringBuffer buffer) {
            int originalIndex = index;
            buffer.setLength(0);
            while (index < characters.length && (characters[index] >= 'a' && characters[index] <= 'z' || characters[index] >= 'A' && characters[index] <= 'Z' || characters[index] >= '0' && characters[index] <= '9' || characters[index] == '_' || characters[index] == '$' || characters[index] == ':' || characters[index] == '.' || characters[index] == '/')) {
                ++index;
            }
            if (originalIndex >= index) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read unquoted string. No allowable characters were found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            buffer.append(characters, originalIndex, index - originalIndex);
            return index >= characters.length ? -1 : index;
        }

        private int _readQuotedStringIntoStringBuffer(char[] characters, int index, StringBuffer buffer) {
            this._saveIndexes(index, this._lineNumber, this._startOfLineCharIndex);
            int seqStart = ++index;
            while (index < characters.length && characters[index] != '\"') {
                if (characters[index] == '\\') {
                    if (seqStart < index) {
                        buffer.append(characters, seqStart, index - seqStart);
                    }
                    if (++index >= characters.length) {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
                    }
                    if (characters[index] == 'n') {
                        buffer.append('\n');
                    } else if (characters[index] == 'r') {
                        buffer.append('\r');
                        ++index;
                    } else if (characters[index] == 't') {
                        buffer.append('\t');
                        ++index;
                    } else if (characters[index] == 'f') {
                        buffer.append('\f');
                        ++index;
                    } else if (characters[index] == 'b') {
                        buffer.append('\b');
                        ++index;
                    } else if (characters[index] == 'a') {
                        buffer.append('\u0007');
                        ++index;
                    } else if (characters[index] == 'v') {
                        buffer.append('\u000b');
                        ++index;
                    } else if (characters[index] == 'u' || characters[index] == 'U') {
                        if (index + 4 >= characters.length) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before escape sequence was completed. Opening quote was at " + this._savedIndexesAsString() + ".");
                        }
                        if (!(_Utilities._isHexDigit(characters[++index]) && _Utilities._isHexDigit(characters[index + 1]) && _Utilities._isHexDigit(characters[index + 2]) && _Utilities._isHexDigit(characters[index + 3]))) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Improperly formed \\U type escape sequence. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                        }
                        byte nibble4 = _Utilities._nibbleForHexDigit(characters[index]);
                        byte nibble3 = _Utilities._nibbleForHexDigit(characters[index + 1]);
                        byte nibble2 = _Utilities._nibbleForHexDigit(characters[index + 2]);
                        byte nibble1 = _Utilities._nibbleForHexDigit(characters[index + 3]);
                        buffer.append((char)((nibble4 << 12) + (nibble3 << 8) + (nibble2 << 4) + nibble1));
                        index += 4;
                    } else if (characters[index] >= '0' && characters[index] <= '7') {
                        int temp = 0;
                        int numberOfDigits = 1;
                        int[] digits = new int[3];
                        digits[0] = characters[index] - 48;
                        ++index;
                        while (numberOfDigits < 3 && index < characters.length && characters[index] >= '0' && characters[index] <= '7') {
                            digits[numberOfDigits++] = characters[index] - 48;
                            ++index;
                        }
                        if (numberOfDigits == 3 && digits[0] > 3) {
                            throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Octal escape sequence too large (bigger than octal 377). At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                        }
                        for (int i = 0; i < numberOfDigits; ++i) {
                            temp *= 8;
                            temp += digits[i];
                        }
                        buffer.append(_Utilities._nsToUnicode(temp));
                    } else {
                        buffer.append(characters[index]);
                        if (characters[index] == '\n') {
                            ++this._lineNumber;
                            this._startOfLineCharIndex = index + 1;
                        }
                        ++index;
                    }
                    seqStart = ++index;
                    continue;
                }
                if (characters[index] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = index + 1;
                }
                ++index;
            }
            if (seqStart < index) {
                buffer.append(characters, seqStart, index - seqStart);
            }
            if (index >= characters.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
            }
            return ++index >= characters.length ? -1 : index;
        }

        private int _lengthOfData(char[] characters, int index) {
            int numberOfNibbles = 0;
            boolean isHex = false;
            ++index;
            while (index < characters.length && ((isHex = _Utilities._isHexDigit(characters[index])) || _Utilities._isWhitespace(characters[index]))) {
                if (isHex) {
                    ++numberOfNibbles;
                }
                ++index;
            }
            if (index >= characters.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. Input exhausted before data was terminated with '>'. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            if (characters[index] != '>') {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. Illegal character encountered in data: '" + characters[index] + "'. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            if (numberOfNibbles % 2 != 0) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read data. An odd number of half-bytes were specified. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            return numberOfNibbles / 2;
        }

        private int _readDataContentsIntoData(char[] characters, int index, NSMutableData data) {
            ++index;
            while (characters[index] != '>' && characters[index = this._skipWhitespaceAndComments(characters, index)] != '>') {
                byte nibble2 = _Utilities._nibbleForHexDigit(characters[index]);
                ++index;
                index = this._skipWhitespaceAndComments(characters, index);
                byte nibble1 = _Utilities._nibbleForHexDigit(characters[index]);
                ++index;
                data.appendByte((byte)((nibble2 << 4) + nibble1));
            }
            return ++index >= characters.length ? -1 : index;
        }

        private int _readArrayContentsIntoArray(char[] characters, int index, NSMutableArray array) {
            Object[] objects = new Object[1];
            ++index;
            array.removeAllObjects();
            index = this._skipWhitespaceAndComments(characters, index);
            while (index != -1 && characters[index] != ')') {
                if (array.count() > 0) {
                    if (characters[index] != ',') {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read array. No comma found between array elements. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                    }
                    ++index;
                    if ((index = this._skipWhitespaceAndComments(characters, index)) == -1) {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                    }
                }
                if (characters[index] == ')') continue;
                objects[0] = null;
                index = this._readObjectIntoObjectReference(characters, index, objects);
                if (objects[0] == null) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Failed to read content object. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                index = this._skipWhitespaceAndComments(characters, index);
                array.addObject(objects[0]);
            }
            if (index == -1) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            return ++index >= characters.length ? -1 : index;
        }

        private int _readDictionaryContentsIntoDictionary(char[] characters, int index, NSMutableDictionary dictionary) {
            Object[] keys = new Object[1];
            Object[] values = new Object[1];
            ++index;
            if (dictionary.count() != 0) {
                Enumeration keyEnumerator = dictionary.keyEnumerator();
                while (keyEnumerator.hasMoreElements()) {
                    dictionary.removeObjectForKey(keyEnumerator.nextElement());
                }
            }
            index = this._skipWhitespaceAndComments(characters, index);
            while (index != -1 && characters[index] != '}') {
                index = this._readObjectIntoObjectReference(characters, index, keys);
                if (keys[0] == null || !(keys[0] instanceof String)) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Failed to read key or key is not a String. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                if ((index = this._skipWhitespaceAndComments(characters, index)) == -1 || characters[index] != '=') {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key " + keys[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                ++index;
                if ((index = this._skipWhitespaceAndComments(characters, index)) == -1) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key " + keys[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                index = this._readObjectIntoObjectReference(characters, index, values);
                if (values[0] == null) {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Failed to read value. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                if ((index = this._skipWhitespaceAndComments(characters, index)) == -1 || characters[index] != ';') {
                    throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Read key and value with no terminating semicolon. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                ++index;
                index = this._skipWhitespaceAndComments(characters, index);
                dictionary.setObjectForKey(values[0], keys[0]);
            }
            if (index >= characters.length) {
                throw new IllegalArgumentException("Property list parsing failed while attempting to read dictionary. Exhausted input before end of dictionary was found. At line number: " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
            }
            return ++index >= characters.length ? -1 : index;
        }

        private int _skipWhitespaceAndComments(char[] characters, int index) {
            int nextChar = this._checkForWhitespaceOrComment(characters, index);
            while (nextChar != 1) {
                switch (nextChar) {
                    case 2: {
                        index = this._processWhitespace(characters, index);
                        break;
                    }
                    case 3: {
                        index = this._processSingleLineComment(characters, index);
                        break;
                    }
                    case 4: {
                        index = this._processMultiLineComment(characters, index);
                    }
                }
                nextChar = this._checkForWhitespaceOrComment(characters, index);
            }
            return index >= characters.length ? -1 : index;
        }

        private int _processWhitespace(char[] characters, int index) {
            while (index < characters.length && _Utilities._isWhitespace(characters[index])) {
                if (characters[index] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = index + 1;
                }
                ++index;
            }
            return index >= characters.length ? -1 : index;
        }

        private int _processSingleLineComment(char[] characters, int index) {
            index += 2;
            while (index < characters.length && characters[index] != '\n') {
                ++index;
            }
            return index >= characters.length ? -1 : index;
        }

        private int _processMultiLineComment(char[] characters, int index) {
            this._saveIndexes(index, this._lineNumber, this._startOfLineCharIndex);
            index += 2;
            while (index + 1 < characters.length && (characters[index] != '*' || characters[index + 1] != '/')) {
                if (characters[index] == '/' && characters[index + 1] == '*') {
                    throw new IllegalArgumentException("Property list parsing does not support embedded multi line comments.The first /* was at " + this._savedIndexesAsString() + ". A second /* was found at line " + this._lineNumber + ", column: " + (index - this._startOfLineCharIndex) + ".");
                }
                if (characters[index] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = index + 1;
                }
                ++index;
            }
            if (index + 1 >= characters.length || characters[index] != '*' || characters[index + 1] != '/') {
                throw new IllegalArgumentException("Property list parsing failed while attempting to find closing */ to comment that began at " + this._savedIndexesAsString() + ".");
            }
            return (index += 2) >= characters.length ? -1 : index;
        }

        private int _checkForWhitespaceOrComment(char[] characters, int index) {
            if (index == -1 || index >= characters.length) {
                return 1;
            }
            if (_Utilities._isWhitespace(characters[index])) {
                return 2;
            }
            if (index + 1 < characters.length) {
                if (characters[index] == '/' && characters[index + 1] == '/') {
                    return 3;
                }
                if (characters[index] == '/' && characters[index + 1] == '*') {
                    return 4;
                }
            }
            return 1;
        }

        private static final byte _nibbleForHexDigit(char digit) {
            byte nibble = 0;
            if (digit >= '0' && digit <= '9') {
                nibble = (byte)(digit - 48);
            } else if (digit >= 'a' && digit <= 'f') {
                nibble = (byte)(digit - 97 + 10);
            } else if (digit >= 'A' && digit <= 'F') {
                nibble = (byte)(digit - 65 + 10);
            } else {
                throw new IllegalArgumentException("Non-hex digit passed to _nibbleForHexDigit()");
            }
            return nibble;
        }

        private static final boolean _isHexDigit(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        private static final boolean _isWhitespace(char c) {
            return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
        }

        private static char _nsToUnicode(int c) {
            return c < 128 ? (char)c : (char)NSToPrecompUnicodeTable[c - 128];
        }

        static {
            NSToPrecompUnicodeTable = new int[]{160, 192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 221, 222, 181, 215, 247, 169, 161, 162, 163, 8260, 165, 402, 167, 164, 8217, 8220, 171, 8249, 8250, 64257, 64258, 174, 8211, 8224, 8225, 183, 166, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 172, 191, 185, 715, 180, 710, 732, 175, 728, 729, 168, 178, 730, 184, 179, 733, 731, 711, 8212, 177, 188, 189, 190, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235, 236, 198, 237, 170, 238, 239, 240, 241, 321, 216, 338, 186, 242, 243, 244, 245, 246, 230, 249, 250, 251, 305, 252, 253, 322, 248, 339, 223, 254, 255, 65533, 65533};
        }
    }
}

