/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOSession;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.directtoweb.D2WPage;
import com.webobjects.directtoweb.ERD2WContext;
import com.webobjects.directtoweb.KeyValuePath;
import com.webobjects.directtoweb.QueryPageInterface;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.directtoweb.ERD2WContainer;
import er.directtoweb.ERD2WFactory;
import er.directtoweb.ERD2WModel;
import er.directtoweb.pages.ERD2WPage;
import er.extensions.ERXExtensions;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.appserver.ERXSession;
import er.extensions.appserver.ERXWOContext;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXKeyValuePair;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXValueUtilities;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERDirectToWeb
extends ERXFrameworkPrincipal {
    public static final Class[] REQUIRES = new Class[]{ERXExtensions.class};
    public static final Logger log = Logger.getLogger((String)"er.directtoweb.ERDirectToWeb");
    public static final String D2WDEBUGGING_ENABLED_KEY = "ERDirectToWeb_d2wDebuggingEnabled";
    public static final String D2WDISPLAY_COMPONENTNAMES_KEY = "ERDirectToWeb_displayComponentNames";
    public static final String D2WDISPLAY_PROPERTYKEYS_KEY = "ERDirectToWeb_displayPropertyKeys";
    public static final String D2WDISPLAY_PAGE_METRICS_KEY = "ERDirectToWeb_displayPageMetrics";
    public static final String D2WDISPLAY_DETAILED_PAGE_METRICS_KEY = "ERDirectToWeb_displayDetailedPageMetrics";
    public static final Logger debugLog = Logger.getLogger((String)"er.directtoweb.ERD2WDebugEnabled");
    public static final Logger componentNameLog = Logger.getLogger((String)"er.directtoweb.ERD2WDebugEnabled.componentName");
    public static final Logger propertyKeyLog = Logger.getLogger((String)"er.directtoweb.ERD2WDebugEnabled.propertyKey");
    public static final NSSelector D2WCONTEXT_SELECTOR = new NSSelector("d2wContext");
    private static D2WContext _context;
    public static Logger trace;

    public void finishInitialization() {
        this.fixClasses();
        ERD2WModel model = ERD2WModel.erDefaultModel();
        if (!(D2W.factory() instanceof ERD2WFactory)) {
            D2W.setFactory((D2W)new ERD2WFactory());
        }
        this.configureTraceRuleFiringRapidTurnAround();
        ERDirectToWeb.warmUpRuleCache();
        model.checkRules();
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("resetModel", ERXConstant.NotificationClassArray), "LocalizationDidReset", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("sortRules", ERXConstant.NotificationClassArray), "WillSortRules", null);
    }

    private void fixClasses(String oldName, String newName) {
        NSArray names = NSBundle.bundleForClass(((Object)((Object)this)).getClass()).bundleClassNames();
        for (String name : names) {
            if (!name.startsWith(newName)) continue;
            Class clazz = ERXPatcher.classForName((String)name);
            name = name.replaceFirst(newName + "(\\.[a-z]+)?", oldName);
            ERXPatcher.setClassForName((Class)clazz, (String)name);
        }
    }

    private void fixClasses() {
        this.fixClasses("er.directtoweb", "er.directtoweb.assignments");
        this.fixClasses("er.directtoweb", "er.directtoweb.assignments.delayed");
        this.fixClasses("er.directtoweb", "er.directtoweb.assignments.defaults");
    }

    public void resetModel(NSNotification n) {
        ERD2WModel.erDefaultModel().resetModel();
    }

    public void sortRules(NSNotification n) {
        ERD2WModel model = (ERD2WModel)((Object)n.object());
        if (ERD2WModel.erDefaultModel() == model) {
            URL url = ERXFileUtilities.pathURLForResourceNamed((String)"d2wClient.d2wmodel", (String)"ERDirectToWeb", null);
            model.mergePathURL(url);
        }
    }

    public static void setD2wDebuggingEnabled(WOSession s, boolean enabled) {
        ERXExtensions.setBooleanFlagOnSessionForKey((WOSession)s, (String)D2WDEBUGGING_ENABLED_KEY, (boolean)enabled);
        if (!enabled) {
            ERDirectToWeb.setD2wComponentNameDebuggingEnabled(s, false);
            ERDirectToWeb.setD2wPropertyKeyDebuggingEnabled(s, false);
        }
    }

    public static boolean d2wDebuggingEnabled(WOSession s) {
        return ERXExtensions.booleanFlagOnSessionForKeyWithDefault((WOSession)s, (String)D2WDEBUGGING_ENABLED_KEY, (boolean)debugLog.isDebugEnabled());
    }

    public static void setD2wComponentNameDebuggingEnabled(WOSession s, boolean enabled) {
        ERXExtensions.setBooleanFlagOnSessionForKey((WOSession)s, (String)D2WDISPLAY_COMPONENTNAMES_KEY, (boolean)enabled);
    }

    public static boolean d2wComponentNameDebuggingEnabled(WOSession s) {
        return ERXExtensions.booleanFlagOnSessionForKeyWithDefault((WOSession)s, (String)D2WDISPLAY_COMPONENTNAMES_KEY, (boolean)componentNameLog.isDebugEnabled());
    }

    public static void setD2wPropertyKeyDebuggingEnabled(WOSession s, boolean enabled) {
        ERXExtensions.setBooleanFlagOnSessionForKey((WOSession)s, (String)D2WDISPLAY_PROPERTYKEYS_KEY, (boolean)enabled);
    }

    public static boolean d2wPropertyKeyDebuggingEnabled(WOSession s) {
        return ERXExtensions.booleanFlagOnSessionForKeyWithDefault((WOSession)s, (String)D2WDISPLAY_PROPERTYKEYS_KEY, (boolean)propertyKeyLog.isDebugEnabled());
    }

    public static boolean pageMetricsEnabled() {
        return ERXExtensions.booleanFlagOnSessionForKeyWithDefault((WOSession)ERXSession.session(), (String)D2WDISPLAY_PAGE_METRICS_KEY, (boolean)false);
    }

    public static void setPageMetricsEnabled(boolean value) {
        ERXExtensions.setBooleanFlagOnSessionForKey((WOSession)ERXSession.session(), (String)D2WDISPLAY_PAGE_METRICS_KEY, (boolean)value);
    }

    public static boolean detailedPageMetricsEnabled() {
        return ERXExtensions.booleanFlagOnSessionForKeyWithDefault((WOSession)ERXSession.session(), (String)D2WDISPLAY_DETAILED_PAGE_METRICS_KEY, (boolean)false);
    }

    public static void setDetailedPageMetricsEnabled(boolean value) {
        ERXExtensions.setBooleanFlagOnSessionForKey((WOSession)ERXSession.session(), (String)D2WDISPLAY_DETAILED_PAGE_METRICS_KEY, (boolean)value);
    }

    public static String resolveUnit(String userInfoUnitString, EOEnterpriseObject object, String prefixKeyPath) {
        if (userInfoUnitString != null && userInfoUnitString.indexOf("@") > -1) {
            String keyPath = userInfoUnitString.substring(1);
            String PropertyKeyWithoutLastProperty = KeyValuePath.keyPathWithoutLastProperty((String)prefixKeyPath);
            EOEnterpriseObject objectForPropertyDisplayed = null;
            objectForPropertyDisplayed = PropertyKeyWithoutLastProperty != null ? (object != null ? (EOEnterpriseObject)object.valueForKeyPath(PropertyKeyWithoutLastProperty) : null) : object;
            userInfoUnitString = objectForPropertyDisplayed != null ? (String)objectForPropertyDisplayed.valueForKeyPath(keyPath) : null;
        }
        return userInfoUnitString;
    }

    public static String convertedPropertyKeyFromString(String s, char start, char end) {
        if (s.length() > 2 && s.charAt(0) == start && s.charAt(s.length() - 1) == end) {
            return s.substring(1, s.length() - 1);
        }
        return null;
    }

    public static NSMutableArray convertedPropertyKeyArray(NSArray keyArray, char startChar, char endChar) {
        NSMutableArray result = new NSMutableArray();
        Object firstValue = null;
        if (keyArray.count() > 0) {
            firstValue = keyArray.objectAtIndex(0);
        }
        if (firstValue != null) {
            boolean isKeyArrayFormat = false;
            if (firstValue instanceof String) {
                boolean bl = isKeyArrayFormat = ERDirectToWeb.convertedPropertyKeyFromString((String)firstValue, startChar, endChar) != null;
            }
            if (firstValue instanceof String && !isKeyArrayFormat) {
                ERD2WContainer c = new ERD2WContainer();
                c.name = "";
                c.keys = new NSMutableArray(keyArray);
                result.addObject((Object)c);
            } else {
                NSMutableArray tmp = null;
                Enumeration e = keyArray.objectEnumerator();
                while (e.hasMoreElements()) {
                    if (isKeyArrayFormat) {
                        String currentValue = (String)e.nextElement();
                        String currentLabel = ERDirectToWeb.convertedPropertyKeyFromString(currentValue, startChar, endChar);
                        if (currentLabel != null) {
                            ERD2WContainer c = new ERD2WContainer();
                            c.name = currentLabel;
                            c.keys = tmp = new NSMutableArray();
                            result.addObject((Object)c);
                            continue;
                        }
                        tmp.addObject((Object)currentValue);
                        continue;
                    }
                    NSArray current = (NSArray)e.nextElement();
                    ERD2WContainer c = new ERD2WContainer();
                    c.name = (String)current.objectAtIndex(0);
                    c.keys = current.mutableClone();
                    c.keys.removeObjectAtIndex(0);
                    result.addObject((Object)c);
                }
            }
        }
        return result;
    }

    public static NSArray<EOSortOrdering> sortOrderings(D2WContext d2wContext) {
        NSMutableArray validatedSortOrderings = new NSMutableArray();
        NSArray sortOrderingDefinition = (NSArray)d2wContext.valueForKey("defaultSortOrdering");
        if (sortOrderingDefinition != null) {
            int i = 0;
            while (i < sortOrderingDefinition.count()) {
                String sortKey = (String)sortOrderingDefinition.objectAtIndex(i++);
                String sortSelectorKey = (String)sortOrderingDefinition.objectAtIndex(i++);
                EOSortOrdering sortOrdering = new EOSortOrdering(sortKey, ERXArrayUtilities.sortSelectorWithKey((String)sortSelectorKey));
                validatedSortOrderings.addObject((Object)sortOrdering);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found sort Orderings in rules " + validatedSortOrderings));
            }
        }
        return validatedSortOrderings;
    }

    public static boolean booleanForKey(D2WContext context, String key) {
        return ERXValueUtilities.booleanValue((Object)context.valueForKey(key));
    }

    public static String userInfoUnit(EOEnterpriseObject object, String key) {
        EOEntity entity = null;
        String lastKey = null;
        String result = null;
        if (object == null || key == null) {
            log.warn((Object)("UserInfoUnit: Attempting to relsolve a unit for object: " + object + " key: " + key));
        } else if (key.indexOf(".") == -1) {
            String entityName = object.entityName();
            entity = EOModelGroup.defaultGroup().entityNamed(entityName);
            lastKey = key;
        } else {
            String partialKeyPath = KeyValuePath.keyPathWithoutLastProperty((String)key);
            EOEnterpriseObject objectForPropertyDisplayed = (EOEnterpriseObject)object.valueForKeyPath(partialKeyPath);
            if (objectForPropertyDisplayed != null) {
                entity = EOModelGroup.defaultGroup().entityNamed(objectForPropertyDisplayed.entityName());
                lastKey = KeyValuePath.lastPropertyKeyInKeyPath((String)key);
            }
        }
        if (entity != null && lastKey != null) {
            EOAttribute property = entity.attributeNamed(lastKey);
            property = property == null ? entity.relationshipNamed(lastKey) : property;
            EOAttribute a = entity.attributeNamed(lastKey);
            NSDictionary userInfo = null;
            if (a != null) {
                userInfo = a.userInfo();
            } else {
                EORelationship r = entity.relationshipNamed(lastKey);
                if (r != null) {
                    userInfo = r.userInfo();
                }
            }
            result = (String)(userInfo != null ? userInfo.valueForKey("unit") : null);
        }
        return result;
    }

    public static WOComponent printerFriendlyPageForD2WContext(D2WContext context, WOSession session) {
        return ERD2WFactory.erFactory().printerFriendlyPageForD2WContext(context, session);
    }

    public static WOComponent csvExportPageForD2WContext(D2WContext context, WOSession session) {
        return ERD2WFactory.erFactory().csvExportPageForD2WContext(context, session);
    }

    public static WOComponent pageForTaskSubTaskAndEntityNamed(String task, String subtask, String entityName, WOSession session) {
        return ERD2WFactory.erFactory().pageForTaskSubTaskAndEntityNamed(task, subtask, entityName, session);
    }

    public static QueryPageInterface queryPageWithFetchSpecificationForEntityNamed(String fsName, String entityName, WOSession session) {
        return ERD2WFactory.erFactory().queryPageWithFetchSpecificationForEntityNamed(fsName, entityName, session);
    }

    public static WOComponent errorPageForException(Throwable e, WOSession session) {
        return ERD2WFactory.erFactory().errorPageForException(e, session);
    }

    public static synchronized void reportException(Exception ex, D2WContext d2wContext) {
        if (d2wContext != null) {
            log.error((Object)("Exception <" + ex + ">: " + "pageConfiguration <" + d2wContext.valueForKeyPath("pageConfiguration") + ">, " + "propertyKey <" + d2wContext.propertyKey() + ">, " + "entityName <" + d2wContext.valueForKeyPath("entity.name") + ">, " + "displayPropertyKeys <" + d2wContext.valueForKeyPath("displayPropertyKeys") + ">, " + "componentName <" + ERDirectToWeb.d2wContext().valueForKey("componentName") + ">, " + "customComponent <" + ERDirectToWeb.d2wContext().valueForKey("customComponentName") + ">"), (Throwable)ex);
        } else {
            log.error((Object)("Exception <" + ex + ">: with NULL d2wContext"));
        }
        if (ERDirectToWeb.shouldRaiseException(true)) {
            if (!(ex instanceof D2WException)) {
                ex = new D2WException((Exception)ex, d2wContext);
            }
            throw (D2WException)((Object)ex);
        }
    }

    public static synchronized NSMutableDictionary informationForContext(WOContext context) {
        WOComponent component;
        D2WContext d2wContext;
        NSMutableDictionary info;
        block7: {
            info = new NSMutableDictionary();
            d2wContext = null;
            NSArray componentStack = ERXWOContext._componentPath((WOContext)context);
            component = null;
            Enumeration componentsEnum = componentStack.reverseObjectEnumerator();
            while (componentsEnum.hasMoreElements()) {
                WOComponent c = (WOComponent)componentsEnum.nextElement();
                if (!(c instanceof D2WPage)) continue;
                component = c;
                break;
            }
            if (null == component) {
                component = context.page();
            }
            try {
                d2wContext = (D2WContext)component.valueForKey("d2wContext");
            }
            catch (NSKeyValueCoding.UnknownKeyException uke) {
                if (!log.isInfoEnabled()) break block7;
                log.info((Object)"Could not retrieve D2WContext from component context; it is probably not a D2W component.");
            }
        }
        if (d2wContext != null) {
            NSMutableDictionary d2wInfo = ERDirectToWeb.informationForD2WContext(d2wContext);
            if (component instanceof ERD2WPage) {
                ERD2WPage currentPage = (ERD2WPage)component;
                String subTask = (String)d2wContext.valueForKey("subTask");
                if ("tab".equals(subTask) || "wizard".equals("subTask")) {
                    NSArray sections = currentPage.sectionsForCurrentTab();
                    d2wInfo.setObjectForKey(sections != null ? sections : "null", (Object)"D2W-SectionsContentsForCurrentTab");
                    d2wInfo.removeObjectForKey((Object)"D2W-TabSectionsContents");
                }
            }
            info.addEntriesFromDictionary((NSDictionary)d2wInfo);
        }
        return info;
    }

    public static synchronized NSMutableDictionary informationForD2WContext(D2WContext d2wContext) {
        NSMutableDictionary info = new NSMutableDictionary();
        if (d2wContext != null) {
            String pageConfiguration = (String)d2wContext.valueForKeyPath("pageConfiguration");
            info.setObjectForKey((Object)(pageConfiguration != null ? pageConfiguration : "null"), (Object)"D2W-PageConfiguration");
            String propertyKey = d2wContext.propertyKey();
            info.setObjectForKey((Object)(propertyKey != null ? propertyKey : "null"), (Object)"D2W-PropertyKey");
            String entityName = (String)d2wContext.valueForKeyPath("entity.name");
            info.setObjectForKey((Object)(entityName != null ? entityName : "null"), (Object)"D2W-EntityName");
            String task = (String)d2wContext.valueForKey("task");
            info.setObjectForKey((Object)(task != null ? task : "null"), (Object)"D2W-SubTask");
            String subTask = (String)d2wContext.valueForKey("subTask");
            info.setObjectForKey((Object)(subTask != null ? subTask : "null"), (Object)"D2W-SubTask");
            if ("tab".equals(subTask) || "wizard".equals("subTask")) {
                String tabKey = (String)d2wContext.valueForKey("tabKey");
                info.setObjectForKey((Object)(tabKey != null ? tabKey : "null"), (Object)"D2W-TabKey");
                NSArray tabSections = (NSArray)d2wContext.valueForKey("tabSectionsContents");
                info.setObjectForKey(tabSections != null ? tabSections : "null", (Object)"D2W-TabSectionsContents");
            } else {
                NSArray displayPropertyKeys = (NSArray)d2wContext.valueForKey("displayPropertyKeys");
                info.setObjectForKey(displayPropertyKeys != null ? displayPropertyKeys : "null", (Object)"D2W-DisplayPropertyKeys");
            }
            String componentName = (String)d2wContext.valueForKey("componentName");
            info.setObjectForKey((Object)(componentName != null ? componentName : "null"), (Object)"D2W-ComponentName");
            if (componentName != null && componentName.indexOf("CustomComponent") > 0) {
                String customComponentName = (String)d2wContext.valueForKey("customComponentName");
                info.setObjectForKey((Object)(customComponentName != null ? customComponentName : "null"), (Object)"D2W-ComponentName");
            }
        }
        return info;
    }

    public static boolean shouldRaiseException(boolean defaultValue) {
        return ERXProperties.booleanForKeyWithDefault((String)"er.directtoweb.ERDirectToWeb.shouldRaiseExceptions", (boolean)defaultValue);
    }

    public static synchronized String displayNameForPropertyKey(String key, String entityName) {
        EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
        ERDirectToWeb.d2wContext()._localValues().clear();
        ERDirectToWeb.d2wContext().setEntity(entity);
        ERDirectToWeb.d2wContext().setPropertyKey(key);
        String result = ERDirectToWeb.d2wContext().displayNameForProperty();
        ERDirectToWeb.d2wContext()._localValues().clear();
        return result;
    }

    private static D2WContext d2wContext() {
        if (_context == null) {
            _context = ERD2WContext.newContext();
        }
        return _context;
    }

    public static Object d2wContextValueForKey(String key, String entityName) {
        return ERDirectToWeb.d2wContextValueForKey(key, entityName, null);
    }

    public static synchronized Object d2wContextValueForKey(String key, String entityName, NSDictionary extraValuesForContext) {
        EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
        ERDirectToWeb.d2wContext()._localValues().clear();
        ERDirectToWeb.d2wContext().setEntity(entity);
        if (extraValuesForContext != null) {
            ERDirectToWeb.d2wContext().takeValuesFromDictionary(extraValuesForContext);
        }
        Object result = ERDirectToWeb.d2wContext().valueForKey(key);
        ERDirectToWeb.d2wContext()._localValues().clear();
        return result;
    }

    public static String createConfigurationForEntityNamed(String entityName) {
        return (String)ERDirectToWeb.d2wContextValueForKey("createConfigurationName", entityName);
    }

    public static void warmUpRuleCache() {
        log.debug((Object)"Preparing DirectToWeb Data Structures");
        ERD2WModel.erDefaultModel().prepareDataStructures();
    }

    public void configureTraceRuleFiring(NSNotification n) {
        ERDirectToWeb.configureTraceRuleFiring();
    }

    private void configureTraceRuleFiringRapidTurnAround() {
        if (trace == null) {
            trace = Logger.getLogger((String)"er.directtoweb.rules.D2WTraceRuleFiringEnabled");
            ERDirectToWeb.configureTraceRuleFiring();
            NSNotificationCenter.defaultCenter().addObserver((Object)ERXFrameworkPrincipal.sharedInstance(ERDirectToWeb.class), new NSSelector("configureTraceRuleFiring", ERXConstant.NotificationClassArray), "ConfigurationDidChangeNotification", null);
        }
    }

    public static void configureTraceRuleFiring() {
        if (trace.isDebugEnabled() && !NSLog.debugLoggingAllowedForGroups((long)0x200000L)) {
            trace.info((Object)"Rule tracing on");
        } else if (!trace.isDebugEnabled() && NSLog.debugLoggingAllowedForGroups((long)0x200000L)) {
            trace.info((Object)"Rule tracing off");
        }
    }

    public static NSArray displayableArrayForKeyPathArray(NSArray array, String entityForReportName) {
        if (array == null) {
            return null;
        }
        NSMutableArray result = new NSMutableArray();
        Enumeration e = array.objectEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result.addObject((Object)new ERXKeyValuePair((Object)key, (Object)ERDirectToWeb.displayNameForPropertyKey(key, entityForReportName)));
        }
        return result;
    }

    static {
        ERDirectToWeb.setUpFrameworkPrincipalClass(ERDirectToWeb.class);
    }

    public static class D2WException
    extends NSForwardException {
        private D2WContext _context;

        public D2WException(Exception ex, D2WContext context) {
            super((Throwable)ex);
            this._context = context;
        }

        public D2WContext d2wContext() {
            return this._context;
        }
    }
}

