/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.components.dates;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation.NSValidation;
import er.directtoweb.components.ERDCustomEditComponent;
import er.extensions.formatters.ERXTimestampFormatter;
import er.extensions.validation.ERXValidationException;
import er.extensions.validation.ERXValidationFactory;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class ERDEditDateJavascript
extends ERDCustomEditComponent {
    static final Logger log = Logger.getLogger(ERDEditDateJavascript.class);
    public String dateString;
    protected String _formatter;
    protected NSTimestampFormatter _dateFormatter;

    public ERDEditDateJavascript(WOContext context) {
        super(context);
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        NSTimestamp date = (NSTimestamp)this.objectPropertyValue();
        if (date != null) {
            try {
                this.dateString = this.dateFormatter().format((Object)date);
            }
            catch (IllegalArgumentException nsfe) {}
        } else {
            this.dateString = null;
        }
        super.appendToResponse(r, c);
    }

    public Object value() {
        return this.dateString;
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        super.takeValuesFromRequest(request, context);
        NSTimestamp date = null;
        try {
            if (this.dateString != null) {
                date = (NSTimestamp)this.dateFormatter().parseObject(this.dateString);
            }
            if (this.object() != null) {
                this.object().validateTakeValueForKeyPath((Object)date, this.key());
            }
        }
        catch (ParseException npse) {
            log.debug((Object)("java.text.ParseException:" + npse));
            ERXValidationException v = ERXValidationFactory.defaultFactory().createException(this.object(), this.key(), (Object)this.dateString, "InvalidDateFormatException");
            this.parent().validationFailedWithException((Throwable)v, (Object)date, this.key());
        }
        catch (NSValidation.ValidationException v) {
            log.debug((Object)("NSValidation.ValidationException:" + (Object)((Object)v)));
            this.parent().validationFailedWithException((Throwable)v, (Object)date, this.key());
        }
        catch (Exception e) {
            log.debug((Object)("Exception:" + e));
            this.parent().validationFailedWithException((Throwable)e, (Object)date, this.key());
        }
    }

    protected NSTimestampFormatter dateFormatter() {
        if (this._dateFormatter == null) {
            this._dateFormatter = ERXTimestampFormatter.dateFormatterForPattern((String)this.formatter());
        }
        return this._dateFormatter;
    }

    public String formatter() {
        if (this._formatter == null) {
            this._formatter = (String)this.valueForBinding("formatter");
        }
        if (this._formatter == null || this._formatter.length() == 0) {
            this._formatter = "%m/%d/%Y";
        }
        return this._formatter;
    }

    public void setFormatter(String formatter) {
        this._formatter = formatter;
    }
}

