/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.components.dates;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import er.directtoweb.components.ERDCustomQueryComponent;
import er.extensions.components._private.ERXWOForm;
import er.extensions.components.javascript.ERXEditDateJavascript;
import er.extensions.formatters.ERXTimestampFormatter;
import er.extensions.localization.ERXLocalizer;
import er.extensions.validation.ERXValidationException;
import er.extensions.validation.ERXValidationFactory;
import java.text.Format;
import java.text.ParseException;

public class ERDQueryDateRangeJavascript
extends ERDCustomQueryComponent {
    protected static String _datePickerJavaScriptUrl;
    protected String key;
    protected Format _dateFormatter;
    protected String _minValue;
    protected String _maxValue;
    protected String _minName;
    protected String _formatter;
    protected String _maxName;
    protected String _formName;
    protected String _javascriptName;

    public ERDQueryDateRangeJavascript(WOContext context) {
        super(context);
    }

    public String propertyKey() {
        if (this.key == null) {
            this.key = (String)this.valueForBinding("propertyKey");
        }
        return this.key;
    }

    public Format dateFormatter() {
        if (this._dateFormatter == null) {
            this._dateFormatter = ERXTimestampFormatter.dateFormatterForPattern((String)this.formatter());
        }
        return this._dateFormatter;
    }

    protected String stringForDate(NSTimestamp d) {
        String result = null;
        if (d != null) {
            try {
                result = this.dateFormatter().format(d);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public String javascriptName() {
        if (this._javascriptName == null) {
            this._javascriptName = "date_" + this.context().elementID().replace('.', '_');
        }
        return this._javascriptName;
    }

    public Object minValue() {
        if (this._minValue == null) {
            this._minValue = this.stringForDate((NSTimestamp)this.displayGroup().queryMin().valueForKey(this.propertyKey()));
        }
        return this._minValue;
    }

    public Object maxValue() {
        if (this._maxValue == null) {
            this._maxValue = this.stringForDate((NSTimestamp)this.displayGroup().queryMax().valueForKey(this.propertyKey()));
        }
        return this._maxValue;
    }

    public NSTimestamp dateForString(String dateString) {
        NSTimestamp date = null;
        try {
            if (dateString != null) {
                date = (NSTimestamp)this.dateFormatter().parseObject(dateString);
            }
        }
        catch (ParseException nspe) {
            ERXValidationException v = ERXValidationFactory.defaultFactory().createException(null, this.propertyKey(), (Object)dateString, "InvalidDateFormatException");
            this.parent().validationFailedWithException((Throwable)v, (Object)date, this.propertyKey());
        }
        catch (NSValidation.ValidationException v) {
            this.parent().validationFailedWithException((Throwable)v, (Object)date, this.propertyKey());
        }
        catch (Exception e) {
            this.parent().validationFailedWithException((Throwable)e, (Object)date, this.propertyKey());
        }
        return date;
    }

    public void setMinValue(String min) {
        this._minValue = min;
        NSTimestamp minDate = this.dateForString(min);
        if (minDate != null) {
            this.displayGroup().queryMin().takeValueForKey((Object)minDate, this.propertyKey());
        } else {
            this.displayGroup().queryMin().removeObjectForKey((Object)this.propertyKey());
        }
    }

    public void setMaxValue(String max) {
        this._maxValue = max;
        NSTimestamp maxDate = this.dateForString(max);
        if (maxDate != null) {
            this.displayGroup().queryMax().takeValueForKey((Object)maxDate, this.propertyKey());
        } else {
            this.displayGroup().queryMax().removeObjectForKey((Object)this.propertyKey());
        }
    }

    public String datePickerJavaScriptUrl() {
        if (_datePickerJavaScriptUrl == null) {
            _datePickerJavaScriptUrl = this.application().resourceManager().urlForResourceNamed("date-picker.js", "ERExtensions", null, this.context().request());
        }
        return _datePickerJavaScriptUrl;
    }

    public String formName() {
        if (this._formName == null) {
            this._formName = ERXWOForm.formName((WOContext)this.context(), (String)"QueryForm");
        }
        return this._formName;
    }

    public String minName() {
        if (this._minName == null) {
            this._minName = this.javascriptName() + "min";
        }
        return this._minName;
    }

    public String minHREF() {
        return "javascript:show_calendar('" + this.formName() + "." + this.minName() + "',null,null,'" + this.formatterStringForScript() + "')";
    }

    public String maxName() {
        if (this._maxName == null) {
            this._maxName = this.javascriptName() + "max";
        }
        return this._maxName;
    }

    public String maxHREF() {
        return "javascript:show_calendar('" + this.formName() + "." + this.maxName() + "',null,null,'" + this.formatterStringForScript() + "')";
    }

    public int formatLength() {
        String formatter = this.formatterStringForScript();
        return formatter.length() < 12 ? 12 : formatter.length();
    }

    public String localizedFormatString() {
        return ERXLocalizer.currentLocalizer().localizedStringForKeyWithDefault(this.formatter());
    }

    public String formatter() {
        if (this._formatter == null) {
            this._formatter = (String)this.valueForBinding("formatter");
            if (this._formatter == null || this._formatter.length() == 0) {
                this._formatter = "%m/%d/%Y";
            }
        }
        return this._formatter;
    }

    public String formatterStringForScript() {
        return ERXEditDateJavascript.formatterStringForScript((String)this.localizedFormatString());
    }
}

