/*
 * Decompiled with CFR 0.152.
 */
package er.directtoweb.qualifiers;

import com.webobjects.directtoweb.BooleanQualifier;
import com.webobjects.directtoweb.NonNullQualifier;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import er.directtoweb.qualifiers.ERDQualifierTraversalCallback;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERDQualifierTraversal {
    public static final Logger log = Logger.getLogger(ERDQualifierTraversal.class);

    public static boolean traverseQualifier(EOQualifierEvaluation q, ERDQualifierTraversalCallback cb) {
        Boolean result = null;
        if (q == null) {
            result = Boolean.TRUE;
        } else if (q instanceof EOOrQualifier) {
            EOOrQualifier aq = (EOOrQualifier)q;
            cb.traverseOrQualifier(aq);
            result = Boolean.TRUE;
            Enumeration e = aq.qualifiers().objectEnumerator();
            while (e.hasMoreElements()) {
                if (ERDQualifierTraversal.traverseQualifier((EOQualifierEvaluation)e.nextElement(), cb)) continue;
                result = Boolean.FALSE;
                break;
            }
        } else if (q instanceof EOAndQualifier) {
            EOAndQualifier aq = (EOAndQualifier)q;
            cb.traverseAndQualifier(aq);
            result = Boolean.TRUE;
            Enumeration e = aq.qualifiers().objectEnumerator();
            while (e.hasMoreElements()) {
                if (ERDQualifierTraversal.traverseQualifier((EOQualifierEvaluation)e.nextElement(), cb)) continue;
                result = Boolean.FALSE;
                break;
            }
        } else if (q instanceof EONotQualifier) {
            EONotQualifier nq = (EONotQualifier)q;
            cb.traverseNotQualifier((EONotQualifier)q);
            result = ERDQualifierTraversal.traverseQualifier((EOQualifierEvaluation)nq.qualifier(), cb) ? Boolean.TRUE : Boolean.FALSE;
        } else if (q instanceof EOKeyValueQualifier) {
            result = cb.traverseKeyValueQualifier((EOKeyValueQualifier)q) ? Boolean.TRUE : Boolean.FALSE;
        } else if (q instanceof EOKeyComparisonQualifier) {
            result = cb.traverseKeyComparisonQualifier((EOKeyComparisonQualifier)q) ? Boolean.TRUE : Boolean.FALSE;
        } else if (q instanceof BooleanQualifier) {
            result = cb.traverseBooleanQualifier((BooleanQualifier)q) ? Boolean.TRUE : Boolean.FALSE;
        } else if (q instanceof NonNullQualifier) {
            Boolean bl = result = cb.traverseNonNullQualifier((NonNullQualifier)q) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (result == null) {
            log.error((Object)("Found unknown qualifier type:" + q.getClass().getName()));
            throw new RuntimeException("Found unknown qualifier type:" + q.getClass().getName());
        }
        return result;
    }
}

