/*
 * Decompiled with CFR 0.152.
 */
package er.jgroups;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSNotification;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRemoteNotificationCenter;
import er.extensions.remoteSynchronizer.ERXRemoteSynchronizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class ERJGroupsNotificationCenter
extends ERXRemoteNotificationCenter {
    private static final Logger log = Logger.getLogger(ERJGroupsNotificationCenter.class);
    private String _groupName;
    private boolean _postLocal;
    private JChannel _channel;
    private static ERJGroupsNotificationCenter _sharedInstance;

    protected ERJGroupsNotificationCenter() throws ChannelException {
        String jgroupsPropertiesFile = ERXProperties.stringForKey((String)"er.extensions.jgroupsNotificationCenter.properties");
        String jgroupsPropertiesFramework = null;
        if (jgroupsPropertiesFile == null) {
            jgroupsPropertiesFile = "jgroups-default.xml";
            jgroupsPropertiesFramework = "ERJGroupsSynchronizer";
        }
        this._groupName = ERXProperties.stringForKeyWithDefault((String)"er.extensions.jgroupsNotificationCenter.groupName", (String)"ERJGroupsNotificationCenter");
        String localBindAddressStr = ERXProperties.stringForKey((String)"er.extensions.jgroupsNotificationCenter.localBindAddress");
        if (localBindAddressStr == null) {
            System.setProperty("bind.address", WOApplication.application().hostAddress().getHostAddress());
        } else {
            System.setProperty("bind.address", localBindAddressStr);
        }
        URL propertiesUrl = WOApplication.application().resourceManager().pathURLForResourceNamed(jgroupsPropertiesFile, jgroupsPropertiesFramework, null);
        this._channel = new JChannel(propertiesUrl);
        this._postLocal = ERXProperties.booleanForKeyWithDefault((String)"er.extensions.jgroupsNotificationCenter.postLocal", (boolean)false);
        this._channel.setOpt(3, (Object)Boolean.FALSE);
        this._channel.connect(this._groupName);
        this._channel.setReceiver((Receiver)new ExtendedReceiverAdapter(){

            public void receive(Message message) {
                try {
                    byte[] buffer = message.getBuffer();
                    ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                    ObjectInputStream dis = new ObjectInputStream(bais);
                    String name = (String)dis.readObject();
                    Object object = dis.readObject();
                    NSDictionary userInfo = (NSDictionary)dis.readObject();
                    NSNotification notification = new NSNotification(name, object, userInfo);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Received notification: " + notification));
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("Received " + notification.name() + " notification."));
                    }
                    ERJGroupsNotificationCenter.this.postLocalNotification(notification);
                }
                catch (IOException e) {
                    log.error((Object)("Failed to read notification: " + e), (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Failed to find class: " + e), (Throwable)e);
                }
            }

            public void viewAccepted(View view) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void install() {
        if (_sharedInstance != null) return;
        Class<ERJGroupsNotificationCenter> clazz = ERJGroupsNotificationCenter.class;
        synchronized (ERJGroupsNotificationCenter.class) {
            if (_sharedInstance != null) return;
            try {
                _sharedInstance = new ERJGroupsNotificationCenter();
                ERJGroupsNotificationCenter.setDefaultCenter((ERXRemoteNotificationCenter)_sharedInstance);
            }
            catch (ChannelException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            return;
        }
    }

    public void postRemoteNotification(NSNotification notification) {
        try {
            this.writeNotification(notification);
            if (this._postLocal) {
                this.postLocalNotification(notification);
            }
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    protected void writeNotification(NSNotification notification) throws ChannelNotConnectedException, ChannelClosedException, IOException {
        ERXRemoteSynchronizer.RefByteArrayOutputStream baos = new ERXRemoteSynchronizer.RefByteArrayOutputStream();
        ObjectOutputStream dos = new ObjectOutputStream((OutputStream)baos);
        dos.writeObject(notification.name());
        dos.writeObject(notification.object());
        dos.writeObject(notification.userInfo());
        dos.flush();
        dos.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending notification: " + notification));
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Sending " + notification.name() + " notification."));
        }
        Message message = new Message(null, null, baos.buffer(), 0, baos.size());
        this._channel.send(message);
    }
}

