/*
 * Decompiled with CFR 0.152.
 */
package er.ticktock.ui;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeZonesPage
extends WOComponent {
    public static final String ID_KEY = "id";
    public static final NSArray<EOSortOrdering> idSortsAsc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"id", (NSSelector)EOSortOrdering.CompareAscending));
    public static final NSArray<EOSortOrdering> idSortsDesc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"id", (NSSelector)EOSortOrdering.CompareDescending));
    public static final String NAME_KEY = "displayName";
    public static final NSArray<EOSortOrdering> nameSortsAsc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"displayName", (NSSelector)EOSortOrdering.CompareAscending));
    public static final NSArray<EOSortOrdering> nameSortsDesc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"displayName", (NSSelector)EOSortOrdering.CompareDescending));
    public static final String DST_KEY = "dstSavings";
    public static final NSArray<EOSortOrdering> dstSortsAsc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"dstSavings", (NSSelector)EOSortOrdering.CompareAscending));
    public static final NSArray<EOSortOrdering> dstSortsDesc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"dstSavings", (NSSelector)EOSortOrdering.CompareDescending));
    public static final String OFF_KEY = "rawOffset";
    public static final NSArray<EOSortOrdering> offsetSortsAsc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"rawOffset", (NSSelector)EOSortOrdering.CompareAscending));
    public static final NSArray<EOSortOrdering> offsetSortsDesc = new NSArray((Object)EOSortOrdering.sortOrderingWithKey((String)"rawOffset", (NSSelector)EOSortOrdering.CompareDescending));
    public NSArray<EOSortOrdering> currentSorts = idSortsAsc;
    NSDictionary<String, NSDictionary<String, Object>> zones = null;
    public String timeZoneId;

    public TimeZonesPage(WOContext context) {
        super(context);
    }

    public WOComponent sortById() {
        this.currentSorts = this.currentSorts == idSortsAsc ? idSortsDesc : idSortsAsc;
        return null;
    }

    public WOComponent sortByName() {
        this.currentSorts = this.currentSorts == nameSortsAsc ? nameSortsDesc : nameSortsAsc;
        return null;
    }

    public WOComponent sortByDSTSavings() {
        this.currentSorts = this.currentSorts == dstSortsAsc ? dstSortsDesc : dstSortsAsc;
        return null;
    }

    public WOComponent sortByRawOffset() {
        this.currentSorts = this.currentSorts == offsetSortsAsc ? offsetSortsDesc : offsetSortsAsc;
        return null;
    }

    public NSArray<String> allTimeZones() {
        if (this.zones == null) {
            NSMutableDictionary zonesHash = new NSMutableDictionary();
            String[] foundZones = TimeZone.getAvailableIDs();
            this.zones = new NSMutableDictionary();
            for (int idx = 0; idx < foundZones.length; ++idx) {
                String id = foundZones[idx];
                TimeZone tz = TimeZone.getTimeZone(id);
                NSArray keys = new NSArray((Object[])new String[]{ID_KEY, NAME_KEY, DST_KEY, OFF_KEY});
                NSArray vals = new NSArray(new Object[]{id, tz.getDisplayName(), new Integer(tz.getDSTSavings()), new Integer(tz.getRawOffset())});
                NSDictionary foundValues = new NSDictionary(vals, keys);
                zonesHash.takeValueForKey((Object)foundValues, id);
            }
            this.zones = zonesHash.immutableClone();
        }
        NSArray sorted = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)this.zones.allValues(), this.currentSorts);
        return (NSArray)sorted.valueForKey(ID_KEY);
    }

    public String tzDisplayName() {
        return (String)((NSDictionary)this.zones.valueForKey(this.timeZoneId)).valueForKey(NAME_KEY);
    }

    public Integer tzDSTSavings() {
        return (Integer)((NSDictionary)this.zones.valueForKey(this.timeZoneId)).valueForKey(DST_KEY);
    }

    public Integer tzRawOffset() {
        return (Integer)((NSDictionary)this.zones.valueForKey(this.timeZoneId)).valueForKey(OFF_KEY);
    }

    public WOComponent timeDisplayNow() {
        WOComponent nextPage = this.pageWithName("TimeDisplayNow");
        nextPage.takeValueForKey((Object)this.timeZoneId, "timeZoneID");
        return nextPage;
    }
}

