/*
 * Decompiled with CFR 0.152.
 */
package er.imadaptor;

import com.webobjects.appserver.WOAdaptor;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WODynamicURL;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDelayedCallbackCenter;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.foundation.ERXProperties;
import er.imadaptor.Conversation;
import er.imadaptor.IInstantMessenger;
import er.imadaptor.IInstantMessengerFactory;
import er.imadaptor.IMessageListener;
import er.imadaptor.InstantMessengerConnection;
import er.imadaptor.JOscarInstantMessenger;
import er.imadaptor.JOscarLogManager;
import er.imadaptor.MessageException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.kano.joscar.logging.LogManager;
import net.kano.joscar.logging.LoggingSystem;
import org.apache.log4j.Logger;

public class InstantMessengerAdaptor
extends WOAdaptor
implements IMessageListener {
    public static Logger log;
    public static final String IM_FACTORY_KEY = "IMFactory";
    public static final String SCREEN_NAME_KEY = "IMScreenName";
    public static final String PASSWORD_KEY = "IMPassword";
    public static final String CONVERSATION_TIMEOUT_KEY = "IMTimeout";
    public static final String CONVERSATION_ACTION_NAME_KEY = "IMConversationActionName";
    public static final String IM_ACTION_URL_KEY = "IMActionURL";
    public static final String AUTO_LOGIN_KEY = "IMAutoLogin";
    public static final String WATCHER_ENABLED_KEY = "IMWatcherEnabled";
    public static final String WATCHER_IM_FACTORY_KEY = "IMWatcherFactory";
    public static final String WATCHER_SCREEN_NAME_KEY = "IMWatcherScreenName";
    public static final String WATCHER_PASSWORD_KEY = "IMWatcherPassword";
    public static final String CENTRALIZE_SCREEN_NAME_KEY = "IMCentralizeScreenName";
    public static final String IS_IM_KEY = "IsIM";
    public static final String CONVERSATION_KEY = "IMConversation";
    public static final String BUDDY_NAME_KEY = "BuddyName";
    public static final String MESSAGE_KEY = "Message";
    public static final String RAW_MESSAGE_KEY = "RawMessage";
    private WOApplication _application;
    private IInstantMessengerFactory _factory;
    private Map<String, InstantMessengerConnection> _instantMessengers;
    private String _centralizeScreenName;
    private String _defaultScreenName;
    private String _conversationActionName;
    private long _conversationTimeout;
    private boolean _autoLogin;
    private boolean _running;

    public InstantMessengerAdaptor(String name, NSDictionary parameters) {
        super(name, parameters);
        boolean watcherEnabled;
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("sessionDidCreate", new Class[]{NSNotification.class}), "SessionDidCreateNotification", null);
        this._application = WOApplication.application();
        this._instantMessengers = new HashMap<String, InstantMessengerConnection>();
        this._centralizeScreenName = ERXProperties.stringForKey((String)CENTRALIZE_SCREEN_NAME_KEY);
        this._factory = this.getFactory(IM_FACTORY_KEY);
        this._conversationTimeout = ERXProperties.longForKeyWithDefault((String)CONVERSATION_TIMEOUT_KEY, (long)300000L);
        this._conversationActionName = ERXProperties.stringForKeyWithDefault((String)CONVERSATION_ACTION_NAME_KEY, (String)"imConversation");
        this._autoLogin = ERXProperties.booleanForKeyWithDefault((String)AUTO_LOGIN_KEY, (boolean)false);
        String defaultScreenName = ERXProperties.stringForKey((String)SCREEN_NAME_KEY);
        String defaultPassword = ERXProperties.stringForKey((String)PASSWORD_KEY);
        if (defaultScreenName != null) {
            this.setDefaultInstantMessenger(defaultScreenName, defaultPassword);
        }
        if (watcherEnabled = ERXProperties.booleanForKeyWithDefault((String)WATCHER_ENABLED_KEY, (boolean)false)) {
            String watcherScreenName = ERXProperties.stringForKey((String)WATCHER_SCREEN_NAME_KEY);
            String watcherPassword = ERXProperties.stringForKey((String)WATCHER_PASSWORD_KEY);
            if (watcherScreenName == null || watcherPassword == null) {
                throw new IllegalArgumentException("You must set both 'IMWatcherScreenName' and 'IMWatcherPassword' if 'IMWatcherEnabled' is true.");
            }
            IInstantMessengerFactory watcherFactory = this.getFactory(WATCHER_IM_FACTORY_KEY);
            InstantMessengerConnection defaultInstantMessengerConnection = this._defaultInstantMessengerConnection();
            if (defaultInstantMessengerConnection != null) {
                defaultInstantMessengerConnection.setWatchDog(watcherScreenName, watcherPassword, watcherFactory);
            }
        }
    }

    public static InstantMessengerAdaptor instantMessengerAdaptor() {
        NSArray adaptors = WOApplication.application().adaptors();
        InstantMessengerAdaptor matchingAdaptor = null;
        Enumeration adaptorsEnum = adaptors.objectEnumerator();
        while (matchingAdaptor == null && adaptorsEnum.hasMoreElements()) {
            WOAdaptor adaptor = (WOAdaptor)adaptorsEnum.nextElement();
            if (!(adaptor instanceof InstantMessengerAdaptor)) continue;
            matchingAdaptor = (InstantMessengerAdaptor)adaptor;
        }
        if (matchingAdaptor == null) {
            throw new IllegalStateException("You must set WOAdditionalAdaptors=({WOAdaptor=\"er.imadaptor.InstantMessengerAdaptor\";})");
        }
        return matchingAdaptor;
    }

    public InstantMessengerConnection setDefaultInstantMessenger(String screenName, String password) {
        this._defaultScreenName = screenName;
        return this._addInstantMessenger(screenName, password);
    }

    public InstantMessengerConnection addInstantMessenger(String screenName, String password) {
        return this._addInstantMessenger(screenName, password);
    }

    public InstantMessengerConnection _addInstantMessenger(String screenName, String password) {
        InstantMessengerConnection existingConnection = this._instantMessengers.get(screenName);
        if (existingConnection != null) {
            existingConnection.disconnect();
        }
        InstantMessengerConnection connection = new InstantMessengerConnection(screenName, password, this._factory);
        this._instantMessengers.put(screenName, connection);
        if (this._running && this._autoLogin) {
            connection.connect(this);
        }
        return connection;
    }

    public void _removeInstantMessengerConnection(InstantMessengerConnection connection) {
        connection.disconnect();
        this._instantMessengers.remove(connection.instantMessenger().getScreenName());
    }

    public void removeInstantMessenger(String screenName) {
        InstantMessengerConnection existingConnection = this._instantMessengers.remove(screenName);
        if (existingConnection != null) {
            existingConnection.disconnect();
        }
    }

    public IInstantMessenger instantMessengerForScreenName(String screenName) {
        IInstantMessenger instantMessenger = null;
        InstantMessengerConnection connection = this._instantMessengerConnectionNamed(screenName);
        if (connection != null) {
            instantMessenger = connection.instantMessenger();
        }
        return instantMessenger;
    }

    public IInstantMessenger instantMessenger() {
        return this.defaultInstantMessenger();
    }

    public IInstantMessenger defaultInstantMessenger() {
        return this.instantMessengerForScreenName(this._defaultScreenName);
    }

    public static boolean isIMRequest(WOContext context) {
        return InstantMessengerAdaptor.isIMRequest(context.request());
    }

    public static boolean isIMRequest(WORequest request) {
        NSDictionary userInfo = request.userInfo();
        return userInfo != null && userInfo.objectForKey((Object)IS_IM_KEY) != null;
    }

    public static String message(WORequest request) {
        return (String)request.userInfo().objectForKey((Object)MESSAGE_KEY);
    }

    public static String rawMessage(WORequest request) {
        return (String)request.userInfo().objectForKey((Object)RAW_MESSAGE_KEY);
    }

    public static String buddyName(WORequest request) {
        return (String)request.userInfo().objectForKey((Object)BUDDY_NAME_KEY);
    }

    public static Conversation conversation(WORequest request) {
        NSDictionary userInfo = request.userInfo();
        Conversation conversation = null;
        if (userInfo != null) {
            conversation = (Conversation)userInfo.objectForKey((Object)CONVERSATION_KEY);
        }
        return conversation;
    }

    public void registerForEvents() {
        if (this._autoLogin) {
            for (Map.Entry<String, InstantMessengerConnection> instantMessengerEntry : this._instantMessengers.entrySet()) {
                String screenName = instantMessengerEntry.getKey();
                InstantMessengerConnection connection = instantMessengerEntry.getValue();
                connection.connect(this);
            }
        }
        this._running = true;
        Thread conversationExpiration = new Thread(new ConversationExpirationRunnable());
        conversationExpiration.start();
    }

    public void unregisterForEvents() {
        this._running = false;
        Iterator<Map.Entry<String, InstantMessengerConnection>> instantMessengerIter = this._instantMessengers.entrySet().iterator();
        while (instantMessengerIter.hasNext()) {
            Map.Entry<String, InstantMessengerConnection> instantMessengerEntry = instantMessengerIter.next();
            String screenName = instantMessengerEntry.getKey();
            InstantMessengerConnection connection = instantMessengerEntry.getValue();
            connection.disconnect();
            instantMessengerIter.remove();
        }
    }

    public boolean dispatchesRequestsConcurrently() {
        return true;
    }

    public synchronized void messageReceived(IInstantMessenger instantMessenger, String buddyName, String rawMessage) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Received message from '" + buddyName + "': " + rawMessage));
        }
        String screenName = instantMessenger.getScreenName();
        String message = rawMessage;
        if (message != null) {
            message = message.replaceAll("<[^>]+>", "");
            message = message.trim();
        }
        StringBuffer uri = new StringBuffer();
        Conversation conversation = this._instantMessengerConnectionNamed(screenName).conversationForBuddyNamed(buddyName, this._conversationTimeout);
        String requestUrl = conversation.requestUrl();
        if (requestUrl == null) {
            String webserverConnectUrl = this._application.webserverConnectURL();
            String cgiAdaptorURL = this._application.cgiAdaptorURL();
            WODynamicURL imConversationUrl = new WODynamicURL();
            int j = cgiAdaptorURL.indexOf("//");
            int i = 0;
            if (j > 0 && cgiAdaptorURL.length() - j > 2) {
                i = cgiAdaptorURL.indexOf(47, j + 2);
            }
            if (i > 0) {
                imConversationUrl.setPrefix(cgiAdaptorURL.substring(i));
            } else {
                imConversationUrl.setPrefix(this._application.applicationBaseURL());
            }
            imConversationUrl.setRequestHandlerKey(this._application.directActionRequestHandlerKey());
            imConversationUrl.setApplicationName(this._application.name());
            imConversationUrl.setApplicationNumber(this._application.number());
            imConversationUrl.setRequestHandlerPath(this._conversationActionName);
            uri.append(imConversationUrl.toString());
        } else {
            uri.append(requestUrl);
        }
        uri.append("?");
        uri.append(BUDDY_NAME_KEY);
        uri.append("=");
        uri.append(WOURLEncoder.encode((String)buddyName));
        uri.append("&");
        uri.append(MESSAGE_KEY);
        uri.append("=");
        uri.append(WOURLEncoder.encode((String)message));
        uri.append("&");
        uri.append(RAW_MESSAGE_KEY);
        uri.append("=");
        uri.append(WOURLEncoder.encode((String)rawMessage));
        String sessionID = conversation.sessionID();
        if (sessionID != null) {
            uri.append("&wosid=" + sessionID);
        }
        NSMutableDictionary headers = new NSMutableDictionary();
        NSMutableDictionary userInfo = new NSMutableDictionary();
        userInfo.setObjectForKey((Object)Boolean.TRUE, (Object)IS_IM_KEY);
        userInfo.setObjectForKey((Object)screenName, (Object)SCREEN_NAME_KEY);
        userInfo.setObjectForKey((Object)buddyName, (Object)BUDDY_NAME_KEY);
        userInfo.setObjectForKey((Object)message, (Object)MESSAGE_KEY);
        userInfo.setObjectForKey((Object)rawMessage, (Object)RAW_MESSAGE_KEY);
        userInfo.setObjectForKey((Object)conversation, (Object)CONVERSATION_KEY);
        WORequest request = this._application.createRequest("GET", uri.toString(), "HTTP/1.0", (NSDictionary)headers, null, (NSDictionary)userInfo);
        try {
            WOResponse response = this._application.dispatchRequest(request);
            if (response != null) {
                String nextRequestUrl = response.headerForKey((Object)IM_ACTION_URL_KEY);
                conversation.setRequestUrl(nextRequestUrl);
                String responseMessage = response.contentString();
                if (responseMessage != null) {
                    responseMessage = responseMessage.trim();
                }
                if (responseMessage.length() > 0) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Sending message to '" + buddyName + "': " + responseMessage));
                    }
                    this.sendMessage(screenName, buddyName, responseMessage, true);
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)(this.toString() + " Exception occurred while responding to client: " + t.toString()), t);
        }
        NSDelayedCallbackCenter.defaultCenter().eventEnded();
    }

    public void sessionDidCreate(NSNotification notification) {
        WOSession session = (WOSession)notification.object();
        WORequest request = session.context().request();
        Conversation conversation = InstantMessengerAdaptor.conversation(request);
        if (conversation != null) {
            conversation.setSessionID(session.sessionID());
        }
    }

    public void sendMessage(String screenName, String buddyName, String message, boolean block) throws MessageException {
        IInstantMessenger instantMessenger;
        if (this._centralizeScreenName != null) {
            log.warn((Object)("IM's are centralized; replacing '" + buddyName + "' with '" + this._centralizeScreenName + "'"));
            buddyName = this._centralizeScreenName;
        }
        if ((instantMessenger = this.instantMessengerForScreenName(screenName)) == null) {
            log.error((Object)("There is no connection for the screen name '" + screenName + "'."));
        } else {
            instantMessenger.sendMessage(buddyName, message, true);
        }
    }

    public InstantMessengerConnection _instantMessengerConnectionNamed(String screenName) {
        return this._instantMessengers.get(screenName);
    }

    public InstantMessengerConnection _defaultInstantMessengerConnection() {
        return this._instantMessengerConnectionNamed(this._defaultScreenName);
    }

    protected IInstantMessengerFactory getFactory(String key) {
        String factoryClass = ERXProperties.stringForKey((String)key);
        try {
            IInstantMessengerFactory factory = factoryClass == null ? new JOscarInstantMessenger.Factory() : (IInstantMessengerFactory)Class.forName(factoryClass).newInstance();
            return factory;
        }
        catch (Throwable t) {
            throw new RuntimeException("Invalid InstantMessengerFactory: " + factoryClass, t);
        }
    }

    protected void removeExpiredConversations() {
        for (Map.Entry<String, InstantMessengerConnection> instantMessengerEntry : this._instantMessengers.entrySet()) {
            String screenName = instantMessengerEntry.getKey();
            InstantMessengerConnection connection = instantMessengerEntry.getValue();
            connection.removeExpiredConversations(this._conversationTimeout);
        }
    }

    static {
        LoggingSystem.setLogManager((LogManager)new JOscarLogManager());
        log = Logger.getLogger(InstantMessengerAdaptor.class);
    }

    protected class ConversationExpirationRunnable
    implements Runnable {
        protected ConversationExpirationRunnable() {
        }

        public void run() {
            while (InstantMessengerAdaptor.this._running) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                InstantMessengerAdaptor.this.removeExpiredConversations();
            }
        }
    }
}

