/*
 * Decompiled with CFR 0.152.
 */
package er.corebusinesslogic;

import com.webobjects.appserver.WOApplication;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import er.corebusinesslogic.ERCMailDelivery;
import er.corebusinesslogic.ERCMailState;
import er.corebusinesslogic.ERCMailableExceptionPage;
import er.corebusinesslogic.ERCStampedEnterpriseObject;
import er.corebusinesslogic.ERCStatic;
import er.corebusinesslogic.ERCoreUserInterface;
import er.corebusinesslogic.ERCoreUserPreferences;
import er.corebusinesslogic.audittrail.ERCAuditTrailHandler;
import er.directtoweb.ERDirectToWeb;
import er.extensions.ERXExtensions;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXUtilities;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import er.javamail.ERJavaMail;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERCoreBusinessLogic
extends ERXFrameworkPrincipal {
    public static final Logger log = Logger.getLogger(ERCoreBusinessLogic.class);
    public static final String ProblemEmailDomainPropertyKey = "er.corebusinesslogic.ERCoreBusinessLogic.ProblemEmailDomain";
    public static final String ProblemEmailRecipientsPropertyKey = "er.corebusinesslogic.ERCoreBusinessLogic.ProblemEmailRecipients";
    protected static ERCoreBusinessLogic sharedInstance;
    public static final Class[] REQUIRES;
    protected NSArray _emailsForProblemRecipients;
    protected String _problemEmailDomain;

    public static ERCoreBusinessLogic sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = (ERCoreBusinessLogic)ERXFrameworkPrincipal.sharedInstance(ERCoreBusinessLogic.class);
        }
        return sharedInstance;
    }

    public static void setActor(EOEnterpriseObject actor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting actor to : " + actor));
        }
        if (actor != null) {
            ERXThreadStorage.takeValueForKey((Object)actor, (String)"actor");
        } else {
            ERXThreadStorage.removeValueForKey((String)"actor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOEnterpriseObject actor(EOEditingContext ec) {
        EOEnterpriseObject actor = ERCoreBusinessLogic.actor();
        if (actor != null && actor.editingContext() != ec) {
            EOEditingContext actorEc = actor.editingContext();
            actorEc.lock();
            try {
                EOEnterpriseObject localActor = ERXEOControlUtilities.localInstanceOfObject((EOEditingContext)ec, (EOEnterpriseObject)actor);
                try {
                    if (actor instanceof ERCoreUserInterface) {
                        NSArray prefs = ((ERCoreUserInterface)actor).preferences();
                        prefs = ERXEOControlUtilities.localInstancesOfObjects((EOEditingContext)ec, (NSArray)prefs);
                        ((ERCoreUserInterface)localActor).setPreferences(prefs);
                    }
                }
                catch (RuntimeException ex) {
                    log.error((Object)("Error while setting getting actor's preferences: " + ex), (Throwable)ex);
                }
                actor = localActor;
            }
            finally {
                actorEc.unlock();
            }
        }
        return actor;
    }

    public static EOEnterpriseObject actor() {
        return (EOEnterpriseObject)ERXThreadStorage.valueForKey((String)"actor");
    }

    public static String staticStoredValueForKey(String key) {
        return ERCStatic.clazz.staticStoredValueForKey(key);
    }

    public static int staticStoredIntValueForKey(String key) {
        return ERCStatic.clazz.staticStoredIntValueForKey(key);
    }

    public static String staticStoredValueForKey(String key, boolean noCache) {
        return ERCStatic.clazz.staticStoredValueForKey(key, noCache);
    }

    public static int staticStoredIntValueForKey(String key, boolean noCache) {
        return ERCStatic.clazz.staticStoredIntValueForKey(key, noCache);
    }

    public static String staticStoredValueForKey(String key, EOEditingContext ec) {
        return ERCStatic.clazz.staticStoredValueForKey(ec, key);
    }

    public static int staticStoredIntValueForKey(String key, EOEditingContext ec) {
        return ERCStatic.clazz.staticStoredIntValueForKey(ec, key);
    }

    public static void takeStaticStoredValueForKey(String value, String key, EOEditingContext editingContext) {
        ERCStatic.clazz.takeStaticStoredValueForKey(editingContext, value, key);
    }

    public static void takeStaticStoredValueForKey(String value, String key) {
        ERCStatic.clazz.takeStaticStoredValueForKey(value, key);
    }

    public static void invalidateStaticValueForKeyCache() {
        ERCStatic.clazz.invalidateCache();
    }

    public void finishInitialization() {
        ERCAuditTrailHandler.initialize();
        ERCStampedEnterpriseObject.initialize();
        this.initializeSharedData();
        ERCoreUserPreferences.userPreferences().registerHandlers();
        log.debug((Object)"ERCoreBusinessLogic: finishInitialization");
    }

    public void initializeSharedData() {
        Class<ERCMailState> c = ERCMailState.class;
    }

    public boolean shouldMailReportedExceptions() {
        return ERXProperties.booleanForKey((String)"er.corebusinesslogic.ERCoreBusinessLogic.ShouldMailExceptions");
    }

    public void addPreferenceRelationshipToActorEntity(String entityName) {
        EOEntity entity = EOModelGroup.defaultGroup().entityNamed(entityName);
        if (entity == null || entity.primaryKeyAttributeNames().count() != 1) {
            throw new IllegalArgumentException("Entity is not suitable: " + entityName);
        }
        this.addPreferenceRelationshipToActorEntity(entityName, (String)entity.primaryKeyAttributeNames().lastObject());
    }

    public void addPreferenceRelationshipToActorEntity(String entityName, String attributeNameToJoin) {
        EOEntity actor = EOModelGroup.defaultGroup().entityNamed(entityName);
        EOEntity preference = EOModelGroup.defaultGroup().entityNamed("ERCPreference");
        EOJoin preferencesJoin = new EOJoin(actor.attributeNamed(attributeNameToJoin), preference.attributeNamed("userID"));
        EORelationship preferencesRelationship = new EORelationship();
        preferencesRelationship.setName("preferences");
        actor.addRelationship(preferencesRelationship);
        preferencesRelationship.addJoin(preferencesJoin);
        preferencesRelationship.setToMany(true);
        preferencesRelationship.setJoinSemantic(0);
        preferencesRelationship.setDeleteRule(1);
        EOJoin userJoin = new EOJoin(preference.attributeNamed("userID"), actor.attributeNamed(attributeNameToJoin));
        EORelationship userRelationship = new EORelationship();
        userRelationship.setName("user");
        preference.addRelationship(userRelationship);
        userRelationship.addJoin(userJoin);
        userRelationship.setToMany(false);
        userRelationship.setJoinSemantic(0);
    }

    public NSArray emailsForProblemRecipients() {
        if (this._emailsForProblemRecipients == null) {
            this._emailsForProblemRecipients = ERXProperties.arrayForKeyWithDefault((String)ProblemEmailRecipientsPropertyKey, (NSArray)NSArray.EmptyArray);
        }
        return this._emailsForProblemRecipients;
    }

    public void setEmailsForProblemRecipients(NSArray a) {
        this._emailsForProblemRecipients = a;
    }

    public String problemEmailDomain() {
        if (this._problemEmailDomain == null) {
            this._problemEmailDomain = System.getProperty(ProblemEmailDomainPropertyKey);
        }
        return this._problemEmailDomain;
    }

    public void setProblemEmailDomain(String value) {
        this._problemEmailDomain = value;
    }

    public synchronized String extraInfoString(NSDictionary extraInfo, int indent) {
        StringBuffer s = new StringBuffer();
        ERXStringUtilities.indent((StringBuffer)s, (int)indent);
        s.append("Extra Information: \n");
        ERXStringUtilities.indent((StringBuffer)s, (int)indent);
        s.append("    Actor = " + (ERCoreBusinessLogic.actor() != null ? ERCoreBusinessLogic.actor().toString() : "No Actor") + "\n");
        if (extraInfo != null && extraInfo.count() > 0) {
            Enumeration keyEnumerator = extraInfo.keyEnumerator();
            while (keyEnumerator.hasMoreElements()) {
                String key = (String)keyEnumerator.nextElement();
                Object value = extraInfo.objectForKey((Object)key);
                if (value instanceof NSDictionary) {
                    String valueStr = String.valueOf(value);
                    StringBuffer valueIndent = new StringBuffer();
                    valueIndent.append("\n         ");
                    ERXStringUtilities.indent((StringBuffer)valueIndent, (int)indent);
                    for (int i = 0; i < key.length(); ++i) {
                        valueIndent.append(" ");
                    }
                    value = valueStr.replaceAll("\n", valueIndent.toString());
                }
                ERXStringUtilities.indent((StringBuffer)s, (int)indent);
                s.append("    " + key + " = " + value + "\n");
            }
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reportException(Throwable exception, NSDictionary extraInfo) {
        block17: {
            if (exception instanceof NSForwardException) {
                exception = ((NSForwardException)exception).originalException();
            }
            StringBuffer s = new StringBuffer();
            try {
                s.append(" **** Caught: " + exception + "\n");
                s.append(this.extraInfoString(extraInfo, 3));
                if (exception instanceof EOGeneralAdaptorException) {
                    EOGeneralAdaptorException e = (EOGeneralAdaptorException)exception;
                    if (e.userInfo() != null) {
                        NSDictionary userInfo = e.userInfo();
                        if (userInfo instanceof NSDictionary) {
                            NSDictionary uid = userInfo;
                            Enumeration e2 = uid.keyEnumerator();
                            while (e2.hasMoreElements()) {
                                String key = (String)e2.nextElement();
                                Object value = uid.objectForKey((Object)key);
                                s.append(key + " = " + value + ";\n");
                            }
                        } else {
                            s.append(e.userInfo().toString());
                        }
                    }
                } else {
                    s.append(ERXUtilities.stackTrace((Throwable)exception));
                }
                if (!(WOApplication.application().isCachingEnabled() && ERCMailDelivery.usesMail() && this.shouldMailReportedExceptions())) {
                    log.error((Object)s.toString());
                    break block17;
                }
                log.warn((Object)s.toString());
                if (this.emailsForProblemRecipients().count() == 0 || this.problemEmailDomain() == null) {
                    log.error((Object)("Unable to log problem due to misconfiguration: recipients: " + this.emailsForProblemRecipients() + " email domain: " + this.problemEmailDomain()));
                    break block17;
                }
                ERCMailableExceptionPage standardExceptionPage = (ERCMailableExceptionPage)ERXApplication.instantiatePage((String)"ERCMailableExceptionPage");
                standardExceptionPage.setException(exception);
                standardExceptionPage.setActor(ERCoreBusinessLogic.actor());
                standardExceptionPage.setExtraInfo(extraInfo);
                EOEditingContext ec = ERXEC.newEditingContext();
                ec.lock();
                try {
                    Throwable exceptionForTitle = exception;
                    if (exception instanceof InvocationTargetException) {
                        exceptionForTitle = ((InvocationTargetException)exception).getTargetException();
                    }
                    String shortExceptionName = ERXStringUtilities.lastPropertyKeyInKeyPath((String)exceptionForTitle.getClass().getName());
                    String hostName = ERXConfigurationManager.defaultManager().hostName();
                    ERCMailDelivery.sharedInstance().composeEmail(WOApplication.application().name() + "-" + hostName + "@" + this.problemEmailDomain(), this.emailsForProblemRecipients(), null, null, WOApplication.application().name() + ": " + shortExceptionName + ": " + exceptionForTitle.getMessage(), standardExceptionPage.generateResponse().contentString(), ec);
                    ec.saveChanges();
                }
                finally {
                    ec.unlock();
                }
                ec.dispose();
            }
            catch (Throwable u) {
                try {
                    s.append("************ Caught exception " + u + " trying to report another one: " + exception);
                    s.append("** Original exception ");
                    s.append(ERXUtilities.stackTrace((Throwable)exception));
                    s.append("** Second exception ");
                    s.append(ERXUtilities.stackTrace((Throwable)u));
                    NSLog.err.appendln((Object)s.toString());
                    log.error((Object)s.toString());
                }
                catch (Throwable u2) {
                    // empty catch block
                }
            }
        }
    }

    public void createTables(EOEditingContext ec, String modelName) throws SQLException {
        EODatabaseContext databaseContext = EOUtilities.databaseContextForModelNamed((EOEditingContext)ec, (String)modelName);
        ERXSQLHelper helper = ERXSQLHelper.newSQLHelper((EODatabaseContext)databaseContext);
        String sql = helper.createSchemaSQLForEntitiesInModelWithName(null, modelName);
        NSArray sqls = helper.splitSQLStatements(sql);
        EOAdaptorChannel channel = databaseContext.availableChannel().adaptorChannel();
        ERXJDBCUtilities.executeUpdateScript((EOAdaptorChannel)channel, (String)sql);
    }

    public void createTables(EOEditingContext ec) throws SQLException {
        this.createTables(ec, "ERMail");
        this.createTables(ec, "ERCoreBusinessLogic");
    }

    static {
        REQUIRES = new Class[]{ERXExtensions.class, ERDirectToWeb.class, ERJavaMail.class};
        ERCoreBusinessLogic.setUpFrameworkPrincipalClass(ERCoreBusinessLogic.class);
    }
}

