/*
 * Decompiled with CFR 0.152.
 */
package er.jasperreports;

import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXAssert;
import er.extensions.foundation.ERXProperties;
import er.jasperreports.ERJRUtilities;
import java.util.Enumeration;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERJRFoundationDataSource
implements JRDataSource {
    public static final String REPORT_KEYPATH_SEPARATOR = ERXProperties.stringForKeyWithDefault((String)"er.jasperreports.keyPathSeparator", (String)"_");
    private static final String WEBOBJECTS_KEYPATH_SEPARATOR = ".";
    private static final Logger log = Logger.getLogger(ERJRFoundationDataSource.class);
    private static final String FIELD_NAME_FOR_CURRENT_ROW = ERXProperties.stringForKeyWithDefault((String)"er.jasperreports.currentRow.fieldName", (String)"_currentRow");
    protected NSKeyValueCodingAdditions currRow;
    protected Enumeration<? extends NSKeyValueCodingAdditions> e;
    protected boolean filterNulls = true;
    protected NSMutableDictionary<String, Object> debugRow;
    private int processedCount = 0;
    private int totalCount = 100;

    public ERJRFoundationDataSource(NSArray<? extends NSKeyValueCodingAdditions> arr) {
        this.e = arr.objectEnumerator();
        this.totalCount = arr.count();
    }

    public ERJRFoundationDataSource(Enumeration<? extends NSKeyValueCodingAdditions> enumeration, int itemCount) {
        ERXAssert.PRE.notNull(enumeration);
        this.e = enumeration;
        this.totalCount = itemCount;
    }

    public boolean next() throws JRException {
        if (this.e.hasMoreElements()) {
            this.currRow = this.e.nextElement();
            ++this.processedCount;
            if (log.isInfoEnabled()) {
                if (this.debugRow != null) {
                    log.info((Object)("DetailRow: " + this.debugRow));
                }
                this.debugRow = new NSMutableDictionary();
                if (this.currRow instanceof EOEnterpriseObject) {
                    EOEnterpriseObject eo = (EOEnterpriseObject)this.currRow;
                    this.debugRow.takeValueForKey((Object)eo.editingContext().globalIDForObject(eo), "_globalID");
                }
            }
            return true;
        }
        return false;
    }

    public boolean getFilterNulls() {
        return this.filterNulls;
    }

    public void setFilterNulls(boolean filters) {
        this.filterNulls = filters;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        if (jrField.getName().equals(FIELD_NAME_FOR_CURRENT_ROW)) {
            return this.currRow;
        }
        boolean isStringValueClass = jrField.getValueClass().equals(String.class);
        Object fieldValue = null;
        try {
            fieldValue = this.currRow.valueForKeyPath(jrField.getName().replaceAll(REPORT_KEYPATH_SEPARATOR, WEBOBJECTS_KEYPATH_SEPARATOR));
            if (log.isDebugEnabled()) {
                log.debug((Object)("value = " + fieldValue + "; jrField = " + (jrField == null ? "null" : ERJRUtilities.toString(jrField))));
            }
            if (isStringValueClass) {
                fieldValue = fieldValue == null ? null : fieldValue.toString();
            }
        }
        catch (Exception ex) {
            NSLog.err.appendln((Object)("Error while retrieving value" + jrField.getName().replaceAll("_", WEBOBJECTS_KEYPATH_SEPARATOR)));
            NSLog.err.appendln((Throwable)ex);
        }
        if (this.filterNulls && fieldValue == null && isStringValueClass) {
            fieldValue = "";
        }
        if (log.isInfoEnabled()) {
            this.debugRow.takeValueForKey(fieldValue == null ? "null" : fieldValue, jrField.getName());
        }
        return fieldValue;
    }

    public double percentProcessed() {
        return (double)this.processedCount / (double)this.totalCount;
    }
}

