/*
 * Decompiled with CFR 0.152.
 */
package er.jasperreports;

import er.extensions.foundation.ERXFileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperRunManager;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.exception.NestableRuntimeException;

public class ERJRUtilities {
    public static File runCompiledReportToPDFFile(String compiledReportName, String frameworkName, Map parameters, JRDataSource dataSource) {
        try {
            File destFile = File.createTempFile(compiledReportName + System.currentTimeMillis(), ".pdf");
            String inputFileName = ERXFileUtilities.pathURLForResourceNamed((String)compiledReportName, (String)frameworkName, null).getFile();
            JasperRunManager.runReportToPdfFile((String)inputFileName, (String)destFile.getPath(), (Map)parameters, (JRDataSource)dataSource);
            return destFile;
        }
        catch (IOException e) {
            throw new NestableRuntimeException("Failed to generate report " + compiledReportName, (Throwable)e);
        }
        catch (JRException e) {
            throw new NestableRuntimeException("Failed to generate report " + compiledReportName, (Throwable)e);
        }
    }

    public static String toString(JRField jrField) {
        ToStringBuilder t = new ToStringBuilder((Object)jrField);
        t.append("description", (Object)jrField.getDescription());
        t.append("name", (Object)jrField.getName());
        t.append("valueClass", (Object)jrField.getValueClass());
        t.append("valueClassName", (Object)jrField.getValueClassName());
        t.append("propertiesMap", (Object)jrField.getPropertiesMap());
        return t.toString();
    }
}

