/*
 * Decompiled with CFR 0.152.
 */
package er.plot;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import er.extensions.foundation.ERXAssert;
import er.plot.ERPChart;
import java.util.Enumeration;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERPPieChart
extends ERPChart {
    public static final NSArray<String> SUPPORTED_TYPES = new NSArray((Object[])new String[]{"PieChart", "PieChart3D", "RingChart"});

    public ERPPieChart(WOContext context) {
        super(context);
    }

    @Override
    public String nameKey() {
        if (this._nameKey == null) {
            this._nameKey = (String)this.valueForBinding("nameKey");
            ERXAssert.DURING.notNull("nameKey", (Object)this._nameKey);
        }
        return this._nameKey;
    }

    @Override
    public String valueKey() {
        if (this._valueKey == null) {
            this._valueKey = (String)this.valueForBinding("valueKey");
            ERXAssert.DURING.notNull("valueKey", (Object)this._valueKey);
        }
        return this._valueKey;
    }

    @Override
    protected Dataset createDataset() {
        AccumulatingPieDataset dataset = new AccumulatingPieDataset();
        Enumeration items = this.items().objectEnumerator();
        while (items.hasMoreElements()) {
            Object item = items.nextElement();
            Comparable name = (Comparable)NSKeyValueCodingAdditions.Utility.valueForKeyPath(item, (String)this.nameKey());
            Number value = (Number)NSKeyValueCodingAdditions.Utility.valueForKeyPath(item, (String)this.valueKey());
            dataset.setValue(name, value);
        }
        return dataset;
    }

    @Override
    public JFreeChart createChart() {
        JFreeChart chart = null;
        PieDataset dataset = (PieDataset)this.dataset();
        String name = this.stringValueForBinding("name", null);
        chart = "PieChart3D".equals(this.chartType()) ? ChartFactory.createPieChart3D((String)name, (PieDataset)dataset, (boolean)this.showLegends(), (boolean)this.showToolTips(), (boolean)this.showUrls()) : ("RingChart".equals(this.chartType()) ? ChartFactory.createRingChart((String)name, (PieDataset)dataset, (boolean)this.showLegends(), (boolean)this.showToolTips(), (boolean)this.showUrls()) : ChartFactory.createPieChart((String)name, (PieDataset)dataset, (boolean)this.showLegends(), (boolean)this.showToolTips(), (boolean)this.showUrls()));
        if (!this.showLabels()) {
            ((PiePlot)chart.getPlot()).setLabelGenerator(null);
        }
        return chart;
    }

    @Override
    protected NSArray<String> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    public boolean showLabels() {
        return this.booleanValueForBinding("showLabels", true);
    }

    public static class AccumulatingPieDataset
    extends DefaultPieDataset {
        public void setValue(Comparable key, Number value) {
            if (this.getIndex(key) >= 0) {
                Number oldValue = this.getValue(key);
                value = new Double(value.doubleValue() + oldValue.doubleValue());
            }
            super.setValue(key, value);
        }
    }
}

