/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;

public class NSData
implements Cloneable,
Serializable,
NSCoding {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSData");
    public static final NSData EmptyData = new NSData();
    static final long serialVersionUID = -6138488451902188317L;
    private static final String SerializationBytesFieldKey = "bytes";
    protected byte[] _bytes;
    protected transient NSRange _range;
    protected transient int _hashCache;
    private transient boolean _recomputeHashCode = true;
    private static char[] _nibbleToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("bytes", _NSUtilities._NoByteArray.getClass())};

    public NSData() {
        this._bytes = null;
        this._range = new NSMutableRange(0, 0);
    }

    public NSData(byte[] bytes) {
        this(bytes, new NSRange(0, bytes.length), false);
    }

    public NSData(byte[] bytes, NSRange range) {
        this(bytes, range, false);
    }

    public NSData(byte[] bytes, int offset, int count) {
        this(bytes, new NSRange(offset, count), false);
    }

    private void initFromBytes(byte[] bytes, NSRange range, boolean noCopy) {
        if (bytes == null) {
            this._bytes = null;
            this._range = new NSMutableRange(0, 0);
        } else {
            if (range.maxRange() > bytes.length) {
                throw new IllegalArgumentException("range out of bounds for bytes");
            }
            if (noCopy) {
                this._bytes = bytes;
                this._range = new NSMutableRange(range);
            } else {
                int length = range.length();
                this._bytes = new byte[length];
                this._range = new NSMutableRange(0, length);
                if (length > 0) {
                    System.arraycopy(bytes, range.location(), this._bytes, 0, length);
                }
            }
        }
    }

    public NSData(byte[] bytes, NSRange range, boolean noCopy) {
        this.initFromBytes(bytes, range, noCopy);
    }

    public NSData(NSData otherData) {
        this(otherData.immutableBytes(), otherData.immutableRange(), true);
    }

    public NSData(InputStream inputStream, int chunkSize) throws IOException {
        if (chunkSize < 1) {
            chunkSize = 1000;
        }
        int numberOfChunks = 0;
        int numberOfChunkSlots = 32;
        Object[] chunks = new Object[numberOfChunkSlots];
        int lastChunkLength = 0;
        boolean streamEndReached = false;
        while (!streamEndReached) {
            int length;
            int bytesRead;
            if (numberOfChunks == numberOfChunkSlots) {
                Object[] oldChunks = chunks;
                chunks = new Object[numberOfChunkSlots *= 2];
                System.arraycopy(oldChunks, 0, chunks, 0, numberOfChunks);
            }
            byte[] chunk = new byte[chunkSize];
            for (length = 0; length < chunkSize; length += bytesRead) {
                bytesRead = inputStream.read(chunk, length, chunkSize - length);
                if (bytesRead >= 0) continue;
                streamEndReached = true;
                break;
            }
            if (length <= 0) continue;
            chunks[numberOfChunks] = chunk;
            lastChunkLength = length;
            ++numberOfChunks;
        }
        this._range = new NSMutableRange(0, 0);
        if (numberOfChunks == 0) {
            this._bytes = null;
        } else if (numberOfChunks == 1) {
            this._bytes = (byte[])chunks[0];
            this._range._length = lastChunkLength;
        } else {
            this._bytes = new byte[chunkSize * (numberOfChunks - 1) + lastChunkLength];
            for (int i = 0; i < numberOfChunks - 1; ++i) {
                System.arraycopy((byte[])chunks[i], 0, this._bytes, this._range._length, chunkSize);
                this._range._length += chunkSize;
            }
            System.arraycopy((byte[])chunks[numberOfChunks - 1], 0, this._bytes, this._range._length, lastChunkLength);
            this._range._length += lastChunkLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _createBytesFromInputStream(InputStream inputStream, int length, boolean closeInputStream) throws IOException {
        try {
            int bytesRead;
            this._bytes = new byte[length];
            if (this._range == null) {
                this._range = new NSMutableRange(0, length);
            } else {
                this._range._location = 0;
                this._range._length = length;
            }
            for (int offset = 0; offset < length; offset += bytesRead) {
                bytesRead = inputStream.read(this._bytes, offset, length - offset);
                if (bytesRead >= 0) continue;
                throw new IOException("error while reading input stream for new NSData: " + offset + " out of " + length + SerializationBytesFieldKey);
            }
        }
        finally {
            if (closeInputStream) {
                inputStream.close();
            }
        }
    }

    public NSData(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("file '" + file.getName() + "' does not exist");
        }
        this._createBytesFromInputStream(new FileInputStream(file), (int)file.length(), true);
    }

    public NSData(URL url) throws IOException {
        this(url.openStream(), (int)NSPathUtilities._contentLengthForPathURL(url));
    }

    public NSData(String value) {
        this(value, null);
    }

    public NSData(String value, String encoding) {
        this(_NSStringUtilities.bytesForString(value, encoding));
    }

    protected byte[] bytesNoCopy() {
        return this._bytes != null ? this._bytes : _NSCollectionPrimitives.EmptyByteArray;
    }

    protected NSRange rangeNoCopy() {
        return this._range;
    }

    protected byte[] immutableBytes() {
        return this._bytes != null ? this._bytes : _NSCollectionPrimitives.EmptyByteArray;
    }

    protected NSRange immutableRange() {
        return this._range;
    }

    public byte[] bytesNoCopy(NSMutableRange range) {
        byte[] returnValue = this.bytesNoCopy();
        if (range == null) {
            throw new IllegalArgumentException("must pass NSMutableRange to bytesNoCopy");
        }
        range.setLocation(this._range.location());
        range.setLength(this._range.length());
        return returnValue;
    }

    public NSData subdataWithRange(NSRange range) {
        int rangeLength;
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > this.length()) {
            throw new IllegalArgumentException("range [" + rangeLocation + "; " + rangeLength + "] out of bounds");
        }
        return new NSData(this.immutableBytes(), new NSRange(this.immutableRange().location() + range.location(), range.length()), true);
    }

    public static NSData dataWithContentsOfMappedFile(File file) throws IOException {
        return NSData.dataWithContentsOfFile(file);
    }

    public static NSData dataWithContentsOfFile(File file) throws IOException {
        return new NSData(file);
    }

    public static NSData dataWithContentsOfFile(String path) throws IOException {
        return NSData.dataWithContentsOfFile(new File(path));
    }

    public int length() {
        return this.rangeNoCopy().length();
    }

    public int _offset() {
        return this.rangeNoCopy().location();
    }

    public byte[] _bytesNoCopy() {
        return this.bytesNoCopy();
    }

    private byte[] _bytes(int offset, int length) {
        byte[] bytes = new byte[length];
        if (length > 0) {
            System.arraycopy(this.bytesNoCopy(), this._offset() + offset, bytes, 0, length);
        }
        return bytes;
    }

    public byte[] bytes() {
        return this._bytes(0, this.length());
    }

    public byte[] bytes(int offset, int length) {
        if (offset + length > this.length()) {
            throw new IllegalArgumentException("range [" + offset + "; " + length + "] out of bounds");
        }
        return this._bytes(offset, length);
    }

    public byte[] bytes(NSRange range) {
        return this.bytes(range.location(), range.length());
    }

    public boolean writeToURL(URL url, boolean atomically) {
        if (url.getHost().equals("")) {
            return this.writeToFile(url.getFile());
        }
        return false;
    }

    public boolean writeToFile(String path) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            fileOutputStream.write(this.bytesNoCopy(), this._offset(), this.length());
            fileOutputStream.close();
        }
        catch (IOException exception) {
            NSLog._conditionallyLogPrivateException(exception);
            return false;
        }
        return true;
    }

    public boolean isEqualToData(NSData otherData) {
        if (otherData == null) {
            return false;
        }
        if (otherData == this) {
            return true;
        }
        int length = this.length();
        if (length != otherData.length()) {
            return false;
        }
        byte[] bytes = this.bytesNoCopy();
        byte[] otherBytes = otherData.bytesNoCopy();
        int offset = this._offset();
        int otherOffset = otherData._offset();
        for (int i = 0; i < length; ++i) {
            if (bytes[i + offset] == otherBytes[i + otherOffset]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof NSData ? this.isEqualToData((NSData)object) : false;
    }

    public ByteArrayInputStream stream() {
        byte[] bytes = this.immutableBytes();
        NSRange range = this.immutableRange();
        return new ByteArrayInputStream(bytes, range.location(), range.length());
    }

    public void writeToStream(OutputStream stream) throws IOException {
        stream.write(this.bytesNoCopy(), this._offset(), this.length());
    }

    public Class classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        return new NSData(coder.decodeBytes());
    }

    public void encodeWithCoder(NSCoder coder) {
        byte[] bytesNoCopy = this.bytesNoCopy();
        byte[] bytes = this.length() == bytesNoCopy.length && this._offset() == 0 ? bytesNoCopy : this.bytes();
        coder.encodeBytes(bytes);
    }

    public int hashCode() {
        if (this._mustRecomputeHash()) {
            int limit;
            byte[] bytes = this.bytesNoCopy();
            int offset = this._offset();
            int hash = limit = this.length();
            if (limit > 32) {
                limit = 32;
            }
            for (int i = 0; i < limit; ++i) {
                hash = 31 * hash + bytes[offset++];
            }
            this._hashCache = hash;
            this._setMustRecomputeHash(false);
        }
        return this._hashCache;
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        int i;
        if (this.length() == 0) {
            return "<" + this.getClass().toString() + "(empty...)>";
        }
        int offset = this._offset();
        int length = this.length();
        byte[] bytes = this.bytesNoCopy();
        StringBuffer buffer = new StringBuffer("<" + this.getClass().toString() + " (offset=" + offset + ", length=" + length + ", data=");
        for (i = 0; i < length && i < 30; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("[" + bytes[i + offset] + "]'" + (char)bytes[i + offset] + "'");
        }
        if (i < length) {
            buffer.append("...");
        }
        buffer.append(")>");
        return new String(buffer);
    }

    public String _hexString() {
        int dataLength = this.length();
        byte[] bytes = this.bytes();
        char[] cString = new char[2 * dataLength];
        int stringIndex = 0;
        for (int i = 0; i < dataLength; ++i) {
            cString[stringIndex++] = _nibbleToHex[bytes[i] >> 4];
            cString[stringIndex++] = _nibbleToHex[bytes[i] & 0xF];
        }
        return new String(cString);
    }

    protected boolean _mustRecomputeHash() {
        return this._recomputeHashCode;
    }

    protected void _setMustRecomputeHash(boolean change) {
        this._recomputeHashCode = change;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationBytesFieldKey, this.bytes());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        byte[] bytes = (byte[])fields.get(SerializationBytesFieldKey, _NSUtilities._NoByteArray);
        bytes = bytes == null ? _NSUtilities._NoByteArray : bytes;
        this.initFromBytes(bytes, new NSRange(0, bytes.length), false);
        this._recomputeHashCode = true;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.length() == 0) {
            return EmptyData;
        }
        return this;
    }
}

