/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.util.Dictionary;

public class NSMutableDictionary
extends NSDictionary {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime("com.webobjects.foundation.NSMutableDictionary");
    static final long serialVersionUID = 6690723083816355576L;

    public NSMutableDictionary() {
    }

    public NSMutableDictionary(int capacity) {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ": Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableDictionary(Object object, Object key) {
        super(object, key);
    }

    public NSMutableDictionary(Object[] objects, Object[] keys) {
        super(objects, keys);
    }

    public NSMutableDictionary(NSArray objects, NSArray keys) {
        super(objects, keys);
    }

    public NSMutableDictionary(NSDictionary otherDictionary) {
        this._copyMutableDictionary(otherDictionary);
    }

    public NSMutableDictionary(Dictionary dictionary, boolean ignoreNull) {
        super(dictionary, ignoreNull);
    }

    public void setObjectForKey(Object object, Object key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an " + this.getClass().getName() + ".");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an " + this.getClass().getName() + ".");
        }
        int capacity = this._capacity;
        int count = this._count;
        if (++count > capacity) {
            this._ensureCapacity(count);
        }
        if (_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) {
            this._count = count;
            this._keysCache = null;
        }
        this._objectsCache = null;
    }

    public Object removeObjectForKey(Object key) {
        Object result = null;
        if (key == null) {
            throw new IllegalArgumentException("Attempt to remove null key from an " + this.getClass().getName() + ".");
        }
        if (this._count != 0 && (result = _NSCollectionPrimitives.removeValueInHashTable(key, this._keys, this._objects, this._flags)) != null) {
            --this._count;
            --this._deletionLimit;
            if (this._count == 0 || this._deletionLimit == 0) {
                this._clearDeletionsAndCollisions();
            }
            this._objectsCache = null;
            this._keysCache = null;
        }
        return result;
    }

    public void removeAllObjects() {
        if (this._count != 0) {
            this._objects = new Object[this._hashtableBuckets];
            this._keys = new Object[this._hashtableBuckets];
            this._flags = new byte[this._hashtableBuckets];
            this._count = 0;
            this._objectsCache = null;
            this._keysCache = null;
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
        }
    }

    public void setDictionary(NSDictionary otherDictionary) {
        if (otherDictionary != this) {
            this.removeAllObjects();
            if (otherDictionary != null) {
                this.addEntriesFromDictionary(otherDictionary);
            }
        }
    }

    public void addEntriesFromDictionary(NSDictionary otherDictionary) {
        if (otherDictionary != null) {
            Object[] keys = otherDictionary.keysNoCopy();
            for (int i = 0; i < keys.length; ++i) {
                this.setObjectForKey(otherDictionary.objectForKey(keys[i]), keys[i]);
            }
        }
    }

    public void removeObjectsForKeys(NSArray keys) {
        if (keys != null) {
            Object[] keysArray = keys.objectsNoCopy();
            for (int i = 0; i < keysArray.length; ++i) {
                this.removeObjectForKey(keysArray[i]);
            }
        }
    }

    public void takeValueForKey(Object value, String key) {
        if (value != null) {
            this.setObjectForKey(value, key);
        } else {
            this.removeObjectForKey(key);
        }
    }

    public Object clone() {
        return new NSMutableDictionary(this);
    }

    public NSDictionary immutableClone() {
        return new NSDictionary(this);
    }

    public NSMutableDictionary mutableClone() {
        return (NSMutableDictionary)this.clone();
    }
}

