/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects._ideservices._IDEProject;
import com.webobjects._ideservices._PBProject;
import com.webobjects._ideservices._WOProject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import java.io.File;
import java.net.URL;

public class _IDEProjectPB
implements _IDEProject {
    private static final String LANGUAGE_RESOURCE_SEPARATOR = "_";
    private volatile _PBProject _pbProject;
    private volatile String _pathToPBProjectFile;

    private String _languageFromKey(String fileKey) {
        int i;
        String language = "";
        String suffix = null;
        if (fileKey.endsWith("WEBSERVER_RESOURCES")) {
            suffix = "WEBSERVER_RESOURCES";
        } else if (fileKey.endsWith("WOAPP_RESOURCES")) {
            suffix = "WOAPP_RESOURCES";
        } else if (fileKey.endsWith("OTHER_RESOURCES")) {
            suffix = "OTHER_RESOURCES";
        } else if (fileKey.endsWith("WO_COMPONENTS")) {
            suffix = "WO_COMPONENTS";
        }
        if (suffix != null) {
            language = fileKey.substring(0, fileKey.indexOf(suffix));
        }
        if ((i = language.indexOf(LANGUAGE_RESOURCE_SEPARATOR)) > 0) {
            language = language.substring(0, i);
        }
        return language;
    }

    public static _IDEProjectPB pbProjectAtPath(String path) {
        _PBProject rootProject = _PBProject.pbProjectAtPath(path);
        if (rootProject != null) {
            return new _IDEProjectPB(rootProject);
        }
        return null;
    }

    public _IDEProjectPB(_PBProject rootProject) {
        this._pbProject = rootProject;
    }

    public String projectDir() {
        return NSPathUtilities.stringByNormalizingExistingPath((String)this._pbProject.projectDir());
    }

    public String projectDirNotNormalized() {
        return this._pbProject.projectDir();
    }

    public String languageDir() {
        return this._pbProject.languageDir();
    }

    public String projectName() {
        return this._pbProject.projectName();
    }

    public String projectTypeName() {
        return this._pbProject.projectTypeName();
    }

    public String languageName() {
        return this._pbProject.languageName();
    }

    public NSMutableArray fileListForKey(String aKey, boolean createIt) {
        return this._pbProject.fileListForKey(aKey, createIt);
    }

    public String pathForFrameworkNamed(String fwName) {
        return "unimplemented";
    }

    public void setPathForFramework(String path, String fwName) {
    }

    public void addComponent(String componentDirectoryString, String javaFileString) {
        this.addFileKey(javaFileString, "CLASSES");
        this.addFileKey(componentDirectoryString, "WO_COMPONENTS");
    }

    public String pathToBucket(String aKey) {
        if (aKey.equals("EJB_META_INFO")) {
            return "";
        }
        if (aKey.equals("EJB_SERVER_CLASSES")) {
            return "EJBServer.subproj";
        }
        if (aKey.equals("EJB_CLIENT_CLASSES")) {
            return "EJBClient.subproj";
        }
        if (aKey.equals("EJB_COMMON_CLASSES")) {
            return "";
        }
        return "";
    }

    public void addFileKey(String aFile, String aKey) {
        _PBProject project = this._pbProject;
        String projectName = NSPathUtilities.lastPathComponent((String)project.projectDir());
        String newKey = aKey;
        if (aKey.equals("WO_COMPONENTS")) {
            newKey = "WEBCOMPONENTS";
        } else if (aKey.equals("EJB_META_INFO")) {
            newKey = "RESOURCES";
        } else if (aKey.equals("EJB_SERVER_CLASSES")) {
            projectName = String.valueOf(projectName) + "/EJBServer";
            newKey = "CLASSES";
        } else if (aKey.equals("EJB_CLIENT_CLASSES")) {
            projectName = String.valueOf(projectName) + "/EJBClient";
            newKey = "CLASSES";
        } else if (aKey.equals("EJB_COMMON_CLASSES")) {
            newKey = "CLASSES";
        }
        _PBProject.addFileToPBBucket(projectName, aFile, newKey);
    }

    public void openFile(String filename, int line, String errorMessage) {
        _PBProject.openFile(filename, line, errorMessage);
    }

    public void extractFilesIntoWOProject(_WOProject woProject) {
        this.extractFilesFromProjectIntoWOProject(this._pbProject, woProject);
    }

    public void extractFilesFromProjectIntoWOProject(_PBProject project, _WOProject woProject) {
        if (project == null) {
            return;
        }
        this.extractFilesForKeyFromProjectIntoWOProject("H_FILES", project, woProject);
        this.extractFilesForKeyFromProjectIntoWOProject("WOAPP_RESOURCES", project, woProject);
        this.extractFilesForKeyFromProjectIntoWOProject("CLASSES", project, woProject);
        this.extractFilesForKeyFromProjectIntoWOProject("OTHER_LINKED", project, woProject);
        if (woProject.includeFrameworks()) {
            this.extractFrameworksFromProjectIntoWOProject(project, woProject);
        }
        this.extractResourcesFromProjectIntoWOProject(project, woProject);
        this.extractEOModelsFromProjectIntoWOProject(project, woProject);
        NSArray subprojects = project.parseSubprojects();
        if (subprojects != null) {
            int i = 0;
            int count = subprojects.count();
            while (i < count) {
                _PBProject subproject = (_PBProject)subprojects.objectAtIndex(i);
                this.extractFilesFromProjectIntoWOProject(subproject, woProject);
                ++i;
            }
        }
    }

    public void extractFrameworksFromProjectIntoWOProject(_PBProject project, _WOProject woProject) {
        NSMutableArray<String> frameworkNames = project.fileListForKey("FRAMEWORKS", false);
        if (frameworkNames != null) {
            int i = 0;
            int count = frameworkNames.count();
            while (i < count) {
                String frameworkName = (String)frameworkNames.objectAtIndex(i);
                woProject.extractFrameworkNamed(frameworkName);
                ++i;
            }
        }
    }

    public void extractEOModelsFromProjectIntoWOProject(_PBProject project, _WOProject woProject) {
        String[] stringArray = new String[3];
        stringArray[0] = "OTHER_RESOURCES";
        stringArray[1] = "WOAPP_RESOURCES";
        String[] keys = stringArray;
        int k = 0;
        while (keys[k] != null) {
            NSMutableArray<String> files = project.fileListForKey(keys[k], false);
            if (files != null) {
                int i = 0;
                int count = files.count();
                while (i < count) {
                    String fileName = (String)files.objectAtIndex(i);
                    if ("eomodeld".equals(NSPathUtilities.pathExtension((String)fileName))) {
                        String modelPath = String.valueOf(project.projectDir()) + File.separator + fileName;
                        woProject.addModelFilePath(modelPath);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    public void extractResourcesFromProjectIntoWOProject(_PBProject project, _WOProject woProject) {
        NSMutableDictionary<String, NSMutableArray<String>> filesTable = project.filesTable();
        NSArray fileKeys = filesTable.allKeys();
        int i = 0;
        int count = fileKeys.count();
        while (i < count) {
            String fileKey = (String)fileKeys.objectAtIndex(i);
            if (fileKey.endsWith("WEBSERVER_RESOURCES") || fileKey.endsWith("WOAPP_RESOURCES") || fileKey.endsWith("OTHER_RESOURCES") || fileKey.endsWith("WO_COMPONENTS")) {
                this.extractResourcesFromProjectWithKeyIntoWOProject(project, fileKey, woProject);
            }
            ++i;
        }
    }

    public void extractResourcesFromProjectWithKeyIntoWOProject(_PBProject project, String key, _WOProject woProject) {
        NSMutableArray<String> fileList = project.fileListForKey(key, false);
        if (fileList != null) {
            String language = this._languageFromKey(key);
            int i = 0;
            int count = fileList.count();
            while (i < count) {
                String filename = (String)fileList.objectAtIndex(i);
                String parentDir = _WOProject.resourcePathByAppendingLanguageFileName(project.projectDir(), language, "");
                String resourcePath = String.valueOf(parentDir) + File.separator + filename;
                File resourceFile = new File(resourcePath);
                if (NSPathUtilities.pathExtension((String)filename).length() <= 0 && resourceFile.exists() && resourceFile.isDirectory()) {
                    woProject.extractResourcesFromPath(parentDir, filename);
                } else {
                    woProject.addResource(filename, resourcePath, language);
                }
                ++i;
            }
        }
    }

    public void extractFilesForKeyFromProjectIntoWOProject(String projectKey, _PBProject project, _WOProject woProject) {
        NSMutableArray<String> fileList = project.fileListForKey(projectKey, false);
        if (fileList != null) {
            int i = 0;
            int c = fileList.count();
            while (i < c) {
                String fileName = (String)fileList.objectAtIndex(i);
                if ("java".equals(NSPathUtilities.pathExtension((String)fileName))) {
                    String filePath = String.valueOf(project.projectDir()) + File.separator + fileName;
                    woProject.addInterfaceFilePath(filePath);
                }
                ++i;
            }
        }
    }

    public String ideApplicationName() {
        return "unimplemented";
    }

    public String ideProjectPath() {
        return NSPathUtilities.stringByNormalizingExistingPath((String)this._pbProject.projectDir());
    }

    @Deprecated
    public NSArray frameworkBundlePaths() {
        NSMutableArray frameworkPaths = new NSMutableArray();
        NSMutableArray<String> frameworkNames = this._pbProject.fileListForKey("FRAMEWORKS", false);
        if (frameworkNames != null) {
            int fnCount = frameworkNames.count();
            int i = 0;
            while (i < fnCount) {
                NSBundle frameworkBundle = NSBundle.bundleForName((String)((String)frameworkNames.objectAtIndex(i)));
                if (frameworkBundle != null) {
                    frameworkPaths.addObject((Object)frameworkBundle.bundlePath());
                }
                ++i;
            }
        }
        return frameworkPaths;
    }

    public NSArray frameworkBundlePathURLs() {
        NSMutableArray frameworkPaths = new NSMutableArray();
        NSMutableArray<String> frameworkNames = this._pbProject.fileListForKey("FRAMEWORKS", false);
        if (frameworkNames != null) {
            int fnCount = frameworkNames.count();
            int i = 0;
            while (i < fnCount) {
                NSBundle frameworkBundle = NSBundle.bundleForName((String)((String)frameworkNames.objectAtIndex(i)));
                if (frameworkBundle != null) {
                    frameworkPaths.addObject((Object)frameworkBundle.bundlePathURL());
                }
                ++i;
            }
        }
        return frameworkPaths;
    }

    public void addFilenameExtensionToListOfKnowns(String anExtension) {
    }

    public void refreshUnderlyingProjectCache() {
        this._pbProject.setRememberFileAttributes(false);
        if (this._pathToPBProjectFile == null) {
            this._pathToPBProjectFile = String.valueOf(this.projectDir()) + File.separator + "PB.project";
        }
        _PBProject.parse(this._pathToPBProjectFile);
    }

    @Deprecated
    public String bundlePath() {
        String path = null;
        String projectType = this._pbProject.projectTypeName();
        if (projectType.equalsIgnoreCase("JavaWebObjectsFramework")) {
            path = NSBundle.bundleForName((String)this._pbProject.projectName()).bundlePath();
        } else if (projectType.equalsIgnoreCase("JavaWebObjectsApplication")) {
            path = NSBundle.mainBundle().bundlePath();
        }
        return NSPathUtilities.stringByNormalizingExistingPath((String)path);
    }

    public URL bundlePathURL() {
        URL path = null;
        String projectType = this._pbProject.projectTypeName();
        if (projectType.equalsIgnoreCase("JavaWebObjectsFramework")) {
            path = NSBundle.bundleForName((String)this._pbProject.projectName()).bundlePathURL();
        } else if (projectType.equalsIgnoreCase("JavaWebObjectsApplication")) {
            path = NSBundle.mainBundle().bundlePathURL();
        }
        return path;
    }

    public boolean shouldPreloadResources() {
        return true;
    }
}

