/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import er.erxtest.ERXTestCase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class NSArrayTest
extends ERXTestCase {
    private static final String prefix = "0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|";
    private static final String multiPrefix = "01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||";

    public void testNSArray() {
        NSArray array = new NSArray();
        NSArrayTest.assertEquals((int)0, (int)array.count());
    }

    public void testNSArrayIsImmutable() {
        NSArray array = new NSArray();
        try {
            array.add((Object)"abc");
            NSArrayTest.fail((String)"NSArray is not immutable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testNSArrayE() {
        NSArray array = new NSArray((Object)"abc");
        NSArrayTest.assertEquals((int)1, (int)array.size());
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
    }

    public void testNSArrayENull() {
        try {
            new NSArray((Object)null);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNSArrayEArray() {
        Object[] str = new String[]{"abc", "def"};
        NSArray array = new NSArray(str);
        NSArray array2 = new NSArray((Object[])new String[]{"abc", "def"});
        NSArrayTest.assertEquals((int)2, (int)array.size());
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
        NSArrayTest.assertEquals((String)"def", (String)((String)array.objectAtIndex(1)));
        NSArrayTest.assertEquals(array, array2);
        array = new NSArray((Object[])new String[]{"abc", null, "def", null, "ghi"});
        NSArrayTest.assertEquals((int)3, (int)array.size());
        NSArrayTest.assertEquals((String)"ghi", (String)((String)array.objectAtIndex(2)));
    }

    public void testNSArrayEArrayNull() {
        NSArray array = new NSArray((Object[])null);
        NSArrayTest.assertEquals((int)0, (int)array.size());
    }

    public void testNSArrayEVarArgs() {
        NSArray array = new NSArray((Object)"abc", (Object[])new String[]{"def", "ghi"});
        NSArrayTest.assertEquals((int)3, (int)array.size());
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
        NSArrayTest.assertEquals((String)"ghi", (String)((String)array.objectAtIndex(2)));
    }

    public void testNSArrayEVarArgsNull() {
        NSArray array = new NSArray((Object)"abc", (Object[])new String[]{null});
        NSArrayTest.assertEquals((int)1, (int)array.size());
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
        array = new NSArray(null, (Object[])new String[]{null});
        NSArrayTest.assertEquals((int)0, (int)array.size());
        NSArray array2 = new NSArray((Object)null, (Object[])new String[]{"abc"});
        NSArrayTest.assertEquals((int)1, (int)array2.size());
        array2 = new NSArray((Object)null, (Object[])new String[]{null});
        NSArrayTest.assertEquals((int)0, (int)array2.size());
    }

    public void testNSArrayEArrayNSRange() {
        Object[] str = new String[]{"abc", "def"};
        NSRange range = new NSRange(1, 1);
        NSArray array = new NSArray(str, range);
        NSArrayTest.assertEquals((int)1, (int)array.size());
        NSArrayTest.assertEquals((String)"def", (String)((String)array.objectAtIndex(0)));
    }

    public void testNSArrayEArrayNSRangeNull() {
        NSArray array = new NSArray((Object[])null, new NSRange(0, 0));
        NSArrayTest.assertEquals((int)0, (int)array.size());
        array = new NSArray((Object[])new String[]{"abc"}, (NSRange)null);
        NSArrayTest.assertEquals((int)0, (int)array.size());
        array = new NSArray((Object[])null, (NSRange)null);
        NSArrayTest.assertEquals((int)0, (int)array.size());
    }

    public void testNSArrayEArrayNSRangeInvalid() {
        try {
            new NSArray((Object[])new String[]{"abc"}, new NSRange(1, 1));
            NSArrayTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            new NSArray((Object[])null, new NSRange(1, 1));
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNSArrayNSArrayOfQextendsE() {
        NSArray nsarray = new NSArray((Object[])new String[]{"abc"});
        NSArray array = new NSArray(nsarray);
        NSArrayTest.assertEquals((int)1, (int)array.size());
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
        NSMutableArray nsmutablearray = new NSMutableArray((Object[])new String[]{"abc"});
        array = new NSArray((NSArray)nsmutablearray);
        NSArrayTest.assertEquals((int)1, (int)array.size());
        nsmutablearray.add((Object)"def");
        NSArrayTest.assertEquals((int)1, (int)array.size());
        nsmutablearray.set(0, (Object)"123");
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
    }

    public void testNSArrayNSArrayOfQextendsENull() {
        NSArray array = new NSArray((NSArray)null);
        NSArrayTest.assertEquals((int)0, (int)array.count());
    }

    public void testNSArrayListOfQextendsEBoolean() {
        List<String> list = Arrays.asList("abc", "def");
        NSArray array = new NSArray(list, true);
        NSArrayTest.assertEquals((int)2, (int)array.size());
        array = new NSArray(list, false);
        NSArrayTest.assertEquals((int)2, (int)array.size());
        NSArray array2 = new NSArray(array);
        NSArrayTest.assertTrue((boolean)array2.equals((Object)array));
        list = Arrays.asList("abc", "def", null);
        array = new NSArray(list, false);
        NSArrayTest.assertEquals((int)3, (int)array.size());
    }

    public void testNSArrayListOfQextendsEBooleanNull() {
        try {
            new NSArray((List)null, true);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new NSArray((List)null, false);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNSArrayListOfQextendsEBooleanInvalid() {
        List<String> list = Arrays.asList("abc", "def", null);
        try {
            new NSArray(list, true);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNSArrayCollectionOfQextendsE() {
        List<String> list = Arrays.asList("abc", "def");
        NSArray array = new NSArray(list);
        NSArrayTest.assertEquals((int)2, (int)array.size());
        NSArray array2 = new NSArray(array);
        NSArrayTest.assertTrue((boolean)array2.equals((Object)array));
    }

    public void testNSArrayCollectionOfQextendsENull() {
        try {
            new NSArray((Collection)null);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNSArrayCollectionOfQextendsEInvalid() {
        List<String> list = Arrays.asList("abc", "def", null);
        try {
            new NSArray(list);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNSArrayCollectionOfQextendsEBoolean() {
        List<String> collection = Arrays.asList("abc", "def");
        NSArray array = new NSArray(collection, false);
        NSArrayTest.assertEquals((int)2, (int)array.size());
        NSArrayTest.assertTrue((boolean)Arrays.equals(collection.toArray(), array.toArray()));
        collection = Arrays.asList("abc", "def", null);
        array = new NSArray(collection, false);
        NSArrayTest.assertEquals((int)3, (int)array.size());
    }

    public void testNSArrayCollectionOfQextendsEBooleanNull() {
        try {
            new NSArray((Collection)null, true);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new NSArray((Collection)null, false);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNSArrayCollectionOfQextendsEBooleanInvalid() {
        List<String> collection = Arrays.asList("abc", "def", null);
        try {
            new NSArray(collection, true);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNSArrayListOfQextendsENSRangeBoolean() {
        List<String> list = Arrays.asList("abc", null, "def");
        NSRange range = new NSRange(1, 2);
        NSArray array = new NSArray(list, range, true);
        NSArrayTest.assertEquals((int)1, (int)array.size());
        array = new NSArray(list, new NSRange(1, 2), true);
        NSArrayTest.assertEquals((int)1, (int)array.size());
        NSArrayTest.assertEquals((String)"def", (String)((String)array.objectAtIndex(0)));
        NSArray array2 = new NSArray(list, new NSRange(0, list.size()), true);
        NSArrayTest.assertEquals((int)2, (int)array2.size());
        list = Arrays.asList("abc", "def", "ghi");
        array = new NSArray(list, new NSRange(0, list.size()), false);
        NSArrayTest.assertEquals((int)3, (int)array.size());
        array = new NSArray(list, null, false);
        NSArrayTest.assertEquals((int)0, (int)array.size());
    }

    public void testNSArrayListOfQextendsENSRangeBooleanNull() {
        try {
            new NSArray((List)null, new NSRange(0, 0), false);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        List<String> list = Arrays.asList("abc");
        try {
            new NSArray(list, new NSRange(4, 1), false);
            NSArrayTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testNSArrayListOfQextendsENSRangeBooleanInvalid() {
        List<String> list = Arrays.asList("abc", null, "def");
        NSRange range = new NSRange(1, 2);
        try {
            new NSArray(list, range, false);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        list = Arrays.asList("abc", "def", "ghi");
        try {
            new NSArray(list, new NSRange(4, 1), false);
            NSArrayTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testNSArrayVectorOfQextendsENSRangeBoolean() {
        Vector<String> vector = new Vector<String>();
        vector.add("abc");
        vector.add(null);
        vector.add("def");
        NSRange range = new NSRange(1, 2);
        NSArray array = new NSArray(vector, range, true);
        NSArrayTest.assertEquals((int)1, (int)array.size());
        array = new NSArray(vector, new NSRange(1, 2), true);
        NSArrayTest.assertEquals((int)1, (int)array.size());
        NSArrayTest.assertEquals((String)"def", (String)((String)array.objectAtIndex(0)));
        try {
            new NSArray(vector, range, false);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        vector.clear();
        vector.add("abc");
        vector.add("def");
        vector.add("ghi");
        array = new NSArray(vector, new NSRange(0, vector.size()), false);
        NSArrayTest.assertEquals((int)3, (int)array.size());
        array = new NSArray(vector, null, false);
        NSArrayTest.assertEquals((int)0, (int)array.size());
        try {
            new NSArray((Vector)null, range, false);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testNSArrayVectorOfQextendsENSRangeBooleanNull() {
        Vector<String> vector = new Vector<String>();
        vector.add("abc");
        vector.add("def");
        vector.add("ghi");
        NSArray array = new NSArray(vector, null, false);
        NSArrayTest.assertEquals((int)0, (int)array.size());
        try {
            new NSArray((Vector)null, new NSRange(0, 0), false);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new NSArray((Vector)null, (NSRange)null, false);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNSArrayVectorOfQextendsENSRangeBooleanInvalid() {
        Vector<String> vector = new Vector<String>();
        vector.add("abc");
        vector.add(null);
        vector.add("def");
        NSRange range = new NSRange(1, 2);
        try {
            new NSArray(vector, range, false);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        vector = new Vector();
        vector.add("abc");
        vector.add("def");
        vector.add("ghi");
        try {
            new NSArray(vector, new NSRange(4, 1), false);
            NSArrayTest.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testArrayByAddingObject() {
        NSArray array = new NSArray((Object)"abc");
        NSArray array2 = array.arrayByAddingObject((Object)"def");
        NSArrayTest.assertEquals((int)2, (int)array2.size());
    }

    public void testArrayByAddingObjectNull() {
        NSArray array = new NSArray((Object)"abc");
        try {
            array.arrayByAddingObject(null);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testArrayByAddingObjectsFromArray() {
        Object[] combined = new String[]{"abc", "def", "ghi"};
        NSArray array = new NSArray((Object)"abc");
        NSArray array2 = new NSArray((Object[])new String[]{"def", "ghi"});
        NSArray result = array.arrayByAddingObjectsFromArray(array2);
        NSArrayTest.assertEquals((int)3, (int)result.size());
        NSArrayTest.assertEquals(result, new NSArray(combined));
        result = array.arrayByAddingObjectsFromArray(null);
        NSArrayTest.assertEquals(array, result);
        result = NSArray.EmptyArray.arrayByAddingObjectsFromArray(array);
        NSArrayTest.assertEquals(array, result);
        result = array.arrayByAddingObjectsFromArray(NSArray.EmptyArray);
        NSArrayTest.assertEquals(array, result);
    }

    public void testArrayByAddingObjectsFromArrayNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc"});
        NSArray result = array.arrayByAddingObjectsFromArray(null);
        NSArrayTest.assertEquals(array, result);
    }

    public void testArrayList() {
        NSArray array = new NSArray((Object)"abc");
        ArrayList list = array.arrayList();
        NSArrayTest.assertTrue((boolean)(list instanceof ArrayList));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("abc");
        NSArrayTest.assertEquals(expected, list);
    }

    public void testClone() {
        NSArray array = new NSArray((Object)"abc");
        NSArray clone = (NSArray)array.clone();
        NSArrayTest.assertEquals(clone, array);
    }

    public void testComponentsJoinedByString() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        String joined = array.componentsJoinedByString("-");
        NSArrayTest.assertEquals((String)"abc-def", (String)joined);
    }

    public void testComponentsJoinedByStringNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        String joined = array.componentsJoinedByString(null);
        NSArrayTest.assertEquals((String)"abcdef", (String)joined);
    }

    public void testContainsObject() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArrayTest.assertTrue((boolean)array.containsObject((Object)"def"));
        NSArrayTest.assertFalse((boolean)array.containsObject((Object)"123"));
    }

    public void testContainsObjectNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArrayTest.assertFalse((boolean)array.containsObject(null));
    }

    public void testContains() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArrayTest.assertTrue((boolean)array.contains((Object)new String("abc")));
    }

    public void testContainsNull() {
        try {
            NSArrayTest.assertFalse((boolean)NSArray.EmptyArray.contains(null));
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testContainsAllCollection() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi"});
        NSArray array2 = new NSArray(Arrays.asList("abc", "def"));
        NSArrayTest.assertTrue((boolean)array.containsAll((Collection)array2));
        array2 = new NSArray((Object[])new String[]{"abc", "def", "xyz"});
        NSArrayTest.assertFalse((boolean)array.containsAll((Collection)array2));
        List<String> list = array2.subList(1, 3);
        NSArrayTest.assertFalse((boolean)list.containsAll((Collection<?>)array));
        list = Arrays.asList("abc", "def", null);
        NSArrayTest.assertFalse((boolean)array.containsAll(list));
    }

    public void testContainsAllCollectionNull() {
        try {
            NSArray.emptyArray().containsAll(null);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCount() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArrayTest.assertEquals((int)2, (int)array.count());
        NSArrayTest.assertEquals((int)array.size(), (int)array.count());
    }

    public void testEmptyArray() {
        NSArrayTest.assertEquals((int)0, (int)NSArray.EmptyArray.size());
        NSArrayTest.assertEquals((int)0, (int)NSArray.emptyArray().size());
        NSArrayTest.assertTrue((NSArray.emptyArray() == NSArray.EmptyArray ? 1 : 0) != 0);
    }

    public void testIsEmpty() {
        NSArrayTest.assertTrue((boolean)NSArray.emptyArray().isEmpty());
        NSArrayTest.assertFalse((boolean)new NSArray((Object)"abc").isEmpty());
    }

    public void testEquals() {
        NSArray array = new NSArray((Object)"abc");
        NSArrayTest.assertTrue((boolean)array.equals(array.clone()));
        NSArrayTest.assertFalse((boolean)array.equals((Object)"abc"));
        NSMutableArray array2 = new NSMutableArray((Object)"def");
        array.hashCode();
        array2.hashCode();
        NSArrayTest.assertFalse((boolean)array.equals((Object)array2));
    }

    public void testEqualsNull() {
        NSArray array = new NSArray((Object)"abc");
        NSArrayTest.assertFalse((boolean)array.equals(null));
    }

    public void testFirstObjectCommonWithArray() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArray array2 = new NSArray((Object[])new String[]{"def", "ghi"});
        Object commonObject = array.firstObjectCommonWithArray(array2);
        NSArrayTest.assertEquals((Object)"def", (Object)commonObject);
        array2 = new NSArray((Object[])new String[]{"ghi", "jkl"});
        commonObject = array.firstObjectCommonWithArray(array2);
        NSArrayTest.assertNull((Object)commonObject);
    }

    public void testFirstObjectCommonWithArrayNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        String commonObject = (String)array.firstObjectCommonWithArray(null);
        NSArrayTest.assertNull((Object)commonObject);
    }

    public void testImmutableClone() {
        NSMutableArray array = new NSMutableArray((Object)"abc");
        NSArray clone = array.immutableClone();
        NSArrayTest.assertEquals(array, clone);
        NSArrayTest.assertEquals((int)array.size(), (int)clone.size());
        array.addObjects((Object[])new String[]{"def"});
        NSArrayTest.assertEquals((int)1, (int)clone.size());
    }

    public void testIndexOfIdenticalObjectObject() {
        Object obj = new Object();
        NSArray array = new NSArray(new Object[]{"abc", obj});
        int index = array.indexOfIdenticalObject(obj);
        NSArrayTest.assertEquals((int)1, (int)index);
        index = array.indexOfIdenticalObject(new Object());
        NSArrayTest.assertEquals((int)-1, (int)index);
        index = array.indexOfIdenticalObject((Object)"ghi");
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfIdenticalObjectObjectNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc"});
        int index = array.indexOfIdenticalObject(null);
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfIdenticalObjectObjectNSRange() {
        String def = "def";
        NSArray array = new NSArray((Object[])new String[]{"abc", def});
        NSRange range = new NSRange(1, 1);
        int index = array.indexOfIdenticalObject((Object)def, range);
        NSArrayTest.assertEquals((int)1, (int)index);
        range = NSRange.ZeroRange;
        index = array.indexOfIdenticalObject((Object)def, range);
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfIdenticalObjectObjectNSRangeNull() {
        String def = "def";
        NSArray array = new NSArray((Object[])new String[]{"abc", def});
        NSRange range = new NSRange(1, 1);
        int index = array.indexOfIdenticalObject(null, range);
        NSArrayTest.assertEquals((int)-1, (int)index);
        index = array.indexOfIdenticalObject((Object)def, null);
        NSArrayTest.assertEquals((int)-1, (int)index);
        index = array.indexOfIdenticalObject(null, null);
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfIdenticalObjectObjectNSRangeInvalid() {
        String def = "def";
        NSArray array = new NSArray((Object[])new String[]{"abc", def});
        try {
            array.indexOfIdenticalObject((Object)def, new NSRange(2, 1));
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIndexOfObject() {
        String def = "def";
        NSArray array = new NSArray((Object[])new String[]{"abc", def});
        int index = array.indexOf((Object)def);
        NSArrayTest.assertEquals((int)1, (int)index);
        index = array.indexOf((Object)new String("def"));
        NSArrayTest.assertEquals((int)1, (int)index);
    }

    public void testIndexOfObjectNull() {
        try {
            NSArray.emptyArray().indexOf(null);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIndexOfObjectObject() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        int index = array.indexOfObject((Object)"def");
        NSArrayTest.assertEquals((int)1, (int)index);
        index = array.indexOfObject((Object)new String("def"));
        NSArrayTest.assertEquals((int)1, (int)index);
        index = array.indexOfIdenticalObject((Object)"ghi");
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfObjectObjectNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        int index = array.indexOfObject(null);
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfObjectObjectNSRange() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSRange range = new NSRange(1, 1);
        int index = array.indexOfObject((Object)"def", range);
        NSArrayTest.assertEquals((int)1, (int)index);
        index = array.indexOfObject((Object)"def", new NSRange(0, 2));
        NSArrayTest.assertEquals((int)1, (int)index);
        index = array.indexOfObject((Object)"def", new NSRange(0, 1));
        NSArrayTest.assertEquals((int)-1, (int)index);
        range = NSRange.ZeroRange;
        index = array.indexOfObject((Object)"def", range);
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfObjectObjectNSRangeNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSRange range = new NSRange(1, 1);
        int index = array.indexOfObject((Object)"def", null);
        NSArrayTest.assertEquals((int)-1, (int)index);
        index = array.indexOfObject(null, range);
        NSArrayTest.assertEquals((int)-1, (int)index);
        index = array.indexOfObject(null, null);
        NSArrayTest.assertEquals((int)-1, (int)index);
    }

    public void testIndexOfObjectObjectNSRangeInvalid() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        try {
            array.indexOfObject((Object)"def", new NSRange(2, 1));
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsEqualToArray() {
        NSArray array = new NSArray((Object)"abc");
        NSArray clone = array.immutableClone();
        NSArrayTest.assertTrue((boolean)array.isEqualToArray(clone));
        clone = new NSArray((Object)"def");
        NSArrayTest.assertFalse((boolean)array.isEqualToArray(clone));
        NSArrayTest.assertFalse((boolean)array.isEqualToArray(NSArray.emptyArray()));
        NSArrayTest.assertFalse((boolean)array.isEqualToArray(null));
    }

    public void testIsEqualToArrayNull() {
        NSArray array = new NSArray((Object)"abc");
        NSArrayTest.assertFalse((boolean)array.isEqualToArray(null));
    }

    public void testLastIndexOfObject() {
        NSArray array = new NSArray((Object[])new String[]{"a", "b", "c", "a"});
        NSArrayTest.assertEquals((int)3, (int)array.lastIndexOf((Object)"a"));
        NSArrayTest.assertEquals((int)2, (int)array.lastIndexOf((Object)"c"));
    }

    public void testLastIndexOfObjectNull() {
        try {
            NSArray.emptyArray().lastIndexOf(null);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testLastObject() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi"});
        NSArrayTest.assertEquals((String)"ghi", (String)((String)array.lastObject()));
        NSArrayTest.assertEquals(null, (Object)NSArray.emptyArray().lastObject());
    }

    public void testMakeObjectsPerformSelector() {
        TestSelectable selectable = new TestSelectable();
        NSArray array = new NSArray((Object)selectable);
        NSSelector selector = new NSSelector("invoke", new Class[]{String.class});
        array.makeObjectsPerformSelector(selector, new Object[]{"abc"});
        NSArrayTest.assertTrue((boolean)selectable.array.contains("abc"));
    }

    public void testMakeObjectsPerformSelectorNull() {
        NSArray array = new NSArray((Object)"abc");
        try {
            array.makeObjectsPerformSelector(null, (Object[])null);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMakeObjectsPerformSelectorInvalid() {
        TestSelectable selectable = new TestSelectable();
        NSArray array = new NSArray((Object)selectable);
        NSSelector selector = new NSSelector("missiginvoke", new Class[]{String.class});
        try {
            array.makeObjectsPerformSelector(selector, new Object[]{"abc"});
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        NSArray array2 = new NSArray((Object)"abc");
        try {
            array2.makeObjectsPerformSelector(new NSSelector("invoke"), (Object[])null);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testMutableClone() {
        NSArray array = new NSArray((Object)"abc");
        NSMutableArray clone = array.mutableClone();
        NSArrayTest.assertEquals((int)1, (int)clone.size());
        NSArrayTest.assertEquals((String)"abc", (String)((String)clone.objectAtIndex(0)));
        clone.set(0, (Object)"def");
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
        NSArrayTest.assertEquals((String)"def", (String)((String)clone.objectAtIndex(0)));
    }

    public void testObjectAtIndex() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi"});
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
    }

    public void testObjectAtIndexInvalid() {
        try {
            NSArray.emptyArray().objectAtIndex(0);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new NSArray((Object)"abc").objectAtIndex(1);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testObjects() {
        Object[] strings = new String[]{"abc", "def"};
        NSArray array = new NSArray(strings);
        Object[] objects = array.objects();
        NSArrayTest.assertEquals(strings, objects);
        objects[0] = "xyz";
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
    }

    public void testObjectsNSRange() {
        Object[] strings = new String[]{"abc", "def"};
        NSArray array = new NSArray(strings);
        NSRange range = new NSRange(1, 1);
        Object[] objects = array.objects(range);
        NSArrayTest.assertEquals((int)1, (int)objects.length);
        NSArrayTest.assertEquals((Object)strings[1], (Object)objects[0]);
    }

    public void testObjectsNSRangeNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        Object[] objects = array.objects((NSRange)null);
        NSArrayTest.assertEquals((int)0, (int)objects.length);
    }

    public void testObjectEnumerator() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        Enumeration e = array.objectEnumerator();
        NSArrayTest.assertTrue((boolean)e.hasMoreElements());
        NSArrayTest.assertEquals((String)"abc", (String)((String)e.nextElement()));
        NSArrayTest.assertEquals((String)"def", (String)((String)e.nextElement()));
        NSArrayTest.assertFalse((boolean)e.hasMoreElements());
        try {
            e.nextElement();
            NSArrayTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testReverseObjectEnumerator() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        Enumeration e = array.reverseObjectEnumerator();
        NSArrayTest.assertTrue((boolean)e.hasMoreElements());
        NSArrayTest.assertEquals((String)"def", (String)((String)e.nextElement()));
        NSArrayTest.assertEquals((String)"abc", (String)((String)e.nextElement()));
        NSArrayTest.assertFalse((boolean)e.hasMoreElements());
        try {
            e.nextElement();
            NSArrayTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSortedArrayUsingComparatorString() throws NSComparator.ComparisonException {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArray sorted = array.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
        NSArrayTest.assertNotSame((Object)array, (Object)sorted);
        NSArrayTest.assertEquals((String)"abc", (String)((String)sorted.objectAtIndex(0)));
        NSArrayTest.assertEquals((String)"def", (String)((String)sorted.objectAtIndex(1)));
        sorted = array.sortedArrayUsingComparator(NSComparator.DescendingStringComparator);
        NSArrayTest.assertEquals((String)"def", (String)((String)sorted.objectAtIndex(0)));
        NSArrayTest.assertEquals((String)"abc", (String)((String)sorted.objectAtIndex(1)));
        array = new NSArray((Object[])new String[]{"abc", "DEF"});
        sorted = array.sortedArrayUsingComparator(NSComparator.AscendingCaseInsensitiveStringComparator);
        NSArrayTest.assertEquals((String)"abc", (String)((String)sorted.objectAtIndex(0)));
        NSArrayTest.assertEquals((String)"DEF", (String)((String)sorted.objectAtIndex(1)));
        sorted = array.sortedArrayUsingComparator(NSComparator.DescendingCaseInsensitiveStringComparator);
        NSArrayTest.assertEquals((String)"DEF", (String)((String)sorted.objectAtIndex(0)));
        NSArrayTest.assertEquals((String)"abc", (String)((String)sorted.objectAtIndex(1)));
    }

    public void testSortedArrayUsingComparatorNull() throws NSComparator.ComparisonException {
        NSArray array = new NSArray((Object[])new String[]{"abc", "xyz", "def"});
        try {
            array.sortedArrayUsingComparator(null);
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSortedArrayUsingComparatorNumber() throws NSComparator.ComparisonException {
        NSArray array = new NSArray((Object[])new Integer[]{new Integer(1), new Integer(2)});
        NSArray sorted = array.sortedArrayUsingComparator(NSComparator.AscendingNumberComparator);
        NSArrayTest.assertEquals((Object)1, (Object)sorted.objectAtIndex(0));
        NSArrayTest.assertEquals((Object)2, (Object)sorted.objectAtIndex(1));
        sorted = array.sortedArrayUsingComparator(NSComparator.DescendingNumberComparator);
        NSArrayTest.assertEquals((Object)2, (Object)sorted.objectAtIndex(0));
        NSArrayTest.assertEquals((Object)1, (Object)sorted.objectAtIndex(1));
    }

    public void testSortedArrayUsingComparatorTimestamp() throws NSComparator.ComparisonException {
        NSTimestamp earlierTime = new NSTimestamp();
        NSTimestamp laterTime = earlierTime.timestampByAddingGregorianUnits(0, 1, 0, 0, 0, 0);
        NSArray array = new NSArray((Object[])new NSTimestamp[]{earlierTime, laterTime});
        NSArray sorted = array.sortedArrayUsingComparator(NSComparator.AscendingTimestampComparator);
        NSArrayTest.assertEquals((Object)earlierTime, (Object)sorted.objectAtIndex(0));
        NSArrayTest.assertEquals((Object)laterTime, (Object)sorted.objectAtIndex(1));
        sorted = array.sortedArrayUsingComparator(NSComparator.DescendingTimestampComparator);
        NSArrayTest.assertEquals((Object)laterTime, (Object)sorted.objectAtIndex(0));
        NSArrayTest.assertEquals((Object)earlierTime, (Object)sorted.objectAtIndex(1));
    }

    public void testSubarrayWithRange() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArray subArray = array.subarrayWithRange(new NSRange(1, 1));
        NSArrayTest.assertEquals((int)1, (int)subArray.size());
        NSArrayTest.assertEquals((String)"def", (String)((String)subArray.objectAtIndex(0)));
        try {
            subArray.set(0, (Object)"xyz");
            NSArrayTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSubarrayWithRangeNull() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
        NSArray subArray = array.subarrayWithRange(null);
        NSArrayTest.assertEquals((int)0, (int)subArray.size());
    }

    public void testSubList() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi", "jkl"});
        List sublist = array.subList(2, 4);
        NSArrayTest.assertEquals((int)2, (int)sublist.size());
        NSArrayTest.assertEquals((String)"ghi", (String)((String)sublist.get(0)));
        try {
            sublist.add("mno");
            NSArrayTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            sublist.set(0, "mno");
            NSArrayTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            sublist.remove("ghi");
            NSArrayTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            sublist.clear();
            NSArrayTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSubListOutOfBounds() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi", "jkl"});
        try {
            array.subList(-1, 1);
            NSArrayTest.fail((String)"IndexOutofBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            array.subList(1, 5);
            NSArrayTest.fail((String)"IndexOutofBoundsException expected");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            array.subList(5, 1);
            NSArrayTest.fail((String)"IndexOutofBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testValueForKey() {
        Object[] dicts = new NSDictionary[]{new NSDictionary((Object)"val1", (Object)"key"), new NSDictionary((Object)"val2", (Object)"key")};
        NSArray array = new NSArray(dicts);
        NSArray result = (NSArray)array.valueForKey("key");
        NSArrayTest.assertEquals((int)2, (int)result.size());
        NSArrayTest.assertEquals((Object)"val1", (Object)result.objectAtIndex(0));
        NSArrayTest.assertEquals((Object)"val2", (Object)result.objectAtIndex(1));
        NSArrayTest.assertEquals((Object)new Integer(2), (Object)result.valueForKey("count"));
    }

    public void testValueForKeyPath() {
        Object[] dicts = new NSDictionary[]{new NSDictionary((Object)new Integer(2), (Object)"key"), new NSDictionary((Object)new Integer(4), (Object)"key")};
        NSArray array = new NSArray(dicts);
        NSDictionary subDict = new NSDictionary((Object)new Integer(2), (Object)"subkey");
        NSDictionary dict = new NSDictionary((Object)subDict, (Object)"key");
        array = new NSArray((Object)dict);
        NSArray values = (NSArray)array.valueForKeyPath("key.subkey");
        NSArrayTest.assertEquals((int)1, (int)values.size());
        NSArrayTest.assertEquals((Object)new Integer(2), (Object)values.objectAtIndex(0));
    }

    public void testNullOperator() {
        try {
            NSArray.emptyArray().valueForKeyPath("@");
            NSArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCountOperator() {
        Object[] dicts = new NSDictionary[]{new NSDictionary((Object)new Integer(2), (Object)"key"), new NSDictionary((Object)new Integer(4), (Object)"key")};
        NSArray array = new NSArray(dicts);
        int count = (Integer)array.valueForKeyPath("@count");
        NSArrayTest.assertEquals((int)2, (int)count);
        count = (Integer)array.valueForKey("@count");
        NSArrayTest.assertEquals((int)2, (int)count);
        count = (Integer)NSArray.emptyArray().valueForKey("@count");
        NSArrayTest.assertEquals((int)0, (int)count);
    }

    public void testSumOperator() {
        Object[] dicts = new NSDictionary[]{new NSDictionary((Object)new Integer(2), (Object)"key"), new NSDictionary((Object)new Integer(4), (Object)"key")};
        NSArray array = new NSArray(dicts);
        BigDecimal sum = (BigDecimal)array.valueForKeyPath("@sum.key");
        NSArrayTest.assertEquals((int)6, (int)sum.intValue());
        sum = (BigDecimal)new NSArray((Object[])new Integer[]{new Integer(1), new Integer(2), new Integer(3)}).valueForKeyPath("@sum");
        NSArrayTest.assertEquals((int)6, (int)sum.intValue());
        sum = (BigDecimal)NSArray.emptyArray().valueForKeyPath("@sum.key");
        NSArrayTest.assertEquals((int)0, (int)sum.intValue());
        sum = (BigDecimal)NSArray.emptyArray().valueForKeyPath("@sum");
        NSArrayTest.assertEquals((int)0, (int)sum.intValue());
        sum = (BigDecimal)NSArray.emptyArray().valueForKeyPath("@sum.");
        NSArrayTest.assertEquals((int)0, (int)sum.intValue());
    }

    public void testAvgOperator() {
        Object[] dicts = new NSDictionary[]{new NSDictionary((Object)new Integer(2), (Object)"key"), new NSDictionary((Object)new Integer(4), (Object)"key")};
        NSArray array = new NSArray(dicts);
        BigDecimal avg = (BigDecimal)array.valueForKeyPath("@avg.key");
        NSArrayTest.assertEquals((int)3, (int)avg.intValue());
        avg = (BigDecimal)array.valueForKeyPath("@avg.unknownkey");
        NSArrayTest.assertEquals((int)0, (int)avg.intValue());
        avg = (BigDecimal)new NSArray((Object[])new Integer[]{new Integer(1), new Integer(2), new Integer(3)}).valueForKeyPath("@avg");
        NSArrayTest.assertEquals((int)2, (int)avg.intValue());
        avg = (BigDecimal)new NSArray((Object[])new String[]{"1", "2", "3"}).valueForKeyPath("@avg");
        NSArrayTest.assertEquals((int)2, (int)avg.intValue());
        avg = (BigDecimal)NSArray.emptyArray().valueForKeyPath("@avg.key");
        NSArrayTest.assertEquals(null, (Object)avg);
        avg = (BigDecimal)NSArray.emptyArray().valueForKeyPath("@avg");
        NSArrayTest.assertEquals(null, (Object)avg);
        try {
            avg = (BigDecimal)array.valueForKeyPath("@avg");
            NSArrayTest.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    public void testMinOperator() {
        Object[] dicts = new NSDictionary[]{new NSDictionary((Object)new Integer(2), (Object)"key"), new NSDictionary((Object)new Integer(4), (Object)"key")};
        NSArray array = new NSArray(dicts);
        int min = (Integer)array.valueForKeyPath("@min.key");
        NSArrayTest.assertEquals((int)2, (int)min);
    }

    public void testMaxOperator() {
        Object[] dicts = new NSDictionary[]{new NSDictionary((Object)new Integer(2), (Object)"key"), new NSDictionary((Object)new Integer(4), (Object)"key")};
        NSArray array = new NSArray(dicts);
        int max = (Integer)array.valueForKeyPath("@max.key");
        NSArrayTest.assertEquals((int)4, (int)max);
    }

    public void testTakeValueForKeyPath() {
        NSMutableDictionary subDict = new NSMutableDictionary((Object)new Integer(2), (Object)"subkey");
        NSMutableDictionary dict = new NSMutableDictionary((Object)subDict, (Object)"key");
        NSArray array = new NSArray((Object)dict);
        array.takeValueForKeyPath((Object)new Integer(3), "key.subkey");
        NSArrayTest.assertEquals((Object)new Integer(3), (Object)subDict.objectForKey((Object)"subkey"));
    }

    public void testVector() {
        Object[] strings = new String[]{"abc", "def"};
        NSArray array = new NSArray(strings);
        Vector vector = array.vector();
        NSArrayTest.assertEquals((int)strings.length, (int)vector.size());
        NSArrayTest.assertEquals((String)strings[0], (String)((String)vector.get(0)));
        NSArrayTest.assertEquals((String)strings[1], (String)((String)vector.get(1)));
    }

    public void testClear() {
        try {
            NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
            array.clear();
            NSArrayTest.fail((String)"Clear should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddObject() {
        try {
            NSArray.emptyArray().add((Object)"abc");
            NSArrayTest.fail((String)"Add should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddIntObject() {
        try {
            NSArray.emptyArray().add(0, (Object)"abc");
            NSArrayTest.fail((String)"Add should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddAllCollection() {
        try {
            List<String> list = Arrays.asList("abc", "def");
            NSArray.emptyArray().addAll(list);
            NSArrayTest.fail((String)"AddAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddAllIntCollection() {
        try {
            List<String> list = Arrays.asList("abc", "def");
            NSArray.emptyArray().addAll(0, list);
            NSArrayTest.fail((String)"AddAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetInt() {
        try {
            NSArray.EmptyArray.get(-1);
            NSArrayTest.fail((String)"Get should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            NSArray.EmptyArray.get(1);
            NSArrayTest.fail((String)"Get should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testRemoveInt() {
        try {
            NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
            array.remove(0);
            NSArrayTest.fail((String)"Remove should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveObject() {
        try {
            NSArray array = new NSArray((Object[])new String[]{"abc", "def"});
            array.remove((Object)"abc");
            NSArrayTest.fail((String)"Remove should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveAllCollection() {
        try {
            List<String> list = Arrays.asList("abc", "def");
            NSArray array = new NSArray(list);
            array.removeAll(list);
            NSArrayTest.fail((String)"RemoveAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRetainAllCollection() {
        try {
            List<String> list = Arrays.asList("abc", "def");
            NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi"});
            array.retainAll(list);
            NSArrayTest.fail((String)"RetainAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSetIntObjectInvalid() {
        try {
            new NSArray((Object)"abc").set(0, (Object)"def");
            NSArrayTest.fail((String)"Set should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            new NSArray((Object)"abc").set(-1, (Object)"def");
            NSArrayTest.fail((String)"Set should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            new NSArray((Object)"abc").set(2, (Object)"def");
            NSArrayTest.fail((String)"Set should throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testComponentsSeparatedByString() {
        NSArray array = NSArray.componentsSeparatedByString((String)"", (String)"|");
        NSArrayTest.assertEquals((int)0, (int)array.count());
        array = NSArray.componentsSeparatedByString(null, (String)"|");
        NSArrayTest.assertEquals((int)0, (int)array.count());
        String string = prefix;
        array = NSArray.componentsSeparatedByString((String)string, (String)"");
        NSArrayTest.assertEquals((int)1, (int)array.count());
        array = NSArray.componentsSeparatedByString((String)string, null);
        NSArrayTest.assertEquals((int)1, (int)array.count());
        array = NSArray.componentsSeparatedByString((String)string, (String)"X");
        NSArrayTest.assertEquals((int)1, (int)array.count());
        string = "0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|||||X";
        array = NSArray.componentsSeparatedByString((String)string, (String)"|");
        NSArrayTest.assertEquals((int)255, (int)string.length());
        NSArrayTest.assertEquals((int)10, (int)array.count());
        NSArrayTest.assertEquals((String)"X", (String)((String)array.objectAtIndex(9)));
        string = "0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678||||||";
        array = NSArray.componentsSeparatedByString((String)string, (String)"|");
        NSArrayTest.assertEquals((int)255, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(10)));
        string = "0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|X|||||";
        array = NSArray.componentsSeparatedByString((String)string, (String)"|");
        NSArrayTest.assertEquals((int)256, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(10)));
        NSArrayTest.assertEquals((String)"X", (String)((String)array.objectAtIndex(5)));
        string = "0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|||||X|";
        array = NSArray.componentsSeparatedByString((String)string, (String)"|");
        NSArrayTest.assertEquals((int)256, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(10)));
        NSArrayTest.assertEquals((String)"X", (String)((String)array.objectAtIndex(9)));
        string = "0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678|0123456789012345678901234567890123456789012345678||||||X";
        array = NSArray.componentsSeparatedByString((String)string, (String)"|");
        NSArrayTest.assertEquals((int)256, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(9)));
        NSArrayTest.assertEquals((String)"X", (String)((String)array.objectAtIndex(10)));
        string = "01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||X|||||||||";
        array = NSArray.componentsSeparatedByString((String)string, (String)"||");
        NSArrayTest.assertEquals((int)255, (int)string.length());
        NSArrayTest.assertEquals((int)10, (int)array.count());
        NSArrayTest.assertEquals((String)"|", (String)((String)array.objectAtIndex(9)));
        string = "01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||||||||||||";
        array = NSArray.componentsSeparatedByString((String)string, (String)"||");
        NSArrayTest.assertEquals((int)255, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(10)));
        string = "01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||X||||||||||";
        array = NSArray.componentsSeparatedByString((String)string, (String)"||");
        NSArrayTest.assertEquals((int)256, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(10)));
        NSArrayTest.assertEquals((String)"X", (String)((String)array.objectAtIndex(5)));
        string = "01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||||||||||X||";
        array = NSArray.componentsSeparatedByString((String)string, (String)"||");
        NSArrayTest.assertEquals((int)256, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(10)));
        NSArrayTest.assertEquals((String)"X", (String)((String)array.objectAtIndex(9)));
        string = "01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||01234567890123456789012345678901234567890123456||||||||||||X";
        array = NSArray.componentsSeparatedByString((String)string, (String)"||");
        NSArrayTest.assertEquals((int)256, (int)string.length());
        NSArrayTest.assertEquals((int)11, (int)array.count());
        NSArrayTest.assertEquals((String)"", (String)((String)array.objectAtIndex(9)));
        NSArrayTest.assertEquals((String)"X", (String)((String)array.objectAtIndex(10)));
    }

    public void testComponentsSeparatedByStringNull() {
        NSArray array = NSArray.componentsSeparatedByString((String)"a,b,c", null);
        NSArrayTest.assertEquals(new NSArray((Object[])new String[]{"a,b,c"}), array);
    }

    public void test_MutableComponentsSeparatedByString() {
        NSMutableArray array = NSArray._mutableComponentsSeparatedByString((String)"a,b,c", (String)",");
        array.add((Object)"d");
        NSArrayTest.assertEquals(array, new NSArray((Object[])new String[]{"a", "b", "c", "d"}));
        array = NSArray._mutableComponentsSeparatedByString((String)"a||b||c", (String)"||");
        array.add((Object)"d");
        NSArrayTest.assertEquals(new NSArray((Object[])new String[]{"a", "b", "c", "d"}), array);
    }

    public void testIterator() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi"});
        Iterator i = array.iterator();
        NSArrayTest.assertTrue((boolean)i.hasNext());
        NSMutableArray array2 = new NSMutableArray();
        while (i.hasNext()) {
            array2.add(i.next());
        }
        NSArrayTest.assertEquals(array, array2);
    }

    public void testIteratorInvalid() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi"});
        Iterator i = array.iterator();
        i.next();
        try {
            i.remove();
            NSArrayTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToArray() {
        Object[] str = new String[]{"abc", "def", "ghi"};
        NSArray array = new NSArray(str);
        Object[] array2 = array.toArray();
        NSArrayTest.assertEquals(str, array2);
        array2[0] = "xyz";
        NSArrayTest.assertEquals((String)"abc", (String)((String)array.objectAtIndex(0)));
    }

    public void testToArrayTArray() {
        Object[] str = new String[]{"abc", "def", "ghi"};
        NSArray array = new NSArray(str);
        Object[] array2 = array.toArray((Object[])new String[array.size()]);
        NSArrayTest.assertEquals(str, array2);
        array2[0] = "xyz";
        NSArrayTest.assertEquals((String)str[0], (String)((String)array.objectAtIndex(0)));
        try {
            array2[0] = new Object();
            NSArrayTest.fail((String)"ArrayStoreException expected");
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
        array2 = array.toArray((Object[])new String[0]);
        NSArrayTest.assertEquals(str, array2);
    }

    public void testToArrayTArrayNull() {
        Object[] str = new String[]{"abc", "def", "ghi"};
        NSArray array = new NSArray(str);
        try {
            array.toArray(null);
            NSArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static class TestSelectable {
        public ArrayList<String> array = new ArrayList();

        public void invoke(String value) {
            this.array.add(value);
        }

        public void invoke() {
            this.array.add("invoked");
        }
    }
}

