/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSTimestamp;
import er.erxtest.ERXTestCase;
import java.util.ArrayList;
import java.util.List;

public class NSMutableArrayTest
extends ERXTestCase {
    public void testNSMutableArray() {
        NSMutableArray array = new NSMutableArray();
        NSMutableArrayTest.assertTrue((boolean)array.isEmpty());
    }

    public void testNSMutableArrayE() {
        NSMutableArray array = new NSMutableArray((Object)"abc");
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testNSMutableArrayEArray() {
        Object[] str = new String[]{"abc", "def"};
        NSMutableArray array = new NSMutableArray(str);
        NSMutableArrayTest.assertEquals((int)2, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array.get(1)));
    }

    public void testNSMutableArrayEArrayNSRange() {
        Object[] str = new String[]{"abc", "def"};
        NSRange range = new NSRange(1, 1);
        NSMutableArray array = new NSMutableArray(str, range);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array.get(0)));
    }

    public void testNSMutableArrayNSArrayOfQextendsE() {
        NSMutableArray array = new NSMutableArray((Object)"abc");
        NSMutableArray array2 = new NSMutableArray((NSArray)array);
        NSMutableArrayTest.assertEquals((int)1, (int)array2.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array2.get(0)));
    }

    public void testNSMutableArrayCollectionOfQextendsE() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("abc");
        list.add("def");
        NSArray array = new NSArray(list);
        NSMutableArrayTest.assertEquals((int)2, (int)array.size());
        list.add(null);
        try {
            array = new NSArray(list);
            NSMutableArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNSMutableArrayInt() {
        NSMutableArray array = new NSMutableArray(2);
        NSMutableArrayTest.assertTrue((boolean)array.isEmpty());
    }

    public void testNSMutableArrayListOfQextendsENSRangeBoolean() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("abc");
        list.add(null);
        list.add("def");
        NSRange range = new NSRange(1, 2);
        NSArray array = new NSArray(list, range, true);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        try {
            array = new NSArray(list, range, false);
            NSMutableArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testAddObjectArg() {
        NSMutableArray array = new NSMutableArray();
        array.add((Object)"abc");
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testAddIntObject() {
        NSMutableArray array = new NSMutableArray((Object)"abc");
        array.add(0, (Object)"def");
        NSMutableArrayTest.assertEquals((int)2, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array.get(0)));
    }

    public void testAddAllCollection() {
        NSMutableArray array = new NSMutableArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("abc");
        arrayList.add("def");
        array.addAll(arrayList);
        NSMutableArrayTest.assertEquals((int)2, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testAddAllIntCollection() {
        NSMutableArray array = new NSMutableArray((Object)"ghi");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("abc");
        arrayList.add("def");
        array.addAll(0, arrayList);
        NSMutableArrayTest.assertEquals((int)3, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testAddObject() {
        NSMutableArray array = new NSMutableArray();
        array.addObject((Object)"abc");
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testAddObjects() {
        NSMutableArray array = new NSMutableArray();
        Object[] strings = new String[]{"abc", "def"};
        array.addObjects(strings);
        NSMutableArrayTest.assertEquals((int)2, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testAddObjectsFromArray() {
        NSMutableArray array = new NSMutableArray();
        NSMutableArray otherArray = new NSMutableArray();
        otherArray.add((Object)"abc");
        otherArray.add((Object)"def");
        array.addObjectsFromArray((NSArray)otherArray);
        NSMutableArrayTest.assertEquals((int)2, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testClear() {
        NSMutableArray array = new NSMutableArray((Object)"abc");
        NSMutableArrayTest.assertFalse((boolean)array.isEmpty());
        array.clear();
        NSMutableArrayTest.assertTrue((boolean)array.isEmpty());
    }

    public void testClone() {
        NSMutableArray array = new NSMutableArray((Object)"abc");
        NSMutableArray clone = (NSMutableArray)array.clone();
        NSMutableArrayTest.assertEquals(array, clone);
    }

    public void testImmutableClone() {
        NSMutableArray array = new NSMutableArray((Object)"abc");
        NSArray clone = array.immutableClone();
        NSMutableArrayTest.assertEquals(NSArray.class, clone.getClass());
        NSMutableArrayTest.assertEquals(array, clone);
    }

    public void testRemoveInt() {
        NSMutableArray array = new NSMutableArray();
        array.add((Object)"abc");
        array.add((Object)"def");
        array.remove(0);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array.get(0)));
    }

    public void testRemoveObject() {
        NSMutableArray array = new NSMutableArray();
        array.add((Object)"abc");
        array.add((Object)"def");
        array.removeObject((Object)"abc");
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array.get(0)));
    }

    public void testRemoveAllCollection() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("abc");
        arrayList.add("def");
        array.removeAll(arrayList);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"ghi", (String)((String)array.get(0)));
    }

    public void testRetainAllCollection() {
        NSMutableArray array = new NSMutableArray();
        array.add((Object)"abc");
        array.add((Object)"def");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("abc");
        array.retainAll(arrayList);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testSetIntObject() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        array.set(0, (Object)"123");
        NSMutableArrayTest.assertEquals((String)"123", (String)((String)array.get(0)));
    }

    public void testInsertObjectAtIndex() {
        NSMutableArray array = new NSMutableArray((Object)"def");
        array.insertObjectAtIndex((Object)"abc", 0);
        NSMutableArrayTest.assertEquals((int)2, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveAllObjects() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        NSMutableArrayTest.assertFalse((boolean)array.isEmpty());
        array.removeAllObjects();
        NSMutableArrayTest.assertTrue((boolean)array.isEmpty());
    }

    public void testRemoveIdenticalObjectObject() {
        String def = "def";
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", def});
        array.removeIdenticalObject((Object)def);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveIdenticalObjectObjectNSRange() {
        String def = "def";
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", def});
        NSRange range = new NSRange(1, 1);
        array.removeIdenticalObject((Object)def, range);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveLastObject() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def"});
        array.removeLastObject();
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveObjectObject() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def"});
        array.removeObject((Object)"def");
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveObjectObjectNSRange() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def"});
        NSRange range = new NSRange(1, 1);
        array.removeObject((Object)"def", range);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveObjectAtIndex() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def"});
        array.removeObjectAtIndex(1);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveObjects() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        String[] strings = new String[]{"def", "ghi"};
        array.removeObjects((Object[])strings);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveObjectsInArray() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        NSArray strings = new NSArray((Object[])new String[]{"def", "ghi"});
        array.removeObjectsInArray(strings);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testRemoveObjectsInRange() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        NSRange range = new NSRange(1, 2);
        array.removeObjectsInRange(range);
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testReplaceObjectAtIndexEInt() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        array.replaceObjectAtIndex(0, (Object)"123");
        NSMutableArrayTest.assertEquals((String)"123", (String)((String)array.get(0)));
    }

    public void testReplaceObjectAtIndexIntE() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        array.replaceObjectAtIndex((Object)"123", 0);
        NSMutableArrayTest.assertEquals((String)"123", (String)((String)array.get(0)));
    }

    public void testReplaceObjectsInRange() {
        NSArray array = new NSArray((Object[])new String[]{"abc", "def", "ghi"});
        NSArray array2 = new NSArray((Object[])new String[]{"123", "456"});
        NSRange sourceRange = new NSRange(1, 2);
        NSRange otherRange = new NSRange(0, 2);
        NSMutableArray array3 = array.mutableClone();
        array3.replaceObjectsInRange(sourceRange, array2, otherRange);
        NSMutableArrayTest.assertEquals((int)3, (int)array3.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array3.get(0)));
        NSMutableArrayTest.assertEquals((String)"123", (String)((String)array3.get(1)));
        NSMutableArrayTest.assertEquals((String)"456", (String)((String)array3.get(2)));
        array3 = array.mutableClone();
        sourceRange = new NSRange(0, 3);
        otherRange = new NSRange(0, 2);
        array3.replaceObjectsInRange(sourceRange, array2, otherRange);
        NSMutableArrayTest.assertEquals((int)2, (int)array3.size());
        NSMutableArrayTest.assertEquals(array2, array3);
        array3 = array.mutableClone();
        sourceRange = new NSRange(2, 1);
        otherRange = new NSRange(0, 2);
        array3.replaceObjectsInRange(sourceRange, array2, otherRange);
        NSMutableArrayTest.assertEquals((int)4, (int)array3.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array3.get(0)));
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array3.get(1)));
        NSMutableArrayTest.assertEquals((String)"123", (String)((String)array3.get(2)));
        NSMutableArrayTest.assertEquals((String)"456", (String)((String)array3.get(3)));
    }

    public void testSetArray() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi"});
        array.setArray(new NSArray((Object)"abc"));
        NSMutableArrayTest.assertEquals((int)1, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
    }

    public void testSubList() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi", "jkl"});
        List sublist = array.subList(2, 4);
        NSMutableArrayTest.assertEquals((int)2, (int)sublist.size());
        NSMutableArrayTest.assertEquals((String)"ghi", (String)((String)sublist.get(0)));
    }

    public void testSubListAdd() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi", "jkl"});
        List sublist = array.subList(1, 3);
        NSMutableArrayTest.assertEquals((int)2, (int)sublist.size());
        sublist.add("mno");
        NSMutableArrayTest.assertEquals((int)3, (int)sublist.size());
        NSMutableArrayTest.assertEquals((String)"mno", (String)((String)sublist.get(2)));
        NSMutableArrayTest.assertEquals((int)5, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"mno", (String)((String)array.get(3)));
        NSMutableArrayTest.assertEquals((String)"jkl", (String)((String)array.get(4)));
    }

    public void testSubListAddNull() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi", "jkl"});
        List sublist = array.subList(1, 3);
        try {
            sublist.add(null);
            NSMutableArrayTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubListRemove() {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def", "ghi", "jkl", "ghi"});
        List sublist = array.subList(2, 4);
        sublist.remove("ghi");
        NSMutableArrayTest.assertEquals((int)1, (int)sublist.size());
        NSMutableArrayTest.assertEquals((int)4, (int)array.size());
        NSMutableArrayTest.assertEquals((String)"jkl", (String)((String)sublist.get(0)));
        NSMutableArrayTest.assertEquals((String)"ghi", (String)((String)array.objectAtIndex(3)));
        try {
            sublist.remove(null);
            NSMutableArrayTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSortUsingComparator() throws NSComparator.ComparisonException {
        NSMutableArray array = new NSMutableArray((Object[])new String[]{"abc", "def"});
        array.sortUsingComparator(NSComparator.AscendingStringComparator);
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array.get(1)));
        array.sortUsingComparator(NSComparator.DescendingStringComparator);
        NSMutableArrayTest.assertEquals((String)"def", (String)((String)array.get(0)));
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(1)));
        array = new NSMutableArray((Object[])new String[]{"abc", "DEF"});
        array.sortUsingComparator(NSComparator.AscendingCaseInsensitiveStringComparator);
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(0)));
        NSMutableArrayTest.assertEquals((String)"DEF", (String)((String)array.get(1)));
        array.sortUsingComparator(NSComparator.DescendingCaseInsensitiveStringComparator);
        NSMutableArrayTest.assertEquals((String)"DEF", (String)((String)array.get(0)));
        NSMutableArrayTest.assertEquals((String)"abc", (String)((String)array.get(1)));
        NSMutableArray intarray = new NSMutableArray((Object[])new Integer[]{new Integer(1), new Integer(2)});
        intarray.sortUsingComparator(NSComparator.AscendingNumberComparator);
        NSMutableArrayTest.assertEquals((Object)1, (Object)intarray.get(0));
        NSMutableArrayTest.assertEquals((Object)2, (Object)intarray.get(1));
        intarray.sortUsingComparator(NSComparator.DescendingNumberComparator);
        NSMutableArrayTest.assertEquals((Object)2, (Object)intarray.get(0));
        NSMutableArrayTest.assertEquals((Object)1, (Object)intarray.get(1));
        NSTimestamp earlierTime = new NSTimestamp();
        NSTimestamp laterTime = earlierTime.timestampByAddingGregorianUnits(0, 1, 0, 0, 0, 0);
        NSMutableArray timearray = new NSMutableArray((Object[])new NSTimestamp[]{earlierTime, laterTime});
        timearray.sortUsingComparator(NSComparator.AscendingTimestampComparator);
        NSMutableArrayTest.assertEquals((Object)earlierTime, (Object)timearray.get(0));
        NSMutableArrayTest.assertEquals((Object)laterTime, (Object)timearray.get(1));
        timearray.sortUsingComparator(NSComparator.DescendingTimestampComparator);
        NSMutableArrayTest.assertEquals((Object)laterTime, (Object)timearray.get(0));
        NSMutableArrayTest.assertEquals((Object)earlierTime, (Object)timearray.get(1));
    }

    public void testTakeValueForKey() {
        Object[] dicts = new NSDictionary[]{new NSMutableDictionary((Object)"val1", (Object)"key"), new NSMutableDictionary((Object)"val2", (Object)"key")};
        NSArray array = new NSArray(dicts);
        array.takeValueForKey((Object)"val3", "key3");
        NSDictionary dict1 = (NSDictionary)array.get(0);
        NSDictionary dict2 = (NSDictionary)array.get(1);
        NSMutableArrayTest.assertEquals((Object)"val3", (Object)dict1.objectForKey((Object)"key3"));
        NSMutableArrayTest.assertEquals((Object)"val3", (Object)dict2.objectForKey((Object)"key3"));
    }
}

