/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.erxtest.ERXTestCase;
import java.util.HashMap;

public class NSMutableDictionaryTest
extends ERXTestCase {
    public void testNSMutableDictionary() {
        NSMutableDictionary dict = new NSMutableDictionary();
        NSMutableDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testNSMutableDictionaryInt() {
        NSMutableDictionary dict = new NSMutableDictionary(5);
        NSMutableDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testNSMutableDictionaryMapOfKV() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        NSMutableDictionary dict = new NSMutableDictionary(map);
        NSMutableDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testNSMutableDictionaryNSArrayOfVNSArrayOfK() {
        NSArray keys = new NSArray((Object[])new String[]{"key1", "key2"});
        NSArray values = new NSArray((Object[])new String[]{"value1", "value2"});
        NSMutableDictionary dict = new NSMutableDictionary(values, keys);
        NSMutableDictionaryTest.assertEquals((String)"value1", (String)((String)dict.get((Object)"key1")));
        NSMutableDictionaryTest.assertEquals((String)"value2", (String)((String)dict.get((Object)"key2")));
    }

    public void testNSMutableDictionaryNSMutableDictionaryOfKV() {
        NSMutableDictionary mutableDict = new NSMutableDictionary((Object)"value", (Object)"key");
        NSMutableDictionary dict = new NSMutableDictionary((NSDictionary)mutableDict);
        NSMutableDictionaryTest.assertFalse((boolean)dict.isEmpty());
        mutableDict.put((Object)"key", (Object)"newValue");
        NSMutableDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testNSMutableDictionaryVArrayKArray() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSMutableDictionary dict = new NSMutableDictionary(values, keys);
        NSMutableDictionaryTest.assertEquals((String)"value1", (String)((String)dict.get((Object)"key1")));
        NSMutableDictionaryTest.assertEquals((String)"value2", (String)((String)dict.get((Object)"key2")));
    }

    public void testNSMutableDictionaryVK() {
        NSMutableDictionary dict = new NSMutableDictionary((Object)"value", (Object)"key");
        NSMutableDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testPutObjectObject() {
        NSMutableDictionary dict = new NSMutableDictionary();
        dict.put((Object)"key", (Object)"value");
        NSMutableDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testSetObjectForKey() {
        NSMutableDictionary dict = new NSMutableDictionary();
        dict.setObjectForKey((Object)"value", (Object)"key");
        NSMutableDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
    }

    public void testPutAllMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        map.put("key2", "value2");
        NSMutableDictionary dict = new NSMutableDictionary();
        dict.putAll(map);
        NSMutableDictionaryTest.assertEquals((String)"value", (String)((String)dict.get((Object)"key")));
        NSMutableDictionaryTest.assertEquals((String)"value2", (String)((String)dict.get((Object)"key2")));
    }

    public void testAddEntriesFromDictionary() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSMutableDictionary mutableDict = new NSMutableDictionary();
        mutableDict.addEntriesFromDictionary(dict);
        NSMutableDictionaryTest.assertEquals((String)"value1", (String)((String)dict.get((Object)"key1")));
        NSMutableDictionaryTest.assertEquals((String)"value2", (String)((String)dict.get((Object)"key2")));
    }

    public void testRemoveObject() {
        NSMutableDictionary dict = new NSMutableDictionary((Object)"value", (Object)"key");
        dict.remove((Object)"key");
        NSMutableDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testClear() {
        NSMutableDictionary dict = new NSMutableDictionary((Object)"value", (Object)"key");
        dict.clear();
        NSMutableDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testRemoveAllObjects() {
        NSMutableDictionary dict = new NSMutableDictionary((Object)"value", (Object)"key");
        dict.removeAllObjects();
        NSMutableDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testRemoveObjectForKey() {
        NSMutableDictionary dict = new NSMutableDictionary((Object)"value", (Object)"key");
        dict.removeObjectForKey((Object)"key");
        NSMutableDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testRemoveObjectsForKeys() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSMutableDictionary dict = new NSMutableDictionary(values, keys);
        dict.removeObjectsForKeys(new NSArray((Object[])new String[]{"key1", "key2"}));
        NSMutableDictionaryTest.assertTrue((boolean)dict.isEmpty());
    }

    public void testSetDictionary() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSMutableDictionary dict = new NSMutableDictionary(values, keys);
        dict.setDictionary(new NSDictionary((Object)"value3", (Object)"key3"));
        NSMutableDictionaryTest.assertEquals((String)"value3", (String)((String)dict.get((Object)"key3")));
    }

    public void testImmutableClone() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSDictionary dict = new NSDictionary(values, keys);
        NSDictionary clone = dict.immutableClone();
        NSMutableDictionaryTest.assertEquals(NSDictionary.class, clone.getClass());
        NSMutableDictionaryTest.assertEquals((Object)clone, (Object)dict);
    }

    public void testClone() {
        Object[] keys = new String[]{"key1", "key2"};
        Object[] values = new String[]{"value1", "value2"};
        NSMutableDictionary dict = new NSMutableDictionary(values, keys);
        NSMutableDictionary clone = (NSMutableDictionary)dict.clone();
        NSMutableDictionaryTest.assertEquals(NSMutableDictionary.class, clone.getClass());
        NSMutableDictionaryTest.assertEquals((Object)clone, (Object)dict);
    }

    public void testTakeValueForKeyPath() {
        NSMutableDictionary dict = new NSMutableDictionary((Object)"value", (Object)"key");
        dict.takeValueForKeyPath((Object)"newValue", "key");
        NSMutableDictionaryTest.assertEquals((String)"newValue", (String)((String)dict.get((Object)"key")));
        NSMutableDictionary subDict = new NSMutableDictionary((Object)"value", (Object)"path");
        NSDictionary dict2 = new NSDictionary((Object)subDict, (Object)"key");
        dict2.takeValueForKeyPath((Object)"newValue", "key.path");
        NSMutableDictionaryTest.assertEquals((Object)"newValue", (Object)dict2.valueForKeyPath("key.path"));
    }

    public void testTakeValueForKey() {
        NSMutableDictionary dict = new NSMutableDictionary((Object)"value", (Object)"key");
        dict.takeValueForKey((Object)"newValue", "key");
        NSMutableDictionaryTest.assertEquals((String)"newValue", (String)((String)dict.get((Object)"key")));
    }
}

