/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import er.erxtest.ERXTestCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class NSMutableSetTest
extends ERXTestCase {
    public void testNSMutableSet() {
        NSMutableSet set = new NSMutableSet();
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testNSMutableSetCollectionOfQextendsE() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("abc");
        list.add("abc");
        NSMutableSet set = new NSMutableSet(list);
        NSMutableSetTest.assertEquals((int)1, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSMutableSetE() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSMutableSetEArray() {
        Object[] strings = new String[]{"abc", "abc"};
        NSMutableSet set = new NSMutableSet(strings);
        NSMutableSetTest.assertEquals((int)1, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSMutableSetInt() {
        NSMutableSet set = new NSMutableSet(1);
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testNSMutableSetNSArrayOfQextendsE() {
        NSMutableArray list = new NSMutableArray();
        list.add((Object)"abc");
        list.add((Object)"abc");
        NSMutableSet set = new NSMutableSet((NSArray)list);
        NSMutableSetTest.assertEquals((int)1, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSMutableSetNSSetOfQextendsE() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        NSMutableSet copy = new NSMutableSet((NSSet)set);
        NSMutableSetTest.assertEquals((int)1, (int)copy.size());
        NSMutableSetTest.assertTrue((boolean)copy.contains((Object)"abc"));
    }

    public void testNSMutableSetSetOfQextendsEBoolean() {
        HashSet<String> source = new HashSet<String>();
        source.add("abc");
        source.add(null);
        NSMutableSet set = new NSMutableSet(source, true);
        NSMutableSetTest.assertEquals((int)1, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
        try {
            set = new NSMutableSet(source, false);
            NSMutableSetTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddObject() {
        NSMutableSet set = new NSMutableSet();
        set.addObject((Object)"abc");
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testAddObjectsFromArray() {
        NSMutableArray list = new NSMutableArray();
        list.add((Object)"abc");
        list.add((Object)"abc");
        NSMutableSet set = new NSMutableSet();
        set.addObjectsFromArray((NSArray)list);
        NSMutableSetTest.assertEquals((int)1, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testRemoveAllObjects() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        set.removeAllObjects();
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testRemoveObject() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        Object removed = set.removeObject((Object)"abc");
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
        NSMutableSetTest.assertEquals((Object)"abc", (Object)removed);
    }

    public void testSubtractSet() {
        NSMutableSet otherSet = new NSMutableSet();
        otherSet.add((Object)"abc");
        otherSet.add((Object)"123");
        NSMutableSet set = new NSMutableSet((Object)"abc");
        set.subtractSet((NSSet)otherSet);
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testUnionSet() {
        NSMutableSet otherSet = new NSMutableSet();
        otherSet.add((Object)"abc");
        otherSet.add((Object)"123");
        NSMutableSet set = new NSMutableSet((Object)"abc");
        set.unionSet((NSSet)otherSet);
        NSMutableSetTest.assertEquals((int)2, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"123"));
    }

    public void testSetSet() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        NSMutableSet otherSet = new NSMutableSet((Object)"123");
        otherSet.add((Object)"def");
        set.setSet((NSSet)otherSet);
        NSMutableSetTest.assertEquals(otherSet, set);
    }

    public void testClone() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        NSMutableSet clone = (NSMutableSet)set.clone();
        NSMutableSetTest.assertEquals(set, clone);
        NSMutableSetTest.assertNotSame((Object)set, (Object)clone);
    }

    public void testImmutableClone() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        NSSet clone = set.immutableClone();
        NSMutableSetTest.assertEquals((int)1, (int)clone.size());
        NSMutableSetTest.assertTrue((boolean)clone.contains((Object)"abc"));
        NSMutableSetTest.assertNotSame((Object)set, (Object)clone);
        NSMutableSetTest.assertEquals(NSSet.class, clone.getClass());
    }

    public void testClear() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        set.clear();
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testAdd() {
        NSMutableSet set = new NSMutableSet();
        set.add((Object)"abc");
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testAddAllCollection() {
        NSMutableArray list = new NSMutableArray();
        list.add((Object)"abc");
        list.add((Object)"abc");
        NSMutableSet set = new NSMutableSet();
        set.addAll((Collection)list);
        NSMutableSetTest.assertEquals((int)1, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testRemove() {
        NSMutableSet set = new NSMutableSet((Object)"abc");
        boolean removed = set.remove((Object)"abc");
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
        NSMutableSetTest.assertTrue((boolean)removed);
    }

    public void testRemoveAllCollection() {
        NSMutableArray list = new NSMutableArray();
        list.add((Object)"abc");
        list.add((Object)"123");
        NSMutableSet set = new NSMutableSet();
        set.addAll((Collection)list);
        set.removeAll((Collection)list);
        NSMutableSetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testRetainAllCollection() {
        NSMutableArray list = new NSMutableArray();
        list.add((Object)"abc");
        list.add((Object)"123");
        NSMutableSet set = new NSMutableSet();
        set.addAll((Collection)list);
        list.remove((Object)"123");
        set.retainAll((Collection)list);
        NSMutableSetTest.assertEquals((int)1, (int)set.size());
        NSMutableSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }
}

