/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import er.erxtest.ERXTestCase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class NSSetTest
extends ERXTestCase {
    public void testNSSet() {
        NSSet set = new NSSet();
        NSSetTest.assertTrue((boolean)set.isEmpty());
        NSSetTest.assertEquals((int)0, (int)set.size());
    }

    public void testNSSetCollectionOfQextendsE() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("abc");
        list.add("abc");
        NSSet set = new NSSet(list);
        NSSetTest.assertEquals((int)1, (int)set.size());
        NSSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSSetE() {
        NSSet set = new NSSet((Object)"abc");
        NSSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSSetEArray() {
        Object[] strings = new String[]{"abc", "abc"};
        NSSet set = new NSSet(strings);
        NSSetTest.assertEquals((int)1, (int)set.size());
        NSSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSSetNSArrayOfQextendsE() {
        NSMutableArray list = new NSMutableArray();
        list.add((Object)"abc");
        list.add((Object)"abc");
        NSSet set = new NSSet((NSArray)list);
        NSSetTest.assertEquals((int)1, (int)set.size());
        NSSetTest.assertTrue((boolean)set.contains((Object)"abc"));
    }

    public void testNSSetNSSetOfQextendsE() {
        NSSet set = new NSSet((Object)"abc");
        NSSet copy = new NSSet(set);
        NSSetTest.assertEquals((int)1, (int)copy.size());
        NSSetTest.assertTrue((boolean)copy.contains((Object)"abc"));
    }

    public void testNSSetSetOfQextendsEBoolean() {
        NSSet source = new HashSet();
        source.add("abc");
        source.add(null);
        NSSet set = new NSSet(source, true);
        NSSetTest.assertEquals((int)1, (int)set.size());
        NSSetTest.assertTrue((boolean)set.contains((Object)"abc"));
        try {
            set = new NSSet(source, false);
            NSSetTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        source = new NSSet((Object[])new String[]{"abc", "def"});
        set = new NSSet((Set)source, false);
        NSSetTest.assertEquals(source, set);
    }

    public void testAllObjects() {
        NSSet set = new NSSet((Object[])new String[]{"abc", "123"});
        NSArray allObjects = set.allObjects();
        NSSetTest.assertEquals((int)2, (int)allObjects.size());
        NSSetTest.assertTrue((boolean)allObjects.contains((Object)"abc"));
        NSSetTest.assertTrue((boolean)allObjects.contains((Object)"123"));
    }

    public void testAnyObject() {
        NSSet set = new NSSet((Object)"abc");
        Object object = set.anyObject();
        NSSetTest.assertEquals((Object)"abc", (Object)object);
    }

    public void testContainsObject() {
        NSSet set = new NSSet((Object)"abc");
        NSSetTest.assertTrue((boolean)set.containsObject((Object)"abc"));
        NSSetTest.assertFalse((boolean)set.containsObject((Object)"123"));
    }

    public void testCount() {
        NSSet set = new NSSet((Object)"abc");
        NSSetTest.assertEquals((int)1, (int)set.count());
        set = new NSSet((Object[])new String[]{"abc", "123", "abc"});
        NSSetTest.assertEquals((int)2, (int)set.count());
    }

    public void testEmptySet() {
        NSSet set = NSSet.emptySet();
        NSSetTest.assertTrue((boolean)set.isEmpty());
    }

    public void testHashSet() {
        NSSet set = new NSSet((Object)"abc");
        HashSet hashSet = set.hashSet();
        NSSetTest.assertEquals((int)1, (int)hashSet.size());
        NSSetTest.assertTrue((boolean)hashSet.contains("abc"));
    }

    public void testClone() {
        NSSet set = new NSSet((Object[])new String[]{"abc", "123"});
        NSSet clone = (NSSet)set.clone();
        NSSetTest.assertEquals(set, clone);
    }

    public void testImmutableClone() {
        NSSet set = new NSSet((Object[])new String[]{"abc", "123"});
        NSSet clone = set.immutableClone();
        NSSetTest.assertEquals(set, clone);
        NSSetTest.assertEquals(NSSet.class, clone.getClass());
    }

    public void testMutableClone() {
        NSSet set = new NSSet((Object)"abc");
        NSMutableSet clone = set.mutableClone();
        NSSetTest.assertEquals((int)1, (int)clone.size());
        NSSetTest.assertTrue((boolean)clone.contains((Object)"abc"));
    }

    public void testIntersectsSet() {
        NSSet set = new NSSet((Object[])new String[]{"abc", "123"});
        NSSet set2 = new NSSet((Object)"abc");
        NSSetTest.assertTrue((boolean)set.intersectsSet(set2));
        NSSet set3 = new NSSet((Object)"def");
        NSSetTest.assertFalse((boolean)set.intersectsSet(set3));
    }

    public void testIsEqualToSet() {
        NSSet set = new NSSet((Object[])new String[]{"abc", "123"});
        NSSet set2 = new NSSet((Object[])new String[]{"abc", "123"});
        NSSetTest.assertTrue((boolean)set.isEqualToSet(set2));
        NSSet set3 = new NSSet((Object)"abc");
        NSSetTest.assertFalse((boolean)set.isEqualToSet(set3));
    }

    public void testIsSubsetOfSet() {
        NSSet set = new NSSet((Object)"abc");
        NSSet set2 = new NSSet((Object[])new String[]{"abc", "123"});
        NSSetTest.assertTrue((boolean)set.isSubsetOfSet(set2));
        NSSetTest.assertFalse((boolean)set2.isSubsetOfSet(set));
        NSSet set3 = new NSSet((Object)"def");
        NSSetTest.assertFalse((boolean)set.isSubsetOfSet(set3));
    }

    public void testMember() {
        NSSet set = new NSSet((Object)"abc");
        NSSetTest.assertTrue((boolean)((String)set.member((Object)"abc")).equals("abc"));
        NSSetTest.assertFalse((set.member((Object)"123") != null ? 1 : 0) != 0);
    }

    public void testSetByIntersectingSet() {
        NSSet set = new NSSet((Object)"abc");
        NSSet set2 = new NSSet((Object[])new String[]{"abc", "123"});
        NSSet intersection = set.setByIntersectingSet(set2);
        NSSetTest.assertEquals((int)1, (int)intersection.size());
        NSSetTest.assertTrue((boolean)intersection.contains((Object)"abc"));
        set2 = new NSSet((Object)"123");
        intersection = set.setByIntersectingSet(set2);
        NSSetTest.assertTrue((boolean)intersection.isEmpty());
    }

    public void testSetBySubtractingSet() {
        NSSet set = new NSSet((Object[])new String[]{"abc", "123"});
        NSSet set2 = new NSSet((Object)"123");
        NSSet difference = set.setBySubtractingSet(set2);
        NSSetTest.assertEquals((int)1, (int)difference.size());
        NSSetTest.assertTrue((boolean)difference.contains((Object)"abc"));
        set2 = new NSSet((Object)"def");
        difference = set.setBySubtractingSet(set2);
        NSSetTest.assertEquals(set, difference);
    }

    public void testSetByUnioningSet() {
        NSSet set = new NSSet((Object[])new String[]{"abc", "123"});
        NSSet set2 = new NSSet((Object)"def");
        NSSet union = set.setByUnioningSet(set2);
        NSSetTest.assertEquals((int)3, (int)union.size());
        set2 = new NSSet((Object)"abc");
        union = set.setByUnioningSet(set2);
        NSSetTest.assertEquals((int)set.size(), (int)union.size());
    }

    public void testClear() {
        try {
            new NSSet((Object)"abc").clear();
            NSSetTest.fail((String)"Clear should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAdd() {
        try {
            NSSet.emptySet().add((Object)"abc");
            NSSetTest.fail((String)"Add should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAddAllCollection() {
        try {
            HashSet<String> set = new HashSet<String>();
            set.add("abc");
            set.add("123");
            NSSet.emptySet().addAll(set);
            NSSetTest.fail((String)"AddAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemove() {
        try {
            NSSet set = new NSSet((Object[])new String[]{"abc"});
            set.remove((Object)"abc");
            NSSetTest.fail((String)"Clear should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveAllCollection() {
        try {
            HashSet<String> hashset = new HashSet<String>();
            hashset.add("abc");
            hashset.add("123");
            NSSet set = new NSSet((Object[])new String[]{"abc"});
            set.removeAll(hashset);
            NSSetTest.fail((String)"RemoveAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRetainAllCollection() {
        try {
            HashSet<String> hashset = new HashSet<String>();
            hashset.add("abc");
            hashset.add("123");
            NSSet set = new NSSet((Object[])new String[]{"abc", "def"});
            set.retainAll(hashset);
            NSSetTest.fail((String)"RetainAll should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

