/*
 * Decompiled with CFR 0.152.
 */
package er.erxtest.tests;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import er.erxtest.ERXTestCase;
import er.erxtest.model.Company;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEnterpriseObjectCache;
import java.util.UUID;

public class ERXEnterpriseObjectCacheTestCase
extends ERXTestCase {
    private EOEditingContext editingContext;
    private Company c1;
    private Company c2;

    public void testInsert() {
        this.testInsert(true);
    }

    public void testUpdate() {
        this.testUpdate(true);
    }

    public void testDelete() {
        this.testDelete(true);
    }

    public void testInsertNoFetchInitialValues() {
        this.testInsert(false);
    }

    public void testUpdateNoFetchInitialValues() {
        this.testUpdate(false);
    }

    public void testDeleteNoFetchInitialValues() {
        this.testDelete(false);
    }

    public void testFetchWithFetchInitialValues() {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 0L);
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c1.name());
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c1Test));
        cache.stop();
    }

    public void testFetchWithFetchInitialValuesAndTimeout() {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 100000L);
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c1.name());
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c1Test));
        cache.stop();
    }

    public void testFetchNoFetchInitialValues() {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 0L);
        cache.setFetchInitialValues(false);
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c1.name());
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c1Test));
        cache.stop();
    }

    public void testFetchNoFetchInitialValuesAndTimeout() {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 100000L);
        cache.setFetchInitialValues(false);
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c1.name());
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c1Test));
        cache.stop();
    }

    public void testFetchWithQualifier() {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, (EOQualifier)Company.NAME.contains("Test"), 0L);
        cache.setFetchInitialValues(false);
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c1.name());
        ERXEnterpriseObjectCacheTestCase.assertNull((Object)((Object)c1Test));
        Company c2Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c2.name());
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c2), (Object)((Object)c2Test));
        cache.stop();
    }

    public void testUpdateWithQualifier() {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, (EOQualifier)Company.NAME.contains("Test"), 0L);
        cache.setFetchInitialValues(false);
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c1.name());
        ERXEnterpriseObjectCacheTestCase.assertNull((Object)((Object)c1Test));
        Company c2Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c2.name());
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c2), (Object)((Object)c2Test));
        String name1Update = "Another Test Company " + UUID.randomUUID().toString();
        this.c1.setName(name1Update);
        this.editingContext.saveChanges();
        Company c1UpdateTest = (Company)cache.objectForKey(this.editingContext, (Object)name1Update);
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c1UpdateTest));
        String name2Update = "Company 2 " + UUID.randomUUID().toString();
        this.c2.setName(name2Update);
        this.editingContext.saveChanges();
        Company c2UpdateTest = (Company)cache.objectForKey(this.editingContext, (Object)name2Update);
        ERXEnterpriseObjectCacheTestCase.assertNull((Object)((Object)c2UpdateTest));
        cache.stop();
    }

    public void testInsert(boolean fetchInitialValues) {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 0L);
        cache.setFetchInitialValues(fetchInitialValues);
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)this.c1.name());
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c1Test));
        cache.stop();
    }

    public void testDelete(boolean fetchInitialValues) {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 0L);
        cache.setFetchInitialValues(fetchInitialValues);
        String name = this.c1.name();
        Company c1Test = (Company)cache.objectForKey(this.editingContext, (Object)name);
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c1Test));
        this.c1.delete();
        this.editingContext.saveChanges();
        this.c1 = null;
        Company c1DeleteTest = (Company)cache.objectForKey(this.editingContext, (Object)name);
        ERXEnterpriseObjectCacheTestCase.assertNull((Object)((Object)c1DeleteTest));
        cache.stop();
    }

    public void testUpdate(boolean fetchInitialValues) {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 0L);
        cache.setFetchInitialValues(fetchInitialValues);
        String name1 = this.c1.name();
        String name2 = "Company " + UUID.randomUUID().toString();
        this.c1.setName(name2);
        this.editingContext.saveChanges();
        Company c1DeleteTest = (Company)cache.objectForKey(this.editingContext, (Object)name1);
        ERXEnterpriseObjectCacheTestCase.assertNull((Object)((Object)c1DeleteTest));
        Company c2UpdateTest = (Company)cache.objectForKey(this.editingContext, (Object)name2);
        ERXEnterpriseObjectCacheTestCase.assertSame((Object)((Object)this.c1), (Object)((Object)c2UpdateTest));
        cache.stop();
    }

    public void testAllObjects() {
        ERXEnterpriseObjectCache cache = new ERXEnterpriseObjectCache("Company", Company.NAME_KEY, null, 0L);
        cache.setFetchInitialValues(true);
        NSArray allObjects = cache.allObjects(this.editingContext);
        ERXEnterpriseObjectCacheTestCase.assertTrue((boolean)allObjects.containsObject((Object)this.c1));
        ERXEnterpriseObjectCacheTestCase.assertTrue((boolean)allObjects.containsObject((Object)this.c2));
        allObjects = cache.allObjects(this.editingContext, (EOQualifier)Company.NAME.contains("Test"));
        ERXEnterpriseObjectCacheTestCase.assertFalse((boolean)allObjects.containsObject((Object)this.c1));
        ERXEnterpriseObjectCacheTestCase.assertTrue((boolean)allObjects.containsObject((Object)this.c2));
        cache.stop();
    }

    protected void setUp() throws Exception {
        String name1 = "Company " + UUID.randomUUID().toString();
        this.editingContext = ERXEC.newEditingContext();
        this.c1 = Company.createCompany(this.editingContext, name1);
        this.editingContext.saveChanges();
        String name2 = "Company Test " + UUID.randomUUID().toString();
        this.c2 = Company.createCompany(this.editingContext, name2);
        this.editingContext.saveChanges();
    }

    protected void tearDown() throws Exception {
        if (this.c1 != null) {
            this.editingContext.deleteObject((EOEnterpriseObject)this.c1);
        }
        if (this.c2 != null) {
            this.editingContext.deleteObject((EOEnterpriseObject)this.c2);
        }
        this.editingContext.saveChanges();
        this.editingContext.dispose();
        this.editingContext = null;
    }
}

