/*
 * Decompiled with CFR 0.152.
 */
package er.erxtest.tests;

import er.erxtest.ERXTestCase;
import er.extensions.foundation.ERXExpiringCache;

public class ERXExpiringCacheTestCase
extends ERXTestCase {
    public void testThatItWorksAtAll() {
        ERXExpiringCache cache = new ERXExpiringCache(100L);
        cache.setObjectForKey((Object)"Krank", (Object)"Anjo");
        cache.setObjectForKey((Object)"Schrag", (Object)"Mike");
        ERXExpiringCacheTestCase.assertEquals((String)"Schrag", (String)((String)cache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Chuck")));
    }

    public void testThatNoTimeoutWorksAtAll() {
        ERXExpiringCache noTimeoutCache = new ERXExpiringCache(0L);
        noTimeoutCache.setObjectForKey((Object)"Krank", (Object)"Anjo");
        noTimeoutCache.setObjectForKey((Object)"Schrag", (Object)"Mike");
        ERXExpiringCacheTestCase.assertEquals((String)"Schrag", (String)((String)noTimeoutCache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)noTimeoutCache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)noTimeoutCache.objectForKey((Object)"Chuck")));
    }

    public void testVersionsWithVersionlessGet() {
        ERXExpiringCache cache = new ERXExpiringCache(0L);
        cache.setObjectForKeyWithVersion((Object)"Krank", (Object)"Anjo", (Object)1);
        cache.setObjectForKeyWithVersion((Object)"Schrag", (Object)"Mike", (Object)1);
        ERXExpiringCacheTestCase.assertEquals((String)"Schrag", (String)((String)cache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Chuck")));
    }

    public void testVersionsWithSameVersionGet() {
        ERXExpiringCache cache = new ERXExpiringCache(0L);
        cache.setObjectForKeyWithVersion((Object)"Krank", (Object)"Anjo", (Object)1);
        cache.setObjectForKeyWithVersion((Object)"Schrag", (Object)"Mike", (Object)1);
        ERXExpiringCacheTestCase.assertEquals((String)"Schrag", (String)((String)cache.objectForKeyWithVersion((Object)"Mike", (Object)1)));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKeyWithVersion((Object)"Anjo", (Object)1)));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKeyWithVersion((Object)"Chuck", (Object)1)));
    }

    public void testVersionsWithNewVersionGetMakeSureItIsStillGone() {
        ERXExpiringCache cache = new ERXExpiringCache(0L);
        cache.setObjectForKeyWithVersion((Object)"Krank", (Object)"Anjo", (Object)1);
        cache.setObjectForKeyWithVersion((Object)"Schrag", (Object)"Mike", (Object)1);
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKeyWithVersion((Object)"Mike", (Object)2)));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKeyWithVersion((Object)"Anjo", (Object)1)));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKeyWithVersion((Object)"Chuck", (Object)1)));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKeyWithVersion((Object)"Mike", (Object)1)));
    }

    public void testVersionsWithNewVersionGet() {
        ERXExpiringCache cache = new ERXExpiringCache(0L);
        cache.setObjectForKeyWithVersion((Object)"Krank", (Object)"Anjo", (Object)1);
        cache.setObjectForKeyWithVersion((Object)"Schrag", (Object)"Mike", (Object)1);
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKeyWithVersion((Object)"Mike", (Object)2)));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKeyWithVersion((Object)"Anjo", (Object)1)));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKeyWithVersion((Object)"Chuck", (Object)1)));
    }

    public void testTimeExpiration() {
        ERXExpiringCache cache = new ERXExpiringCache(30L);
        cache.startBackgroundExpiration();
        cache.setObjectForKey((Object)"Krank", (Object)"Anjo");
        cache.setObjectForKey((Object)"Schrag", (Object)"Mike");
        ERXExpiringCacheTestCase.assertEquals((String)"Schrag", (String)((String)cache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Chuck")));
        try {
            Thread.sleep(20000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ERXExpiringCacheTestCase.assertEquals((String)"Schrag", (String)((String)cache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Chuck")));
        cache.setObjectForKey((Object)"Hill", (Object)"Chuck");
        ERXExpiringCacheTestCase.assertEquals((String)"Schrag", (String)((String)cache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals((String)"Krank", (String)((String)cache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals((String)"Hill", (String)((String)cache.objectForKey((Object)"Chuck")));
        try {
            Thread.sleep(15000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals((String)"Hill", (String)((String)cache.objectForKey((Object)"Chuck")));
        try {
            Thread.sleep(20000L);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Mike")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Anjo")));
        ERXExpiringCacheTestCase.assertEquals(null, (String)((String)cache.objectForKey((Object)"Chuck")));
        cache.stopBackgroundExpiration();
    }
}

