/*
 * Decompiled with CFR 0.152.
 */
package er.erxtest.tests;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import er.erxtest.ERXTestCase;
import er.erxtest.model.Company;
import er.erxtest.model.Employee;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXGenericRecord;

public class ERXGenericRecordUpdateInverseRelationshipsTest
extends ERXTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ERXGenericRecord.InverseRelationshipUpdater.setUpdateInverseRelationships((boolean)true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ERXGenericRecord.InverseRelationshipUpdater.setUpdateInverseRelationships((boolean)false);
    }

    public void testSetToOneImplicitToMany() {
        ERXGenericRecord.InverseRelationshipUpdater.setUpdateInverseRelationships((boolean)false);
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        p1.setCompanyRelationship(company);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)1, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)p1), (Object)company.employees().objectAtIndex(0));
    }

    public void testAddToToManyImplicitToOne() {
        ERXGenericRecord.InverseRelationshipUpdater.setUpdateInverseRelationships((boolean)false);
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        company.addToEmployeesRelationship(p1);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)1, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)p1), (Object)company.employees().objectAtIndex(0));
    }

    public void testAutoSetToOneImplicitToMany() {
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        p1.setCompany(company);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)1, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)p1), (Object)company.employees().objectAtIndex(0));
    }

    public void testAutoAddToToManyImplicitToOne() {
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        company.addToEmployees(p1);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)1, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)p1), (Object)company.employees().objectAtIndex(0));
    }

    public void testAutoSetThenSetToOneToNullImplicitToMany() {
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        p1.setCompany(company);
        p1.setCompany(null);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals(null, (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)0, (int)company.employees().count());
    }

    public void testAutoSetThenSetToOneToAnotherImplicitToMany() {
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Company company2 = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        p1.setCompany(company);
        p1.setCompany(company2);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company2), (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)0, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)1, (int)company2.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)p1), (Object)company2.employees().objectAtIndex(0));
    }

    public void testAutoRemoveFromToManyImplicitToOne() {
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        company.addToEmployees(p1);
        company.removeFromEmployees(p1);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals(null, (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)0, (int)company.employees().count());
    }

    public void testAutoSetTwoToOnesImplicitToMany() {
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        Employee p2 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        p1.setCompany(company);
        p2.setCompany(company);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p2.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)2, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertTrue((boolean)company.employees().containsObject((Object)p1));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertTrue((boolean)company.employees().containsObject((Object)p2));
    }

    public void testAutoRemoveFromToManyWithManyImplicitToOne() {
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        Employee p2 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        company.addToEmployees(p1);
        company.addToEmployees(p2);
        company.removeFromEmployees(p1);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals(null, (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p2.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)1, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)p2), (Object)company.employees().objectAtIndex(0));
    }

    public void testRevertToManyWithoutInverseRelationshipUpdating() {
        this.testRevertToMany(false);
    }

    public void testRevertToManyWithInverseRelationshipUpdating() {
        this.testRevertToMany(true);
    }

    public void testRevertToMany(boolean updateInverseRelationships) {
        ERXGenericRecord.InverseRelationshipUpdater.setUpdateInverseRelationships((boolean)updateInverseRelationships);
        EOEditingContext editingContext = ERXEC.newEditingContext();
        Company company = Company.createCompany(editingContext, "XYZ");
        editingContext.saveChanges();
        Employee p1 = (Employee)EOUtilities.createAndInsertInstance((EOEditingContext)editingContext, (String)"Employee");
        p1.setCompanyRelationship(company);
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)company), (Object)((Object)p1.company()));
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)1, (int)company.employees().count());
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((Object)((Object)p1), (Object)company.employees().objectAtIndex(0));
        editingContext.revert();
        ERXGenericRecordUpdateInverseRelationshipsTest.assertEquals((int)0, (int)company.employees().count());
    }
}

