/*
 * Decompiled with CFR 0.152.
 */
package er.erxtest.tests;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.foundation.NSArray;
import er.erxtest.ERXTestCase;
import er.erxtest.model.Company;
import er.erxtest.model.Employee;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXObjectStoreCoordinatorPool;
import er.extensions.foundation.ERXRandomGUID;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ERXObjectStoreCoordinatorSynchronizerTestCase
extends ERXTestCase {
    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ERXObjectStoreCoordinatorSynchronizerTestCase.class);
        return suite;
    }

    public void testPool() {
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)ERXObjectStoreCoordinatorPool._pool());
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
    }

    public void testDifferenceStores() {
        EOObjectStore osc1 = ERXObjectStoreCoordinatorPool._pool().nextObjectStore();
        EOObjectStore osc2 = ERXObjectStoreCoordinatorPool._pool().nextObjectStore();
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotSame((Object)osc1, (Object)osc2);
    }

    public void testInsertEO() {
        String companyName = "Company" + ERXRandomGUID.newGid();
        EOEditingContext editingContext_osc1 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc1 = Company.createCompany(editingContext_osc1, companyName);
        editingContext_osc1.saveChanges();
        Company company_osc1_fetched = Company.fetchCompany(editingContext_osc1, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc1_fetched));
        this.sleep();
        EOEditingContext editingContext_osc2 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc2));
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName, (String)company_osc1.name());
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName, (String)company_osc2.name());
    }

    public void testUpdateEO() {
        String companyName = "Company" + ERXRandomGUID.newGid();
        EOEditingContext editingContext_osc1 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc1 = Company.createCompany(editingContext_osc1, companyName);
        editingContext_osc1.saveChanges();
        this.sleep();
        EOEditingContext editingContext_osc2 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc2));
        for (int i = 0; i < 10; ++i) {
            String companyName_1 = "Company" + ERXRandomGUID.newGid() + "_osc1";
            company_osc1.setName(companyName_1);
            editingContext_osc1.saveChanges();
            this.sleep();
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_1, (String)company_osc2.name());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_1, (String)company_osc1.name());
            Company company_osc1_with_companyName1 = Company.fetchCompany(editingContext_osc1, Company.NAME_KEY, companyName_1);
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((Object)((Object)company_osc1), (Object)((Object)company_osc1_with_companyName1));
            Company company_osc2_with_companyName1 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName_1);
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((Object)((Object)company_osc2), (Object)((Object)company_osc2_with_companyName1));
            String companyName_2 = "Company" + ERXRandomGUID.newGid() + "_osc2";
            company_osc2.setName(companyName_2);
            editingContext_osc2.saveChanges();
            this.sleep();
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_2, (String)company_osc1.name());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_2, (String)company_osc2.name());
            Company company_osc1_with_companyName2 = Company.fetchCompany(editingContext_osc1, Company.NAME_KEY, companyName_2);
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((Object)((Object)company_osc1), (Object)((Object)company_osc1_with_companyName2));
            Company company_osc2_with_companyName2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName_2);
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((Object)((Object)company_osc2), (Object)((Object)company_osc2_with_companyName2));
        }
    }

    public void testMergeEOChanges() {
        String companyName = "Company" + ERXRandomGUID.newGid();
        EOEditingContext editingContext_osc1 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc1 = Company.createCompany(editingContext_osc1, companyName);
        editingContext_osc1.saveChanges();
        this.sleep();
        EOEditingContext editingContext_osc2 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc2));
        for (int i = 0; i < 10; ++i) {
            String companyName_1 = "Company" + ERXRandomGUID.newGid() + "_osc1";
            String companyAddress1_1 = company_osc1.address1();
            company_osc1.setName(companyName_1);
            String companyAddress1_2 = "Address" + ERXRandomGUID.newGid() + "_osc2";
            company_osc2.setAddress1(companyAddress1_2);
            editingContext_osc1.saveChanges();
            this.sleep();
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_1, (String)company_osc2.name());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_1, (String)company_osc1.name());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyAddress1_2, (String)company_osc2.address1());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyAddress1_1, (String)company_osc1.address1());
            Company company_osc1_with_companyName1 = Company.fetchCompany(editingContext_osc1, Company.NAME_KEY, companyName_1);
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((Object)((Object)company_osc1), (Object)((Object)company_osc1_with_companyName1));
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyAddress1_1, (String)company_osc1_with_companyName1.address1());
            Company company_osc2_with_companyName1 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName_1);
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((Object)((Object)company_osc2), (Object)((Object)company_osc2_with_companyName1));
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyAddress1_2, (String)company_osc2_with_companyName1.address1());
            editingContext_osc2.saveChanges();
            this.sleep();
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_1, (String)company_osc1.name());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyName_1, (String)company_osc2.name());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyAddress1_2, (String)company_osc2.address1());
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((String)companyAddress1_2, (String)company_osc1.address1());
        }
    }

    public void testAddToUnfaultedToMany() {
        String companyName = "Company" + ERXRandomGUID.newGid();
        EOEditingContext editingContext_osc1 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc1 = Company.createCompany(editingContext_osc1, companyName);
        editingContext_osc1.saveChanges();
        EOEditingContext editingContext_osc2 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc2));
        String employeeFirstName = "Employee" + ERXRandomGUID.newGid();
        String employeeLastName = "Jones";
        Employee employee_osc1 = Employee.createEmployee(editingContext_osc1, employeeFirstName, employeeLastName, Boolean.FALSE, company_osc1);
        editingContext_osc1.saveChanges();
        this.assertContainsExactlyEOs(new NSArray((Object)employee_osc1), company_osc1.employees());
        this.assertContainsExactlyEOs(new NSArray((Object)employee_osc1), company_osc2.employees());
    }

    public void testAddToFaultedToMany() {
        String companyName = "Company" + ERXRandomGUID.newGid();
        EOEditingContext editingContext_osc1 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc1 = Company.createCompany(editingContext_osc1, companyName);
        editingContext_osc1.saveChanges();
        this.sleep();
        NSArray<Employee> employees_osc1 = company_osc1.employees();
        EOEditingContext editingContext_osc2 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc2));
        NSArray<Employee> employees_osc2 = company_osc2.employees();
        String employeeFirstName = "Employee" + ERXRandomGUID.newGid();
        String employeeLastName = "Jones";
        Employee employee_osc1 = Employee.createEmployee(editingContext_osc1, employeeFirstName, employeeLastName, Boolean.FALSE, company_osc1);
        editingContext_osc1.saveChanges();
        this.sleep();
        this.assertContainsExactlyEOs(new NSArray((Object)employee_osc1), company_osc1.employees());
        this.assertContainsExactlyEOs(new NSArray((Object)employee_osc1), company_osc2.employees());
        String employeeFirstName2 = "Employee" + ERXRandomGUID.newGid();
        String employeeLastName2 = "Jones";
        Employee employee_osc2 = Employee.createEmployee(editingContext_osc2, employeeFirstName2, employeeLastName2, Boolean.FALSE, company_osc2);
        editingContext_osc2.saveChanges();
        this.sleep();
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee_osc1, employee_osc2}), company_osc1.employees());
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee_osc1, employee_osc2}), company_osc2.employees());
    }

    public void testAddToFaultedToManyWithUncommittedToManyEntries() {
        String companyName = "Company" + ERXRandomGUID.newGid();
        EOEditingContext editingContext_osc1 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc1 = Company.createCompany(editingContext_osc1, companyName);
        editingContext_osc1.saveChanges();
        this.sleep();
        EOEditingContext editingContext_osc2 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc2));
        String employeeFirstName1 = "Employee" + ERXRandomGUID.newGid();
        String employeeLastName1 = "Jones";
        Employee employee1_osc2 = Employee.createEmployee(editingContext_osc2, employeeFirstName1, employeeLastName1, Boolean.FALSE, company_osc2);
        NSArray<Employee> employees_osc2_BeforeInsert = company_osc2.employees();
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((int)1, (int)employees_osc2_BeforeInsert.count());
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEOEquals((Object)employee1_osc2, employees_osc2_BeforeInsert.objectAtIndex(0));
        String employeeFirstName2 = "Employee" + ERXRandomGUID.newGid();
        String employeeLastName2 = "Jones";
        Employee employee2_osc1 = Employee.createEmployee(editingContext_osc1, employeeFirstName2, employeeLastName2, Boolean.FALSE, company_osc1);
        editingContext_osc1.saveChanges();
        this.sleep();
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee1_osc2, employee2_osc1}), company_osc2.employees());
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee2_osc1}), company_osc1.employees());
        editingContext_osc2.saveChanges();
        this.sleep();
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee1_osc2, employee2_osc1}), company_osc2.employees());
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee1_osc2, employee2_osc1}), company_osc1.employees());
    }

    public void testRemoveFromFaultedToMany() {
        String companyName = "Company" + ERXRandomGUID.newGid();
        EOEditingContext editingContext_osc1 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc1 = Company.createCompany(editingContext_osc1, companyName);
        editingContext_osc1.saveChanges();
        this.sleep();
        String employeeFirstName1 = "Employee" + ERXRandomGUID.newGid();
        String employeeLastName1 = "Jones";
        Employee employee1_osc1 = Employee.createEmployee(editingContext_osc1, employeeFirstName1, employeeLastName1, Boolean.FALSE, company_osc1);
        String employeeFirstName2 = "Employee" + ERXRandomGUID.newGid();
        String employeeLastName2 = "Jones";
        Employee employee2_osc1 = Employee.createEmployee(editingContext_osc1, employeeFirstName2, employeeLastName2, Boolean.FALSE, company_osc1);
        editingContext_osc1.saveChanges();
        this.sleep();
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee1_osc1, employee2_osc1}), company_osc1.employees());
        EOEditingContext editingContext_osc2 = ERXEC.newEditingContext((EOObjectStore)ERXObjectStoreCoordinatorPool._pool().nextObjectStore());
        Company company_osc2 = Company.fetchCompany(editingContext_osc2, Company.NAME_KEY, companyName);
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)company_osc2));
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee1_osc1, employee2_osc1}), company_osc2.employees());
        NSArray<Employee> employees_osc2 = company_osc2.employees();
        Employee employee2_osc2 = (Employee)((Object)employees_osc2.objectAtIndex(0));
        Employee employee1_osc2 = (Employee)((Object)employees_osc2.objectAtIndex(1));
        Employee secondEmployee_osc2 = ERXEOControlUtilities.eoEquals((EOEnterpriseObject)employee1_osc1, (EOEnterpriseObject)employee1_osc2) ? employee2_osc2 : employee1_osc2;
        NSArray<Employee> holdingOnToEmployees = company_osc2.employees();
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((int)2, (int)holdingOnToEmployees.count());
        for (Employee employee : holdingOnToEmployees) {
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)employee));
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)employee.firstName());
        }
        NSArray<Employee> holdingOnToUntouchedEmployees = company_osc2.employees();
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((int)2, (int)holdingOnToUntouchedEmployees.count());
        editingContext_osc1.deleteObject((EOEnterpriseObject)employee1_osc1);
        editingContext_osc1.saveChanges();
        this.sleep();
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((int)2, (int)holdingOnToEmployees.count());
        for (Employee employee : holdingOnToEmployees) {
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)employee));
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)employee.firstName());
        }
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((int)2, (int)holdingOnToUntouchedEmployees.count());
        for (Employee employee : holdingOnToUntouchedEmployees) {
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)((Object)employee));
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertNotNull((Object)employee.firstName());
        }
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee2_osc1}), company_osc1.employees());
        this.assertContainsExactlyEOs(new NSArray((Object[])new Employee[]{employee2_osc1}), company_osc2.employees());
        editingContext_osc2.deleteObject((EOEnterpriseObject)secondEmployee_osc2);
        editingContext_osc2.saveChanges();
        this.sleep();
        this.assertContainsExactlyEOs(NSArray.EmptyArray, company_osc1.employees());
        this.assertContainsExactlyEOs(NSArray.EmptyArray, company_osc2.employees());
    }

    public static void assertEOEquals(Object obj1, Object obj2) {
        if (obj1 != null && obj2 != null && obj1 instanceof EOEnterpriseObject && obj2 instanceof EOEnterpriseObject) {
            EOEnterpriseObject eo1 = (EOEnterpriseObject)obj1;
            EOEnterpriseObject eo2 = (EOEnterpriseObject)obj2;
            if (!ERXEOControlUtilities.eoEquals((EOEnterpriseObject)eo1, (EOEnterpriseObject)eo2)) {
                throw new AssertionFailedError("Expected " + eo1.editingContext().globalIDForObject(eo1) + ", but got " + eo2.editingContext().globalIDForObject(eo2));
            }
        } else {
            ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((Object)obj1, (Object)obj2);
        }
    }

    public void assertContainsExactlyEOs(NSArray expectedEOs, NSArray actualEOs) {
        int expectedCount = expectedEOs.count();
        int actualCount = actualEOs.count();
        ERXObjectStoreCoordinatorSynchronizerTestCase.assertEquals((int)expectedCount, (int)actualCount);
        Enumeration expectedEOsEnum = expectedEOs.objectEnumerator();
        while (expectedEOsEnum.hasMoreElements()) {
            EOEnterpriseObject expectedEO = (EOEnterpriseObject)expectedEOsEnum.nextElement();
            boolean containsEO = false;
            Enumeration actualEOsEnum = actualEOs.objectEnumerator();
            while (!containsEO && actualEOsEnum.hasMoreElements()) {
                EOEnterpriseObject actualEO = (EOEnterpriseObject)actualEOsEnum.nextElement();
                containsEO = ERXEOControlUtilities.eoEquals((EOEnterpriseObject)expectedEO, (EOEnterpriseObject)actualEO);
            }
            if (containsEO) continue;
            throw new AssertionFailedError("Expected " + expectedEOs.valueForKey("__globalID") + ", but got " + actualEOs.valueForKey("__globalID"));
        }
    }

    protected void sleep() {
        try {
            Thread.sleep(50L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

