/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.foundation.NSData;
import er.erxtest.ERXTestCase;
import er.erxtest.ERXTestUtilities;
import er.erxtest.model.Company;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXKeyGlobalID;
import junit.framework.Assert;

public class ERXKeyGlobalIDTest
extends ERXTestCase {
    private EOEditingContext ec;
    private Company co;

    public void setUp() throws Exception {
        super.setUp();
        this.ec = ERXEC.newEditingContext();
        this.co = Company.createCompany(this.ec, "Foobar.com");
        this.ec.saveChanges();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testConstructor() {
        ERXKeyGlobalID xkgid = new ERXKeyGlobalID("Company", EOUtilities.primaryKeyForObject((EOEditingContext)this.ec, (EOEnterpriseObject)this.co).values().toArray());
        Assert.assertNotNull((Object)xkgid);
    }

    public void testFromData() {
        int pk = ERXTestUtilities.pkOne(this.ec, (EOEnterpriseObject)this.co);
        ERXKeyGlobalID xkgid = ERXKeyGlobalID.fromData((NSData)new NSData(("Company." + pk).getBytes()));
        Assert.assertNotNull((Object)xkgid);
    }

    public void testFromString() {
        int pk = ERXTestUtilities.pkOne(this.ec, (EOEnterpriseObject)this.co);
        ERXKeyGlobalID xkgid = ERXKeyGlobalID.fromString((String)("Company." + pk));
        Assert.assertNotNull((Object)xkgid);
    }

    public void testEquals() {
        EOKeyGlobalID kgid1 = EOKeyGlobalID.globalIDWithEntityName((String)"Company", (Object[])new Integer[]{ERXTestUtilities.pkOne(this.ec, (EOEnterpriseObject)this.co)});
        ERXKeyGlobalID xkgid1 = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)kgid1);
        ERXKeyGlobalID xkgid2 = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)kgid1);
        Assert.assertFalse((boolean)kgid1.equals((Object)xkgid1));
        Assert.assertFalse((boolean)xkgid1.equals((Object)kgid1));
        Assert.assertTrue((boolean)xkgid1.equals((Object)xkgid2));
        Assert.assertTrue((boolean)xkgid2.equals((Object)xkgid1));
        EOEditingContext ec2 = ERXEC.newEditingContext();
        EOEnterpriseObject co2 = ERXEOControlUtilities.localInstanceOfObject((EOEditingContext)ec2, (EOEnterpriseObject)this.co);
        EOKeyGlobalID kgid2 = EOKeyGlobalID.globalIDWithEntityName((String)"Company", (Object[])new Integer[]{ERXTestUtilities.pkOne(ec2, co2)});
        ERXKeyGlobalID xkgid3 = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)kgid2);
        Assert.assertFalse((boolean)kgid2.equals((Object)xkgid3));
        Assert.assertFalse((boolean)xkgid3.equals((Object)kgid2));
        Assert.assertTrue((boolean)xkgid1.equals((Object)xkgid3));
        Assert.assertTrue((boolean)xkgid3.equals((Object)xkgid1));
    }

    public void testGlobalIDForGID() {
        EOGlobalID gid = this.ec.globalIDForObject((EOEnterpriseObject)this.co);
        ERXKeyGlobalID xkgid1 = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)((EOKeyGlobalID)gid));
        Assert.assertEquals((Object)gid, (Object)xkgid1.globalID());
    }

    public void testGlobalID() {
        EOGlobalID gid = this.ec.globalIDForObject((EOEnterpriseObject)this.co);
        int pk = ERXTestUtilities.pkOne(this.ec, (EOEnterpriseObject)this.co);
        ERXKeyGlobalID xkgid1 = new ERXKeyGlobalID("Company", (Object[])new Integer[]{pk});
        Assert.assertEquals((Object)gid, (Object)xkgid1.globalID());
        ERXKeyGlobalID xkgid2 = ERXKeyGlobalID.fromData((NSData)new NSData(("Company." + pk).getBytes()));
        Assert.assertEquals((Object)gid, (Object)xkgid2.globalID());
        ERXKeyGlobalID xkgid3 = ERXKeyGlobalID.fromString((String)("Company." + pk));
        Assert.assertEquals((Object)gid, (Object)xkgid3.globalID());
    }

    public void test_keyValuesNoCopy() {
        ERXKeyGlobalID xkgid = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)((EOKeyGlobalID)this.ec.globalIDForObject((EOEnterpriseObject)this.co)));
        ERXKeyGlobalIDTest.assertEquals(xkgid.keyValues(), xkgid._keyValuesNoCopy());
    }

    public void testHashCode() {
        ERXKeyGlobalID xkgid = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)((EOKeyGlobalID)this.ec.globalIDForObject((EOEnterpriseObject)this.co)));
        Assert.assertTrue((xkgid.hashCode() != 0 ? 1 : 0) != 0);
    }

    public void testKeyCount() {
        ERXKeyGlobalID xkgid = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)((EOKeyGlobalID)this.ec.globalIDForObject((EOEnterpriseObject)this.co)));
        Assert.assertEquals((int)1, (int)xkgid.keyCount());
    }

    public void testKeyValues() {
        ERXKeyGlobalID xkgid = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)((EOKeyGlobalID)this.ec.globalIDForObject((EOEnterpriseObject)this.co)));
        int pk = ERXTestUtilities.pkOne(this.ec, (EOEnterpriseObject)this.co);
        Object[] values = new Integer[]{pk};
        ERXKeyGlobalIDTest.assertEquals(values, xkgid.keyValues());
    }

    public void testToString() {
        ERXKeyGlobalID xkgid = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)((EOKeyGlobalID)this.ec.globalIDForObject((EOEnterpriseObject)this.co)));
        int pk = ERXTestUtilities.pkOne(this.ec, (EOEnterpriseObject)this.co);
        Assert.assertEquals((String)("_EOIntegralKeyGlobalID[Company (java.lang.Integer)" + pk + "]"), (String)xkgid.toString());
    }
}

