/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import er.erxtest.Application;
import er.extensions.ERXExtensions;
import er.extensions.eof.ERXEC;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXThrashTest {
    public static boolean _useWonder = true;

    static List<ThrashTest> useScheme(String scheme) throws Throwable {
        LinkedList<ThrashTest> tests = new LinkedList<ThrashTest>();
        String[] parts = scheme.split(":");
        String testClassName = parts[1];
        String parameter = parts[2];
        String plan = parts[3];
        System.out.println("testClassName = \"" + testClassName + "\"");
        System.out.println("parameter = \"" + parameter + "\"");
        System.out.println("plan = \"" + plan + "\"");
        Class<ThrashTest> testClass = Class.forName(ERXThrashTest.class.getName() + "$" + testClassName).asSubclass(ThrashTest.class);
        String[] plans = plan.split(",");
        for (int planNum = 0; planNum < plans.length; ++planNum) {
            String subPlan = plans[planNum];
            String[] planParts = subPlan.split("-");
            if (planParts.length != 2) {
                throw new IllegalArgumentException("Cannot figure out part # " + planNum + " (\"" + planParts[planNum] + "\") in scheme: \"" + scheme + "\"");
            }
            int delay = Integer.parseInt(planParts[0]);
            int count = Integer.parseInt(planParts[1]);
            for (int testNum = 0; testNum < count; ++testNum) {
                ThrashTest test = testClass.newInstance();
                test.setDelay(delay);
                test.setParam(parameter);
                tests.add(test);
            }
        }
        return tests;
    }

    public static void main(String[] arg) throws Throwable {
        ERXExtensions.initApp(Application.class, (String[])arg);
        long startTime = System.currentTimeMillis();
        List<ThrashTest> tests = ERXThrashTest.useScheme(System.getProperty("thrash.scheme", "scheme:SimpleInsertTest::0-100,2-100"));
        LinkedList<Thread> threads = new LinkedList<Thread>();
        for (ThrashTest test : tests) {
            Thread thread = new Thread(test);
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        System.out.println("ERXThrashTest.main: " + (System.currentTimeMillis() - startTime) + " total time");
    }

    public static class SimpleInsertTest
    extends ThrashTest {
        protected void _run() {
            EOEditingContext ec = this.editingContext();
            ec.lock();
            EOEnterpriseObject company = EOUtilities.createAndInsertInstance((EOEditingContext)ec, (String)"Company");
            company.takeValueForKey((Object)"SomeBody.com", "name");
            ec.saveChanges();
            ec.unlock();
            this.start();
            String lastName = Thread.currentThread().getName() + System.currentTimeMillis() + "Person";
            int iters = 10;
            for (int idx = 0; idx < iters; ++idx) {
                ec.lock();
                EOEnterpriseObject eo = EOUtilities.createAndInsertInstance((EOEditingContext)ec, (String)"Employee");
                eo.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)company, "company");
                eo.takeValueForKey((Object)Boolean.TRUE, "manager");
                eo.takeValueForKey((Object)("Bob" + idx), "name");
                eo.takeValueForKey((Object)lastName, "state");
                ec.unlock();
            }
            ec.lock();
            ec.saveChanges();
            ec.unlock();
            ec.lock();
            NSArray rowsInserted = EOUtilities.objectsMatchingKeyAndValue((EOEditingContext)ec, (String)"Employee", (String)"state", (Object)lastName);
            boolean insertOk = rowsInserted.count() == iters;
            for (int idx = 0; idx < iters; ++idx) {
                ec.deleteObject((EOEnterpriseObject)rowsInserted.get(idx));
            }
            ec.saveChanges();
            ec.unlock();
            ec.lock();
            NSArray rowsDeleted = EOUtilities.objectsMatchingKeyAndValue((EOEditingContext)ec, (String)"Employee", (String)"state", (Object)lastName);
            ec.unlock();
            boolean deleteOk = rowsDeleted.count() == 0;
            ec.lock();
            ec.deleteObject(company);
            ec.saveChanges();
            ec.unlock();
            this.end();
            this.print("RESULT", insertOk && deleteOk ? "OK" : "FAILED");
        }
    }

    public static class SimpleFetchTest
    extends ThrashTest {
        protected void _run() {
            EOEditingContext ec = this.editingContext();
            ec.lock();
            NSArray rows = EOUtilities.objectsForEntityNamed((EOEditingContext)ec, (String)"Employee");
            ec.unlock();
            this.print("RESULT", "row count = " + rows.count());
        }
    }

    public static abstract class ThrashTest
    implements Runnable {
        private String _param;
        private int _delay;
        private long _startTime;
        private long _endTime;

        public void setDelay(int delay) {
            this._delay = delay;
        }

        public void setParam(String param) {
            this._param = param;
        }

        public String param() {
            return this._param;
        }

        public EOEditingContext editingContext() {
            EOEditingContext ec = _useWonder ? ERXEC.newEditingContext() : new EOEditingContext();
            return ec;
        }

        protected void start() {
            this._startTime = System.currentTimeMillis();
        }

        protected void end() {
            this._endTime = System.currentTimeMillis();
        }

        protected void print(String title, String str) {
            System.out.println(this + ": " + title + ": " + str);
        }

        public void run() {
            if (this._delay > 0) {
                try {
                    Thread.sleep((long)this._delay * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.start();
            this._run();
            if (this._endTime == 0L) {
                this.end();
            }
            this.print("TIME", "duration = " + (this._endTime - this._startTime));
        }

        protected abstract void _run();
    }
}

