/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.erxtest.ERXTestCase;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.io.IOException;
import junit.framework.AssertionFailedError;

public class ERXPropertiesTest
extends ERXTestCase {
    private static final String Key = "testKey";

    public void test() throws IOException {
        ERXProperties._Properties properties = new ERXProperties._Properties();
        properties.load(new File("ERXPropertiesTest0.properties"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest0", (String)properties.getProperty("key0"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest0", (String)properties.getProperty("key1"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest2", (String)properties.getProperty("key2"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest0", (String)properties.getProperty("key3"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest2", (String)properties.getProperty("key4"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest0", (String)properties.getProperty("key5"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest1", (String)properties.getProperty("key6"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest3", (String)properties.getProperty("key7"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest3", (String)properties.getProperty("key8"));
        ERXPropertiesTest.assertEquals((String)"ERXPropertiesTest3", (String)properties.getProperty("key9"));
    }

    protected static void _setProperty(String key, String value) {
        ERXProperties.setStringForKey((String)value, (String)key);
    }

    protected static void removePropertyForKey(String key) {
        ERXProperties.removeKey((String)key);
    }

    protected static void setCachingEnabled(boolean cachingEnabled) {
    }

    public void testGetProperty() {
    }

    public void testCache() {
        ERXPropertiesTest.setCachingEnabled(true);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest._setProperty(Key, "(\"a\", \"b\", \"c\")");
        ERXPropertiesTest.assertSame((Object)ERXProperties.arrayForKey((String)Key), (Object)ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest.assertEquals(new NSArray((Object[])new String[]{"a", "b", "c"}), ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest._setProperty(Key, "()");
        ERXPropertiesTest.assertEquals(NSArray.EmptyArray, ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKey((String)Key));
    }

    public void testArrayForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKeyWithDefault((String)Key, null));
        NSArray defaultValue = new NSArray((Object[])new String[]{"a"});
        ERXPropertiesTest.assertSame((Object)defaultValue, (Object)ERXProperties.arrayForKeyWithDefault((String)Key, (NSArray)defaultValue));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKeyWithDefault((String)Key, null));
        ERXPropertiesTest.assertSame((Object)defaultValue, (Object)ERXProperties.arrayForKeyWithDefault((String)Key, (NSArray)defaultValue));
        ERXPropertiesTest._setProperty(Key, "()");
        ERXPropertiesTest.assertEquals(NSArray.EmptyArray, ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest.assertEquals(NSArray.EmptyArray, ERXProperties.arrayForKeyWithDefault((String)Key, null));
        NSArray value = new NSArray((Object[])new String[]{"a", "b", "c"});
        ERXPropertiesTest._setProperty(Key, "(\"a\", \"b\", \"c\")");
        ERXPropertiesTest.assertEquals(value, ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest.assertEquals(value, ERXProperties.arrayForKeyWithDefault((String)Key, null));
        ERXPropertiesTest.assertNotSame((Object)value, (Object)ERXProperties.arrayForKey((String)Key));
        ERXPropertiesTest._setProperty(Key, "a");
        ERXPropertiesTest.assertEquals(new NSArray((Object)"a"), ERXProperties.arrayForKeyWithDefault((String)Key, (NSArray)defaultValue));
        try {
            ERXPropertiesTest._setProperty(Key, "('a')");
            ERXProperties.arrayForKeyWithDefault((String)Key, null);
            throw new AssertionFailedError("This should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ERXPropertiesTest.setCachingEnabled(true);
            ERXPropertiesTest.removePropertyForKey(Key);
            ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKey((String)Key));
            ERXPropertiesTest.assertNull((Object)ERXProperties.arrayForKey((String)Key));
            ERXPropertiesTest._setProperty(Key, "(\"a\", \"b\", \"c\")");
            ERXPropertiesTest.assertSame((Object)ERXProperties.arrayForKey((String)Key), (Object)ERXProperties.arrayForKey((String)Key));
            ERXPropertiesTest.assertEquals(value, ERXProperties.arrayForKey((String)Key));
            return;
        }
    }

    public void testBooleanForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKey((String)Key));
        boolean defaultValue = true;
        ERXPropertiesTest.assertEquals((boolean)defaultValue, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)defaultValue));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKey((String)Key));
        ERXPropertiesTest.assertEquals((boolean)defaultValue, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)defaultValue));
        ERXPropertiesTest._setProperty(Key, "yes");
        ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false));
        ERXPropertiesTest._setProperty(Key, "y");
        ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false));
        ERXPropertiesTest._setProperty(Key, "YES");
        ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false));
        ERXPropertiesTest._setProperty(Key, "Y");
        ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false));
        ERXPropertiesTest._setProperty(Key, "true");
        ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false));
        ERXPropertiesTest._setProperty(Key, "TRUE");
        ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false));
        ERXPropertiesTest._setProperty(Key, "no");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)true));
        ERXPropertiesTest._setProperty(Key, "n");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)true));
        ERXPropertiesTest._setProperty(Key, "NO");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)true));
        ERXPropertiesTest._setProperty(Key, "N");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)true));
        ERXPropertiesTest._setProperty(Key, "false");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)true));
        ERXPropertiesTest._setProperty(Key, "FALSE");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)true));
        ERXPropertiesTest._setProperty(Key, "0");
        ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)true));
        ERXPropertiesTest._setProperty(Key, "1");
        ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false));
        try {
            ERXPropertiesTest._setProperty(Key, "randomString");
            ERXProperties.booleanForKeyWithDefault((String)Key, (boolean)false);
            throw new AssertionFailedError("This should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ERXPropertiesTest.setCachingEnabled(true);
            ERXPropertiesTest.removePropertyForKey(Key);
            ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKey((String)Key));
            ERXPropertiesTest.assertEquals((boolean)false, (boolean)ERXProperties.booleanForKey((String)Key));
            ERXPropertiesTest._setProperty(Key, "yes");
            ERXPropertiesTest.assertEquals((boolean)true, (boolean)ERXProperties.booleanForKey((String)Key));
            ERXPropertiesTest.assertSame((Object)new Boolean(ERXProperties.booleanForKey((String)Key)), (Object)new Boolean(ERXProperties.booleanForKey((String)Key)));
            return;
        }
    }

    public void testDictionaryForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertNull((Object)ERXProperties.dictionaryForKey((String)Key));
        ERXPropertiesTest.assertNull((Object)ERXProperties.dictionaryForKeyWithDefault((String)Key, null));
        NSDictionary defaultValue = new NSDictionary();
        ERXPropertiesTest.assertSame((Object)defaultValue, (Object)ERXProperties.dictionaryForKeyWithDefault((String)Key, (NSDictionary)defaultValue));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertNull((Object)ERXProperties.dictionaryForKey((String)Key));
        ERXPropertiesTest.assertNull((Object)ERXProperties.dictionaryForKeyWithDefault((String)Key, null));
        ERXPropertiesTest.assertSame((Object)defaultValue, (Object)ERXProperties.dictionaryForKeyWithDefault((String)Key, (NSDictionary)defaultValue));
        ERXPropertiesTest._setProperty(Key, "{}");
        ERXPropertiesTest.assertEquals((Object)NSDictionary.EmptyDictionary, (Object)ERXProperties.dictionaryForKey((String)Key));
        ERXPropertiesTest.assertEquals((Object)NSDictionary.EmptyDictionary, (Object)ERXProperties.dictionaryForKeyWithDefault((String)Key, null));
        NSDictionary value = new NSDictionary((Object)"value", (Object)"key");
        ERXPropertiesTest._setProperty(Key, "{key=value;}");
        ERXPropertiesTest.assertEquals((Object)value, (Object)ERXProperties.dictionaryForKey((String)Key));
        ERXPropertiesTest.assertEquals((Object)value, (Object)ERXProperties.dictionaryForKeyWithDefault((String)Key, null));
        ERXPropertiesTest.assertNotSame((Object)value, (Object)ERXProperties.dictionaryForKey((String)Key));
        try {
            ERXPropertiesTest._setProperty(Key, "randomString");
            ERXProperties.dictionaryForKeyWithDefault((String)Key, null);
            throw new AssertionFailedError("This should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ERXPropertiesTest.setCachingEnabled(true);
            ERXPropertiesTest.removePropertyForKey(Key);
            ERXPropertiesTest.assertNull((Object)ERXProperties.dictionaryForKey((String)Key));
            ERXPropertiesTest.assertNull((Object)ERXProperties.dictionaryForKey((String)Key));
            ERXPropertiesTest._setProperty(Key, "{key=value;}");
            ERXPropertiesTest.assertSame((Object)ERXProperties.dictionaryForKey((String)Key), (Object)ERXProperties.dictionaryForKey((String)Key));
            ERXPropertiesTest.assertEquals((Object)value, (Object)ERXProperties.dictionaryForKey((String)Key));
            return;
        }
    }

    public void testDoubleForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertEquals((Object)new Double(0.0), (Object)new Double(ERXProperties.doubleForKey((String)Key)));
        double defaultValue = 15.0;
        ERXPropertiesTest.assertEquals((Object)new Double(defaultValue), (Object)new Double(ERXProperties.doubleForKeyWithDefault((String)Key, (double)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertEquals((Object)new Double(0.0), (Object)new Double(ERXProperties.doubleForKey((String)Key)));
        ERXPropertiesTest.assertEquals((Object)new Double(defaultValue), (Object)new Double(ERXProperties.doubleForKeyWithDefault((String)Key, (double)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "0");
        ERXPropertiesTest.assertEquals((Object)new Double(0.0), (Object)new Double(ERXProperties.doubleForKeyWithDefault((String)Key, (double)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "1");
        ERXPropertiesTest.assertEquals((Object)new Double(1.0), (Object)new Double(ERXProperties.doubleForKeyWithDefault((String)Key, (double)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "5.0");
        ERXPropertiesTest.assertEquals((Object)new Double(5.0), (Object)new Double(ERXProperties.doubleForKeyWithDefault((String)Key, (double)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "-5.0");
        ERXPropertiesTest.assertEquals((Object)new Double(-5.0), (Object)new Double(ERXProperties.doubleForKeyWithDefault((String)Key, (double)defaultValue)));
        try {
            ERXPropertiesTest._setProperty(Key, "randomString");
            ERXProperties.doubleForKeyWithDefault((String)Key, (double)defaultValue);
            throw new AssertionFailedError("This should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ERXPropertiesTest.setCachingEnabled(true);
            ERXPropertiesTest.removePropertyForKey(Key);
            ERXPropertiesTest.assertEquals((Object)new Double(0.0), (Object)new Double(ERXProperties.doubleForKey((String)Key)));
            ERXPropertiesTest.assertEquals((Object)new Double(0.0), (Object)new Double(ERXProperties.doubleForKey((String)Key)));
            ERXPropertiesTest._setProperty(Key, "5000.0");
            ERXPropertiesTest.assertEquals((Object)new Double(5000.0), (Object)new Double(ERXProperties.doubleForKey((String)Key)));
            ERXPropertiesTest.assertEquals((Object)new Double(ERXProperties.doubleForKey((String)Key)), (Object)new Double(ERXProperties.doubleForKey((String)Key)));
            return;
        }
    }

    public void testFloatForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertEquals((Object)new Float(0.0f), (Object)new Float(ERXProperties.floatForKey((String)Key)));
        float defaultValue = 15.0f;
        ERXPropertiesTest.assertEquals((Object)new Float(defaultValue), (Object)new Float(ERXProperties.floatForKeyWithDefault((String)Key, (float)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertEquals((Object)new Float(0.0f), (Object)new Float(ERXProperties.floatForKey((String)Key)));
        ERXPropertiesTest.assertEquals((Object)new Float(defaultValue), (Object)new Float(ERXProperties.floatForKeyWithDefault((String)Key, (float)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "0");
        ERXPropertiesTest.assertEquals((Object)new Float(0.0f), (Object)new Float(ERXProperties.floatForKeyWithDefault((String)Key, (float)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "1");
        ERXPropertiesTest.assertEquals((Object)new Float(1.0f), (Object)new Float(ERXProperties.floatForKeyWithDefault((String)Key, (float)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "5.0");
        ERXPropertiesTest.assertEquals((Object)new Float(5.0f), (Object)new Float(ERXProperties.floatForKeyWithDefault((String)Key, (float)defaultValue)));
        ERXPropertiesTest._setProperty(Key, "-5.0");
        ERXPropertiesTest.assertEquals((Object)new Float(-5.0f), (Object)new Float(ERXProperties.floatForKeyWithDefault((String)Key, (float)defaultValue)));
        try {
            ERXPropertiesTest._setProperty(Key, "randomString");
            ERXProperties.floatForKeyWithDefault((String)Key, (float)defaultValue);
            throw new AssertionFailedError("This should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ERXPropertiesTest.setCachingEnabled(true);
            ERXPropertiesTest.removePropertyForKey(Key);
            ERXPropertiesTest.assertEquals((Object)new Float(0.0f), (Object)new Float(ERXProperties.floatForKey((String)Key)));
            ERXPropertiesTest.assertEquals((Object)new Float(0.0f), (Object)new Float(ERXProperties.floatForKey((String)Key)));
            ERXPropertiesTest._setProperty(Key, "5000.0");
            ERXPropertiesTest.assertEquals((Object)new Float(5000.0f), (Object)new Float(ERXProperties.floatForKey((String)Key)));
            ERXPropertiesTest.assertEquals((Object)new Float(ERXProperties.floatForKey((String)Key)), (Object)new Float(ERXProperties.floatForKey((String)Key)));
            return;
        }
    }

    public void testIntForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertEquals((int)0, (int)ERXProperties.intForKey((String)Key));
        int defaultValue = 15;
        ERXPropertiesTest.assertEquals((int)defaultValue, (int)ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertEquals((int)0, (int)ERXProperties.intForKey((String)Key));
        ERXPropertiesTest.assertEquals((int)defaultValue, (int)ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue));
        ERXPropertiesTest._setProperty(Key, "0");
        ERXPropertiesTest.assertEquals((int)0, (int)ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue));
        ERXPropertiesTest._setProperty(Key, "1");
        ERXPropertiesTest.assertEquals((int)1, (int)ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue));
        ERXPropertiesTest._setProperty(Key, "5");
        ERXPropertiesTest.assertEquals((int)5, (int)ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue));
        ERXPropertiesTest._setProperty(Key, "-5");
        ERXPropertiesTest.assertEquals((int)-5, (int)ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue));
        try {
            ERXPropertiesTest._setProperty(Key, "5.0");
            ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue);
            throw new AssertionFailedError("This should have failed.");
        }
        catch (IllegalArgumentException e) {
            try {
                ERXPropertiesTest._setProperty(Key, "randomString");
                ERXProperties.intForKeyWithDefault((String)Key, (int)defaultValue);
                throw new AssertionFailedError("This should have failed.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ERXPropertiesTest.setCachingEnabled(true);
                ERXPropertiesTest.removePropertyForKey(Key);
                ERXPropertiesTest.assertEquals((int)0, (int)ERXProperties.intForKey((String)Key));
                ERXPropertiesTest.assertEquals((int)0, (int)ERXProperties.intForKey((String)Key));
                ERXPropertiesTest._setProperty(Key, "5000");
                ERXPropertiesTest.assertEquals((int)5000, (int)ERXProperties.intForKey((String)Key));
                ERXPropertiesTest.assertEquals((int)ERXProperties.intForKey((String)Key), (int)ERXProperties.intForKey((String)Key));
                return;
            }
        }
    }

    public void testLongForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertEquals((long)0L, (long)ERXProperties.longForKey((String)Key));
        long defaultValue = 15L;
        ERXPropertiesTest.assertEquals((long)defaultValue, (long)ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertEquals((long)0L, (long)ERXProperties.longForKey((String)Key));
        ERXPropertiesTest.assertEquals((long)defaultValue, (long)ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue));
        ERXPropertiesTest._setProperty(Key, "0");
        ERXPropertiesTest.assertEquals((long)0L, (long)ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue));
        ERXPropertiesTest._setProperty(Key, "1");
        ERXPropertiesTest.assertEquals((long)1L, (long)ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue));
        ERXPropertiesTest._setProperty(Key, "5");
        ERXPropertiesTest.assertEquals((long)5L, (long)ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue));
        ERXPropertiesTest._setProperty(Key, "-5");
        ERXPropertiesTest.assertEquals((long)-5L, (long)ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue));
        try {
            ERXPropertiesTest._setProperty(Key, "5.0");
            ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue);
            throw new AssertionFailedError("This should have failed.");
        }
        catch (IllegalArgumentException e) {
            try {
                ERXPropertiesTest._setProperty(Key, "randomString");
                ERXProperties.longForKeyWithDefault((String)Key, (long)defaultValue);
                throw new AssertionFailedError("This should have failed.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ERXPropertiesTest.setCachingEnabled(true);
                ERXPropertiesTest.removePropertyForKey(Key);
                ERXPropertiesTest.assertEquals((long)0L, (long)ERXProperties.longForKey((String)Key));
                ERXPropertiesTest.assertEquals((long)0L, (long)ERXProperties.longForKey((String)Key));
                ERXPropertiesTest._setProperty(Key, "5000");
                ERXPropertiesTest.assertEquals((long)5000L, (long)ERXProperties.longForKey((String)Key));
                ERXPropertiesTest.assertEquals((long)ERXProperties.longForKey((String)Key), (long)ERXProperties.longForKey((String)Key));
                return;
            }
        }
    }

    public void setPropertiesFromArgv() {
    }

    public void testStringForKey() {
        ERXPropertiesTest.setCachingEnabled(false);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertNull((Object)ERXProperties.stringForKey((String)Key));
        ERXPropertiesTest.assertNull((Object)ERXProperties.stringForKeyWithDefault((String)Key, null));
        String defaultValue = "defaultValue";
        ERXPropertiesTest.assertSame((Object)defaultValue, (Object)ERXProperties.stringForKeyWithDefault((String)Key, (String)defaultValue));
        ERXPropertiesTest._setProperty(Key, "");
        ERXPropertiesTest.assertEquals((String)"", (String)ERXProperties.stringForKey((String)Key));
        ERXPropertiesTest.assertEquals((String)"", (String)ERXProperties.stringForKeyWithDefault((String)Key, null));
        String value = "value";
        ERXPropertiesTest._setProperty(Key, new String("value"));
        ERXPropertiesTest.assertEquals((String)value, (String)ERXProperties.stringForKey((String)Key));
        ERXPropertiesTest.assertEquals((String)value, (String)ERXProperties.stringForKeyWithDefault((String)Key, null));
        ERXPropertiesTest.assertNotSame((Object)value, (Object)ERXProperties.stringForKey((String)Key));
        ERXPropertiesTest.setCachingEnabled(true);
        ERXPropertiesTest.removePropertyForKey(Key);
        ERXPropertiesTest.assertNull((Object)ERXProperties.stringForKey((String)Key));
        ERXPropertiesTest.assertNull((Object)ERXProperties.stringForKey((String)Key));
        ERXPropertiesTest._setProperty(Key, value);
        ERXPropertiesTest.assertEquals((String)ERXProperties.stringForKey((String)Key), (String)ERXProperties.stringForKey((String)Key));
        ERXPropertiesTest.assertEquals((String)value, (String)ERXProperties.stringForKey((String)Key));
    }
}

