/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSKeyValueCoding;
import er.erxtest.ERXTestCase;
import er.extensions.foundation.ERXValueUtilities;
import junit.framework.Assert;

public class ERXValueUtilitiesTest
extends ERXTestCase {
    public void testIsNull() {
        Object obj = null;
        Assert.assertFalse((boolean)ERXValueUtilities.isNull((Object)((Object)this)));
        Assert.assertTrue((boolean)ERXValueUtilities.isNull(obj));
        Assert.assertTrue((boolean)ERXValueUtilities.isNull((Object)NSKeyValueCoding.NullValue));
        Assert.assertTrue((boolean)ERXValueUtilities.isNull(null));
    }

    public void testBooleanValue() {
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)new Integer(1)));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)new Byte("1")));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)new Float(1.0f)));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)new Long(1L)));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)new Short("1")));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)new Integer(0)));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)new Byte("0")));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)new Float(0.0f)));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)new Long(0L)));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)new Short("0")));
        try {
            ERXValueUtilities.booleanValue((Object)"hello");
            Assert.fail((String)"a boolean from hello?");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            ERXValueUtilities.booleanValue((Object)"0.0");
            Assert.fail((String)"a boolean from 0.0?");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"0"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"000000"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"false"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"False"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"FALSE"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"fAlSe"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"NO"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"no"));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValue((Object)"nO"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"1"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"11"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"true"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"TRUE"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"tRuE"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"YES"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"yes"));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValue((Object)"yEs"));
    }

    public void testBooleanValueWithDefault() {
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Integer(1), (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Byte("1"), (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Float(1.0f), (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Long(1L), (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Short("1"), (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Integer(0), (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Byte("0"), (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Float(0.0f), (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Long(0L), (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Short("0"), (boolean)false));
        try {
            ERXValueUtilities.booleanValueWithDefault((Object)"hello", (boolean)false);
            Assert.fail((String)"a boolean from hello?");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            ERXValueUtilities.booleanValueWithDefault((Object)"0.0", (boolean)false);
            Assert.fail((String)"a boolean from 0.0?");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"0", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"000000", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"false", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"False", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"FALSE", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"fAlSe", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"NO", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"no", (boolean)false));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"nO", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"1", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"11", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"true", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"TRUE", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"tRuE", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"YES", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"yes", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"yEs", (boolean)false));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Integer(1), (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Byte("1"), (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Float(1.0f), (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Long(1L), (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Short("1"), (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Integer(0), (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Byte("0"), (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Float(0.0f), (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Long(0L), (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)new Short("0"), (boolean)true));
        try {
            ERXValueUtilities.booleanValueWithDefault((Object)"hello", (boolean)true);
            Assert.fail((String)"a boolean from hello?");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            ERXValueUtilities.booleanValueWithDefault((Object)"0.0", (boolean)true);
            Assert.fail((String)"a boolean from 0.0?");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"0", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"000000", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"false", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"False", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"FALSE", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"fAlSe", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"NO", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"no", (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"nO", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"1", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"11", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"true", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"TRUE", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"tRuE", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"YES", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"yes", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault((Object)"yEs", (boolean)true));
        Assert.assertTrue((boolean)ERXValueUtilities.booleanValueWithDefault(null, (boolean)true));
        Assert.assertFalse((boolean)ERXValueUtilities.booleanValueWithDefault(null, (boolean)false));
    }

    public void testBooleanValueWithDefaultBoolean() {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Integer(1), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Byte("1"), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Float(1.0f), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Long(1L), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Short("1"), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Integer(0), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Byte("0"), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Float(0.0f), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Long(0L), (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Short("0"), (Boolean)Boolean.FALSE));
        try {
            ERXValueUtilities.BooleanValueWithDefault((Object)"hello", (Boolean)Boolean.FALSE);
            Assert.fail((String)"a boolean from hello?");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            ERXValueUtilities.BooleanValueWithDefault((Object)"0.0", (Boolean)Boolean.FALSE);
            Assert.fail((String)"a boolean from 0.0?");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"0", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"000000", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"false", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"False", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"FALSE", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"fAlSe", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"NO", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"no", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"nO", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"1", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"11", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"true", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"TRUE", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"tRuE", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"YES", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"yes", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"yEs", (Boolean)Boolean.FALSE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Integer(1), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Byte("1"), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Float(1.0f), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Long(1L), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Short("1"), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Integer(0), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Byte("0"), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Float(0.0f), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Long(0L), (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)new Short("0"), (Boolean)Boolean.TRUE));
        try {
            ERXValueUtilities.BooleanValueWithDefault((Object)"hello", (Boolean)Boolean.TRUE);
            Assert.fail((String)"a boolean from hello?");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            ERXValueUtilities.BooleanValueWithDefault((Object)"0.0", (Boolean)Boolean.TRUE);
            Assert.fail((String)"a boolean from 0.0?");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"0", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"000000", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"false", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"False", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"FALSE", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"fAlSe", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"NO", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"no", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"nO", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"1", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"11", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"true", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"TRUE", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"tRuE", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"YES", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"yes", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault((Object)"yEs", (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)ERXValueUtilities.BooleanValueWithDefault(null, (Boolean)Boolean.TRUE));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)ERXValueUtilities.BooleanValueWithDefault(null, (Boolean)Boolean.FALSE));
    }
}

