/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.jdbc;

import er.erxtest.ERXTestCase;
import er.extensions.jdbc.ERXSQLHelper;

public class MicrosoftSQLHelperTest
extends ERXTestCase {
    private ERXSQLHelper.MicrosoftSQLHelper helper;

    protected void setUp() throws Exception {
        super.setUp();
        this.helper = new ERXSQLHelper.MicrosoftSQLHelper();
    }

    public void testLimitExpressionFixPaginationRange() throws Exception {
        String result = this.helper.limitExpressionForSQL(null, null, "select t1.column1 from table1 as t1", 0L, 20L);
        MicrosoftSQLHelperTest.assertTrue((boolean)result.contains("eo_rownum >= 1"));
        MicrosoftSQLHelperTest.assertTrue((boolean)result.contains("eo_rownum < 21"));
    }

    public void testLimitExpressionForEmptySql() throws Exception {
        String result = this.helper.limitExpressionForSQL(null, null, "", 0L, 0L);
        MicrosoftSQLHelperTest.assertEquals((String)"", (String)result);
    }

    public void testLimitExpressionForNullSql() throws Exception {
        String result = this.helper.limitExpressionForSQL(null, null, null, 0L, 0L);
        MicrosoftSQLHelperTest.assertNull((Object)result);
    }

    public void testLimitExpressionForSimpleSql() throws Exception {
        String result = this.helper.limitExpressionForSQL(null, null, "select t1.column1 from table1 as t1", 0L, 5L);
        MicrosoftSQLHelperTest.assertEquals((String)"select * from (select t1.column1, row_number() over (order by t1.column1) eo_rownum from table1 as t1) as temp_row_number where eo_rownum >= 1 and eo_rownum < 6 order by eo_rownum", (String)result);
    }

    public void testLimitExpressionForSqlWithOrderByClause() throws Exception {
        String result = this.helper.limitExpressionForSQL(null, null, "select t1.column1, t1.column2 from table1 as t1 order by t1.column2", 0L, 5L);
        MicrosoftSQLHelperTest.assertEquals((String)"select * from (select t1.column1, t1.column2, row_number() over (order by t1.column2) eo_rownum from table1 as t1) as temp_row_number where eo_rownum >= 1 and eo_rownum < 6 order by eo_rownum", (String)result);
    }

    public void testLimitExpressionIsCaseInsensitive() throws Exception {
        String result = this.helper.limitExpressionForSQL(null, null, "SeLecT t1.column1 FrOM table1 AS t1", 0L, 5L);
        MicrosoftSQLHelperTest.assertEquals((String)"select * from (select t1.column1, row_number() over (order by t1.column1) eo_rownum from table1 as t1) as temp_row_number where eo_rownum >= 1 and eo_rownum < 6 order by eo_rownum", (String)result);
    }
}

