/*
 * Decompiled with CFR 0.152.
 */
package er.reporting;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXAssert;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.grouping.DRReportModel;
import org.apache.log4j.Logger;

public class WRQuickReport
extends WOComponent {
    private Logger log = Logger.getLogger(WRQuickReport.class);
    protected DRReportModel _model;
    protected NSDictionary _modelDictionary;
    protected NSDictionary _reportDictionary;
    protected NSDictionary _settingsDictionary;
    protected NSArray _objects;
    protected NSArray _attributeArray;
    protected NSArray _criteriaArray;
    protected String _componentName;

    public WRQuickReport(WOContext c) {
        super(c);
        NSSelector synchModelSelector = new NSSelector("synchModel", ERXConstant.NotificationClassArray);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, synchModelSelector, "DRReportModelUpdate", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, synchModelSelector, "DRReportModelRebuild", null);
    }

    public String reportComponentName() {
        String name = (String)this.valueForBinding("reportComponentName");
        if (name == null) {
            name = "WRReport";
        }
        return name;
    }

    public void synchModel(NSNotification notification) {
        if (this._model == notification.object() && !this.dontSyncModel()) {
            DRReportModel model = this._model;
            this.reset();
            if (model != null) {
                model.initWithRawRecords(this.objects(), this.criteriaArray(), this.attributeArray());
            }
            this.log.info((Object)"Model was re-set.");
        }
    }

    public String componentName() {
        if (this._componentName == null) {
            this._componentName = (String)this.valueForBinding("reportComponentName");
            if (this._componentName == null) {
                this._componentName = "WRRecordGroup";
            }
        }
        return this._componentName;
    }

    public void finalize() throws Throwable {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
        super.finalize();
    }

    public void awake() {
        super.awake();
        this._objects = null;
    }

    public void reset() {
        super.reset();
        this._model = null;
        this._modelDictionary = null;
        this._reportDictionary = null;
        this._settingsDictionary = null;
        this._attributeArray = null;
        this._criteriaArray = null;
        this._objects = null;
        this._componentName = null;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String plistString() {
        if (super.hasBinding("plistString")) {
            return (String)super.valueForBinding("plistString");
        }
        if (this.hasBinding("pathString")) {
            String p = (String)super.valueForBinding("pathString");
            this.log.debug((Object)("p:" + p));
            String plist = ERXStringUtilities.stringWithContentsOfFile((String)p);
            this.log.debug((Object)("plist:" + plist));
            return plist;
        }
        return null;
    }

    public NSDictionary modelDictionary() {
        if (this._modelDictionary == null) {
            if (super.hasBinding("modelDictionary")) {
                this._modelDictionary = (NSDictionary)super.valueForBinding("modelDictionary");
            } else {
                String plistString = this.plistString();
                if (plistString != null) {
                    this._modelDictionary = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)plistString);
                } else {
                    this._modelDictionary = (NSDictionary)this.reportDictionary().objectForKey((Object)"model");
                    if (this._modelDictionary == null) {
                        this.log.warn((Object)"No modelDictionary found!");
                        this._modelDictionary = NSDictionary.EmptyDictionary;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("plistString:" + plistString));
                    this.log.debug((Object)("modelDict:" + this._modelDictionary));
                }
            }
        }
        return this._modelDictionary;
    }

    public NSDictionary reportDictionary() {
        if (this._reportDictionary == null) {
            this._reportDictionary = super.hasBinding("reportDictionary") ? (NSDictionary)super.valueForBinding("reportDictionary") : NSDictionary.EmptyDictionary;
        }
        return this._reportDictionary;
    }

    public NSDictionary settingsDictionary() {
        if (this._settingsDictionary == null) {
            this._settingsDictionary = (NSDictionary)this.reportDictionary().objectForKey((Object)"settings");
            if (this._settingsDictionary == null) {
                this._settingsDictionary = NSDictionary.EmptyDictionary;
            }
        }
        return this._settingsDictionary;
    }

    public NSArray criteriaArray() {
        if (this._criteriaArray == null) {
            if (super.hasBinding("criteriaArray")) {
                this._criteriaArray = (NSArray)super.valueForBinding("criteriaArray");
            } else {
                NSArray rawArray = (NSArray)this.modelDictionary().objectForKey((Object)"GroupDef");
                this._criteriaArray = DRReportModel.masterCriteriaList((NSArray)rawArray);
            }
            ERXAssert.DURING.notNull("criteriaArray", (Object)this._criteriaArray);
        }
        return this._criteriaArray;
    }

    public NSArray attributeArray() {
        if (this._attributeArray == null) {
            if (super.hasBinding("attributeArray")) {
                this._attributeArray = (NSArray)super.valueForBinding("attributeArray");
            } else {
                NSArray rawArray = (NSArray)this.modelDictionary().objectForKey((Object)"AttributeDef");
                this._attributeArray = DRReportModel.attributeList((NSArray)rawArray);
            }
            ERXAssert.DURING.notNull("attributeArray", (Object)this._attributeArray);
        }
        return this._attributeArray;
    }

    public DRReportModel model() {
        if (this._model == null) {
            if (super.hasBinding("model")) {
                this.log.info((Object)"pulling model from bindings");
                this._model = (DRReportModel)super.valueForBinding("model");
            }
            if (this._model == null) {
                this.log.info((Object)"creating model from definition");
                this._model = DRReportModel.withRawRecordsCriteriaListAttributeList((NSArray)this.objects(), (NSArray)this.criteriaArray(), (NSArray)this.attributeArray());
            }
            if (super.hasBinding("model") && super.canSetValueForBinding("model")) {
                this.log.info((Object)("setValueForBinding model: DRReportModel@" + this._model.hashCode()));
                super.setValueForBinding((Object)this._model, "model");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("model(): DRReportModel@" + this._model.hashCode()));
                this.log.debug((Object)("model().records(): " + this._model.records().count()));
            }
        }
        return this._model;
    }

    public NSArray objects() {
        if (this._objects == null) {
            if (super.hasBinding("objects")) {
                this._objects = (NSArray)super.valueForBinding("objects");
            } else if (super.hasBinding("dataSource")) {
                EODataSource ds = (EODataSource)super.valueForBinding("dataSource");
                ERXAssert.DURING.notNull("dataSource", (Object)ds);
                this._objects = ds.fetchObjects();
            }
        }
        return this._objects;
    }

    public boolean hasBinding(String name) {
        boolean result;
        boolean bl = result = super.hasBinding(name) || this.settingsDictionary().objectForKey((Object)name) != null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("hasBinding: " + name + " : " + result));
        }
        return result;
    }

    public Object valueForBinding(String name) {
        Object result = super.hasBinding(name) ? super.valueForBinding(name) : this.settingsDictionary().objectForKey((Object)name);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("valueForBinding: " + name + " : " + result));
        }
        return result;
    }

    public boolean dontSyncModel() {
        return ERXValueUtilities.booleanValue((Object)this.valueForBinding("dontSyncModel"));
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        super.appendToResponse(r, c);
    }
}

