/*
 * Decompiled with CFR 0.152.
 */
package er.reporting;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import er.extensions.formatters.ERXNumberFormatter;
import er.extensions.foundation.ERXValueUtilities;
import er.grouping.DRRecord;
import er.grouping.DRRecordGroup;
import er.grouping.DRReportModel;
import er.grouping.DRValue;
import org.apache.log4j.Logger;

public class WRRecordGroup
extends WOComponent {
    private static final Logger log = Logger.getLogger(WRRecordGroup.class);
    String _totalToShow;
    DRRecordGroup _recordGroup;
    String _displayType;
    String _noTotalLabel;
    Boolean _showAsTable;
    Boolean _showHeadings;
    Boolean _showRecordTable;
    DRReportModel _model;
    NSArray _colors;
    String _reportStyle;
    NSDictionary _totalDict;
    NSDictionary _coordinates;
    int _totalCount = -1;
    public DRRecord record;
    public DRValue value;
    public DRValue totalValue;
    String bgcolor;

    public WRRecordGroup(WOContext c) {
        super(c);
    }

    public void reset() {
        this._totalToShow = null;
        this._recordGroup = null;
        this._displayType = null;
        this._noTotalLabel = null;
        this._showAsTable = null;
        this._showHeadings = null;
        this._showRecordTable = null;
        this._model = null;
        this._colors = null;
        this._reportStyle = null;
        this._coordinates = null;
        this._totalDict = null;
        this._totalCount = -1;
    }

    public final boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public boolean isStateless() {
        return true;
    }

    public void sleep() {
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        super.appendToResponse(r, c);
    }

    public DRRecordGroup recordGroup() {
        if (this._recordGroup == null) {
            this._recordGroup = (DRRecordGroup)this.valueForBinding("recordGroup");
        }
        return this._recordGroup;
    }

    public String displayType() {
        if (this._displayType == null) {
            this._displayType = (String)this.valueForBinding("displayType");
            if (this._displayType == null) {
                this._displayType = "TOTALS";
            }
        }
        return this._displayType;
    }

    public String noTotalLabel() {
        if (this._noTotalLabel == null) {
            this._noTotalLabel = (String)this.valueForBinding("noTotalLabel");
            if (this._noTotalLabel == null) {
                this._noTotalLabel = "-";
            }
        }
        return this._noTotalLabel;
    }

    public String reportStyle() {
        if (this._reportStyle == null) {
            this._reportStyle = (String)this.valueForBinding("reportStyle");
            if (this._reportStyle == null) {
                this._reportStyle = "NESTED_CELLS";
            }
        }
        return this._reportStyle;
    }

    public NSArray records() {
        return this.recordGroup().sortedRecordList();
    }

    public NSArray totals() {
        if (this.recordGroup() == null) {
            return NSArray.EmptyArray;
        }
        return this.recordGroup().totalList();
    }

    public double totalValueTotal() {
        if (this.totalValue != null) {
            return this.totalValue.total();
        }
        return 0.0;
    }

    public boolean nototals() {
        return this.totals().count() <= 0;
    }

    public String toString() {
        return this.recordGroup().totals().toString();
    }

    public DRReportModel model() {
        if (this._model == null) {
            this._model = (DRReportModel)this.valueForBinding("model");
        }
        return this._model;
    }

    public Boolean booleanValueForBinding(String name) {
        boolean flag = ERXValueUtilities.booleanValue((Object)this.valueForBinding(name));
        return flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean showAsTable() {
        if (this._showAsTable == null) {
            this._showAsTable = this.booleanValueForBinding("showAsTable");
        }
        return this._showAsTable;
    }

    public boolean showHeadings() {
        if (this.showSingleValue()) {
            return false;
        }
        if (this._showHeadings == null) {
            this._showHeadings = this.booleanValueForBinding("showHeadings");
        }
        return this._showHeadings;
    }

    public boolean showHeadingsForTotalsOrTable() {
        return this.showHeadings();
    }

    public boolean showRecordTable() {
        if (this._showRecordTable == null) {
            this._showRecordTable = "TABLE".equals(this.displayType()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._showRecordTable;
    }

    public boolean showSingleValue() {
        return "SINGLE_TOTAL".equals(this.displayType());
    }

    public boolean showTotalsOnly() {
        return "TOTALS".equals(this.displayType());
    }

    public boolean showTotalsOnlyAsTable() {
        return this.showTotalsOnly() && this.showAsTable();
    }

    public boolean showTotalsOnlyAsCells() {
        return this.showTotalsOnly() && !this.showAsTable();
    }

    public boolean showRecordTableAsCells() {
        return this.showRecordTable() && !this.showAsTable();
    }

    public boolean showRecordTableAsTable() {
        return this.showRecordTable() && this.showAsTable();
    }

    public boolean totalsOnly() {
        return this.showTotalsOnly();
    }

    public String totalToShow() {
        if (this._totalToShow == null) {
            this._totalToShow = (String)this.valueForBinding("totalToShow");
        }
        return this._totalToShow;
    }

    public String singleTotal() {
        NSArray tots;
        if (this.recordGroup() == null) {
            return this.noTotalLabel();
        }
        String totalKey = this.totalToShow();
        double doubleValue = 0.0;
        if (totalKey != null && (tots = this.recordGroup().totalList()) != null && tots.count() > 0) {
            DRValue v = this.recordGroup().totalForKey(this.totalToShow());
            if (v != null) {
                doubleValue = v.total();
            } else {
                return this.noTotalLabel();
            }
        }
        Double nm = new Double(doubleValue);
        String formatString = (String)this.valueForBinding("formatForSingleTotal");
        NSNumberFormatter formatter = ERXNumberFormatter.numberFormatterForPattern((String)formatString);
        return formatter.format((Object)nm);
    }

    public int nototalsrowspan() {
        return this.model().flatAttributeListTotal().count();
    }

    public boolean hDimsUsed() {
        return this.model().hList().count() > 0;
    }

    public boolean useVerticalReportStyle() {
        String style = this.reportStyle();
        return "VERTICAL_ROWS".equals(style);
    }

    public NSDictionary totalDict() {
        if (this._totalDict == null) {
            this._totalDict = (NSDictionary)this.valueForBinding("totalDict");
        }
        return this._totalDict;
    }

    public NSDictionary coordinates() {
        if (this._coordinates == null) {
            this._coordinates = (NSDictionary)this.valueForBinding("coordinates");
        }
        return this._coordinates;
    }

    public NSArray colors() {
        if (this._colors == null) {
            this._colors = (NSArray)this.valueForBinding("colors");
            if (this._colors == null) {
                this._colors = NSArray.EmptyArray;
            }
        }
        return this._colors;
    }

    public int totalCount() {
        if (this._totalCount == -1) {
            NSDictionary d = this.totalDict();
            this._totalCount = d == null ? 0 : d.allKeys().count();
        }
        return this._totalCount;
    }

    public boolean isNotTotalGroup() {
        return this.totalCount() <= 0;
    }

    public NSDictionary attributeListDict() {
        if (this.totalsOnly()) {
            return this.model().flatAttributeListTotalDict();
        }
        return this.model().flatAttributeDepthDict();
    }

    public int depthCount() {
        return this.attributeListDict().allKeys().count();
    }

    public int colspanForAllAttribs() {
        return this.model().flatAttributeList().count();
    }

    public NSArray recordFlatValueList() {
        return this.record.flatValueList();
    }
}

