/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOSession;
import com.webobjects.directtoweb.D2W;
import com.webobjects.directtoweb.D2WPage;
import com.webobjects.directtoweb.EditPageInterface;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import er.bugtracker.Component;
import er.bugtracker.Factory;
import er.bugtracker.People;
import er.corebusinesslogic.ERCoreBusinessLogic;
import er.extensions.appserver.ERXSession;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXStringUtilities;

public class Session
extends ERXSession {
    public NSMutableDictionary handlers = new NSMutableDictionary();
    private String _lastname;
    private String _firstname;
    private NSArray _activeUsers;
    protected People _user;
    private People _signUp;

    public Session() {
        new ReleaseHandler();
        new BugHandler();
        new ComponentHandler();
        new PeopleHandler();
        new FrameworkHandler();
        new TestItemHandler();
        new RequirementHandler();
        new ReportHandler();
        this.setStoresIDsInCookies(true);
    }

    public void setDefaultEditingContext(EOEditingContext newEc) {
        super.setDefaultEditingContext(newEc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOComponent editMyInfo() {
        People user = this.user();
        EditPageInterface epi = (EditPageInterface)D2W.factory().pageForConfigurationNamed("EditMyPeople", (WOSession)this);
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            user = (People)user.localInstanceIn(ec);
            epi.setObject((EOEnterpriseObject)user);
            epi.setNextPage(this.context().page());
            WOComponent wOComponent = (WOComponent)epi;
            return wOComponent;
        }
        finally {
            ec.unlock();
        }
    }

    public NSArray indentedComponents() {
        return Component.clazz.orderedComponents(this.defaultEditingContext());
    }

    public NSArray activeUsers() {
        if (this._activeUsers == null) {
            this._activeUsers = People.clazz.activeUsers(this.defaultEditingContext());
        }
        return this._activeUsers;
    }

    public People user() {
        return this._user;
    }

    public void setUser(People user) {
        this._user = user;
        ERCoreBusinessLogic.setActor((EOEnterpriseObject)this.user());
    }

    public void awake() {
        super.awake();
        if (this.user() != null) {
            ERCoreBusinessLogic.setActor((EOEnterpriseObject)this.user());
        }
    }

    public boolean hasValidUser() {
        return this.user() != null;
    }

    public void sleep() {
        ERCoreBusinessLogic.setActor(null);
        super.sleep();
    }

    public People signUp() {
        return this._signUp;
    }

    public void setSignUp(People value) {
        this._signUp = value;
    }

    public void finishSignUp() {
        this.setUser(this._signUp);
        this._signUp = null;
    }

    public String navigationRootChoice() {
        People user = this.user();
        if (user != null && user.isActive().booleanValue()) {
            if (user.isAdmin().booleanValue()) {
                return "admin";
            }
            if (user.isEngineering().booleanValue()) {
                return "engineer";
            }
        }
        return "none";
    }

    public class ReportHandler
    extends Handler {
        public ReportHandler() {
            super("reports");
        }

        public Object handleQueryWithUnboundKey(String key) {
            String keyPath = ERXStringUtilities.capitalize((String)key);
            return Factory.bugTracker().reportForName("Report" + keyPath);
        }
    }

    public class BugHandler
    extends Handler {
        public BugHandler() {
            super("bugs");
        }
    }

    public class ReleaseHandler
    extends Handler {
        public ReleaseHandler() {
            super("releases");
        }
    }

    public class TestItemHandler
    extends Handler {
        public TestItemHandler() {
            super("testItems");
        }
    }

    public class RequirementHandler
    extends Handler {
        public RequirementHandler() {
            super("requirements");
        }
    }

    public class FrameworkHandler
    extends Handler {
        public FrameworkHandler() {
            super("frameworks");
        }
    }

    public class PeopleHandler
    extends Handler {
        public PeopleHandler() {
            super("peoples");
        }
    }

    public class ComponentHandler
    extends Handler {
        public ComponentHandler() {
            super("components");
        }
    }

    public class Handler
    implements NSKeyValueCoding,
    NSKeyValueCoding.ErrorHandling {
        private String _key;

        public Handler(String key) {
            this._key = key;
            Session.this.handlers.setObjectForKey((Object)this, (Object)key);
        }

        public void takeValueForKey(Object value, String key) {
            throw new UnsupportedOperationException("Can't takeValueForKey");
        }

        public Object valueForKey(String key) {
            String keyPath = ERXStringUtilities.uncapitalize((String)key);
            WOActionResults result = (WOActionResults)NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)keyPath);
            if (result instanceof D2WPage) {
                D2WPage page = (D2WPage)result;
                String state = ERXStringUtilities.capitalize((String)this._key) + "." + key;
                page.d2wContext().takeValueForKey((Object)state, "navigationState");
            }
            return result;
        }

        public Object handleQueryWithUnboundKey(String key) {
            return NSKeyValueCoding.Utility.valueForKey((Object)((Object)Factory.bugTracker()), (String)key);
        }

        public void handleTakeValueForUnboundKey(Object value, String key) {
            throw new UnsupportedOperationException("Can't handleTakeValueForUnboundKey");
        }

        public void unableToSetNullForKey(String key) {
            throw new UnsupportedOperationException("Can't unableToSetNullForKey");
        }
    }
}

