/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOCookie;
import com.webobjects.directtoweb.D2W;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSTimestamp;
import er.bugtracker.Factory;
import er.bugtracker.People;
import er.bugtracker.Session;
import er.extensions.crypting.ERXCrypto;
import er.extensions.foundation.ERXUtilities;

public class LoginPanel
extends WOComponent {
    public String username;
    public String password;
    public boolean validated;
    public boolean rememberPassword;
    public String errorMessage;
    private WOComponent _nextPage;
    private ERXUtilities.Callback _nextPageCallback;

    public LoginPanel(WOContext context) {
        super(context);
    }

    public WOComponent nextPage() {
        if (this._nextPage == null && this._nextPageCallback != null) {
            this._nextPage = (WOComponent)this._nextPageCallback.invoke((Object)this.session());
        }
        return this._nextPage;
    }

    public ERXUtilities.Callback nextPageCallback() {
        return this._nextPageCallback;
    }

    public void setNextPageCallback(ERXUtilities.Callback value) {
        this._nextPageCallback = value;
        this._nextPage = null;
    }

    public WOComponent signUp() {
        return Factory.bugTracker().signUp();
    }

    public WOComponent login() {
        Session session = (Session)this.session();
        EOEditingContext editingContext = session.defaultEditingContext();
        if (!this.validated) {
            // empty if block
        }
        if (this.username == null || this.password == null) {
            this.errorMessage = "Please specify both fields!";
            return null;
        }
        People userObject = People.clazz.userWithUsernamePassword(editingContext, this.username, this.password);
        if (userObject == null) {
            this.errorMessage = "Sorry login incorrect!";
            return null;
        }
        if (!userObject.isActive().booleanValue()) {
            this.errorMessage = "Sorry your account is inactive!";
            return null;
        }
        session.setUser(userObject);
        boolean isAdmin = userObject.isAdmin();
        D2W.factory().setWebAssistantEnabled(isAdmin);
        String encryptedIDPrimaryKey = ERXCrypto.crypterForAlgorithm((String)"Blowfish").encrypt(userObject.primaryKey());
        WOCookie loginCookie = new WOCookie("BTL", this.rememberPassword ? encryptedIDPrimaryKey : "-");
        loginCookie.setExpires(NSTimestamp.DistantFuture);
        loginCookie.setPath("/");
        this.context().response().addCookie(loginCookie);
        WOComponent nextPage = this.nextPage();
        return nextPage == null ? this.pageWithName("HomePage") : nextPage;
    }
}

