/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker.components.reporting;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import er.bugtracker.components.reporting.Report;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.grouping.DRCriteria;
import er.grouping.DRGroup;
import er.grouping.DRRecordGroup;
import er.grouping.DRSubMasterCriteria;
import er.grouping.DRValue;
import er.plot.ERPCategoryChart;
import er.plot.ERPPieChart;
import java.text.Format;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ChartReport
extends Report {
    private static final Logger log = Logger.getLogger(ChartReport.class);
    public String currentType;
    public ChartConfiguration selectedConfiguration = (ChartConfiguration)CHART_CONFIGURATIONS.lastObject();
    public ChartConfiguration currentConfiguration;
    public String selectedType = this.selectedConfiguration.defaultType();
    private static NSArray CHART_CONFIGURATIONS = new NSArray(new Object[]{new PieChartConfiguration(), new AreaChartConfiguration()});

    public NSArray chartConfigurations() {
        return CHART_CONFIGURATIONS;
    }

    public ChartReport(WOContext context) {
        super(context);
    }

    public void awake() {
        super.awake();
    }

    public boolean isCurrentTypeSelected() {
        return this.currentType == this.selectedType;
    }

    public void selectType() {
        this.selectedType = this.currentType;
        this.selectedConfiguration = this.currentConfiguration;
    }

    public JFreeChart chart() {
        return null;
    }

    public void setChart(JFreeChart chart) {
    }

    public Dataset dataset(Integer attribTotalKey) {
        Dataset dataset = this.selectedConfiguration.createDataset();
        NSArray dataList = this.model().vList();
        NSArray valueList = this.model().hList();
        dataList = this.model().hList();
        valueList = this.model().vList();
        DRGroup dayGroup = (DRGroup)dataList.objectAtIndex(0);
        DRSubMasterCriteria daySubMasterCriteria = (DRSubMasterCriteria)dayGroup.masterCriteria().subCriteriaList().objectAtIndex(0);
        String dayKey = daySubMasterCriteria.keyDesc();
        NSArray dayCriterias = dayGroup.sortedCriteriaList();
        Format dayFormat = DRCriteria.formatterForFormat((String)daySubMasterCriteria.format());
        NSMutableDictionary coordinates = new NSMutableDictionary();
        Enumeration en = valueList.objectEnumerator();
        while (en.hasMoreElements()) {
            DRGroup mainGroup = (DRGroup)en.nextElement();
            DRSubMasterCriteria mainSubMasterCriteria = (DRSubMasterCriteria)mainGroup.masterCriteria().subCriteriaList().lastObject();
            String mainKey = mainSubMasterCriteria.keyDesc();
            NSArray mainCriterias = mainGroup.sortedCriteriaList();
            Enumeration values = mainCriterias.objectEnumerator();
            while (values.hasMoreElements()) {
                DRCriteria mainCriteria = (DRCriteria)values.nextElement();
                String label = (String)mainCriteria.valueDict().objectForKey((Object)mainKey);
                coordinates.setObjectForKey((Object)mainCriteria, (Object)mainGroup.masterCriteria().keyDesc());
                if (mainCriteria.isTotal()) continue;
                Enumeration days = dayCriterias.objectEnumerator();
                while (days.hasMoreElements()) {
                    DRCriteria dayCriteria = (DRCriteria)days.nextElement();
                    Object o = dayCriteria.valueDict().objectForKey((Object)dayKey);
                    if (dayCriteria.isTotal()) continue;
                    if (o instanceof NSTimestamp) {
                        NSTimestamp ts = (NSTimestamp)o;
                        if (ts == null) continue;
                        double value = 0.0;
                        String dayLabel = dayFormat.format(ts);
                        coordinates.setObjectForKey((Object)dayCriteria, (Object)dayGroup.masterCriteria().keyDesc());
                        DRRecordGroup recordGroup = this.model().recordGroupForCoordinates((NSDictionary)coordinates);
                        if (attribTotalKey != null) {
                            DRValue drValue = (DRValue)recordGroup.totals().objectForKey((Object)attribTotalKey);
                            if (drValue != null) {
                                value = drValue.total();
                            }
                        } else {
                            value = ((Number)recordGroup.rawRecordList().valueForKeyPath(this.recordGroupTotalToShow())).doubleValue();
                        }
                        if (dataset instanceof CategoryDataset) {
                            ((DefaultCategoryDataset)dataset).setValue(value, (Comparable)((Object)label), (Comparable)((Object)dayLabel));
                            continue;
                        }
                        if (dataset instanceof PieDataset) {
                            ((DefaultPieDataset)dataset).setValue((Comparable)((Object)label), value);
                            continue;
                        }
                        throw new IllegalArgumentException("Neither a Pie nor CategoryDataset");
                    }
                    double value = 0.0;
                    coordinates.setObjectForKey((Object)dayCriteria, (Object)dayGroup.masterCriteria().keyDesc());
                    DRRecordGroup recordGroup = this.model().recordGroupForCoordinates((NSDictionary)coordinates);
                    if (attribTotalKey != null) {
                        DRValue drValue = (DRValue)recordGroup.totals().objectForKey((Object)attribTotalKey);
                        if (drValue != null) {
                            value = drValue.total();
                        }
                    } else {
                        value = ((Number)recordGroup.rawRecordList().valueForKeyPath(this.recordGroupTotalToShow())).doubleValue();
                    }
                    if (dataset instanceof CategoryDataset) {
                        ((DefaultCategoryDataset)dataset).setValue(value, (Comparable)((Object)label), (Comparable)((Object)o.toString()));
                        continue;
                    }
                    if (dataset instanceof PieDataset) {
                        ((DefaultPieDataset)dataset).setValue((Comparable)((Object)label), value);
                        continue;
                    }
                    throw new IllegalArgumentException("Neither a Pie nor CategoryDataset");
                }
            }
        }
        return dataset;
    }

    public Dataset datasetForAttribute() {
        Integer attribTotalKey = new Integer(this.model().flatAttributeList().indexOfObject((Object)this.attrib));
        return this.dataset(attribTotalKey);
    }

    public Dataset dataset() {
        return this.dataset(null);
    }

    public static class AreaChartConfiguration
    implements ChartConfiguration {
        public NSArray supportedTypes() {
            return ERPCategoryChart.SUPPORTED_TYPES;
        }

        public NSDictionary configuration() {
            return ERXDictionaryUtilities.dictionaryWithObjectsAndKeys((Object[])new Object[]{CategoryLabelPositions.UP_45, "categoryPlot.domainAxis.categoryLabelPositions"});
        }

        public String componentName() {
            return ERPCategoryChart.class.getName();
        }

        public Dataset createDataset() {
            return new DefaultCategoryDataset();
        }

        public String defaultType() {
            return "StackedAreaChart";
        }
    }

    public static class PieChartConfiguration
    implements ChartConfiguration {
        public NSArray supportedTypes() {
            return ERPPieChart.SUPPORTED_TYPES;
        }

        public NSDictionary configuration() {
            return null;
        }

        public String componentName() {
            return ERPPieChart.class.getName();
        }

        public Dataset createDataset() {
            return new ERPPieChart.AccumulatingPieDataset();
        }

        public String defaultType() {
            return "PieChart";
        }
    }

    public static interface ChartConfiguration {
        public NSArray supportedTypes();

        public NSDictionary configuration();

        public String componentName();

        public Dataset createDataset();

        public String defaultType();
    }
}

