/*
 * Decompiled with CFR 0.152.
 */
package er.bugtracker.delegates;

import com.webobjects.appserver.WOComponent;
import com.webobjects.directtoweb.D2WContext;
import com.webobjects.foundation.NSArray;
import er.bugtracker.Bug;
import er.bugtracker.Factory;
import er.bugtracker.State;
import er.bugtracker.delegates.BranchDelegate;

public class BugDelegate
extends BranchDelegate {
    protected NSArray defaultBranchChoices(D2WContext context) {
        NSArray result = super.defaultBranchChoices(context);
        log.debug((Object)("in: " + result));
        Bug bug = (Bug)this.object(context);
        if (bug != null) {
            result = this.choiceByRemovingKeys(new NSArray((Object)"edit"), result);
            if (!bug.state().equals(State.ANALYZE)) {
                result = this.choiceByRemovingKeys(new NSArray((Object)"delete"), result);
            }
            if (!bug.state().equals(State.CLOSED)) {
                result = this.choiceByRemovingKeys(new NSArray(new Object[]{"reopen"}), result);
            }
            if (bug.state().equals(State.CLOSED)) {
                result = this.choiceByRemovingKeys(new NSArray(new Object[]{"resolve"}), result);
            }
            if (!bug.state().equals(State.VERIFY)) {
                result = this.choiceByRemovingKeys(new NSArray((Object)"reject"), result);
            }
            log.debug((Object)("out: " + result + " -> " + bug.state().textDescription()));
        } else {
            result = this.choiceByLeavingKeys(new NSArray(new Object[]{"create"}), result);
        }
        return result;
    }

    public WOComponent resolve(WOComponent sender) {
        Bug bug = (Bug)this.object(sender);
        return Factory.bugTracker().resolveBug(bug);
    }

    public WOComponent comment(WOComponent sender) {
        Bug bug = (Bug)this.object(sender);
        return Factory.bugTracker().commentBug(bug);
    }

    public WOComponent reopen(WOComponent sender) {
        Bug bug = (Bug)this.object(sender);
        return Factory.bugTracker().reopenBug(bug);
    }

    public WOComponent reject(WOComponent sender) {
        Bug bug = (Bug)this.object(sender);
        return Factory.bugTracker().rejectBug(bug);
    }

    public WOComponent create(WOComponent sender) {
        return Factory.bugTracker().createBug();
    }

    public WOComponent createTestItem(WOComponent sender) {
        Bug bug = (Bug)this.object(sender);
        return Factory.bugTracker().createTestItemFromBug(bug);
    }
}

